/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.invoice;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.invoice.SysInvoiceDto;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.invoice.SysInvoiceVo;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysInvoiceService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysInvoice"})
public class SysInvoiceController {
    @Autowired
    private SysInvoiceService sysInvoiceService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"page/list/select"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5bf9\u5e94\u7684\u5206\u9875\u5217\u8868\u4fe1\u606f")
    @AntiRefresh
    public Page<SysInvoiceVo> selectPageList(@RequestBody SysInvoiceDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        Page page = this.sysInvoiceService.selectPageList(dto);
        return page;
    }

    @PostMapping(value={"/batchUpdate"})
    @ApiOperation(value="\u5c06\u7cfb\u7edf\u53d1\u7968\u8868\u5185\u6279\u91cf\u83b7\u53d6\u5bf9\u5e94\u7684\u53d1\u7968\u8be6\u7ec6\u4fe1\u606f\uff0c\u5e76\u56de\u5199\u81f3\u7cfb\u7edf\u53d1\u7968\u8868\u5185")
    @UserOptLogger(operation="\u7cfb\u7edf\u53d1\u7968")
    public ResponseData batchUpdate() {
        this.sysInvoiceService.batchUpdate(this.commonRequest.getTenant());
        return ResponseData.success().update();
    }

    @PostMapping(value={"/getInvoiceInfoAndUpdate"})
    @ApiOperation(value="\u83b7\u53d6\u53d1\u7968\u8be6\u7ec6\u4fe1\u606f\u5e76\u5c06\u8be6\u7ec6\u4fe1\u606f\u56de\u5199\u81f3\u7cfb\u7edf\u53d1\u7968\u8868")
    @UserOptLogger(operation="\u7cfb\u7edf\u53d1\u7968")
    public ResponseData getInvoiceInfoAndUpdate(@RequestBody SysInvoiceDto dto) {
        this.sysInvoiceService.getInvoiceInfoAndUpdate(dto);
        return ResponseData.success().update();
    }
}

