/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysChargeItemHsInfoEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.data.repository.SysChargeItemHsInfoMapper;
import com.byh.sys.web.service.SysChargeItemHsInfoService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysChargeItemHsInfoServiceImpl
extends ServiceImpl<SysChargeItemHsInfoMapper, SysChargeItemHsInfoEntity>
implements SysChargeItemHsInfoService {
    private Logger logger = LoggerFactory.getLogger(SysChargeItemHsInfoServiceImpl.class);
    @Resource
    private SysChargeItemHsInfoMapper sysChargeItemHsInfoMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public void importChargeItemHsInfoList(MultipartFile file, Integer tenantId) {
        try {
            InputStream inputStream = file.getInputStream();
            XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
            XSSFSheet sheet = workbook.getSheetAt(0);
            ArrayList<SysChargeItemHsInfoEntity> chargeItemHsInfoList = new ArrayList<SysChargeItemHsInfoEntity>();
            Integer count = 0;
            for (Row row : sheet) {
                if (count < 3) {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    continue;
                }
                SysChargeItemHsInfoEntity chargeItemHsInfo = new SysChargeItemHsInfoEntity();
                String cHsDrugCode = row.getCell(0).getStringCellValue();
                String hsDrugName = row.getCell(1).getStringCellValue();
                String locDrugCode = row.getCell(3).getStringCellValue();
                String locDrugName = row.getCell(4).getStringCellValue();
                String hsDrugCode = cHsDrugCode + "-" + locDrugCode;
                chargeItemHsInfo.setCHsDrugCode(cHsDrugCode);
                chargeItemHsInfo.setHsDrugName(hsDrugName);
                chargeItemHsInfo.setLocDrugCode(locDrugCode);
                chargeItemHsInfo.setLocDrugName(locDrugName);
                chargeItemHsInfo.setHsDrugCode(hsDrugCode);
                String itemDetail = row.getCell(5).getStringCellValue();
                chargeItemHsInfo.setItemDetail(itemDetail);
                String extendContent = row.getCell(6).getStringCellValue();
                chargeItemHsInfo.setExtendContent(extendContent);
                String priceUnit = row.getCell(7).getStringCellValue();
                chargeItemHsInfo.setPriceUnit(priceUnit);
                String illustrate = row.getCell(8).getStringCellValue();
                chargeItemHsInfo.setIllustrate(illustrate);
                String feeLevel = row.getCell(9).getStringCellValue();
                chargeItemHsInfo.setFeeLevel(feeLevel);
                String remark = row.getCell(10).getStringCellValue();
                chargeItemHsInfo.setRemark(remark);
                chargeItemHsInfo.setTenantId(tenantId.intValue());
                chargeItemHsInfo.setDrugType("5");
                chargeItemHsInfo.setHsType("1");
                chargeItemHsInfo.setDelFlag("1");
                chargeItemHsInfo.setF5("-");
                chargeItemHsInfoList.add(chargeItemHsInfo);
            }
            List hsDrugCodes = chargeItemHsInfoList.stream().map(SysChargeItemHsInfoEntity::getHsDrugCode).distinct().filter(Objects::nonNull).collect(Collectors.toList());
            List dbList = this.sysChargeItemHsInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysChargeItemHsInfoEntity.class).eq(tenantId != null, SysChargeItemHsInfoEntity::getTenantId, (Object)tenantId)).eq(SysChargeItemHsInfoEntity::getDrugType, (Object)"5")).eq(SysChargeItemHsInfoEntity::getHsType, (Object)"1")).in(SysChargeItemHsInfoEntity::getHsDrugCode, hsDrugCodes));
            List dbHsDrugCodes = dbList.stream().map(SysChargeItemHsInfoEntity::getHsDrugCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List importList = chargeItemHsInfoList.stream().filter(item -> !dbHsDrugCodes.contains(item.getHsDrugCode())).collect(Collectors.toList());
            if (!importList.isEmpty()) {
                this.sysChargeItemHsInfoMapper.insertList(importList);
            }
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
            this.logger.info(e.getMessage());
        }
    }

    private String getString(String value) {
        String label = StrUtil.isEmpty((CharSequence)value) ? null : ("/".equals(value) ? null : value);
        return label;
    }
}

