/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.AdmissionEntity;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.drug.drugPharmacQcQm.SysDrugPharmacyQcQmSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacSimple.SysDrugPharmacySimpleDto;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacySaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyOut.SysDrugPharmacyOutDto;
import com.byh.sys.api.dto.drug.drugPharmacyOut.SysDrugPharmacyOutExcel;
import com.byh.sys.api.dto.drug.drugPharmacyOut.SysDrugPharmacyOutSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyOut.SysDrugPharmacyOutUpdateDto;
import com.byh.sys.api.dto.drug.drugPharmacyOut.SysDrugPharmacyOutUpdateStatusDto;
import com.byh.sys.api.dto.drug.drugPharmacyOutPrescip.SysDrugPharmacyOutPrescriptionSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyOutPrescip.SysDrugPharmacyOutPrescriptionUpdateDto;
import com.byh.sys.api.dto.drug.drugPharmacyOutTemp.SysDrugPharmacyOutTempSaveDto;
import com.byh.sys.api.dto.hsUpload.HsUploadParamSaveDto;
import com.byh.sys.api.enums.DictEnums;
import com.byh.sys.api.enums.SysCommonEnum;
import com.byh.sys.api.enums.SysDrugEnum;
import com.byh.sys.api.enums.SysMaterialInventoryEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysUserEntity;
import com.byh.sys.api.model.base.NoIdBaseEntity;
import com.byh.sys.api.model.dict.SysDictValueEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyOutEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyOutLogEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyOutPrescriptionEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyQcQmEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacySimpleEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.DateUtils;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.HttpUtils;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.drug.SysDrugPharmacyOutPrescriptionVo;
import com.byh.sys.api.vo.drug.SysDrugPharmacyOutVo;
import com.byh.sys.api.vo.drug.SysDrugPharmacySimpleVo;
import com.byh.sys.api.vo.drug.SysDrugPharmacyVo;
import com.byh.sys.data.repository.SysDictValueMapper;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysDrugPharmacyBackLogMapper;
import com.byh.sys.data.repository.SysDrugPharmacyMapper;
import com.byh.sys.data.repository.SysDrugPharmacyOutLogMapper;
import com.byh.sys.data.repository.SysDrugPharmacyOutMapper;
import com.byh.sys.data.repository.SysDrugPharmacyOutPrescriptionMapper;
import com.byh.sys.data.repository.SysDrugPharmacyQcQmMapper;
import com.byh.sys.data.repository.SysDrugPharmacySimpleMapper;
import com.byh.sys.data.repository.SysHsInfoMapper;
import com.byh.sys.data.repository.SysShelfMapper;
import com.byh.sys.data.repository.SysShelfPharmacyMapper;
import com.byh.sys.web.call_function.ExtendServiceImpl;
import com.byh.sys.web.call_function.HsUploadExtend;
import com.byh.sys.web.fegin.OutServiceFeign;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.HsUploadParamService;
import com.byh.sys.web.service.SysDrugPharmacyCheckService;
import com.byh.sys.web.service.SysDrugPharmacyOutPrescriptionService;
import com.byh.sys.web.service.SysDrugPharmacyOutService;
import com.byh.sys.web.service.SysDrugPharmacyOutTempService;
import com.byh.sys.web.service.SysDrugPharmacyQcQmService;
import com.byh.sys.web.service.SysDrugPharmacySimpleService;
import com.byh.sys.web.service.SysParamService;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDrugPharmacyOutServiceImpl
implements SysDrugPharmacyOutService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugPharmacyOutServiceImpl.class);
    @Resource
    private SysDrugPharmacyOutMapper sysDrugPharmacyOutMapper;
    @Autowired
    private SysHsInfoMapper sysHsInfoMapper;
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private SysDrugPharmacyOutPrescriptionService sysDrugPharmacyOutPrescriptionService;
    @Autowired
    private SysDrugPharmacyQcQmService sysDrugPharmacyQcQmService;
    @Resource
    private SysDrugPharmacyQcQmMapper sysDrugPharmacyQcQmMapper;
    @Resource
    private SysDrugPharmacyMapper sysDrugPharmacyMapper;
    @Resource
    private SysDrugPharmacyOutPrescriptionMapper sysDrugPharmacyOutPrescriptionMapper;
    @Resource
    private SysDrugPharmacySimpleMapper sysDrugPharmacySimpleMapper;
    @Resource
    private SysDrugPharmacySimpleService sysDrugPharmacySimpleService;
    @Autowired
    private SysDrugPharmacyCheckService sysDrugPharmacyCheckService;
    @Autowired
    private SysDrugPharmacyOutTempService sysDrugPharmacyOutTempService;
    @Resource
    private SysDictValueMapper sysDictValueMapper;
    @Autowired
    private SysDrugPharmacyOutLogMapper sysDrugPharmacyOutLogMapper;
    @Autowired
    private SysDrugPharmacyBackLogMapper sysDrugPharmacyBackLogMapper;
    @Autowired
    private SysDrugMapper sysDrugMapper;
    @Autowired
    private ExtendServiceImpl extendServiceImpl;
    @Autowired
    private SysShelfPharmacyMapper sysShelfPharmacyMapper;
    @Autowired
    private SysShelfMapper sysShelfMapper;
    @Autowired
    private HsUploadExtend hsUploadExtend;
    @Autowired
    SysParamService sysParamService;
    @Autowired
    private OutServiceFeign outServiceFeign;
    @Autowired
    private HsUploadParamService hsUploadParamService;

    @Transactional(rollbackFor={BusinessException.class})
    public SysDrugPharmacyOutEntity sysDrugPharmacyOutSave(SysDrugPharmacyOutSaveDto dto) {
        try {
            this.sysDrugPharmacyCheckService.sysDrugPharmacyCheckStatus(dto.getOutboundWarehouse());
            this.checkLossOrBack(dto);
            this.checkPrescriptionId(dto);
            BigDecimal purchaseAmount = new BigDecimal(0);
            BigDecimal retailPrice = new BigDecimal(0);
            SysDrugPharmacyOutEntity entity = (SysDrugPharmacyOutEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyOutEntity.class);
            String drugPharmacyInventoryInId = UUIDUtils.getRandom((int)6, (boolean)true);
            entity.setId(drugPharmacyInventoryInId);
            entity.setAuditStatus(DictEnums.AUDIT_STATUS_WAIT.getCode());
            entity.setCreateId(this.commonRequest.getUserId());
            List prescripList = dto.getList();
            for (SysDrugPharmacyOutPrescriptionSaveDto n : prescripList) {
                this.extendServiceImpl.drugCheckDrugRelation(n.getQuantity(), entity.getTenantId(), n.getDrugsId(), dto.getOutboundWarehouse());
                n.setTenantId(dto.getTenantId());
                n.setDrugPharmacyOutId(drugPharmacyInventoryInId);
                n.setId(UUIDUtils.getRandom((int)6, (boolean)true));
                retailPrice = retailPrice.add(new BigDecimal(n.getQuantity()).multiply(n.getRetailPrice()));
                SysDrugPharmacySimpleEntity simpleEntity = (SysDrugPharmacySimpleEntity)this.sysDrugPharmacySimpleMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacySimpleEntity::getDrugsId, (Object)n.getDrugsId())).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)dto.getOutboundWarehouse())).eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)dto.getTenantId())).eq(SysDrugPharmacySimpleEntity::getDelFlag, (Object)"0")).orderByAsc(SysDrugPharmacySimpleEntity::getId)).last("FOR UPDATE"));
                if (simpleEntity.getActualInventory() - simpleEntity.getOccupyInventory() < n.getQuantity()) {
                    log.error(String.valueOf(simpleEntity));
                    ExceptionUtils.createException((Logger)log, (boolean)Boolean.TRUE, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_INVENTORY_LACK.getCode(), (String)(simpleEntity.getDrugsName() + "\u3010" + simpleEntity.getSpecifications() + " \uff1a" + simpleEntity.getDrugsId() + "\u3011\u836f\u54c1\u6570\u91cf\u4e0d\u8db3\uff0c\u5269\u4f59\u836f\u54c1\u6570\u91cf\uff1a" + (simpleEntity.getActualInventory() - simpleEntity.getOccupyInventory()) + ";\u51fa\u5e93\u6570\u91cf\uff1a" + n.getQuantity()));
                }
                simpleEntity.setOccupyInventory(Integer.valueOf(simpleEntity.getOccupyInventory() + n.getQuantity()));
                this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleUpdateEntity(simpleEntity);
            }
            entity.setOutboundPurchaseAmount(purchaseAmount);
            entity.setOutboundRetailAmount(retailPrice);
            SysUserEntity userInfo = this.commonRequest.getUserInfo();
            if (null != userInfo) {
                entity.setOutboundUse(userInfo.getUserName());
            }
            int a = this.sysDrugPharmacyOutMapper.insert((Object)entity);
            ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_INSERT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_INSERT_ERROR.getName());
            this.sysDrugPharmacyOutPrescriptionService.sysDrugPharmacyOutPrescriptionSaveBatch(prescripList);
            return entity;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException(e.getMessage());
        }
    }

    public IPage<SysDrugPharmacyOutVo> sysDrugPharmacyOutSelect(Page page, SysDrugPharmacyOutDto dto) {
        IPage list = this.sysDrugPharmacyOutMapper.sysDrugPharmacyOutSelect(page, dto);
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyOutUpdate(SysDrugPharmacyOutUpdateDto dto) {
        BigDecimal retailPrice = new BigDecimal(0);
        SysDrugPharmacyOutEntity entity = (SysDrugPharmacyOutEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyOutEntity.class);
        List list = dto.getList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            int a;
            List oldPrescriptionList = this.sysDrugPharmacyOutPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyOutPrescriptionEntity::getDrugPharmacyOutId, (Object)dto.getId())).eq(SysDrugPharmacyOutPrescriptionEntity::getTenantId, (Object)dto.getTenantId()));
            for (SysDrugPharmacyOutPrescriptionEntity n : oldPrescriptionList) {
                a = this.sysDrugPharmacySimpleMapper.subtractInventory(n, dto.getOutboundWarehouse());
                ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_UPDATE_ERROR.getCode());
            }
            for (SysDrugPharmacyOutPrescriptionEntity n : dto.getList()) {
                retailPrice = retailPrice.add(new BigDecimal(n.getQuantity()).multiply(n.getRetailPrice()));
                a = this.sysDrugPharmacySimpleMapper.addInventory((SysDrugPharmacyOutPrescriptionUpdateDto)n, dto.getOutboundWarehouse());
                ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_UPDATE_ERROR.getCode());
            }
            entity.setOutboundRetailAmount(retailPrice);
            for (SysDrugPharmacyOutPrescriptionEntity n : list) {
                n.setTenantId(dto.getTenantId());
                this.sysDrugPharmacyOutPrescriptionService.sysDrugPharmacyOutPrescriptionUpdate((SysDrugPharmacyOutPrescriptionUpdateDto)n);
            }
        }
        int a = this.sysDrugPharmacyOutMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacyOutEntity::getId, (Object)dto.getId())).eq(SysDrugPharmacyOutEntity::getTenantId, (Object)dto.getTenantId())).eq(NoIdBaseEntity::getDelFlag, (Object)"0"));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_UPDATE_ERROR.getName());
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyOutDelete(String[] ids) {
        for (String id : ids) {
            this.removeOccupyInventory(this.commonRequest.getTenant(), id, this.commonRequest.getDrugRoomId());
        }
        int a = this.sysDrugPharmacyOutMapper.sysDrugPharmacyOutDelete(ids);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_DELETE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_DELETE_ERROR.getName());
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyOutBackDrug(String id, Integer tenantId, SysEasyEntity easyEntity) {
        SysDrugPharmacyOutEntity entry = (SysDrugPharmacyOutEntity)this.sysDrugPharmacyOutMapper.selectOne((Wrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacyOutEntity::getId, (Object)id));
        ExceptionUtils.createException((Logger)log, (!DictEnums.AUDIT_STATUS_ALREADY.getCode().equals(entry.getAuditStatus()) ? 1 : 0) != 0, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_STATUS_IS_NOT_CONFIRM_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_STATUS_IS_NOT_CONFIRM_ERROR.getName());
        SysDrugPharmacyOutEntity entity = new SysDrugPharmacyOutEntity();
        entity.setAuditStatus(DictEnums.AUDIT_STATUS_CANCEL.getCode());
        int a = this.sysDrugPharmacyOutMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacyOutEntity::getId, (Object)id));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_UPDATE_ERROR.getName());
        List drugPharmacyList = this.sysDrugPharmacyMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyEntity::getInventoryId, (Object)id));
        ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)drugPharmacyList), (String)SysDrugEnum.SYS_DRUG_PHARMACY_BACK_SELECT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_BACK_SELECT_ERROR.getName());
        Map<String, List<SysDrugPharmacyEntity>> drugPharmacyMap = drugPharmacyList.stream().collect(Collectors.groupingBy(SysDrugPharmacyEntity::getDrugsId));
        List prescriptionList = this.sysDrugPharmacyOutPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyOutPrescriptionEntity::getDrugPharmacyOutId, (Object)id)).eq(SysDrugPharmacyOutPrescriptionEntity::getTenantId, (Object)tenantId));
        Map<String, List<SysDrugPharmacyOutPrescriptionEntity>> prescriptionMap = prescriptionList.stream().collect(Collectors.groupingBy(SysDrugPharmacyOutPrescriptionEntity::getDrugsId));
        List ids = prescriptionList.stream().map(SysDrugPharmacyOutPrescriptionEntity::getDrugsId).collect(Collectors.toList());
        List simpleList = this.sysDrugPharmacySimpleMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugPharmacySimpleEntity::getDrugsId, ids)).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)entry.getOutboundWarehouse())).eq(SysDrugPharmacySimpleEntity::getDelFlag, (Object)"0")).orderByAsc(SysDrugPharmacySimpleEntity::getId)).last("FOR UPDATE"));
        ArrayList<SysDrugPharmacyOutLogEntity> logList = new ArrayList<SysDrugPharmacyOutLogEntity>();
        for (SysDrugPharmacySimpleEntity n : simpleList) {
            SysDrugPharmacyOutLogEntity logEntity = new SysDrugPharmacyOutLogEntity();
            List<SysDrugPharmacyOutPrescriptionEntity> mapOutPrescriptionlist = prescriptionMap.get(n.getDrugsId());
            List<SysDrugPharmacyEntity> mapDrugPharmacyList = drugPharmacyMap.get(n.getDrugsId());
            SysDrugPharmacyOutPrescriptionEntity mapOutPrescription = mapOutPrescriptionlist.get(0);
            logEntity.setDrugsId(n.getDrugsId());
            logEntity.setDrugsName(n.getDrugsName());
            logEntity.setActualInventory(n.getActualInventory());
            logEntity.setQuantity(mapOutPrescription.getQuantity());
            logEntity.setCreateId(this.commonRequest.getUserId());
            logEntity.setOccupyInventory(id);
            logEntity.setThirdCode("2");
            logList.add(logEntity);
            SysDrugPharmacyEntity mapDrugPharmacy = mapDrugPharmacyList.get(0);
            n.setActualInventory(Integer.valueOf(n.getActualInventory() + mapOutPrescription.getQuantity()));
            n.setPurchaseAmount(n.getPurchaseAmount().add(mapDrugPharmacy.getPurchaseAmount()));
            this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleUpdateEntity(n);
        }
        this.sysDrugPharmacyOutLogMapper.saveBatch(logList);
        for (SysDrugPharmacyEntity e : drugPharmacyList) {
            e.setId(UUIDUtils.getRandomMill());
            e.setActualInventory(Integer.valueOf(Math.abs(e.getActualInventory())));
            e.setInOutTime(new Date());
            e.setCreateTime(new Date());
            e.setInOutType("1");
            e.setInOutMethod("3");
        }
        List saveDtoList = BeanUtil.copyList((List)drugPharmacyList, SysDrugPharmacySaveDto.class);
        Map<String, List<SysDrugPharmacySaveDto>> saveMap = saveDtoList.stream().collect(Collectors.groupingBy(SysDrugPharmacySaveDto::getDrugsId));
        int b = this.sysDrugPharmacyMapper.sysDrugPharmacySaveBatch(saveDtoList);
        ExceptionUtils.createException((Logger)log, (int)b, (String)"\u95e8\u8bca\u9000\u836f\uff0c\u836f\u623f\u6279\u6b21\u6570\u636e\u56de\u9000\u5f02\u5e38");
        this.extendServiceImpl.sysDrugShelfBackDrug(id, tenantId, entry.getOutboundWarehouse());
        ArrayList<HsUploadParamSaveDto> hsUploadParamSaveDtos = new ArrayList<HsUploadParamSaveDto>();
        for (JSONObject n : easyEntity.getJsonList()) {
            String mergeFlag = String.valueOf(n.get((Object)"mergeFlag"));
            String pushFlag = String.valueOf(n.get((Object)"pushFlag"));
            String drugTracCodg = String.valueOf(n.get((Object)"drugTracCodg"));
            String quantity = String.valueOf(n.get((Object)"quantity"));
            String drugNo = String.valueOf(n.get((Object)"drugNo"));
            HsUploadParamSaveDto saveDto = new HsUploadParamSaveDto();
            saveDto.setTrdnSpecification(Integer.valueOf(Integer.parseInt(String.valueOf(n.get((Object)"trdnSpecification")))));
            saveDto.setDrugTraceableCode("null".equals(drugTracCodg) || null == drugTracCodg ? null : String.valueOf(n.get((Object)"drugTracCodg")));
            saveDto.setMergeFlag(Boolean.parseBoolean(mergeFlag));
            saveDto.setPushFlag(Boolean.parseBoolean(String.valueOf(n.get((Object)"pushFlag"))));
            saveDto.setTrdnUnit(null == n.get((Object)"trdnUnit") ? null : String.valueOf(n.get((Object)"trdnUnit")));
            saveDto.setPrescriptionDrugsId(String.valueOf(n.get((Object)"prescDrugId")));
            saveDto.setOutpatientNo(String.valueOf(n.get((Object)"outpatientNo")));
            saveDto.setType("2");
            saveDto.setPrescriptionNo(entry.getPrescriptionId());
            hsUploadParamSaveDtos.add(saveDto);
            if ("false".equals(pushFlag)) continue;
            if ("true".equals(pushFlag)) {
                ExceptionUtils.createException((Logger)log, (Objects.isNull(n.get((Object)"drugTracCodg")) || StringUtils.isBlank((String)String.valueOf(n.get((Object)"drugTracCodg"))) ? 1 : 0) != 0, (String)(String.valueOf(n.get((Object)"drugName")) + "\u8ffd\u6eaf\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                int length = drugTracCodg.split(",").length;
                ExceptionUtils.createException((Logger)log, (Integer.parseInt(quantity) != length ? 1 : 0) != 0, (String)("\u9000\u836f\u8ffd\u6eaf\u7801\u6570\u91cf\u4e0d\u4e00\u81f4\u9000\u836f\u6570\u91cf\uff1a" + quantity + "\uff1b\u8ffd\u6eaf\u7801\u6570\u91cf\uff1a" + length));
            }
            SysDrugEntity sysDrugEntity = (SysDrugEntity)this.sysDrugMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugEntity::getId, (Object)drugNo));
            if ("true".equals(mergeFlag)) {
                this.splitDrugCodg(easyEntity.getDrugTracCodg(), String.valueOf(n.get((Object)"drugNo")), Integer.valueOf(Integer.parseInt(String.valueOf(n.get((Object)"trdnSpecification")))));
            }
            if (Objects.isNull(sysDrugEntity)) continue;
            if (Integer.parseInt(sysDrugEntity.getPackSpecification()) > 1) {
                ExceptionUtils.createException((Logger)log, (boolean)"0".equals(sysDrugEntity.getUnpacking()), (String)(sysDrugEntity.getDrugsName() + "\u836f\u54c1\u6570\u636e\u5f02\u5e38\uff0c\u5305\u88c5\u89c4\u683c\u7cfb\u6570>1\u7684\u836f\u54c1\u4e0d\u80fd\u8fdb\u884c\u62c6\u96f6"));
                this.splitDrugCodg(easyEntity.getDrugTracCodg(), drugNo, Integer.valueOf(Integer.parseInt(sysDrugEntity.getPackSpecification())));
            }
            easyEntity.getDrugTracCodg().put("createId", (Object)this.commonRequest.getUserId());
            easyEntity.getDrugTracCodg().put("createName", (Object)this.commonRequest.getUserInfo().getUserName());
            this.hsUploadExtend.goodsReturnContext(saveMap.get(drugNo), easyEntity.getDrugTracCodg());
        }
        this.hsUploadParamService.saveBatch(hsUploadParamSaveDtos);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyOutUpdateStatus(SysDrugPharmacyOutUpdateStatusDto dto) {
        SysDrugPharmacyOutEntity e = (SysDrugPharmacyOutEntity)this.sysDrugPharmacyOutMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyOutEntity::getId, (Object)dto.getId()));
        if (DictEnums.AUDIT_STATUS_WAIT.getCode().equals(e.getAuditStatus())) {
            SysUserEntity userInfo;
            SysDrugPharmacyOutEntity entity = (SysDrugPharmacyOutEntity)BeanUtil.copy((Object)dto, SysDrugPharmacyOutEntity.class);
            if (dto.getAuditStatus().equals(DictEnums.AUDIT_STATUS_CANCEL.getCode())) {
                List entities = this.sysDrugPharmacyOutPrescriptionMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyOutPrescriptionEntity::getDrugPharmacyOutId, (Object)dto.getId()));
                List ids = entities.stream().map(SysDrugPharmacyOutPrescriptionEntity::getDrugsId).collect(Collectors.toList());
                List simpleList = this.sysDrugPharmacySimpleMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugPharmacySimpleEntity::getDrugsId, ids)).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)dto.getOutboundWarehouse())).eq(SysDrugPharmacySimpleEntity::getDelFlag, (Object)"0")).orderByAsc(SysDrugPharmacySimpleEntity::getId)).last("FOR UPDATE"));
                Map<String, List<SysDrugPharmacySimpleEntity>> simpleMap = simpleList.stream().collect(Collectors.groupingBy(SysDrugPharmacySimpleEntity::getDrugsId));
                for (SysDrugPharmacyOutPrescriptionEntity n : entities) {
                    SysDrugPharmacySimpleEntity simpleEntity = simpleMap.get(n.getDrugsId()).get(0);
                    simpleEntity.setOccupyInventory(Integer.valueOf(simpleEntity.getOccupyInventory() - n.getQuantity()));
                    int b = this.sysDrugPharmacySimpleMapper.updateById((Object)simpleEntity);
                    ExceptionUtils.createException((Logger)log, (int)b, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_UPDATE_ERROR.getName());
                }
            }
            if (null != (userInfo = this.commonRequest.getUserInfo())) {
                entity.setCompositeUse(userInfo.getUserName());
            }
            entity.setConfirmTime(new Date());
            int a = this.sysDrugPharmacyOutMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacyOutEntity::getTenantId, (Object)dto.getTenantId())).eq(SysDrugPharmacyOutEntity::getId, (Object)dto.getId()));
            ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_UPDATE_ERROR.getName());
        } else if (DictEnums.AUDIT_STATUS_ALREADY.getCode().equals(e.getAuditStatus())) {
            throw new BusinessException("500", "\u672a\u9000\u836f\uff0c\u8bf7\u5148\u8fdb\u884c\u9000\u836f\u64cd\u4f5c");
        }
    }

    public void sysDrugPharmacyOutExport(HttpServletResponse response, Page page, SysDrugPharmacyOutDto dto) {
        IPage list = this.sysDrugPharmacyOutMapper.sysDrugPharmacyOutSelect(page, dto);
        List excels = BeanUtil.copyList((List)list.getRecords(), SysDrugPharmacyOutExcel.class);
        for (SysDrugPharmacyOutExcel n : excels) {
            if (DictEnums.AUDIT_STATUS_WAIT.getCode().equals(n.getAuditStatus())) {
                n.setAuditStatus(DictEnums.AUDIT_STATUS_WAIT.getMsg());
                continue;
            }
            if (DictEnums.AUDIT_STATUS_ALREADY.getCode().equals(n.getAuditStatus())) {
                n.setAuditStatus(DictEnums.AUDIT_STATUS_ALREADY.getMsg());
                continue;
            }
            if (!DictEnums.AUDIT_STATUS_CANCEL.getCode().equals(n.getAuditStatus())) continue;
            n.setAuditStatus(DictEnums.AUDIT_STATUS_CANCEL.getMsg());
        }
        List dictValueList = this.sysDictValueMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getType, (Object)"drug_room_in_out_type")).eq(SysDictValueEntity::getTenantId, (Object)dto.getTenantId()));
        Map<String, List<SysDictValueEntity>> dictMap = dictValueList.stream().collect(Collectors.groupingBy(SysDictValueEntity::getValue));
        for (SysDrugPharmacyOutExcel n : excels) {
            List<SysDictValueEntity> dictValueEntityList = dictMap.get(n.getOutboundMethod());
            if (CollectionUtils.isEmpty(dictValueEntityList)) continue;
            n.setOutboundMethod(dictValueEntityList.get(0).getLabel());
        }
        String excelName = "\u836f\u623f\u51fa\u5e93\u5bfc\u51fa";
        String sheetName = "\u836f\u623f\u51fa\u5e93";
        try {
            EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)excelName, (String)sheetName, (List)excels, (Object)new SysDrugPharmacyOutExcel());
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_EXPORT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_IN_EXPORT_ERROR.getName());
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public ResponseData sysDrugPharmacyOutSearchByPrescriptionNoAndConfirm(SysEasyEntity entity) {
        List outList = this.sysDrugPharmacyOutMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugPharmacyOutEntity::getPrescriptionId, (Object[])entity.getIds())).eq(SysDrugPharmacyOutEntity::getTenantId, (Object)entity.getTenantId()));
        Iterator iterator = outList.iterator();
        if (iterator.hasNext()) {
            SysDrugPharmacyOutEntity n = (SysDrugPharmacyOutEntity)iterator.next();
            entity.setId(n.getId());
            return this.sysDrugPharmacyOutConfirm(entity, entity.getTenantId());
        }
        return ResponseData.success();
    }

    public List<SysDrugPharmacySimpleVo> sysDrugPharmacyOutList(SysDrugPharmacySimpleDto dto) {
        List list = this.sysDrugPharmacySimpleMapper.sysDrugPharmacyOutList(dto);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (SysDrugPharmacySimpleVo n : list) {
                n.getActualInventory();
                n.setActualInventory(Integer.valueOf(n.getActualInventory() - n.getOccupyInventory()));
                String isPlus = dto.getIsPlus();
                if (isPlus != null && !isPlus.equals("on")) continue;
                this.commonRequest.checkNumber(SysCommonEnum.BACK_OR_LOSS_LT_ZERO_01.getCode(), SysCommonEnum.BACK_OR_LOSS_LT_ZERO_01.getName(), new Integer[]{n.getActualInventory()});
            }
        }
        return list;
    }

    public IPage<SysDrugPharmacySimpleVo> sysDrugPharmacyOutPageList(Page page, SysDrugPharmacySimpleDto dto) {
        IPage iPage = this.sysDrugPharmacySimpleMapper.sysDrugPharmacyOutPageList(page, dto);
        List list = iPage.getRecords();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (SysDrugPharmacySimpleVo n : list) {
                n.getActualInventory();
                n.setActualInventory(Integer.valueOf(n.getActualInventory() - n.getOccupyInventory()));
                String isPlus = dto.getIsPlus();
                if (isPlus != null && !isPlus.equals("on")) continue;
                this.commonRequest.checkNumber(SysCommonEnum.BACK_OR_LOSS_LT_ZERO_01.getCode(), SysCommonEnum.BACK_OR_LOSS_LT_ZERO_01.getName(), new Integer[]{n.getActualInventory()});
            }
        }
        return iPage;
    }

    public List<SysDrugPharmacySimpleVo> numberSearch(SysDrugPharmacySimpleDto dto) {
        List list = this.sysDrugPharmacySimpleMapper.numberSearch(dto);
        return list;
    }

    public SysDrugPharmacyOutVo sysDrugPharmacyOutSelectById(SysEasyEntity dto) {
        if (null != dto.getWarehouse() && !"202401290919222322,202401290919222323,2024042515142937970,2025042317264321881".contains(dto.getWarehouse())) {
            return null;
        }
        SysDrugPharmacyOutEntity entity = (SysDrugPharmacyOutEntity)this.sysDrugPharmacyOutMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyOutEntity::getPrescriptionId, (Object)dto.getId())).eq(SysDrugPharmacyOutEntity::getTenantId, (Object)dto.getTenantId()));
        ExceptionUtils.createException((Logger)log, (boolean)Objects.isNull(entity), (String)"500", (String)("\u901a\u8fc7\u5904\u65b9\u3010id\uff1a" + dto.getId() + "\u3011\u83b7\u53d6\u5230\u7684\u51fa\u5e93\u5355\u4e3a\u7a7a"));
        SysDrugPharmacyOutVo vo = (SysDrugPharmacyOutVo)BeanUtil.copy((Object)entity, SysDrugPharmacyOutVo.class);
        return vo;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public ResponseData sysDrugPharmacyOutConfirm(SysEasyEntity easyEntity, Integer tenantId) {
        SysDrugPharmacyOutEntity entry = (SysDrugPharmacyOutEntity)this.sysDrugPharmacyOutMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyOutEntity::getId, (Object)easyEntity.getId()));
        ExceptionUtils.createException((Logger)log, (boolean)Objects.isNull(entry), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u51fa\u5e93\u5355");
        if (DictEnums.AUDIT_STATUS_ALREADY.getCode().equals(entry.getAuditStatus())) {
            return ResponseData.success().msg(SysDrugEnum.SYS_DRUG_PHARMACY_OUT_STATUS_ALREADY_CONFIRM_ERROR.getName());
        }
        if (DictEnums.AUDIT_STATUS_CANCEL.getCode().equals(entry.getAuditStatus())) {
            ExceptionUtils.createException((Logger)log, (boolean)Boolean.TRUE, (String)"\u5f53\u524d\u51fa\u5e93\u5355\u5df2\u88ab\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d1\u836f");
        }
        SysDrugPharmacyOutEntity entity = new SysDrugPharmacyOutEntity();
        entity.setAuditStatus(DictEnums.AUDIT_STATUS_ALREADY.getCode());
        entity.setConfirmTime(new Date());
        SysUserEntity userInfo = this.commonRequest.getUserInfo();
        if (null != userInfo) {
            entity.setCompositeUse(userInfo.getUserName());
        }
        int a = this.sysDrugPharmacyOutMapper.update((Object)entity, (Wrapper)Wrappers.lambdaUpdate().eq(SysDrugPharmacyOutEntity::getId, (Object)easyEntity.getId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_UPDATE_ERROR.getName());
        List saveDtoList = this.addInventory(easyEntity.getId(), tenantId, entry, entity.getConfirmTime(), easyEntity.getDrugTracCodg(), easyEntity.getJsonList());
        return ResponseData.success().confirm();
    }

    public void checkLossOrBack(SysDrugPharmacyOutSaveDto dto) {
        if (DictEnums.DRUG_PHARMACY_OUT_BOUND_METHOD_7.getCode().equals(dto.getOutboundMethod()) || DictEnums.DRUG_PHARMACY_OUT_BOUND_METHOD_8.getCode().equals(dto.getOutboundMethod())) {
            Map<String, List<SysDrugPharmacyOutPrescriptionSaveDto>> drugMap = dto.getList().stream().collect(Collectors.groupingBy(SysDrugPharmacyOutPrescriptionSaveDto::getDrugsId));
            List<String> drugsId = dto.getList().stream().map(SysDrugPharmacyOutPrescriptionSaveDto::getDrugsId).distinct().collect(Collectors.toList());
            SysEasyEntity sysEasyEntity = new SysEasyEntity();
            sysEasyEntity.setIds(drugsId.toArray(new String[drugsId.size()]));
            sysEasyEntity.setTenantId(dto.getTenantId());
            if (dto.getOutboundWarehouse() != null) {
                sysEasyEntity.setWarehouse(dto.getOutboundWarehouse());
            }
            List simpleList = this.sysDrugPharmacyOutSearchByIds(sysEasyEntity);
            Map<String, List<SysDrugPharmacySimpleVo>> simpleMap = simpleList.stream().collect(Collectors.groupingBy(SysDrugPharmacySimpleVo::getDrugsId));
            for (Map.Entry<String, List<SysDrugPharmacyOutPrescriptionSaveDto>> entry : drugMap.entrySet()) {
                List<SysDrugPharmacySimpleVo> simpleVo;
                int saveQuantity = entry.getValue().stream().mapToInt(SysDrugPharmacyOutPrescriptionSaveDto::getQuantity).sum();
                if (saveQuantity <= (simpleVo = simpleMap.get(entry.getKey())).get(0).getActualInventory()) continue;
                String b = "\u3010" + simpleVo.get(0).getDrugsName() + "\u3011" + SysDrugEnum.SYS_DRUG_PHARMACY_OUT_LOSS_OR_BACK_ERROR.getName() + "\u3010\u5e93\u5b58\u6570\uff1a" + (simpleVo.get(0).getActualInventory() + simpleVo.get(0).getOccupyInventory()) + "\uff1b\u5360\u7528\u5e93\u5b58\uff1a" + simpleVo.get(0).getOccupyInventory() + "\uff1b\u3011";
                ExceptionUtils.createException((Logger)log, (boolean)Boolean.TRUE, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_LOSS_OR_BACK_ERROR.getCode(), (String)b);
            }
        }
    }

    public void addStartAndEnd(SysDrugPharmacyOutEntity entry, List<SysDrugPharmacySaveDto> saveDtoList, Integer tenantId) {
        Date date = entry.getOutboundTime();
        String year = DateUtils.dateFormat((Date)date, (String)"yyyy");
        String month = DateUtils.dateFormat((Date)date, (String)"MM");
        String day = DateUtils.dateFormat((Date)date, (String)"dd");
        for (SysDrugPharmacySaveDto saveDto : saveDtoList) {
            SysDrugPharmacyQcQmEntity qcQmEntity = (SysDrugPharmacyQcQmEntity)this.sysDrugPharmacyQcQmMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyQcQmEntity::getWarehouse, (Object)entry.getOutboundWarehouse())).eq(SysDrugPharmacyQcQmEntity::getDrugId, (Object)saveDto.getDrugsId())).eq(SysDrugPharmacyQcQmEntity::getDrugYear, (Object)year)).eq(SysDrugPharmacyQcQmEntity::getDrugMonth, (Object)month)).eq(SysDrugPharmacyQcQmEntity::getDrugDay, (Object)day)).eq(SysDrugPharmacyQcQmEntity::getTenantId, (Object)tenantId));
            if (null != qcQmEntity) {
                qcQmEntity.setOutNum(Integer.valueOf(qcQmEntity.getOutNum() + saveDto.getActualInventory()));
                this.sysDrugPharmacyQcQmService.sysDrugPharmacyQcQmUpdateEntity(qcQmEntity);
                continue;
            }
            SysDrugPharmacyQcQmSaveDto qcQmSaveDto = new SysDrugPharmacyQcQmSaveDto();
            qcQmSaveDto.setWarehouse(entry.getOutboundWarehouse());
            qcQmSaveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            qcQmSaveDto.setDrugYear(year);
            qcQmSaveDto.setDrugMonth(month);
            qcQmSaveDto.setDrugDay(day);
            qcQmSaveDto.setDrugId(saveDto.getDrugsId());
            qcQmSaveDto.setDrugName(saveDto.getDrugsName());
            qcQmSaveDto.setOutNum(saveDto.getActualInventory());
            qcQmSaveDto.setTenantId(tenantId);
            this.sysDrugPharmacyQcQmService.sysDrugPharmacyQcQmSave(qcQmSaveDto);
        }
    }

    public List<SysDrugPharmacySaveDto> addInventory(String id, Integer tenantId, SysDrugPharmacyOutEntity entry, Date confirmTime, JSONObject drugTracCodg, List<JSONObject> jsonList) {
        ArrayList<SysDrugPharmacySaveDto> saveDtoList = new ArrayList<SysDrugPharmacySaveDto>();
        List list = this.sysDrugPharmacyOutPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyOutPrescriptionEntity::getDrugPharmacyOutId, (Object)id)).eq(SysDrugPharmacyOutPrescriptionEntity::getTenantId, (Object)tenantId)).eq(NoIdBaseEntity::getDelFlag, (Object)Character.valueOf('0')));
        List sysDrugPharmacyList = this.sysDrugPharmacyMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyEntity::getInventoryId, (Object)id)).eq(SysDrugPharmacyEntity::getInOutMethod, (Object)"10")).last("limit 1"));
        ExceptionUtils.createException((Logger)log, (!CollectionUtils.isEmpty((Collection)sysDrugPharmacyList) ? 1 : 0) != 0, (String)"500", (String)("\u51fa\u5e93\u5355\u53f7\uff1a" + id + "\u5df2\u7ecf\u5728\u51fa\u5e93\u660e\u7ec6\u4e2d\u3002\u8bf7\u52ff\u518d\u6b21\u64cd\u4f5c\u3002"));
        this.batchOut(list, entry, saveDtoList, confirmTime);
        this.sysDrugPharmacyMapper.sysDrugPharmacySaveBatch(saveDtoList);
        this.extendServiceImpl.sysDrugShelfPharmacyOutSaveBatch(saveDtoList, entry.getOutboundWarehouse(), tenantId);
        if ("202401290919222322,2025042317264321881".contains(entry.getOutboundWarehouse()) && "10,11,12".contains(entry.getOutboundMethod())) {
            ArrayList<HsUploadParamSaveDto> hsUploadParamSaveDtos = new ArrayList<HsUploadParamSaveDto>();
            for (JSONObject n : jsonList) {
                Object cods = drugTracCodg.get((Object)String.valueOf(n.get((Object)"drugNo")));
                String drugNo = String.valueOf(n.get((Object)"drugNo"));
                String drugName = String.valueOf(n.get((Object)"drugName"));
                String quantity = String.valueOf(n.get((Object)"quantity"));
                String mergeFlag = String.valueOf(n.get((Object)"mergeFlag"));
                String pushFlag = String.valueOf(n.get((Object)"pushFlag"));
                HsUploadParamSaveDto saveDto = new HsUploadParamSaveDto();
                saveDto.setTrdnSpecification(Integer.valueOf(Integer.parseInt(String.valueOf(n.get((Object)"trdnSpecification")))));
                saveDto.setDrugTraceableCode("null".equals(String.valueOf(n.get((Object)"drugTracCodg"))) || null == String.valueOf(n.get((Object)"drugTracCodg")) ? null : String.valueOf(n.get((Object)"drugTracCodg")));
                saveDto.setMergeFlag(Boolean.parseBoolean(mergeFlag));
                saveDto.setPushFlag(Boolean.parseBoolean(String.valueOf(n.get((Object)"pushFlag"))));
                saveDto.setTrdnUnit(null == n.get((Object)"trdnUnit") ? null : String.valueOf(n.get((Object)"trdnUnit")));
                saveDto.setPrescriptionDrugsId(String.valueOf(n.get((Object)"prescDrugId")));
                saveDto.setOutpatientNo(String.valueOf(n.get((Object)"outpatientNo")));
                saveDto.setType("1");
                saveDto.setPrescriptionNo(entry.getPrescriptionId());
                hsUploadParamSaveDtos.add(saveDto);
                if ("false".equals(pushFlag)) continue;
                ExceptionUtils.createException((Logger)log, (null == cods || "".equals(cods) ? 1 : 0) != 0, (String)"500", (String)("\u3010" + drugName + "\u3011\u8ffd\u6eaf\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                int length = drugTracCodg.get((Object)drugNo).toString().trim().split(",").length;
                ExceptionUtils.createException((Logger)log, (Integer.parseInt(quantity) != length ? 1 : 0) != 0, (String)"500", (String)("\u836f\u54c1\uff1a" + drugName + "\uff1b\u53d1\u836f\u6570\u91cf\uff1a" + quantity + "\uff1b\u8ffd\u6eaf\u7801\u6570\u91cf\uff1a" + length + "\uff1b\u8bf7\u68c0\u67e5"));
                drugTracCodg.put("createName", (Object)this.commonRequest.getUserInfo().getUserName());
                drugTracCodg.put("createId", (Object)this.commonRequest.getUserInfo().getId());
                Map<String, List<SysDrugPharmacySaveDto>> map = saveDtoList.stream().collect(Collectors.groupingBy(SysDrugPharmacySaveDto::getDrugsId));
                SysDrugEntity sysDrugEntity = (SysDrugEntity)this.sysDrugMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugEntity::getId, (Object)drugNo));
                if ("true".equals(mergeFlag)) {
                    int trdnSpecification = Integer.parseInt(String.valueOf(n.get((Object)"trdnSpecification")));
                    this.splitDrugCodg(drugTracCodg, drugNo, Integer.valueOf(trdnSpecification));
                }
                if (Objects.isNull(sysDrugEntity)) continue;
                if (Integer.parseInt(sysDrugEntity.getPackSpecification()) > 1) {
                    ExceptionUtils.createException((Logger)log, (boolean)"0".equals(sysDrugEntity.getUnpacking()), (String)(sysDrugEntity.getDrugsName() + "\u836f\u54c1\u6570\u636e\u5f02\u5e38\uff0c\u5305\u88c5\u89c4\u683c\u7cfb\u6570>1\u7684\u836f\u54c1\u4e0d\u80fd\u8fdb\u884c\u62c6\u96f6"));
                    this.splitDrugCodg(drugTracCodg, drugNo, Integer.valueOf(Integer.parseInt(sysDrugEntity.getPackSpecification())));
                }
                this.hsUploadExtend.context(map.get(String.valueOf(n.get((Object)"drugNo"))), drugTracCodg);
            }
            this.hsUploadParamService.saveBatch(hsUploadParamSaveDtos);
        }
        return saveDtoList;
    }

    private void splitDrugCodg(JSONObject drugTracCodg, String drugNo, Integer loopCount) {
        String[] split = drugTracCodg.get((Object)drugNo).toString().trim().split(",");
        StringBuilder builder = new StringBuilder(30);
        for (String s : split) {
            for (int l = 0; l < loopCount; ++l) {
                builder.append(s).append(",");
            }
        }
        String substring = builder.substring(0, builder.length() - 1);
        drugTracCodg.put(drugNo, (Object)substring);
    }

    private void batchOut(List<SysDrugPharmacyOutPrescriptionEntity> list, SysDrugPharmacyOutEntity entry, List<SysDrugPharmacySaveDto> saveDtoList, Date confirmTime) {
        if (DictEnums.DRUG_PHARMACY_OUT_BOUND_METHOD_7.getCode().equals(entry.getOutboundMethod()) || DictEnums.DRUG_PHARMACY_OUT_BOUND_METHOD_8.getCode().equals(entry.getOutboundMethod())) {
            this.drugPharmacyBackOut(list, entry, saveDtoList, confirmTime);
        } else {
            this.drugPharmacyNormalOut(list, entry, saveDtoList, confirmTime);
        }
    }

    private void drugPharmacyBackOut(List<SysDrugPharmacyOutPrescriptionEntity> list, SysDrugPharmacyOutEntity entry, List<SysDrugPharmacySaveDto> saveDtoList, Date confirmTime) {
        if (DictEnums.DRUG_PHARMACY_OUT_BOUND_METHOD_7.getCode().equals(entry.getOutboundMethod())) {
            this.saveSysDrugPharmacyOutTemp(entry);
        }
        ArrayList<SysDrugPharmacyOutLogEntity> logList = new ArrayList<SysDrugPharmacyOutLogEntity>();
        for (SysDrugPharmacyOutPrescriptionEntity n : list) {
            SysDrugPharmacyOutLogEntity logEntity = new SysDrugPharmacyOutLogEntity();
            SysDrugPharmacySaveDto saveDto = (SysDrugPharmacySaveDto)BeanUtil.copy((Object)n, SysDrugPharmacySaveDto.class);
            saveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
            saveDto.setInventoryId(n.getDrugPharmacyOutId());
            saveDto.setInOutType(DictEnums.IN_OUT_TYPE_OUT.getCode());
            saveDto.setInOutMethod(entry.getOutboundMethod());
            saveDto.setBatchNumber(n.getBatchNumber());
            saveDto.setInOutTime(confirmTime);
            saveDto.setWarehouse(entry.getOutboundWarehouse());
            saveDto.setPurchasePrice(n.getPurchasePrice());
            saveDto.setRetailPrice(n.getRetailPrice());
            saveDto.setSupplierId(entry.getSupplierId());
            saveDto.setSupplierName(entry.getSupplierName());
            saveDto.setShelfNumber(n.getShelfNumber());
            saveDto.setActualInventory(Integer.valueOf(-n.getQuantity().intValue()));
            saveDto.setPurchaseAmount(new BigDecimal(n.getQuantity()).multiply(n.getPurchasePrice()));
            saveDto.setRetailAmount(new BigDecimal(n.getQuantity()).multiply(n.getRetailPrice()));
            saveDto.setEffectiveTime(n.getEffectiveTime());
            logEntity.setCreateId(this.commonRequest.getUserId());
            logEntity.setDrugsId(n.getDrugsId());
            logEntity.setDrugsName(n.getDrugsName());
            this.selectAndCheckSimpleExist(n, entry, logEntity);
            logList.add(logEntity);
            saveDtoList.add(saveDto);
            this.sysDrugPharmacyOutLogMapper.saveBatch(logList);
        }
    }

    private void drugPharmacyNormalOut(List<SysDrugPharmacyOutPrescriptionEntity> list, SysDrugPharmacyOutEntity entry, List<SysDrugPharmacySaveDto> saveDtoList, Date confirmTime) {
        List drugsIds = list.stream().map(SysDrugPharmacyOutPrescriptionEntity::getDrugsId).collect(Collectors.toList());
        List sysDrugPharmacyVos = this.extendServiceImpl.getDrugBatchDetail(drugsIds, entry.getOutboundWarehouse(), entry.getTenantId());
        Map<String, List<SysDrugPharmacyVo>> inventoryMap = sysDrugPharmacyVos.stream().filter(n -> n.getActualInventory() > 0).collect(Collectors.groupingBy(SysDrugPharmacyVo::getDrugsId));
        Map<Object, Object> backMap = new HashMap(10);
        List backList = this.sysDrugPharmacyOutMapper.selectBackType(drugsIds, entry.getOutboundWarehouse());
        if (!CollectionUtils.isEmpty((Collection)backList)) {
            backMap = backList.stream().collect(Collectors.groupingBy(SysDrugPharmacyOutPrescriptionVo::getDrugsId));
        }
        ArrayList<SysDrugPharmacyOutLogEntity> logList = new ArrayList<SysDrugPharmacyOutLogEntity>();
        if (!CollectionUtils.isEmpty(list)) {
            for (SysDrugPharmacyOutPrescriptionEntity n2 : list) {
                SysDrugPharmacyOutLogEntity logEntity = new SysDrugPharmacyOutLogEntity();
                Map<Object, Object> curDrugBatchMap = new HashMap(5);
                List l = (List)backMap.get(n2.getDrugsId());
                if (!CollectionUtils.isEmpty((Collection)l)) {
                    curDrugBatchMap = ((List)backMap.get(n2.getDrugsId())).stream().collect(Collectors.groupingBy(SysDrugPharmacyOutPrescriptionVo::getBatchNumber));
                }
                BigDecimal purchasePriceAmount = new BigDecimal(0);
                Integer quantity = n2.getQuantity();
                List<SysDrugPharmacyVo> batch = inventoryMap.get(n2.getDrugsId());
                ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty(batch), (String)"500", (String)("\u836f\u54c1\uff1a\u3010" + n2.getDrugsName() + "\u3011\u6ca1\u6709\u67e5\u8be2\u5230\u5177\u4f53\u6279\u6b21\uff0c\u8bf7\u68c0\u67e5\u5e93\u5b58\u6570\u91cf\u548c\u6279\u6b21\u6570\u91cf\u662f\u5426\u4e00\u76f4"));
                for (SysDrugPharmacyVo m : batch) {
                    if (quantity <= 0) continue;
                    SysDrugPharmacySaveDto saveDto = (SysDrugPharmacySaveDto)BeanUtil.copy((Object)n2, SysDrugPharmacySaveDto.class);
                    saveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
                    saveDto.setInventoryId(n2.getDrugPharmacyOutId());
                    logEntity.setOccupyInventory(saveDto.getInventoryId());
                    logEntity.setThirdCode("1");
                    saveDto.setInOutType(DictEnums.IN_OUT_TYPE_OUT.getCode());
                    saveDto.setInOutMethod(entry.getOutboundMethod());
                    saveDto.setBatchNumber(m.getBatchNumber());
                    saveDto.setInOutTime(confirmTime);
                    saveDto.setWarehouse(entry.getOutboundWarehouse());
                    saveDto.setSupplierId(entry.getSupplierId());
                    saveDto.setSupplierName(entry.getSupplierName());
                    saveDto.setShelfNumber(m.getShelfNumber());
                    saveDto.setPrescriptionId(entry.getPrescriptionId());
                    saveDto.setThirdCode(m.getThirdCode());
                    saveDto.setInternalCode(m.getInternalCode());
                    List backChild = (List)curDrugBatchMap.get(m.getBatchNumber());
                    if (!CollectionUtils.isEmpty((Collection)backChild)) {
                        for (SysDrugPharmacyOutPrescriptionVo s : backChild) {
                            if (s.getPurchasePrice().compareTo(m.getPurchasePrice()) != 0) continue;
                            m.setActualInventory(Integer.valueOf(m.getActualInventory() - s.getQuantity()));
                            this.commonRequest.checkNumber(SysCommonEnum.BACK_OR_LOSS_LT_ZERO_02.getCode(), SysCommonEnum.BACK_OR_LOSS_LT_ZERO_02.getName(), new Integer[]{m.getActualInventory()});
                        }
                    }
                    if (m.getActualInventory() <= quantity) {
                        saveDto.setActualInventory(Integer.valueOf(-m.getActualInventory().intValue()));
                        saveDto.setPurchaseAmount(new BigDecimal(m.getActualInventory()).multiply(m.getPurchasePrice()));
                        saveDto.setRetailAmount(new BigDecimal(m.getActualInventory()).multiply(n2.getRetailPrice()));
                        saveDto.setEffectiveTime(m.getEffectiveTime());
                        saveDto.setPurchasePrice(m.getPurchasePrice());
                        saveDto.setRetailPrice(n2.getRetailPrice());
                        purchasePriceAmount = purchasePriceAmount.add(saveDto.getPurchaseAmount());
                        quantity = quantity - m.getActualInventory();
                        saveDtoList.add(saveDto);
                        continue;
                    }
                    saveDto.setActualInventory(Integer.valueOf(-quantity.intValue()));
                    saveDto.setPurchasePrice(m.getPurchasePrice());
                    saveDto.setRetailPrice(n2.getRetailPrice());
                    saveDto.setPurchaseAmount(new BigDecimal(quantity).multiply(m.getPurchasePrice()));
                    saveDto.setRetailAmount(new BigDecimal(quantity).multiply(n2.getRetailPrice()));
                    saveDto.setEffectiveTime(m.getEffectiveTime());
                    quantity = 0;
                    purchasePriceAmount = purchasePriceAmount.add(saveDto.getPurchaseAmount());
                    saveDtoList.add(saveDto);
                    break;
                }
                ExceptionUtils.createException((Logger)log, (quantity > 0 ? 1 : 0) != 0, (String)"500", (String)("\u836f\u54c1\uff1a\u3010" + n2.getDrugsName() + "\u3011\u51fa\u5e93\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3\uff0c\u5269\u4f59\uff1a" + quantity + "\u672a\u51fa\u5e93"));
                n2.setPurchasePrice(purchasePriceAmount);
                logEntity.setCreateId(this.commonRequest.getUserId());
                logEntity.setDrugsId(n2.getDrugsId());
                logEntity.setDrugsName(n2.getDrugsName());
                this.selectAndCheckSimpleExist(n2, entry, logEntity);
                logList.add(logEntity);
            }
            this.sysDrugPharmacyOutLogMapper.saveBatch(logList);
        }
    }

    private void selectAndCheckSimpleExist(SysDrugPharmacyOutPrescriptionEntity n, SysDrugPharmacyOutEntity entry, SysDrugPharmacyOutLogEntity logEntity) {
        SysDrugPharmacySimpleEntity simpleMaterialEntity = (SysDrugPharmacySimpleEntity)this.sysDrugPharmacySimpleMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacySimpleEntity::getDrugsId, (Object)n.getDrugsId())).eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)n.getTenantId())).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)entry.getOutboundWarehouse())).eq(SysDrugPharmacySimpleEntity::getDelFlag, (Object)"0")).orderByAsc(SysDrugPharmacySimpleEntity::getId)).last("FOR UPDATE"));
        if (null != simpleMaterialEntity) {
            logEntity.setActualInventory(simpleMaterialEntity.getActualInventory());
            logEntity.setQuantity(n.getQuantity());
            simpleMaterialEntity.setActualInventory(Integer.valueOf(simpleMaterialEntity.getActualInventory() - n.getQuantity()));
            simpleMaterialEntity.setOccupyInventory(Integer.valueOf(simpleMaterialEntity.getOccupyInventory() - n.getQuantity()));
            simpleMaterialEntity.setPurchaseAmount(simpleMaterialEntity.getPurchaseAmount().subtract(n.getPurchasePrice()));
            this.commonRequest.checkNumber(n.getDrugsName() + SysCommonEnum.BACK_OR_LOSS_LT_ZERO_03.getCode(), SysCommonEnum.BACK_OR_LOSS_LT_ZERO_03.getName(), new Integer[]{simpleMaterialEntity.getActualInventory(), simpleMaterialEntity.getOccupyInventory()});
            this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleUpdateEntity(simpleMaterialEntity);
        } else {
            ExceptionUtils.createException((Logger)log, (boolean)Boolean.TRUE, (String)SysDrugEnum.SYS_DRUG_PHARMACY_SIMPLE_OUT_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_SIMPLE_OUT_ERROR.getName());
        }
    }

    public IPage<SysDrugPharmacySimpleVo> searchForPresc(Page page, SysDrugPharmacySimpleDto dto) {
        JSONObject resultJson;
        IPage voPage;
        String param = this.sysParamService.sysParamSelectByNameReturnValue("JSKF_YF", Integer.valueOf(1));
        String isDispensing = dto.getIsPlus();
        boolean isMatch = false;
        if (!StrUtil.isBlank((CharSequence)param)) {
            String[] warehouses = param.split(",");
            isMatch = Arrays.asList(warehouses).contains(dto.getWarehouse());
        }
        if (isMatch) {
            voPage = this.sysDrugPharmacySimpleMapper.searchForPresc2(page, dto);
            voPage.getRecords().stream().forEach(item -> item.setActualInventory(Integer.valueOf(1000)));
            return voPage;
        }
        if ("2024122210263130864".equals(dto.getWarehouse().trim())) {
            resultJson = null;
            if ("3".equals(isDispensing)) {
                AdmissionEntity data;
                String remark;
                String outpatientNo = dto.getOutpatientNo();
                AdmissionEntity admission = new AdmissionEntity();
                admission.setOutpatientNo(outpatientNo);
                ResponseData admissionEntityResponseData = this.outServiceFeign.queryAdmissionByOutpatient(admission);
                String code = admissionEntityResponseData.getCode();
                if ("200".equals(code) && !StringUtils.isBlank((String)(remark = (data = (AdmissionEntity)admissionEntityResponseData.getData()).getRemark()))) {
                    String deviceNo = remark.replaceAll("deviceNo=", "");
                    dto.setDeviceNo(deviceNo);
                    log.info("\u836f\u54c1\u67e5\u8be2,\u53d1\u836f\u673adeviceNo========>{}", (Object)deviceNo);
                    if (!StringUtils.isBlank((String)deviceNo)) {
                        String baseUrl = "https://medbox.x.yaoxz.cn/mac158";
                        String url = "/his/device/getdrugbycode";
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("deviceNo", deviceNo);
                        try {
                            String reqJson = JSONObject.toJSONString(map);
                            log.info("\u8bf7\u6c42\u53d1\u836f\u673a\u5e93\u5b58\u5165\u53c2========>{}", (Object)reqJson);
                            String post = HttpUtils.post((String)(baseUrl + url), (String)reqJson);
                            log.info("\u8bf7\u6c42\u53d1\u836f\u673a\u5e93\u5b58\u53cd\u53c2========>{}", (Object)post);
                            resultJson = JSON.parseObject((String)post);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ArrayList<String> drugIds = new ArrayList<String>();
                drugIds.add("2025032609564018225");
                drugIds.add("2025032609542377380");
                drugIds.add("2025032609533948460");
                drugIds.add("2025032609524443995");
                drugIds.add("2025032609515687815");
                dto.setDrugIds(drugIds);
            }
            IPage voPage2 = this.sysDrugPharmacySimpleMapper.searchForPresc3(page, dto);
            if (resultJson != null) {
                String status = resultJson.get((Object)"status").toString();
                if ("200".equals(status)) {
                    JSONArray data = resultJson.getJSONArray("data");
                    HashMap<String, String> emptyDrugList = new HashMap<String, String>();
                    for (int i = 0; i < data.size(); ++i) {
                        JSONObject drugJson = data.getJSONObject(i);
                        String quantity = drugJson.get((Object)"quantity").toString();
                        String commonname = drugJson.get((Object)"commonname").toString();
                        emptyDrugList.put(commonname, quantity);
                    }
                    Set keys = emptyDrugList.keySet();
                    voPage2.getRecords().stream().forEach(item -> {
                        if (keys.contains(item.getDrugsName())) {
                            item.setActualInventory(Integer.valueOf(Integer.parseInt(((String)emptyDrugList.get(item.getDrugsName())).toString())));
                        }
                    });
                }
                log.info("\u8bf7\u6c42\u53d1\u836f\u673a\u5e93\u5b58\u6700\u7ec8\u53cd\u53c2========>{}", (Object)JSONObject.toJSONString((Object)voPage2));
            } else {
                voPage2.getRecords().stream().forEach(item -> item.setActualInventory(Integer.valueOf(1000)));
            }
            return voPage2;
        }
        if ("2025031715504724456".equals(dto.getWarehouse().trim())) {
            AdmissionEntity data;
            String remark;
            resultJson = null;
            String outpatientNo = dto.getOutpatientNo();
            log.info("\u53d1\u836f\u673a\u67e5\u8be2\u836f\u54c1\uff0c\u95e8\u8bca\u53f7=========>{}", (Object)outpatientNo);
            if (StringUtils.isBlank((String)outpatientNo)) {
                outpatientNo = "156384600371270221";
            }
            AdmissionEntity admission = new AdmissionEntity();
            admission.setOutpatientNo(outpatientNo);
            ResponseData admissionEntityResponseData = this.outServiceFeign.queryAdmissionByOutpatient(admission);
            String code = admissionEntityResponseData.getCode();
            if ("200".equals(code) && !StringUtils.isBlank((String)(remark = (data = (AdmissionEntity)admissionEntityResponseData.getData()).getRemark()))) {
                String deviceNo = remark.replaceAll("deviceNo=", "");
                dto.setDeviceNo(deviceNo);
                log.info("\u836f\u54c1\u67e5\u8be2,\u53d1\u836f\u673adeviceNo========>{}", (Object)deviceNo);
                if (!StringUtils.isBlank((String)deviceNo)) {
                    String baseUrl = "https://medbox.x.yaoxz.cn/mac158";
                    String url = "/his/device/getdrugbycode";
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("deviceNo", deviceNo);
                    try {
                        String reqJson = JSONObject.toJSONString(map);
                        log.info("\u8bf7\u6c42\u53d1\u836f\u673a\u5e93\u5b58\u5165\u53c2========>{}", (Object)reqJson);
                        String post = HttpUtils.post((String)(baseUrl + url), (String)reqJson);
                        log.info("\u8bf7\u6c42\u53d1\u836f\u673a\u5e93\u5b58\u53cd\u53c2========>{}", (Object)post);
                        resultJson = JSON.parseObject((String)post);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            ArrayList<String> thirdCodes = new ArrayList<String>();
            JSONArray data2 = resultJson.getJSONArray("data");
            for (int i = 0; i < data2.size(); ++i) {
                JSONObject drug = data2.getJSONObject(i);
                String productIdHis = drug.getString("productIdHis");
                thirdCodes.add(productIdHis);
            }
            dto.setThirdCodes(thirdCodes);
            IPage voPage3 = this.sysDrugPharmacySimpleMapper.searchForPresc4(page, dto);
            if (resultJson != null) {
                String status = resultJson.get((Object)"status").toString();
                if ("200".equals(status)) {
                    JSONArray data1 = resultJson.getJSONArray("data");
                    HashMap<String, String> emptyDrugList = new HashMap<String, String>();
                    for (int i = 0; i < data1.size(); ++i) {
                        JSONObject drugJson = data1.getJSONObject(i);
                        String quantity = drugJson.get((Object)"quantity").toString();
                        String commonname = drugJson.get((Object)"commonname").toString();
                        emptyDrugList.put(commonname, quantity);
                    }
                    Set keys = emptyDrugList.keySet();
                    voPage3.getRecords().stream().forEach(item -> {
                        if (keys.contains(item.getDrugsName())) {
                            item.setActualInventory(Integer.valueOf(Integer.parseInt(((String)emptyDrugList.get(item.getDrugsName())).toString())));
                        }
                    });
                }
                log.info("\u8bf7\u6c42\u53d1\u836f\u673a\u5e93\u5b58\u6700\u7ec8\u53cd\u53c2========>{}", (Object)JSONObject.toJSONString((Object)voPage3));
            }
            return voPage3;
        }
        voPage = this.sysDrugPharmacySimpleMapper.searchForPresc(page, dto);
        List list = voPage.getRecords();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (SysDrugPharmacySimpleVo n : list) {
                n.setActualInventory(Integer.valueOf(n.getActualInventory() - n.getOccupyInventory()));
                this.commonRequest.checkNumber(SysCommonEnum.BACK_OR_LOSS_LT_ZERO_04.getCode(), SysCommonEnum.BACK_OR_LOSS_LT_ZERO_04.getName(), new Integer[]{n.getActualInventory()});
            }
        }
        return voPage;
    }

    public IPage<SysDrugPharmacySimpleVo> sysDrugPharmacyOutSearch(Page page, SysDrugPharmacySimpleDto dto) {
        IPage voPage = this.sysDrugPharmacySimpleMapper.sysDrugPharmacySimpleSelect3(page, dto);
        List list = voPage.getRecords();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (SysDrugPharmacySimpleVo n : list) {
                n.setActualInventory(Integer.valueOf(n.getActualInventory() - n.getOccupyInventory()));
                this.commonRequest.checkNumber(SysCommonEnum.BACK_OR_LOSS_LT_ZERO_04.getCode(), SysCommonEnum.BACK_OR_LOSS_LT_ZERO_04.getName(), new Integer[]{n.getActualInventory()});
            }
        }
        return voPage;
    }

    public List<SysDrugPharmacySimpleVo> sysDrugPharmacyOutSearchByIds(SysEasyEntity entity) {
        List list = null;
        String warehouse = entity.getWarehouse();
        String param = this.sysParamService.sysParamSelectByNameReturnValue("JSKF_YF", Integer.valueOf(1));
        boolean isMatch = false;
        if (!StrUtil.isBlank((CharSequence)param)) {
            String[] warehouses = param.split(",");
            isMatch = Arrays.asList(warehouses).contains(warehouse);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = "2024122210263130864".equals(warehouse) ? this.sysDrugPharmacySimpleMapper.sysDrugPharmacyOutSearchByIds2(entity.getTenantId(), entity.getIds(), entity.getWarehouse()) : ("2025031715504724456".equals(warehouse) ? this.sysDrugPharmacySimpleMapper.sysDrugPharmacyOutSearchByIds4(entity.getTenantId(), entity.getIds(), entity.getWarehouse()) : (isMatch ? this.sysDrugPharmacySimpleMapper.sysDrugPharmacyOutSearchByIds3(entity.getTenantId(), entity.getIds(), entity.getWarehouse()) : this.sysDrugPharmacySimpleMapper.sysDrugPharmacyOutSearchByIds(entity.getTenantId(), entity.getIds(), entity.getWarehouse())))))) {
            for (SysDrugPharmacySimpleVo n : list) {
                n.setActualInventory(Integer.valueOf(n.getActualInventory() - n.getOccupyInventory()));
                this.commonRequest.checkNumber(SysCommonEnum.BACK_OR_LOSS_LT_ZERO_05.getCode(), SysCommonEnum.BACK_OR_LOSS_LT_ZERO_05.getName(), new Integer[]{n.getActualInventory()});
            }
        }
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugPharmacyOutDeleteByPrescriptionId(SysEasyEntity entity) {
        SysDrugPharmacyOutEntity outEntity = (SysDrugPharmacyOutEntity)this.sysDrugPharmacyOutMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyOutEntity::getPrescriptionId, (Object)entity.getId())).eq(SysDrugPharmacyOutEntity::getTenantId, (Object)entity.getTenantId()));
        ExceptionUtils.createException((Logger)log, (null == outEntity ? 1 : 0) != 0, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_NOT_FOUNT_PRESCRIPTION.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_NOT_FOUNT_PRESCRIPTION.getName());
        this.removeOccupyInventory(entity.getTenantId(), outEntity.getId(), entity.getWarehouse());
        int a = this.sysDrugPharmacyOutMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyOutEntity::getPrescriptionId, (Object)entity.getId())).eq(SysDrugPharmacyOutEntity::getTenantId, (Object)entity.getTenantId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_DELETE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_DELETE_ERROR.getName());
        int b = this.sysDrugPharmacyOutPrescriptionMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyOutPrescriptionEntity::getDrugPharmacyOutId, (Object)outEntity.getId())).eq(SysDrugPharmacyOutPrescriptionEntity::getTenantId, (Object)entity.getTenantId()));
        ExceptionUtils.createException((Logger)log, (int)b, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_PRESCRIPTION_DELETE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_PRESCRIPTION_DELETE_ERROR.getName());
    }

    private void removeOccupyInventory(Integer tenantId, String parentId, String drugRoomId) {
        List list = this.sysDrugPharmacyOutPrescriptionMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyOutPrescriptionEntity::getDrugPharmacyOutId, (Object)parentId));
        Map<String, List<SysDrugPharmacyOutPrescriptionEntity>> map = list.stream().collect(Collectors.groupingBy(SysDrugPharmacyOutPrescriptionEntity::getDrugsId));
        List ids = list.stream().map(SysDrugPharmacyOutPrescriptionEntity::getDrugsId).collect(Collectors.toList());
        List simpleList = this.sysDrugPharmacySimpleMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugPharmacySimpleEntity::getDrugsId, ids)).eq(SysDrugPharmacySimpleEntity::getTenantId, (Object)tenantId)).eq(SysDrugPharmacySimpleEntity::getWarehouse, (Object)drugRoomId));
        for (SysDrugPharmacySimpleEntity n : simpleList) {
            SysDrugPharmacyOutPrescriptionEntity prescriptionEntity = map.get(n.getDrugsId()).get(0);
            n.setOccupyInventory(Integer.valueOf(n.getOccupyInventory() - prescriptionEntity.getQuantity()));
            this.commonRequest.checkNumber(SysCommonEnum.BACK_OR_LOSS_LT_ZERO_06.getCode(), SysCommonEnum.BACK_OR_LOSS_LT_ZERO_06.getName(), new Integer[]{n.getOccupyInventory()});
            this.sysDrugPharmacySimpleService.sysDrugPharmacySimpleUpdateEntity(n);
        }
    }

    public void checkPrescriptionId(SysDrugPharmacyOutSaveDto dto) {
        if (null != dto.getPrescriptionId() && !"".equals(dto.getPrescriptionId())) {
            List list = this.sysDrugPharmacyOutMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyOutEntity::getPrescriptionId, (Object)dto.getPrescriptionId())).eq(SysDrugPharmacyOutEntity::getTenantId, (Object)dto.getTenantId()));
            ExceptionUtils.createException((Logger)log, (!CollectionUtils.isEmpty((Collection)list) ? 1 : 0) != 0, (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_PRESCRIPTION_ID_USE_ALREADY_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_PHARMACY_OUT_PRESCRIPTION_ID_USE_ALREADY_ERROR.getName());
        }
    }

    public void saveSysDrugPharmacyOutTemp(SysDrugPharmacyOutEntity entry) {
        SysDrugPharmacyOutTempSaveDto dto = new SysDrugPharmacyOutTempSaveDto();
        if (DictEnums.DRUG_PHARMACY_OUT_BOUND_METHOD_7.getCode().equals(entry.getOutboundMethod())) {
            dto.setType(DictEnums.DRUG_PHARMACY_OUT_TEMP_TYPE_1.getCode());
        } else if (DictEnums.DRUG_PHARMACY_OUT_BOUND_METHOD_8.getCode().equals(entry.getOutboundMethod())) {
            dto.setType(DictEnums.DRUG_PHARMACY_OUT_TEMP_TYPE_2.getCode());
        }
        dto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
        dto.setDrugPharmacyOutId(entry.getId());
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugPharmacyOutTempService.sysDrugPharmacyOutTempSave(dto);
    }
}

