/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.templateManage.SysTemplateManageDto;
import com.byh.sys.api.enums.ApplyGenderEnum;
import com.byh.sys.api.enums.DrugSourceEnum;
import com.byh.sys.api.enums.PrescTemplateTypeEnum;
import com.byh.sys.api.enums.StatusEnum;
import com.byh.sys.api.enums.TemplateTypeEnum;
import com.byh.sys.api.enums.UseScopeEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysRoleEntity;
import com.byh.sys.api.model.chargeItem.SysChargeItemEntity;
import com.byh.sys.api.model.dict.SysDictValueEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyEntity;
import com.byh.sys.api.model.templateManage.SysTemplateManageEntity;
import com.byh.sys.api.model.treatmentItem.SysTreatmentItemEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.StringPinYinUtil;
import com.byh.sys.api.util.StringWubiUtil;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.templateManage.SysTemplateManageDetailVo;
import com.byh.sys.api.vo.templateManage.SysTemplateManageVo;
import com.byh.sys.api.vo.treatmentItem.SysTreatmentChargeVo;
import com.byh.sys.data.repository.SysChargeItemMapper;
import com.byh.sys.data.repository.SysDictValueMapper;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysDrugPharmacyMapper;
import com.byh.sys.data.repository.SysRoleMapper;
import com.byh.sys.data.repository.SysTemplateManageDetailMapper;
import com.byh.sys.data.repository.SysTemplateManageMapper;
import com.byh.sys.data.repository.SysTreatmentChargeMapper;
import com.byh.sys.data.repository.SysTreatmentItemMapper;
import com.byh.sys.web.service.SysTemplateManageService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysTemplateManageServiceImpl
extends ServiceImpl<SysTemplateManageMapper, SysTemplateManageEntity>
implements SysTemplateManageService {
    @Resource
    private SysTemplateManageMapper sysTemplateManageMapper;
    @Resource
    private SysTemplateManageDetailMapper sysTemplateManageDetailMapper;
    @Resource
    private SysTreatmentChargeMapper sysTreatmentChargeMapper;
    @Resource
    private SysChargeItemMapper sysChargeItemMapper;
    @Resource
    private SysDictValueMapper sysDictValueMapper;
    @Resource
    private SysDrugMapper sysDrugMapper;
    @Resource
    private SysDrugPharmacyMapper sysDrugPharmacyMapper;
    @Resource
    private SysRoleMapper sysRoleMapper;
    @Resource
    private SysTreatmentItemMapper sysTreatmentItemMapper;
    private Logger logger = LoggerFactory.getLogger(SysTemplateManageServiceImpl.class);

    public List<SysTemplateManageVo> selectList(SysTemplateManageDto dto) {
        List list = this.sysTemplateManageMapper.selectTemplateManageList(dto);
        if (list != null && !list.isEmpty()) {
            list = this.getTemplateManageList(list, dto.getWarehouse());
        }
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void insert(SysTemplateManageDto dto) {
        String statusCode;
        String statusName;
        String useScopeCode;
        String useScopeName;
        SysTemplateManageEntity dbSysTemplateManageEntity;
        if (StrUtil.isEmpty((CharSequence)dto.getTemplateName())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6a21\u677f\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)dto.getTemplateTypeCode())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6a21\u677f\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if ((dbSysTemplateManageEntity = (SysTemplateManageEntity)this.sysTemplateManageMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysTemplateManageEntity.class).eq(SysTemplateManageEntity::getTemplateName, (Object)dto.getTemplateName())).eq(SysTemplateManageEntity::getTemplateTypeCode, (Object)dto.getTemplateTypeCode())).eq(dto.getTenantId() != null, SysTemplateManageEntity::getTenantId, (Object)dto.getTenantId())).and(UseScopeEnum.PERSONAGE.getValue().equals(dto.getUseScopeCode()), wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.eq(SysTemplateManageEntity::getUserId, (Object)dto.getCreateId());
        })).isNull(!UseScopeEnum.PERSONAGE.getValue().equals(dto.getUseScopeCode()), SysTemplateManageEntity::getUserId))) != null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5b58\u5728\u91cd\u590d\u6a21\u677f\uff0c\u65b0\u589e\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        dto.setId(Integer.valueOf(Integer.parseInt(UUIDUtils.getRandom((int)9, (boolean)false))));
        dto.setPyCode(StringPinYinUtil.toFirstChar((String)dto.getTemplateName()));
        dto.setWbCode(StringWubiUtil.getWbCode((String)dto.getTemplateName()));
        String templateTypeName = Optional.ofNullable(TemplateTypeEnum.getEnumLabel((String)dto.getTemplateTypeCode())).map(TemplateTypeEnum::getLabel).orElse(null);
        dto.setTemplateTypeName(templateTypeName);
        if (TemplateTypeEnum.PRESCRIPTION_TEMPLATE.getValue().equals(dto.getTemplateTypeCode())) {
            String prescTemplateTypeName = Optional.ofNullable(PrescTemplateTypeEnum.getEnumLabel((String)dto.getPrescTemplateTypeCode())).map(PrescTemplateTypeEnum::getLabel).orElse(null);
            dto.setPrescTemplateTypeName(prescTemplateTypeName);
        }
        dto.setUseScopeCode(StrUtil.isEmpty((CharSequence)(useScopeName = (String)Optional.ofNullable(UseScopeEnum.getEnumLabel((String)(useScopeCode = dto.getUseScopeCode()))).map(UseScopeEnum::getLabel).orElse(null))) ? UseScopeEnum.WHOLE_HOSPITAL.getValue() : useScopeCode);
        dto.setUseScopeName(StrUtil.isEmpty((CharSequence)useScopeName) ? UseScopeEnum.WHOLE_HOSPITAL.getLabel() : useScopeName);
        dto.setUserId(UseScopeEnum.PERSONAGE.getValue().equals(dto.getUseScopeCode()) ? dto.getCreateId() : null);
        String applyGenderCode = dto.getApplyGenderCode();
        String applyGenderName = Optional.ofNullable(ApplyGenderEnum.getEnumLabel((String)applyGenderCode)).map(ApplyGenderEnum::getLabel).orElse(null);
        dto.setApplyGenderCode(StrUtil.isEmpty((CharSequence)applyGenderName) ? ApplyGenderEnum.NO_LIMITATION.getValue() : applyGenderCode);
        dto.setApplyGenderName(StrUtil.isEmpty((CharSequence)applyGenderName) ? ApplyGenderEnum.NO_LIMITATION.getLabel() : applyGenderName);
        String drugSourceName = Optional.ofNullable(DrugSourceEnum.getEnumLabel((String)dto.getDrugSourceCode())).map(DrugSourceEnum::getLabel).orElse(null);
        dto.setDrugSourceName(drugSourceName);
        if (StrUtil.isNotEmpty((CharSequence)dto.getStatusCode()) && "2".equals(dto.getStatusCode())) {
            dto.setStatusCode(StatusEnum.UN_ENABLED.getValue());
        }
        dto.setStatusCode(StrUtil.isEmpty((CharSequence)(statusName = (String)Optional.ofNullable(StatusEnum.getEnumLabel((String)(statusCode = dto.getStatusCode()))).map(StatusEnum::getLabel).orElse(null))) ? StatusEnum.ENABLED.getValue() : statusCode);
        dto.setStatusName(StrUtil.isEmpty((CharSequence)statusName) ? StatusEnum.ENABLED.getLabel() : statusName);
        dto.setTemplateCode(StrUtil.isEmpty((CharSequence)dto.getTemplateCode()) ? dto.getId().toString() : dto.getTemplateCode());
        SysTemplateManageEntity entity = new SysTemplateManageEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        int insertCount = this.sysTemplateManageMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)insertCount, (String)"500", (String)"\u65b0\u589e\u6a21\u677f\u5931\u8d25\uff01");
        if (entity.getTemplateManageDetailList() != null && !entity.getTemplateManageDetailList().isEmpty()) {
            entity.getTemplateManageDetailList().forEach(detailEntity -> {
                detailEntity.setTemplateId(entity.getId());
                String applyGenderValue = detailEntity.getApplyGenderCode();
                String applyGenderLabel = Optional.ofNullable(ApplyGenderEnum.getEnumLabel((String)applyGenderValue)).map(ApplyGenderEnum::getLabel).orElse(null);
                detailEntity.setApplyGenderCode(StrUtil.isEmpty((CharSequence)applyGenderLabel) ? ApplyGenderEnum.NO_LIMITATION.getValue() : applyGenderValue);
                detailEntity.setApplyGenderName(StrUtil.isEmpty((CharSequence)applyGenderLabel) ? ApplyGenderEnum.NO_LIMITATION.getLabel() : applyGenderLabel);
                detailEntity.setItemName(TemplateTypeEnum.PRESCRIPTION_TEMPLATE.getValue().equals(entity.getTemplateTypeCode()) ? detailEntity.getDrugsName() : detailEntity.getItemName());
            });
            int insertDetailCount = this.sysTemplateManageDetailMapper.insertList(entity.getTemplateManageDetailList());
            ExceptionUtils.createException((Logger)this.logger, (int)insertDetailCount, (String)"500", (String)"\u65b0\u589e\u6a21\u677f\u660e\u7ec6\u5931\u8d25\uff01");
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void deleteList(Integer[] ids) {
        if (ArrayUtil.isEmpty((Object[])ids)) {
            throw new BusinessException("10000", "\u5220\u9664\u6a21\u677f\u65f6\uff0c\u6a21\u677f\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        this.sysTemplateManageMapper.deleteList(ids);
        this.sysTemplateManageDetailMapper.deleteListByTemplateIds(ids);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void update(SysTemplateManageDto dto) {
        SysTemplateManageEntity dbEntity;
        if (dto.getId() == null || StrUtil.isEmpty((CharSequence)dto.getId().toString())) {
            throw new BusinessException("500", "\u7f16\u8f91\u6a21\u677f\u65f6\uff0c\u6a21\u677f\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)dto.getTemplateName())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u6a21\u677f\u65f6\uff0c\u6a21\u677f\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)dto.getTemplateTypeCode())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u6a21\u677f\u65f6\uff0c\u6a21\u677f\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if ((dbEntity = (SysTemplateManageEntity)this.sysTemplateManageMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysTemplateManageEntity.class).eq(SysTemplateManageEntity::getTemplateName, (Object)dto.getTemplateName())).eq(SysTemplateManageEntity::getTemplateTypeCode, (Object)dto.getTemplateTypeCode())).eq(dto.getTenantId() != null, SysTemplateManageEntity::getTenantId, (Object)dto.getTenantId())).and(UseScopeEnum.PERSONAGE.getValue().equals(dto.getUseScopeCode()), wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.eq(SysTemplateManageEntity::getUserId, (Object)dto.getUpdateId());
        })).isNull(!UseScopeEnum.PERSONAGE.getValue().equals(dto.getUseScopeCode()), SysTemplateManageEntity::getUserId))) != null && !dbEntity.getId().equals(dto.getId())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u6a21\u677f\u65f6\uff0c\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        dto.setPyCode(StringPinYinUtil.toFirstChar((String)dto.getTemplateName()));
        dto.setWbCode(StringWubiUtil.getWbCode((String)dto.getTemplateName()));
        String templateTypeName = Optional.ofNullable(TemplateTypeEnum.getEnumLabel((String)dto.getTemplateTypeCode())).map(TemplateTypeEnum::getLabel).orElse(null);
        dto.setTemplateTypeName(templateTypeName);
        if (TemplateTypeEnum.PRESCRIPTION_TEMPLATE.getValue().equals(dto.getTemplateTypeCode())) {
            String prescTemplateTypeName = Optional.ofNullable(PrescTemplateTypeEnum.getEnumLabel((String)dto.getPrescTemplateTypeCode())).map(PrescTemplateTypeEnum::getLabel).orElse(null);
            dto.setPrescTemplateTypeName(prescTemplateTypeName);
        }
        String useScopeName = Optional.ofNullable(UseScopeEnum.getEnumLabel((String)dto.getUseScopeCode())).map(UseScopeEnum::getLabel).orElse(null);
        dto.setUseScopeName(useScopeName);
        dto.setUserId(UseScopeEnum.WHOLE_HOSPITAL.getValue().equals(dto.getUseScopeCode()) ? null : dto.getUpdateId());
        String applyGenderName = Optional.ofNullable(ApplyGenderEnum.getEnumLabel((String)dto.getApplyGenderCode())).map(ApplyGenderEnum::getLabel).orElse(null);
        dto.setApplyGenderName(applyGenderName);
        if (StrUtil.isNotEmpty((CharSequence)dto.getStatusCode()) && "2".equals(dto.getStatusCode())) {
            dto.setStatusCode(StatusEnum.UN_ENABLED.getValue());
        }
        String statusName = Optional.ofNullable(StatusEnum.getEnumLabel((String)dto.getStatusCode())).map(StatusEnum::getLabel).orElse(null);
        dto.setStatusName(statusName);
        String drugSourceName = Optional.ofNullable(DrugSourceEnum.getEnumLabel((String)dto.getDrugSourceCode())).map(DrugSourceEnum::getLabel).orElse(null);
        dto.setDrugSourceName(drugSourceName);
        dto.setUpdateTime(new Date());
        SysTemplateManageEntity entity = new SysTemplateManageEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        int updateCount = this.sysTemplateManageMapper.updateById((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)updateCount, (String)"500", (String)"\u7f16\u8f91\u6a21\u677f\u5931\u8d25\uff01");
        if (entity.getTemplateManageDetailList() != null && !entity.getTemplateManageDetailList().isEmpty()) {
            Integer[] templateIds = new Integer[]{entity.getId()};
            this.sysTemplateManageDetailMapper.deleteListByTemplateIds(templateIds);
            entity.getTemplateManageDetailList().forEach(detailEntity -> {
                detailEntity.setTemplateId(entity.getId());
                String applyGenderLabel = Optional.ofNullable(ApplyGenderEnum.getEnumLabel((String)detailEntity.getApplyGenderCode())).map(ApplyGenderEnum::getLabel).orElse(null);
                detailEntity.setApplyGenderName(applyGenderLabel);
                detailEntity.setItemName(TemplateTypeEnum.PRESCRIPTION_TEMPLATE.getValue().equals(entity.getTemplateTypeCode()) ? (StrUtil.isNotEmpty((CharSequence)detailEntity.getDrugsName()) ? detailEntity.getDrugsName() : detailEntity.getItemName()) : detailEntity.getItemName());
            });
            int insertDetailCount = this.sysTemplateManageDetailMapper.insertList(entity.getTemplateManageDetailList());
            ExceptionUtils.createException((Logger)this.logger, (int)insertDetailCount, (String)"500", (String)"\u6279\u91cf\u65b0\u589e\u6a21\u677f\u660e\u7ec6\u5931\u8d25\uff01");
        }
    }

    public Page<SysTemplateManageVo> selectPageList(SysTemplateManageDto dto) {
        if (StrUtil.isNotEmpty((CharSequence)dto.getStatusCode()) && "2".equals(dto.getStatusCode())) {
            dto.setStatusCode(StatusEnum.UN_ENABLED.getValue());
        }
        if (dto.getRoleId() != null) {
            SysRoleEntity role = (SysRoleEntity)this.sysRoleMapper.selectOne((Wrapper)Wrappers.lambdaQuery(SysRoleEntity.class).eq(SysRoleEntity::getId, (Object)dto.getRoleId()));
            dto.setSuperRoleFlag(role != null && role.getId() == 1 && "\u8d85\u7ea7\u7ba1\u7406\u5458".equals(role.getRoleName()));
        } else {
            dto.setSuperRoleFlag(false);
        }
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.sysTemplateManageMapper.selectPageList(page, dto);
        if (list != null && !list.isEmpty()) {
            list = this.getTemplateManageList(list, dto.getWarehouse());
        }
        page.setRecords(list);
        return page;
    }

    private List<SysTemplateManageVo> getTemplateManageList(List<SysTemplateManageVo> list, String warehouse) {
        List ids = list.stream().map(SysTemplateManageVo::getId).collect(Collectors.toList());
        List detailList = this.sysTemplateManageDetailMapper.selectListByTemplateIds(ids);
        Map<Integer, List<SysTemplateManageDetailVo>> templateManageDetailMap = detailList.stream().collect(Collectors.groupingBy(SysTemplateManageDetailVo::getTemplateId));
        ArrayList<SysTemplateManageVo> itemList = new ArrayList<SysTemplateManageVo>();
        ArrayList<SysTemplateManageVo> prescList = new ArrayList<SysTemplateManageVo>();
        for (SysTemplateManageVo vo2 : list) {
            vo2.setTemplateManageDetailList((List)templateManageDetailMap.getOrDefault(vo2.getId(), new ArrayList()));
            if (TemplateTypeEnum.PRESCRIPTION_TEMPLATE.getValue().equals(vo2.getTemplateTypeCode())) {
                prescList.add(vo2);
                continue;
            }
            itemList.add(vo2);
        }
        list = new ArrayList<SysTemplateManageVo>();
        if (!detailList.isEmpty()) {
            List<String> dictTypes = Arrays.asList("diagnosis_treatment_type", "usage_unit", "we_pack_units");
            List dictValueList = this.sysDictValueMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysDictValueEntity.class).in(SysDictValueEntity::getType, dictTypes));
            HashMap dictValueMap = new HashMap();
            for (SysDictValueEntity entity2 : dictValueList) {
                dictValueMap.computeIfAbsent(entity2.getType(), k -> new HashMap()).put(entity2.getValue(), entity2.getLabel());
            }
            if (!itemList.isEmpty()) {
                List allTreatmentIds = itemList.stream().flatMap(vo -> vo.getTemplateManageDetailList().stream()).map(detailVo -> Integer.valueOf(detailVo.getTreatmentId())).collect(Collectors.toList());
                List treatmentItemList = this.sysTreatmentItemMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysTreatmentItemEntity::getId, allTreatmentIds)).eq(SysTreatmentItemEntity::getStatusCode, (Object)"1"));
                List treatmentIds = treatmentItemList.stream().filter(entity -> "1".equals(entity.getStatusCode())).map(SysTreatmentItemEntity::getId).distinct().collect(Collectors.toList());
                List treatmentChargeList = this.sysTreatmentChargeMapper.selectListByTreatmentIds(treatmentIds);
                Map<Integer, List<SysTreatmentChargeVo>> treatmentChargeMap = treatmentChargeList.stream().collect(Collectors.groupingBy(SysTreatmentChargeVo::getTreatmentId));
                List chargeIds = treatmentChargeList.stream().map(SysTreatmentChargeVo::getChargeId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                List chargeItemList = this.sysChargeItemMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysChargeItemEntity.class).in(!chargeIds.isEmpty(), SysChargeItemEntity::getId, chargeIds)).eq(SysChargeItemEntity::getStatusCode, (Object)"1")).in(chargeIds.isEmpty(), SysChargeItemEntity::getId, new Object[]{-1}));
                Map chargeItemMap = chargeItemList.stream().collect(Collectors.toMap(SysChargeItemEntity::getId, Function.identity()));
                for (Map.Entry<Integer, List<SysTreatmentChargeVo>> entry2 : treatmentChargeMap.entrySet()) {
                    List<SysTreatmentChargeVo> voList = entry2.getValue();
                    Iterator<SysTreatmentChargeVo> iterator = voList.iterator();
                    while (iterator.hasNext()) {
                        SysTreatmentChargeVo vo3 = iterator.next();
                        SysChargeItemEntity chargeItem = (SysChargeItemEntity)chargeItemMap.get(vo3.getChargeId());
                        if (chargeItem == null) {
                            iterator.remove();
                            continue;
                        }
                        vo3.setItemPrice(chargeItem.getItemPrice());
                    }
                }
                Map treatmentTypeMap = dictValueMap.getOrDefault("diagnosis_treatment_type", Collections.emptyMap());
                itemList.forEach(vo -> vo.getTemplateManageDetailList().forEach(detailVo -> {
                    List treatmentCharges = (List)treatmentChargeMap.get(Integer.valueOf(detailVo.getTreatmentId()));
                    if (treatmentCharges != null && !treatmentCharges.isEmpty()) {
                        BigDecimal totalPrice = treatmentCharges.stream().map(treatmentCharge -> {
                            BigDecimal itemPrice = treatmentCharge.getItemPrice() == null ? BigDecimal.ZERO : treatmentCharge.getItemPrice();
                            Integer quantity = treatmentCharge.getQuantity() == null ? 0 : treatmentCharge.getQuantity();
                            return itemPrice.multiply(new BigDecimal(quantity));
                        }).reduce(BigDecimal.ZERO, BigDecimal::add);
                        detailVo.setPrice(totalPrice);
                        detailVo.setTotalPrice(totalPrice);
                    } else {
                        detailVo.setTotalPrice(BigDecimal.ZERO);
                        detailVo.setPrice(BigDecimal.ZERO);
                    }
                    detailVo.setTreatmentTypeName((String)treatmentTypeMap.getOrDefault(detailVo.getTreatmentTypeCode(), null));
                }));
                list.addAll(itemList);
            }
            if (!prescList.isEmpty()) {
                List drugIds = prescList.stream().flatMap(vo -> vo.getTemplateManageDetailList().stream()).map(SysTemplateManageDetailVo::getTreatmentId).collect(Collectors.toList());
                List drugList = this.sysDrugMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysDrugEntity.class).in(SysDrugEntity::getId, drugIds));
                HashMap drugPharmacyEntityMap = new HashMap();
                if (StrUtil.isNotEmpty((CharSequence)warehouse)) {
                    List drugPharmacyList = this.sysDrugPharmacyMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDrugPharmacyEntity.class).eq(SysDrugPharmacyEntity::getWarehouse, (Object)warehouse)).in(SysDrugPharmacyEntity::getDrugsId, drugIds));
                    Map<String, List<SysDrugPharmacyEntity>> drugPharmacyMap = drugPharmacyList.stream().collect(Collectors.groupingBy(SysDrugPharmacyEntity::getDrugsId));
                    drugPharmacyMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().mapToInt(SysDrugPharmacyEntity::getActualInventory).sum() > 0).forEach(entry -> {
                        String cfr_ignored_0 = (String)drugPharmacyEntityMap.put(entry.getKey(), entry.getKey());
                    });
                }
                Map usageUnitMap = dictValueMap.getOrDefault("usage_unit", Collections.emptyMap());
                Map wePackUnitMap = dictValueMap.getOrDefault("we_pack_units", Collections.emptyMap());
                if (!drugList.isEmpty()) {
                    Map drugMap = drugList.stream().filter(entity -> StrUtil.isEmpty((CharSequence)warehouse) || drugPharmacyEntityMap.containsKey(entity.getId())).collect(Collectors.toMap(SysDrugEntity::getId, Function.identity()));
                    for (SysTemplateManageVo vo4 : prescList) {
                        ArrayList<SysTemplateManageDetailVo> detailVoList = new ArrayList<SysTemplateManageDetailVo>();
                        for (SysTemplateManageDetailVo detailVo2 : vo4.getTemplateManageDetailList()) {
                            SysDrugEntity drugEntity = drugMap.getOrDefault(detailVo2.getTreatmentId(), null);
                            if (drugEntity == null) continue;
                            detailVo2.setDrugName(drugEntity.getDrugsName());
                            detailVo2.setPrice(drugEntity.getRetailPrice() == null ? new BigDecimal(0) : drugEntity.getRetailPrice());
                            detailVo2.setDefaultUsage(drugEntity.getDefaultUsage());
                            detailVo2.setDefaultUsageUnit(drugEntity.getDefaultUsageUnit());
                            detailVo2.setDefaultUsageUnitLabel((String)usageUnitMap.getOrDefault(detailVo2.getDefaultUsageUnit(), null));
                            detailVo2.setPackLargeUnits(drugEntity.getPackLargeUnits());
                            detailVo2.setPackLargeUnitsLabel((String)wePackUnitMap.getOrDefault(detailVo2.getPackLargeUnits(), null));
                            detailVo2.setPackSmallUnits(drugEntity.getPackSmallUnits());
                            detailVo2.setPackSmallUnitsLabel((String)wePackUnitMap.getOrDefault(detailVo2.getPackSmallUnits(), null));
                            detailVo2.setIsSkinTest(drugEntity.getAllergyTestType());
                            detailVo2.setSpecifications(drugEntity.getSpecifications());
                            detailVoList.add(detailVo2);
                        }
                        vo4.setTemplateManageDetailList(detailVoList);
                    }
                }
                list.addAll(prescList);
            }
        }
        return list;
    }
}

