/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.applyment;

import com.ebaiyihui.aggregation.payment.common.vo.BusinessDataVO;
import com.ebaiyihui.aggregation.payment.common.vo.MerchantPurchaseVO;
import com.ebaiyihui.aggregation.payment.server.applyment.Applyment;
import com.ebaiyihui.aggregation.payment.server.utils.StringUtil;
import com.github.binarywang.wxpay.bean.applyment.WxPayApplyment4SubCreateRequest;
import com.github.binarywang.wxpay.bean.applyment.enums.SalesScenesTypeEnum;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class BusinessInfoBuilder
implements Applyment {
    public void build(MerchantPurchaseVO merchantPurchaseVO, WxPayApplyment4SubCreateRequest wxPayApplyment4SubCreateRequest) {
        BusinessDataVO businessDataVO = merchantPurchaseVO.getBusinessDataVO();
        wxPayApplyment4SubCreateRequest.setBusinessInfo(WxPayApplyment4SubCreateRequest.BusinessInfo.builder().merchantShortname(businessDataVO.getMerchantShortname()).servicePhone(businessDataVO.getServicePhone()).salesInfo(this.getSalesInfo(businessDataVO)).build());
    }

    private WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo getSalesInfo(BusinessDataVO businessDataVO) {
        WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.MiniProgramInfo build;
        WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.MpInfo build2;
        WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo salesInfo = new WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo();
        String salesScenesType = businessDataVO.getSalesScenesType();
        List<String> strings = Arrays.asList(salesScenesType.split(","));
        List collect = strings.stream().map(SalesScenesTypeEnum::valueOf).collect(Collectors.toList());
        salesInfo.setSalesScenesType(collect);
        if (strings.contains(SalesScenesTypeEnum.SALES_SCENES_STORE.toString())) {
            List<String> storeEntrancePic = Arrays.asList(businessDataVO.getStoreEntrancePicMedia().split(","));
            List<String> indoorPic = Arrays.asList(businessDataVO.getIndoorPicMedia().split(","));
            WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.BizStoreInfo build3 = WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.BizStoreInfo.builder().bizStoreName(businessDataVO.getBizStoreName()).bizAddressCode(businessDataVO.getBizAddressCode()).bizStoreAddress(businessDataVO.getBizStoreAddress()).storeEntrancePic(storeEntrancePic).indoorPic(indoorPic).build();
            if (StringUtil.isNotEmpty((String)businessDataVO.getBizSubAppid())) {
                build3.setBizSubAppid(businessDataVO.getBizSubAppid());
            }
            salesInfo.setBizStoreInfo(build3);
        }
        if (strings.contains(SalesScenesTypeEnum.SALES_SCENES_MP.toString())) {
            String mpSubAppid;
            List<String> mpPics = Arrays.asList(businessDataVO.getMpPicsMedia().split(","));
            build2 = WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.MpInfo.builder().mpPics(mpPics).build();
            String mpAppid = businessDataVO.getMpAppid();
            if (StringUtil.isNotEmpty((String)mpAppid)) {
                build2.setMpAppid(mpAppid);
            }
            if (StringUtil.isNotEmpty((String)(mpSubAppid = businessDataVO.getMpSubAppid()))) {
                build2.setMpSubAppid(mpSubAppid);
            }
            salesInfo.setMpInfo(build2);
        }
        if (strings.contains(SalesScenesTypeEnum.SALES_SCENES_MINI_PROGRAM.toString())) {
            String miniProgramSubAppid;
            String miniProgramAppid;
            build = new WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.MiniProgramInfo();
            String miniProgramPics = businessDataVO.getMiniProgramPicsMedia();
            if (StringUtil.isNotEmpty((String)miniProgramPics)) {
                List<String> miniProgramPicsList = Arrays.asList(miniProgramPics.split(","));
                build.setMiniProgramPics(miniProgramPicsList);
            }
            if (StringUtil.isNotEmpty((String)(miniProgramAppid = businessDataVO.getMiniProgramAppid()))) {
                build.setMiniProgramAppid(miniProgramAppid);
            }
            if (StringUtil.isNotEmpty((String)(miniProgramSubAppid = businessDataVO.getMiniProgramSubAppid()))) {
                build.setMiniProgramSubAppid(miniProgramSubAppid);
            }
            salesInfo.setMiniProgramInfo(build);
        }
        if (strings.contains(SalesScenesTypeEnum.SALES_SCENES_APP.toString())) {
            String appSubAppid;
            List<String> appPics = Arrays.asList(businessDataVO.getAppPicsMedia().split(","));
            build2 = WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.AppInfo.builder().appPics(appPics).build();
            String appAppid = businessDataVO.getAppAppid();
            if (StringUtil.isNotEmpty((String)appAppid)) {
                build2.setAppAppid(appAppid);
            }
            if (StringUtil.isNotEmpty((String)(appSubAppid = businessDataVO.getAppSubAppid()))) {
                build2.setAppSubAppid(appSubAppid);
            }
            salesInfo.setAppInfo((WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.AppInfo)build2);
        }
        if (strings.contains(SalesScenesTypeEnum.SALES_SCENES_WEB.toString())) {
            String webAppid;
            build = WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.WebInfo.builder().domain(businessDataVO.getDomain()).build();
            String webAuthorisation = businessDataVO.getWebAuthorisationMedia();
            if (StringUtil.isNotEmpty((String)webAuthorisation)) {
                build.setWebAuthorisation(webAuthorisation);
            }
            if (StringUtil.isNotEmpty((String)(webAppid = businessDataVO.getWebAppid()))) {
                build.setWebAppid(webAppid);
            }
            salesInfo.setWebInfo((WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.WebInfo)build);
        }
        if (strings.contains(SalesScenesTypeEnum.SALES_SCENES_WEWORK.toString())) {
            List<String> weworkPics = Arrays.asList(businessDataVO.getWeworkPicsMedia().split(","));
            build2 = WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.WeworkInfo.builder().subCorpId(businessDataVO.getSubCorpId()).weworkPics(weworkPics).build();
            salesInfo.setWeworkInfo((WxPayApplyment4SubCreateRequest.BusinessInfo.SalesInfo.WeworkInfo)build2);
        }
        return salesInfo;
    }
}

