/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.notify;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.PayMch;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseNotifyRestVo;
import com.ebaiyihui.aggregation.payment.server.config.WxPayConfiguration;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.RecordsEnum;
import com.ebaiyihui.aggregation.payment.server.enums.WechatTradeTypeEnum;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.PayApplyService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.PayMchService;
import com.ebaiyihui.aggregation.payment.server.service.PaymentRecordsService;
import com.ebaiyihui.aggregation.payment.server.service.RedisTemplateService;
import com.ebaiyihui.aggregation.payment.server.service.notify.INotify;
import com.ebaiyihui.aggregation.payment.server.service.notify.NotifyFactory;
import com.ebaiyihui.aggregation.payment.server.service.notify.RabbitMqPusher;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.SignUtil;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.service.WxPayService;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WeChatNotify
implements INotify,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(WeChatNotify.class);
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private MchChanService mchChanService;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private PayMchService payMchService;
    @Autowired
    private PayApplyService payApplyService;
    @Autowired
    private PaymentRecordsService paymentRecordsService;
    @Autowired
    private RabbitMqPusher rabbitMqPusher;
    @Autowired
    private WxPayConfiguration wxPayConfiguration;

    public String notify(HttpServletRequest request) {
        WxPayService wxPayService = this.wxPayConfiguration.wxService();
        log.info("=====\u8fdb\u5165\u4e86\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03=====");
        try {
            String xmlResult = IOUtils.toString((InputStream)request.getInputStream(), (String)request.getCharacterEncoding());
            WxPayOrderNotifyResult payResult = WxPayOrderNotifyResult.fromXML((String)xmlResult);
            log.info("\u3010\u5fae\u4fe1\u3011\u652f\u4ed8\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)payResult.toString());
            String dealTradeNo = payResult.getOutTradeNo();
            PayBill payBill = this.payBillService.getByDealTradeNo(dealTradeNo);
            String tradeType = payBill.getTradeType();
            if (payBill.getTradeType().equals(WechatTradeTypeEnum.NATIVE.getDisplay())) {
                tradeType = WechatTradeTypeEnum.JSPAI.getDisplay();
            }
            WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)this.mchChanService.getWxPayByMchCodeAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), tradeType)), WxPayParam.class);
            wxPayService.getConfig().setMchKey(wxPayParam.getMchPublicKey());
            wxPayService.getConfig().setTradeType(payBill.getTradeType());
            WxPayOrderNotifyResult wxPayOrderNotifyResult = wxPayService.parseOrderNotifyResult(xmlResult);
            log.info("\u3010\u5fae\u4fe1\u3011\u8c03\u7528SDK\u9a8c\u7b7e\u7ed3\u679c\uff1a{}", (Object)wxPayOrderNotifyResult.toString());
            String orderViewId = wxPayOrderNotifyResult.getOutTradeNo();
            log.info("\u3010\u5fae\u4fe1\u3011\u8ba2\u5355\u7684view_id\u662f{}", (Object)orderViewId);
            PayMch payMch = this.payMchService.getByCode(payBill.getMchCode());
            payBill.setTradeNo(wxPayOrderNotifyResult.getTransactionId());
            payBill.setStatus(OrderStatusEnum.PAID.getValue());
            payBill.setPayTime(DateUtils.stringToDate((String)"yyyyMMddHHmmss", (String)wxPayOrderNotifyResult.getTimeEnd()));
            log.info("\u5fae\u4fe1\u652f\u4ed8\u65f6\u95f4:{},\u7cfb\u7edf\u683c\u5f0f\u5316\u540e\u65f6\u95f4:{}", (Object)wxPayOrderNotifyResult.getTimeEnd(), (Object)payBill.getPayTime());
            log.info("\u3010\u5fae\u4fe1\u3011\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001\uff0c\u4fdd\u5b58\u8ba2\u5355\u8bb0\u5f55{}", (Object)payBill.toString());
            this.payBillService.update(payBill);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.HAVE_TO_PAY);
            log.info("-------------\u3010\u5fae\u4fe1\u3011\u6784\u5efaResponseNotifyRestVo\uff0c\u51c6\u5907\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\u652f\u4ed8\u6d41\u7a0b-----------");
            ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
            responseNotifyRestVo.setTradeNo(wxPayOrderNotifyResult.getTransactionId());
            responseNotifyRestVo.setReturnCode(wxPayOrderNotifyResult.getReturnCode());
            responseNotifyRestVo.setReturnMsg(wxPayOrderNotifyResult.getReturnMsg());
            responseNotifyRestVo.setResultCode(wxPayOrderNotifyResult.getResultCode());
            responseNotifyRestVo.setErrCode(wxPayOrderNotifyResult.getErrCode());
            responseNotifyRestVo.setErrCodeDes(wxPayOrderNotifyResult.getErrCodeDes());
            responseNotifyRestVo.setPayChannel(payBill.getTradeChannel());
            responseNotifyRestVo.setServiceCode(payBill.getServiceCode());
            responseNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
            responseNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
            responseNotifyRestVo.setTotalAmount(payBill.getDealAmount());
            if (null != payBill.getAttach() && !"".equals(payBill.getAttach().trim())) {
                responseNotifyRestVo.setAttach(payBill.getAttach());
            }
            if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
                responseNotifyRestVo.setRemake(payBill.getRemake());
            }
            responseNotifyRestVo.setMchCode(payBill.getMchCode());
            responseNotifyRestVo.setMchId(wxPayOrderNotifyResult.getMchId());
            responseNotifyRestVo.setMchName(payMch.getName());
            String payTime = DateUtils.strToDateLong((String)wxPayOrderNotifyResult.getTimeEnd());
            responseNotifyRestVo.setPayTime(DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)payTime));
            responseNotifyRestVo.setNotifyResultStr(JSON.toJSONString((Object)wxPayOrderNotifyResult));
            PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
            responseNotifyRestVo.setApplyId(payApply.getApplyId());
            Map signMap = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
            responseNotifyRestVo.setSign(sign);
            this.paymentRecordsService.saveByBill(payBill.getDealTradeNo(), payBill.getServiceCode(), RecordsEnum.IN_THE_CALLBACK);
            log.info("\u3010\u5fae\u4fe1\u3011\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)responseNotifyRestVo.toString());
            this.rabbitMqPusher.notify("pay", JSON.toJSONString((Object)responseNotifyRestVo));
            String rediskey = payBill.getServiceCode() + "_" + payBill.getOutTradeNo();
            this.redisTemplateService.del(rediskey);
            return WxPayNotifyResponse.success((String)"OK");
        }
        catch (Exception e) {
            log.error("\u3010\u5fae\u4fe1\u3011\u652f\u4ed8\u56de\u8c03\u7ed3\u679c\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0{},\u5f02\u5e38\u4fe1\u606f{}", (Object)e.getMessage(), (Object)e);
            return WxPayNotifyResponse.fail((String)e.getMessage());
        }
    }

    public void afterPropertiesSet() throws Exception {
        NotifyFactory.register((String)this.getClass().getSimpleName().toLowerCase(), (INotify)this);
    }
}

