/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin.callback;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.app.NotificationCompat;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.StringUtils;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.google.gson.Gson;
import com.igexin.sdk.message.GTCmdMessage;
import com.igexin.sdk.message.GTNotificationMessage;
import com.igexin.sdk.message.GTTransmitMessage;
import com.kangxin.common.byh.db.DB;
import com.kangxin.common.byh.db.entity.ByPushEntity;
import com.kangxin.common.byh.entity.UpdateDataEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.inter.IPushSaveCallback;
import com.kangxin.common.byh.receiver.PushNotifycationReceiver;
import com.kangxin.common.byh.service.OffLineService;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.inter.IPushCallback;
import com.kangxin.module.getui.ByPushCallBack;
import com.umeng.message.PushAgent;
import com.umeng.message.entity.UMessage;
import java.io.Serializable;
import org.greenrobot.eventbus.EventBus;

@Route(path="/service_push/push_callback")
public class LoginPushCallBack
implements ByPushCallBack,
IPushSaveCallback,
IPushCallback {
    private static final String TAG = "LoginPushCallBack";

    public boolean onReceiveServicePid(Context context, int pid) {
        return false;
    }

    public boolean onReceiveClientId(Context context, String cliendId) {
        Log.i((String)TAG, (String)("onReceiveServicePid pid = " + cliendId));
        return false;
    }

    public boolean onReceiveMessageData(Context context, GTTransmitMessage msg) {
        Log.i((String)TAG, (String)("onReceiveMessageData msg = " + new String(msg.getPayload())));
        String msgData = new String(msg.getPayload());
        ByPushEntity byPushEntity = (ByPushEntity)new Gson().fromJson(msgData, ByPushEntity.class);
        return this.savePushEntity(context, byPushEntity);
    }

    private void dispatchPushCode(Context context, ByPushEntity byPushEntity) {
        Log.i((String)TAG, (String)("dispatchPushCode: byPushEntity:" + byPushEntity));
        String pushCode = byPushEntity.getPushCode();
        String notifyType = byPushEntity.getNotifyType();
        Log.i((String)TAG, (String)("dispatchPushCode: pushCode:" + pushCode));
        Log.i((String)TAG, (String)("dispatchPushCode: notifyType:" + notifyType));
        PushAgent.getInstance((Context)context).setNotificaitonOnForeground(true);
        if (!TextUtils.isEmpty((CharSequence)notifyType)) {
            switch (notifyType) {
                case "offline": {
                    String notifyUserId = byPushEntity.getUserId();
                    String localUserId = VertifyDataUtil.getInstance((Context)context).getUserId();
                    Log.i((String)TAG, (String)("dispatchPushCode: notifyUserId:" + notifyUserId + ", localUserId:" + localUserId));
                    if (!TextUtils.isEmpty((CharSequence)notifyUserId)) {
                        if (notifyUserId.equals(localUserId)) {
                            OffLineService offLineService = (OffLineService)ARouter.getInstance().build("/im/notify/OffLineImpProvider").navigation();
                            offLineService.startOffLineActivity();
                            PushAgent.getInstance((Context)context).setNotificaitonOnForeground(true);
                            Log.i((String)TAG, (String)"dispatchPushCode: OFFLINE");
                            break;
                        }
                        Log.i((String)TAG, (String)"dispatchPushCode: else notifyUserId===============");
                        PushAgent.getInstance((Context)context).setNotificaitonOnForeground(false);
                        break;
                    }
                    Log.i((String)TAG, (String)"dispatchPushCode: notifyUserId is null=======");
                    PushAgent.getInstance((Context)context).setNotificaitonOnForeground(false);
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)pushCode)) {
            switch (pushCode) {
                case "2": 
                case "3": {
                    UpdateVerStatus.getInstance().updateDocDetailInfo(context, null);
                    Log.i((String)TAG, (String)"dispatchPushCode: EXAMINE_FAILED");
                    break;
                }
                case "312": {
                    EventBus.getDefault().post((Object)new ByhCommEvent.UpdateFriendsListEvent());
                    Log.i((String)TAG, (String)"dispatchPushCode: AGREE_FRIEND_APPLY");
                    break;
                }
                case "1001": {
                    String targetId = byPushEntity.getBusinessExtend();
                    EventBus.getDefault().post((Object)new ByhCommEvent.UpdateFriendsListEvent(targetId));
                    Log.i((String)TAG, (String)"dispatchPushCode: DELETE_FRIEND");
                }
            }
        }
    }

    public boolean savePushEntity(Context context, final ByPushEntity byPushEntity) {
        this.dispatchPushCode(context, byPushEntity);
        if (byPushEntity.getPushCode() == "701") {
            return true;
        }
        if (!StringUtils.isEmpty((CharSequence)byPushEntity.getPushKey())) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DB.getInstance().pushDao().clearPushByPushKey(byPushEntity.getPushKey());
                    Long aLong = DB.getInstance().pushDao().savePush(byPushEntity);
                    if (aLong > 0L) {
                        EventBus.getDefault().postSticky((Object)new UpdateDataEntity());
                        LogUtils.d((Object[])new Object[]{"success save push entiy"});
                    } else {
                        LogUtils.e((Object[])new Object[]{"entity push key have mulitity"});
                    }
                }
            }).start();
        } else {
            LogUtils.e((Object[])new Object[]{"push key is null , don't save push entity"});
        }
        return true;
    }

    private void showNotify(Context context, ByPushEntity byPushEntity) {
        NotificationManager manager = (NotificationManager)context.getSystemService("notification");
        Intent intent = new Intent(context, PushNotifycationReceiver.class);
        Bundle bundle = new Bundle();
        bundle.putSerializable("pushEntity", (Serializable)byPushEntity);
        intent.putExtras(bundle);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        Notification notification = new NotificationCompat.Builder(context).setSmallIcon(R.drawable.ic_launcher).setWhen(System.currentTimeMillis()).setContentTitle((CharSequence)byPushEntity.getTitle()).setContentText((CharSequence)byPushEntity.getContent()).setContentIntent(pendingIntent).setAutoCancel(true).build();
        EventBus.getDefault().postSticky((Object)new UpdateDataEntity());
    }

    private void processBusinessByBusinessType(int businessType) {
    }

    public boolean onReceiveOnlineState(Context context, boolean state) {
        Log.i((String)TAG, (String)("onReceiveOnlineState online status = " + state));
        return false;
    }

    public boolean onReceiveCommandResult(Context context, GTCmdMessage commandResult) {
        Log.i((String)TAG, (String)("onReceiveCommandResult gtcmdMessage = " + new String(commandResult.getPkgName())));
        return false;
    }

    public boolean onNotificationMessageArrived(Context context, GTNotificationMessage arrivedMsg) {
        Log.i((String)TAG, (String)("onNotificationMessageArrived notify_msgarrived = " + arrivedMsg.getContent()));
        return false;
    }

    public boolean onNotificationMessageClicked(Context context, GTNotificationMessage clicked) {
        Log.i((String)TAG, (String)("onNotificationMessageClicked msg = " + clicked.getContent()));
        return false;
    }

    public void init(Context context) {
    }

    public void receiverMsg(Object object, Context context) {
        Log.i((String)TAG, (String)("receiverMsg: object:" + object));
        if (object instanceof UMessage) {
            UMessage result = (UMessage)object;
            Log.i((String)TAG, (String)("receiverMsg: result:" + result));
            ByPushEntity byPushEntity = ByPushEntity.parse((UMessage)result);
            this.savePushEntity(context, byPushEntity);
            Log.i((String)TAG, (String)("receiverMsg: byPushEntity:" + byPushEntity));
        }
    }

    public void receiverNotifyMsg(Object object, Context context) {
        UMessage result;
        ByPushEntity pushEntity;
        String businessType;
        LogUtils.i((Object[])new Object[]{"\u70b9\u51fb\u4e86\u901a\u77e5\u680f" + object.toString()});
        if (object instanceof UMessage && (businessType = (pushEntity = ByPushEntity.parse((UMessage)(result = (UMessage)object))).getBusinessType()) != null) {
            ARouter.getInstance().build("/home/MainActivity").navigation();
            EventBus.getDefault().postSticky((Object)pushEntity);
        }
    }
}

