/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.authorization_server.config;

import com.ebaiyihui.authorization_server.config.AuthorityConfig;
import com.ebaiyihui.authorization_server.intercepter.ApiAccessInterceptor;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
public class ByhResourceServerConfiguration
extends WebMvcConfigurationSupport {
    @Bean
    protected ApiAccessInterceptor apiAccessInterceptor() {
        return new ApiAccessInterceptor();
    }

    protected void addInterceptors(InterceptorRegistry registry) {
        InterceptorRegistration registration = registry.addWebRequestInterceptor((WebRequestInterceptor)this.apiAccessInterceptor());
        registration.addPathPatterns(new String[]{"/**"});
        registration.excludePathPatterns(new String[]{"/**/swagger-ui.html"});
        registration.excludePathPatterns(new String[]{"/**/*.html"});
        registration.excludePathPatterns(new String[]{"/**/*.jsp"});
        registration.excludePathPatterns(new String[]{"/**/error/**"});
        AuthorityConfig authorityConfig = new AuthorityConfig();
        if (authorityConfig.isEnabled()) {
            List<String> whiteUriList = authorityConfig.getWhiteUriList();
            registration.excludePathPatterns(whiteUriList);
        } else {
            registration.excludePathPatterns(new String[]{"/**"});
        }
    }
}

