/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.AddRecordResDTO;
import com.ebaiyihui.his.pojo.dto.CheckCardDTO;
import com.ebaiyihui.his.pojo.dto.CheckCardResDTO;
import com.ebaiyihui.his.pojo.dto.CreatePatientInfoReqDTO;
import com.ebaiyihui.his.pojo.dto.CreatePatientInfoResDTO;
import com.ebaiyihui.his.pojo.dto.PatientInfo;
import com.ebaiyihui.his.pojo.dto.QueryAccountInfoDTO;
import com.ebaiyihui.his.pojo.dto.QueryAccountInfoResDTO;
import com.ebaiyihui.his.pojo.dto.QueryCardInfoDTO;
import com.ebaiyihui.his.pojo.dto.QueryCardInfoResDTO;
import com.ebaiyihui.his.pojo.dto.RechargeResDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryAccountInfoResVo;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoResVO;
import com.ebaiyihui.his.pojo.vo.card.QueryUserExistReqVo;
import com.ebaiyihui.his.pojo.vo.card.QueryUserExistResVo;
import com.ebaiyihui.his.pojo.vo.card.RechargeReqVo;
import com.ebaiyihui.his.pojo.vo.card.RechargeResVo;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardReqVO;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ICardService;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardServiceImpl
implements ICardService {
    @Autowired
    private HisRemoteService hisRemoteService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FrontResponse<QueryCardInfoResVO> queryCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        QueryCardInfoReqVO paramBody = (QueryCardInfoReqVO)param.getBody();
        HashMap<String, QueryCardInfoDTO> cardInfoMap = new HashMap<String, QueryCardInfoDTO>();
        QueryCardInfoDTO queryCardInfoDTO = QueryCardInfoDTO.builder().transNO("001").markNO(paramBody.getCredNo()).markType("4").build();
        cardInfoMap.put(EntityKeyEnum.QUERY_CARD_INFO.getValue(), queryCardInfoDTO);
        FrontResponse queryCardInfoRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.FIND_PATIENT_INFO.getValue(), cardInfoMap, QueryCardInfoResDTO.class);
        if (Objects.isNull(queryCardInfoRes)) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", null);
        }
        QueryCardInfoResDTO queryCardInfoResDTO = (QueryCardInfoResDTO)queryCardInfoRes.getBody();
        if (Objects.isNull(queryCardInfoResDTO)) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)queryCardInfoRes.getMessage());
        }
        if (!"1".equals(queryCardInfoResDTO.getResult())) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)queryCardInfoResDTO.getErr());
        }
        if (!"1".equals(queryCardInfoResDTO.getState())) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)"\u5361\u65e0\u6548\u6216\u6ce8\u9500");
        }
        PatientInfo patientInfo = queryCardInfoResDTO.getPatientInfo();
        QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
        queryCardInfoResVO.setCredType("4");
        queryCardInfoResVO.setCardNo(patientInfo.getCardNO());
        queryCardInfoResVO.setAddress(patientInfo.getAddress());
        String sex = Objects.equals("\u7537", patientInfo.getSex()) ? "M" : "F";
        queryCardInfoResVO.setSex(sex);
        queryCardInfoResVO.setName(patientInfo.getName());
        queryCardInfoResVO.setTelephone(patientInfo.getPhone());
        queryCardInfoResVO.setCredNo(patientInfo.getIdNO());
        queryCardInfoResVO.setCardNo(patientInfo.getCardNO());
        queryCardInfoResVO.setPatientNo(patientInfo.getPatientNO());
        queryCardInfoResVO.setInPatientNo(patientInfo.getInPatientNO());
        queryCardInfoResVO.setMaritalStatus(patientInfo.getMaritalStatus());
        queryCardInfoResVO.setRemark(patientInfo.getRemark());
        queryCardInfoResVO.setPactCode(patientInfo.getPactCode());
        return FrontResponse.success((String)queryCardInfoRes.getTransactionId(), (Object)queryCardInfoResVO);
    }

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegisteredCardReqVO> param) {
        RegisteredCardReqVO registeredCardReqVO = (RegisteredCardReqVO)param.getBody();
        if (!IdCardUtil.validateIdCard18((String)registeredCardReqVO.getCredNo())) {
            this.logger.warn("\u65b0\u8eab\u4efd\u8bc1\u9a8c\u8bc1\u5931\u8d25[{}],\u5361\u4fe1\u606f[{}]", (Object)JsonUtil.convertObject((Object)registeredCardReqVO), (Object)registeredCardReqVO.getCredNo());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u60a8\u8f93\u5165\u7684\u8bc1\u4ef6\u53f7\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        CreatePatientInfoReqDTO createPatientInfoReqDTO = new CreatePatientInfoReqDTO();
        createPatientInfoReqDTO.setPhone(registeredCardReqVO.getTelephone());
        createPatientInfoReqDTO.setAddress(registeredCardReqVO.getAddress());
        createPatientInfoReqDTO.setName(registeredCardReqVO.getName());
        String birthStr = IdCardUtil.getBirthByIdCard2((String)registeredCardReqVO.getCredNo());
        createPatientInfoReqDTO.setBirthDay(birthStr.replaceAll("-", "/"));
        String genderByIdCard = IdCardUtil.getGenderByIdCard((String)registeredCardReqVO.getCredNo());
        String sex = Objects.equals("M", genderByIdCard) ? "\u7537" : "\u5973";
        createPatientInfoReqDTO.setSex(sex);
        createPatientInfoReqDTO.setIdNO(registeredCardReqVO.getCredNo());
        createPatientInfoReqDTO.setMarkType("4");
        createPatientInfoReqDTO.setMarkNO(registeredCardReqVO.getCredNo());
        createPatientInfoReqDTO.setTransType("1");
        HashMap<String, CreatePatientInfoReqDTO> map = new HashMap<String, CreatePatientInfoReqDTO>();
        map.put(EntityKeyEnum.CREATE_PATIENT_INFO.getValue(), createPatientInfoReqDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.CREATE_PATIENT_FILE.getValue(), map, CreatePatientInfoResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", null);
        }
        CreatePatientInfoResDTO createPatientInfoResDTO = (CreatePatientInfoResDTO)response.getBody();
        if (Objects.isNull(createPatientInfoResDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"1".equals(createPatientInfoResDTO.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)createPatientInfoResDTO.getResultMsg());
        }
        RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
        registeredCardResVO.setCardNo(createPatientInfoResDTO.getCardNo());
        registeredCardResVO.setCredNo(createPatientInfoResDTO.getMarkno());
        registeredCardResVO.setCredType("01");
        registeredCardResVO.setVacancy(createPatientInfoResDTO.getVacancy());
        return FrontResponse.success((String)response.getTransactionId(), (Object)registeredCardResVO);
    }

    public FrontResponse<RegisteredCardResVO> check(FrontRequest<RegisteredCardReqVO> param) {
        CheckCardDTO checkCardDTO = CheckCardDTO.builder().build();
        HashMap<String, CheckCardDTO> map = new HashMap<String, CheckCardDTO>();
        map.put(EntityKeyEnum.CHECK_CARD.getValue(), checkCardDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.CHECK_ACCOUNT_PASSWORD.getValue(), map, CheckCardResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", null);
        }
        CheckCardResDTO checkCardResDTO = (CheckCardResDTO)response.getBody();
        if (Objects.isNull(checkCardResDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"1".equals(checkCardResDTO.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)checkCardResDTO.getResultMsg());
        }
        return FrontResponse.success((String)response.getTransactionId(), null);
    }

    public FrontResponse<QueryAccountInfoResVo> queryAccountInfo(FrontRequest<RegisteredCardReqVO> param) {
        QueryAccountInfoDTO queryAccountInfoDTO = QueryAccountInfoDTO.builder().cardNO(((RegisteredCardReqVO)param.getBody()).getCardNo()).build();
        HashMap<String, QueryAccountInfoDTO> map = new HashMap<String, QueryAccountInfoDTO>();
        map.put(EntityKeyEnum.QUERY_ACCOUNT_INFO.getValue(), queryAccountInfoDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_ACCOUNT_INFO.getValue(), map, QueryAccountInfoResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", null);
        }
        QueryAccountInfoResDTO queryAccountInfoResDTO = (QueryAccountInfoResDTO)response.getBody();
        if (Objects.isNull(queryAccountInfoResDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"1".equals(queryAccountInfoResDTO.getResult())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)queryAccountInfoResDTO.getErr());
        }
        QueryAccountInfoResVo queryAccountInfoResVo = new QueryAccountInfoResVo();
        queryAccountInfoResVo.setAccountNo(queryAccountInfoResDTO.getAccountNO());
        queryAccountInfoResVo.setVacancy(queryAccountInfoResDTO.getVacancy());
        return FrontResponse.success((String)response.getTransactionId(), (Object)queryAccountInfoResVo);
    }

    public FrontResponse<RechargeResVo> recharge(FrontRequest<RechargeReqVo> param) {
        RechargeReqVo body = (RechargeReqVo)param.getBody();
        RegisteredCardReqVO registeredCardReqVO = new RegisteredCardReqVO();
        registeredCardReqVO.setCardNo(body.getCardNO());
        FrontRequest newFrontRequest = new FrontRequest();
        newFrontRequest.setBody((Object)registeredCardReqVO);
        FrontResponse queryAccountInfoResponse = this.queryAccountInfo(newFrontRequest);
        if (Objects.isNull(queryAccountInfoResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", null);
        }
        if (!Objects.equals("1", queryAccountInfoResponse.getCode())) {
            return FrontResponse.error((String)queryAccountInfoResponse.getTransactionId(), (String)"0", (String)queryAccountInfoResponse.getMessage());
        }
        QueryAccountInfoResVo queryAccountInfoResVo = (QueryAccountInfoResVo)queryAccountInfoResponse.getBody();
        String accountNO = queryAccountInfoResVo.getAccountNo();
        body.setAccountNO(accountNO);
        HashMap<String, RechargeReqVo> map = new HashMap<String, RechargeReqVo>();
        map.put(EntityKeyEnum.RECHARGE.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.RECHARGE.getValue(), map, RechargeResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", null);
        }
        RechargeResDTO rechargeResDTO = (RechargeResDTO)response.getBody();
        if (Objects.isNull(rechargeResDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"1".equals(rechargeResDTO.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)rechargeResDTO.getResultMsg());
        }
        RechargeResVo rechargeResVo = new RechargeResVo();
        rechargeResVo.setVacancy(rechargeResDTO.getVacancy());
        return FrontResponse.success((String)response.getTransactionId(), (Object)rechargeResVo);
    }

    public FrontResponse<QueryUserExistResVo> queryUserExist(FrontRequest<QueryUserExistReqVo> param) {
        QueryUserExistReqVo body = (QueryUserExistReqVo)param.getBody();
        HashMap<String, QueryUserExistReqVo> map = new HashMap<String, QueryUserExistReqVo>();
        map.put(EntityKeyEnum.QUERY_USER_EXIST.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_USER_EXIST.getValue(), map, AddRecordResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", null);
        }
        AddRecordResDTO addRecordResDTO = (AddRecordResDTO)response.getBody();
        if (Objects.isNull(addRecordResDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"1".equals(addRecordResDTO.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)addRecordResDTO.getResultMsg());
        }
        QueryUserExistResVo queryUserExistResVo = new QueryUserExistResVo();
        queryUserExistResVo.setCardNo(addRecordResDTO.getCardNO());
        return FrontResponse.success((String)response.getTransactionId(), (Object)queryUserExistResVo);
    }
}

