/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.PayTypeEnums;
import com.ebaiyihui.his.pojo.dto.GetOutPatientAdmResDTO;
import com.ebaiyihui.his.pojo.dto.GetOutPatientAdmResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsReqDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsResDTO;
import com.ebaiyihui.his.pojo.dto.OutpatientComfirePayReqDTO;
import com.ebaiyihui.his.pojo.dto.OutpatientComfirePayResDTO;
import com.ebaiyihui.his.pojo.dto.PendingPayDetailResDTO;
import com.ebaiyihui.his.pojo.dto.PendingPayDetailResItemDTO;
import com.ebaiyihui.his.pojo.dto.PendingPayDetailResItemDetailDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsRes;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemReq;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemRes;
import com.ebaiyihui.his.pojo.vo.outpatient.datas.PayItemResDatas;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetAdmissionItems;
import com.ebaiyihui.his.pojo.vo.outpatient.items.PayItemResItems;
import com.ebaiyihui.his.pojo.vo.outpatient.respmsg.ComfirmPayNewReqMsg;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.OutpatientPaymentService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetAdmissionRes> getAdmission(FrontRequest<GetAdmissionReq> param) {
        GetAdmissionRes getAdmissionRes = new GetAdmissionRes();
        HashMap<String, Object> admMap = new HashMap<String, Object>(1);
        admMap.put(EntityKeyEnum.Get_ADMSSION_INFO.getValue(), param.getBody());
        FrontResponse admRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_MEDICAL_RECORDS.getValue(), admMap, GetOutPatientAdmResDTO.class);
        GetOutPatientAdmResDTO getOutPatientAdmRes = (GetOutPatientAdmResDTO)admRes.getBody();
        if (null == getOutPatientAdmRes) {
            return FrontResponse.error((String)admRes.getTransactionId(), (String)"0", (String)admRes.getMessage());
        }
        if (!"0".equals(getOutPatientAdmRes.getResultCode())) {
            return FrontResponse.error((String)admRes.getTransactionId(), (String)"0", (String)getOutPatientAdmRes.getResultMsg());
        }
        List getOutPatientAdmResItemDTOList = getOutPatientAdmRes.getItems();
        if (CollectionUtils.isEmpty((Collection)getOutPatientAdmResItemDTOList)) {
            return FrontResponse.error((String)admRes.getTransactionId(), (String)"0", (String)getOutPatientAdmRes.getResultMsg());
        }
        ArrayList<GetAdmissionItems> admissionItemsList = new ArrayList<GetAdmissionItems>();
        for (GetOutPatientAdmResItemDTO getOutPatientAdmResItemDTO : getOutPatientAdmResItemDTOList) {
            GetAdmissionItems getAdmissionItems = new GetAdmissionItems();
            BeanUtils.copyProperties((Object)getOutPatientAdmResItemDTO, (Object)getAdmissionItems);
            admissionItemsList.add(getAdmissionItems);
        }
        getAdmissionRes.setItems(admissionItemsList);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getAdmissionRes);
    }

    public FrontResponse<PayItemRes> payItem(FrontRequest<PayItemReq> param) {
        PayItemRes payItemRes = new PayItemRes();
        HashMap<String, Object> pendingPayMap = new HashMap<String, Object>(1);
        pendingPayMap.put(EntityKeyEnum.PENDING_PAY_ITEMS.getValue(), param.getBody());
        FrontResponse detailRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PENDING_RECORD_INQUIRY_DETAIL.getValue(), pendingPayMap, PendingPayDetailResDTO.class);
        if (null == detailRes) {
            return FrontResponse.error((String)detailRes.getTransactionId(), (String)"0", (String)detailRes.getMessage());
        }
        if (!"0".equals(((PendingPayDetailResDTO)detailRes.getBody()).getResultCode())) {
            return FrontResponse.error((String)detailRes.getTransactionId(), (String)"0", (String)((PendingPayDetailResDTO)detailRes.getBody()).getResultMsg());
        }
        List payDetailResList = ((PendingPayDetailResDTO)detailRes.getBody()).getItem();
        if (CollectionUtils.isEmpty((Collection)payDetailResList)) {
            return FrontResponse.error((String)detailRes.getTransactionId(), (String)"0", (String)((PendingPayDetailResDTO)detailRes.getBody()).getResultMsg());
        }
        ArrayList<PayItemResDatas> datas = new ArrayList<PayItemResDatas>();
        for (PendingPayDetailResItemDTO pendingPayDetailResItemDTO : payDetailResList) {
            PayItemResDatas payItemResDatas = new PayItemResDatas();
            payItemResDatas.setAdmId(pendingPayDetailResItemDTO.getAdmId());
            payItemResDatas.setAmount(pendingPayDetailResItemDTO.getAmount());
            payItemResDatas.setStartDate(pendingPayDetailResItemDTO.getOperateTime());
            payItemResDatas.setEndDate(pendingPayDetailResItemDTO.getOperateTime());
            payItemResDatas.setItemType(pendingPayDetailResItemDTO.getPrescriptionType());
            ArrayList<PayItemResItems> payItemResItemsList = new ArrayList<PayItemResItems>();
            List payDetailResItemDetailDTOList = pendingPayDetailResItemDTO.getPayDetailResItemDetailDTOList();
            for (PendingPayDetailResItemDetailDTO payDetailResItemDetailDTO : payDetailResItemDetailDTOList) {
                PayItemResItems payItemResItems = new PayItemResItems();
                BeanUtils.copyProperties((Object)payDetailResItemDetailDTO, (Object)payItemResItems);
                payItemResItems.setPrescriptionNo(pendingPayDetailResItemDTO.getPrescriptionNo());
                payItemResItemsList.add(payItemResItems);
            }
            payItemResDatas.setItems(payItemResItemsList);
            datas.add(payItemResDatas);
        }
        payItemRes.setDatas(datas);
        return FrontResponse.success((String)param.getTransactionId(), (Object)payItemRes);
    }

    public FrontResponse<ComfirmPayNewRes> comfirmPayNew(FrontRequest<ComfirmPayNewReq> param) {
        ComfirmPayNewRes comfirmPayNewRes = new ComfirmPayNewRes();
        ComfirmPayNewReq comfirmPayNewReq = (ComfirmPayNewReq)param.getBody();
        ComfirmPayNewReqMsg comfirmPayNewReqMsg = comfirmPayNewReq.getRespmsg();
        OutpatientComfirePayReqDTO outpatientComfirePayReqDTO = new OutpatientComfirePayReqDTO();
        outpatientComfirePayReqDTO.setVisitNo(comfirmPayNewReq.getId());
        outpatientComfirePayReqDTO.setConsume(comfirmPayNewReq.getAmount());
        outpatientComfirePayReqDTO.setPrescriptionNo(comfirmPayNewReq.getPrescriptionNos());
        outpatientComfirePayReqDTO.setTransFlag(HIS_PAY_SUCCESS);
        outpatientComfirePayReqDTO.setPayType(PayTypeEnums.getDisplay((String)comfirmPayNewReq.getPaychannel()));
        outpatientComfirePayReqDTO.setThirdConsume(comfirmPayNewReqMsg.getPayment());
        outpatientComfirePayReqDTO.setTradNo(comfirmPayNewReqMsg.getOrderid());
        outpatientComfirePayReqDTO.setTradDate(comfirmPayNewReqMsg.getAccdate());
        outpatientComfirePayReqDTO.setFlowNo(comfirmPayNewReq.getFlowNo());
        HashMap<String, OutpatientComfirePayReqDTO> confirmPaymap = new HashMap<String, OutpatientComfirePayReqDTO>(1);
        confirmPaymap.put(EntityKeyEnum.OUTPATIENT_CONFIRM_PAY.getValue(), outpatientComfirePayReqDTO);
        FrontResponse comfirePayResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.OUTPATIENT_PAYMENT.getValue(), confirmPaymap, OutpatientComfirePayResDTO.class);
        if (null == comfirePayResDTO) {
            return FrontResponse.error((String)comfirePayResDTO.getTransactionId(), (String)"0", (String)comfirePayResDTO.getMessage());
        }
        if (!"0".equals(((OutpatientComfirePayResDTO)comfirePayResDTO.getBody()).getResultCode())) {
            return FrontResponse.error((String)comfirePayResDTO.getTransactionId(), (String)"0", (String)((OutpatientComfirePayResDTO)comfirePayResDTO.getBody()).getResultMsg());
        }
        comfirmPayNewRes.setRemark(((OutpatientComfirePayResDTO)comfirePayResDTO.getBody()).getGuideInfo());
        comfirmPayNewRes.setReceiptId(((OutpatientComfirePayResDTO)comfirePayResDTO.getBody()).getReceiptId());
        comfirmPayNewRes.setAdmId(comfirmPayNewReq.getId());
        comfirmPayNewRes.setCardNo(comfirmPayNewReq.getCardNo());
        comfirmPayNewRes.setAmount(comfirmPayNewReq.getAmount());
        return FrontResponse.success((String)param.getTransactionId(), (Object)comfirmPayNewRes);
    }

    public FrontResponse<GetPayRecordsRes> getPayRecords(FrontRequest<GetPayRecordsReq> param) {
        GetPayRecordsRes getPayRecordsRes = new GetPayRecordsRes();
        GetPayRecordsReq body = (GetPayRecordsReq)param.getBody();
        GetPayRecordsReqDTO getPayRecordsReqDTO = GetPayRecordsReqDTO.builder().dtBegin(body.getStartDate()).dtEnd(body.getEndDate()).cardNO(body.getCardNo()).build();
        HashMap<String, GetPayRecordsReqDTO> map = new HashMap<String, GetPayRecordsReqDTO>();
        map.put(EntityKeyEnum.GET_PAY_RECORDS.getValue(), getPayRecordsReqDTO);
        FrontResponse recordsResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.OUTPATIENT_LIST_INQUIRY.getValue(), map, GetPayRecordsResDTO.class);
        if (Objects.isNull(recordsResDTO)) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", (String)recordsResDTO.getMessage());
        }
        if (!"0".equals(((GetPayRecordsResDTO)recordsResDTO.getBody()).getResultCode())) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", null);
        }
        List getPayRecordsResItemDTOList = ((GetPayRecordsResDTO)recordsResDTO.getBody()).getItem();
        if (CollectionUtils.isEmpty((Collection)getPayRecordsResItemDTOList)) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", null);
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)getPayRecordsRes);
    }
}

