/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.AssayReportDetailQueryResDTO;
import com.ebaiyihui.his.pojo.dto.AssayReportQueryItemResDTO;
import com.ebaiyihui.his.pojo.dto.AssayReportQueryResDTO;
import com.ebaiyihui.his.pojo.dto.CheckReportResDTO;
import com.ebaiyihui.his.pojo.dto.InspectionReportListDTO;
import com.ebaiyihui.his.pojo.dto.InspectionReportQueryResDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListReq;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListReq;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.datas.LisReportListResData;
import com.ebaiyihui.his.service.ElectronicReportService;
import com.ebaiyihui.his.service.HisRemoteService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int MAP_SIZE = 1;
    public static final String CHECK_TYPE = "1";
    public static final String INSPECTION_TYPE = "2";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetReportListsRes> getReportLists(FrontRequest<GetReportListsReq> param) {
        GetReportListsReq paramBody = (GetReportListsReq)param.getBody();
        List<Object> getReportList = new ArrayList();
        GetReportListsRes getReportListsRes = new GetReportListsRes();
        if (CHECK_TYPE.equals(paramBody.getReportType())) {
            paramBody.setReportType(INSPECTION_TYPE);
        } else {
            paramBody.setReportType(CHECK_TYPE);
        }
        HashMap<String, GetReportListsReq> reportQueryReqMap = new HashMap<String, GetReportListsReq>(1);
        reportQueryReqMap.put(EntityKeyEnum.REPORT_LIST_QUERY.getValue(), paramBody);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.REPORT_LIST_QUERY.getValue(), reportQueryReqMap, AssayReportQueryResDTO.class);
        AssayReportQueryResDTO responseBody = (AssayReportQueryResDTO)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!CHECK_TYPE.equals(responseBody.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        List reportQueryItemResDTOList = responseBody.getItem();
        if (CollectionUtils.isEmpty((Collection)reportQueryItemResDTOList)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        for (AssayReportQueryItemResDTO assayReportQueryItemResDTO : reportQueryItemResDTOList) {
            GetReportListsData getReportListsData = new GetReportListsData();
            BeanUtils.copyProperties((Object)assayReportQueryItemResDTO, (Object)getReportListsData);
            getReportListsData.setReportType(paramBody.getReportType());
            getReportList.add(getReportListsData);
        }
        getReportList = getReportList.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).collect(Collectors.toList());
        getReportListsRes.setDatas(getReportList);
        getReportListsRes.setPatientNo(((AssayReportQueryItemResDTO)reportQueryItemResDTOList.get(0)).getCardNo());
        getReportListsRes.setPatientName(((AssayReportQueryItemResDTO)reportQueryItemResDTOList.get(0)).getPatientName());
        getReportListsRes.setPatientID(((AssayReportQueryItemResDTO)reportQueryItemResDTOList.get(0)).getPatientId());
        return FrontResponse.success((String)response.getTransactionId(), (Object)getReportListsRes);
    }

    public FrontResponse<LisReportListRes> lisReportList(FrontRequest<LisReportListReq> param) {
        HashMap<String, LisReportListReq> assayReportDetailQueryMap = new HashMap<String, LisReportListReq>(1);
        LisReportListReq paramBody = (LisReportListReq)param.getBody();
        assayReportDetailQueryMap.put(EntityKeyEnum.ASSAY_REPORT_DETAIL_QUERY.getValue(), paramBody);
        FrontResponse assayReportDetailQueryRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.ASSAY_REPORT_DETAIL_QUERY.getValue(), assayReportDetailQueryMap, AssayReportDetailQueryResDTO.class);
        AssayReportDetailQueryResDTO assayReportDetailQueryResDTO = (AssayReportDetailQueryResDTO)assayReportDetailQueryRes.getBody();
        if (Objects.isNull(assayReportDetailQueryResDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)assayReportDetailQueryRes.getMessage());
        }
        if (!Objects.equals(CHECK_TYPE, assayReportDetailQueryResDTO.getResult())) {
            return FrontResponse.error((String)assayReportDetailQueryRes.getTransactionId(), (String)"0", (String)assayReportDetailQueryRes.getMessage());
        }
        LisReportListRes lisReportListRes = new LisReportListRes();
        List item = assayReportDetailQueryResDTO.getInspectionReportListDTO();
        if (CollectionUtils.isEmpty((Collection)item)) {
            return FrontResponse.success((String)assayReportDetailQueryRes.getTransactionId(), (Object)lisReportListRes);
        }
        ArrayList<LisReportListResData> list = new ArrayList<LisReportListResData>();
        lisReportListRes.setReportNo(paramBody.getReportNo());
        for (InspectionReportListDTO inspectionReportListDTO : item) {
            LisReportListResData lisReportListResData = new LisReportListResData();
            lisReportListRes.setReportName(inspectionReportListDTO.getItemName());
            lisReportListResData.setItmCode(inspectionReportListDTO.getLisitemCode());
            lisReportListResData.setItmName(inspectionReportListDTO.getLisitemName());
            lisReportListResData.setItmRes(inspectionReportListDTO.getResult());
            lisReportListResData.setItmUnit(inspectionReportListDTO.getUnit());
            lisReportListResData.setItmRanges(inspectionReportListDTO.getRange());
            list.add(lisReportListResData);
        }
        lisReportListRes.setDatas(list);
        return FrontResponse.success((String)assayReportDetailQueryRes.getTransactionId(), (Object)lisReportListRes);
    }

    public FrontResponse<PacsReportListRes> pacsReportList(FrontRequest<PacsReportListReq> param) {
        HashMap<String, PacsReportListReq> inspectionDetailReportQueryMap = new HashMap<String, PacsReportListReq>(1);
        PacsReportListReq paramBody = (PacsReportListReq)param.getBody();
        inspectionDetailReportQueryMap.put(EntityKeyEnum.CHECK_REPORT_DETAIL.getValue(), paramBody);
        FrontResponse inspectionReportQueryRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.CHECK_REPORT_DETAIL.getValue(), inspectionDetailReportQueryMap, InspectionReportQueryResDTO.class);
        InspectionReportQueryResDTO inspectionReportQueryResDTO = (InspectionReportQueryResDTO)inspectionReportQueryRes.getBody();
        if (Objects.isNull(inspectionReportQueryResDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)inspectionReportQueryRes.getMessage());
        }
        if (!CHECK_TYPE.equals(inspectionReportQueryResDTO.getResultCode())) {
            return FrontResponse.error((String)inspectionReportQueryRes.getTransactionId(), (String)"0", (String)inspectionReportQueryRes.getMessage());
        }
        List item = inspectionReportQueryResDTO.getCheckReportResDTO();
        if (CollectionUtils.isEmpty((Collection)item)) {
            return FrontResponse.success((String)inspectionReportQueryRes.getTransactionId(), null);
        }
        PacsReportListRes pacsReportListRes = new PacsReportListRes();
        CheckReportResDTO checkReportResDTO = (CheckReportResDTO)item.get(0);
        pacsReportListRes.setReportName(checkReportResDTO.getPacsExoression());
        pacsReportListRes.setCheckResult(checkReportResDTO.getPacsExoression());
        pacsReportListRes.setCheckDesc(checkReportResDTO.getDiagImpress());
        return FrontResponse.success((String)inspectionReportQueryRes.getTransactionId(), (Object)pacsReportListRes);
    }
}

