/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.AddRecordDTO;
import com.ebaiyihui.his.pojo.dto.AddRecordResDTO;
import com.ebaiyihui.his.pojo.dto.DayFeeListResDTO;
import com.ebaiyihui.his.pojo.dto.GetInpAdmissionResDTO;
import com.ebaiyihui.his.pojo.dto.GetInpAdmissionResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetInpAdmisssionReqDTO;
import com.ebaiyihui.his.pojo.dto.HospDepositRecordsItemResDTO;
import com.ebaiyihui.his.pojo.dto.HospDepositRecordsResDTO;
import com.ebaiyihui.his.pojo.dto.InHospDepositReqDTO;
import com.ebaiyihui.his.pojo.dto.InHospDepositResDTO;
import com.ebaiyihui.his.pojo.dto.InPatientInfoDTO;
import com.ebaiyihui.his.pojo.dto.InPatientInfoResDTO;
import com.ebaiyihui.his.pojo.dto.QueryHospitalizationInfoResDTO;
import com.ebaiyihui.his.pojo.dto.QueryInpatientExpenseResDTO;
import com.ebaiyihui.his.pojo.dto.QueryInvoiceDTO;
import com.ebaiyihui.his.pojo.dto.QueryInvoiceItemResDTO;
import com.ebaiyihui.his.pojo.dto.QueryInvoiceResDTO;
import com.ebaiyihui.his.pojo.dto.QuerySerialNumberByCardIdResDTO;
import com.ebaiyihui.his.pojo.dto.QuerySerialNumberItemResDTO;
import com.ebaiyihui.his.pojo.dto.QuerySerialNumberResDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpDetailReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpDetailRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.QueryHospitalizationInfoReqVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QueryHospitalizationInfoResItemVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QueryHospitalizationInfoResVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QueryInpatientExpenseItemResVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QueryInpatientExpenseReqVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QueryInpatientExpenseResVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QueryInvoiceReqVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QueryInvoiceResItemVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QueryInvoiceResVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QuerySerialNumberByCardIdItemResVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QuerySerialNumberByCardIdReqVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QuerySerialNumberByCardIdResVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QuerySerialNumberItemResVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QuerySerialNumberReqVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.QuerySerialNumberResVo;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetIPDepositRecordsItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetInpAdmissionResItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetOrdItemsResItems;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.HospitalizationService;
import com.ebaiyihui.his.utils.DateUtil;
import com.ebaiyihui.his.utils.KeyWordUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HospitalizationServiceImpl
implements HospitalizationService {
    private static final Logger log = LoggerFactory.getLogger(HospitalizationServiceImpl.class);
    public static final String HIS_OUT_HOSP_STATUS = "1";
    public static final String BYH_OUT_HOSP_STATUS = "D";
    public static final String BYH_IN_HOSP_STATUS = "A";
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetInpAdmissionRes> getInpAdmission(FrontRequest<GetInpAdmissionReq> param) throws ParseException {
        GetInpAdmissionRes getInpAdmissionRes = new GetInpAdmissionRes();
        QueryHospitalizationInfoReqVo getInpAdmisssionReqDTO = new QueryHospitalizationInfoReqVo();
        getInpAdmisssionReqDTO.setPatientNo(((GetInpAdmissionReq)param.getBody()).getInHospNo());
        HashMap<String, QueryHospitalizationInfoReqVo> inpAdmissionMap = new HashMap<String, QueryHospitalizationInfoReqVo>(1);
        inpAdmissionMap.put(EntityKeyEnum.QUERY_HOSPITALIZATION_INFO.getValue(), getInpAdmisssionReqDTO);
        FrontResponse inpAdmissionResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_HOSPITALIZATION_INFO.getValue(), inpAdmissionMap, GetInpAdmissionResDTO.class);
        if (null == inpAdmissionResDTO) {
            return FrontResponse.error((String)inpAdmissionResDTO.getTransactionId(), (String)SUCCESS_FLAG, (String)inpAdmissionResDTO.getMessage());
        }
        if (!HIS_OUT_HOSP_STATUS.equals(((GetInpAdmissionResDTO)inpAdmissionResDTO.getBody()).getResultCode())) {
            return FrontResponse.error((String)inpAdmissionResDTO.getTransactionId(), (String)SUCCESS_FLAG, (String)((GetInpAdmissionResDTO)inpAdmissionResDTO.getBody()).getErr());
        }
        log.info("\u8c03\u7528his\u83b7\u53d6\u4f4f\u9662\u8bb0\u5f55\u8fd4\u56de\u503c\u4e3a:{}", (Object)inpAdmissionResDTO);
        List getPayRecordsResItemDTOList = ((GetInpAdmissionResDTO)inpAdmissionResDTO.getBody()).getItems();
        log.info("\u8c03\u7528his\u83b7\u53d6\u4f4f\u9662\u8bb0\u5f55\u7684body\u5c5e\u6027\u8fd4\u56de\u503c\u4e3a:{}", (Object)getPayRecordsResItemDTOList);
        if (CollectionUtils.isEmpty((Collection)getPayRecordsResItemDTOList)) {
            return FrontResponse.error((String)inpAdmissionResDTO.getTransactionId(), (String)SUCCESS_FLAG, (String)((GetInpAdmissionResDTO)inpAdmissionResDTO.getBody()).getErr());
        }
        ArrayList<GetInpAdmissionResItems> items = new ArrayList<GetInpAdmissionResItems>();
        for (GetInpAdmissionResItemDTO getInpAdmissionResItemDTO : getPayRecordsResItemDTOList) {
            GetInpAdmissionResItems getInpAdmissionResItems = new GetInpAdmissionResItems();
            BeanUtils.copyProperties((Object)getInpAdmissionResItemDTO, (Object)getInpAdmissionResItems);
            getInpAdmissionResItems.setStartDate(getInpAdmissionResItemDTO.getIndate());
            getInpAdmissionResItems.setPatientName(getInpAdmissionResItemDTO.getName());
            getInpAdmissionResItems.setPatientSex(getInpAdmissionResItemDTO.getSex());
            getInpAdmissionResItems.setCurrentMoney(getInpAdmissionResItemDTO.getFreeCost());
            getInpAdmissionResItems.setNursingUnit(getInpAdmissionResItemDTO.getFeeName());
            getInpAdmissionResItems.setInHospNo(((GetInpAdmissionReq)param.getBody()).getInHospNo());
            getInpAdmissionResItems.setPatientAge(Integer.toString(DateUtil.getAgeByBirth((Date)DateUtil.stringToDate((String)getInpAdmissionResItemDTO.getBirthday(), (String)DateUtil.DATE_FORMAT))));
            getInpAdmissionResItems.setTotalMoney(SUCCESS_FLAG);
            getInpAdmissionResItems.setPatientId(((GetInpAdmissionReq)param.getBody()).getInHospNo());
            if (HIS_OUT_HOSP_STATUS.equals(KeyWordUtil.getInState((String)getInpAdmissionResItemDTO.getHospStatus()))) {
                getInpAdmissionResItems.setHospStatus(BYH_OUT_HOSP_STATUS);
            } else {
                getInpAdmissionResItems.setHospStatus(BYH_IN_HOSP_STATUS);
            }
            items.add(getInpAdmissionResItems);
        }
        getInpAdmissionRes.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getInpAdmissionRes);
    }

    public FrontResponse<GetInpDetailRes> getInpDetail(FrontRequest<GetInpDetailReq> param) {
        return null;
    }

    public FrontResponse<DepositRes> deposit(FrontRequest<DepositReq> param) {
        DepositRes depositRes = new DepositRes();
        DepositReq body = (DepositReq)param.getBody();
        InHospDepositReqDTO inHospDepositReqDTO = InHospDepositReqDTO.builder().patientNO(body.getInHospNo()).payType(body.getPayChannel()).cost(body.getAmount()).bankName(body.getBankName()).bankAccount(body.getBankAccount()).transType(HIS_OUT_HOSP_STATUS).transNO(body.getTransNO()).MachineNO(body.getMachineNO()).build();
        HashMap<String, InHospDepositReqDTO> map = new HashMap<String, InHospDepositReqDTO>();
        map.put(EntityKeyEnum.IN_HOSP_DEPOSIT.getValue(), inHospDepositReqDTO);
        FrontResponse depositResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.HOSPITAL_RENEWAL_DEPOSIT.getValue(), map, InHospDepositResDTO.class);
        if (null == depositResDTO) {
            return FrontResponse.error((String)depositResDTO.getTransactionId(), (String)SUCCESS_FLAG, null);
        }
        if (!HIS_OUT_HOSP_STATUS.equals(((InHospDepositResDTO)depositResDTO.getBody()).getResultCode())) {
            return FrontResponse.error((String)depositResDTO.getTransactionId(), (String)SUCCESS_FLAG, (String)((InHospDepositResDTO)depositResDTO.getBody()).getResultMsg());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)depositRes);
    }

    public FrontResponse<GetIPDepositRecordsRes> getIPDepositRecords(FrontRequest<GetIPDepositRecordsReq> param) {
        GetIPDepositRecordsRes getIPDepositRecordsRes = new GetIPDepositRecordsRes();
        ArrayList<GetIPDepositRecordsItems> getIPDepositRecordsItems = new ArrayList<GetIPDepositRecordsItems>();
        HashMap<String, Object> hospDepositRecordsReqMap = new HashMap<String, Object>(1);
        hospDepositRecordsReqMap.put(EntityKeyEnum.GET_IP_DEPOSIT_RECORDS.getValue(), param.getBody());
        FrontResponse hospDepositRecordsRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_IP_DEPOSIT_RECORDS.getValue(), hospDepositRecordsReqMap, HospDepositRecordsResDTO.class);
        HospDepositRecordsResDTO hospDepositRecordsResDTO = (HospDepositRecordsResDTO)hospDepositRecordsRes.getBody();
        if (Objects.isNull(hospDepositRecordsResDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)hospDepositRecordsRes.getMessage());
        }
        if (!SUCCESS_FLAG.equals(hospDepositRecordsResDTO.getResultCode())) {
            return FrontResponse.error((String)hospDepositRecordsRes.getTransactionId(), (String)SUCCESS_FLAG, (String)hospDepositRecordsRes.getMessage());
        }
        List item = hospDepositRecordsResDTO.getItem();
        if (CollectionUtils.isEmpty((Collection)item)) {
            return FrontResponse.success((String)param.getTransactionId(), (Object)getIPDepositRecordsRes);
        }
        for (HospDepositRecordsItemResDTO hospDepositRecordsItemResDTO : item) {
            GetIPDepositRecordsItems getIPDepositRecords = new GetIPDepositRecordsItems();
            getIPDepositRecords.setPrePayDateTime(hospDepositRecordsItemResDTO.getRechargeTime());
            getIPDepositRecords.setAmout(hospDepositRecordsItemResDTO.getRechargeMoney());
            getIPDepositRecords.setPayStatus(SUCCESS_FLAG);
            getIPDepositRecordsItems.add(getIPDepositRecords);
        }
        getIPDepositRecordsRes.setItems(getIPDepositRecordsItems);
        return FrontResponse.success((String)hospDepositRecordsRes.getTransactionId(), (Object)getIPDepositRecordsRes);
    }

    public FrontResponse<GetOrdItemsRes> getOrdItems(FrontRequest<GetOrdItemsReq> param) {
        GetOrdItemsRes getOrdItemsRes = new GetOrdItemsRes();
        GetOrdItemsReq body = (GetOrdItemsReq)param.getBody();
        GetInpAdmisssionReqDTO getInpAdmisssionReqDTO = GetInpAdmisssionReqDTO.builder().InvoiceNo(body.getInvoiceNo()).PatientNO(body.getInHospNo()).build();
        HashMap<String, GetInpAdmisssionReqDTO> map = new HashMap<String, GetInpAdmisssionReqDTO>();
        map.put(EntityKeyEnum.QUERY_HOSPITALIZATION_INFO.getValue(), getInpAdmisssionReqDTO);
        FrontResponse inpAdmissionResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_HOSPITALIZATION_INFO.getValue(), map, GetInpAdmissionResDTO.class);
        if (Objects.isNull(inpAdmissionResDTO)) {
            return FrontResponse.error((String)inpAdmissionResDTO.getTransactionId(), (String)SUCCESS_FLAG, null);
        }
        if (Objects.isNull(inpAdmissionResDTO.getBody())) {
            return FrontResponse.error((String)inpAdmissionResDTO.getTransactionId(), (String)SUCCESS_FLAG, (String)inpAdmissionResDTO.getMessage());
        }
        GetInpAdmissionResDTO resDTOBody = (GetInpAdmissionResDTO)inpAdmissionResDTO.getBody();
        if (!HIS_OUT_HOSP_STATUS.equals(resDTOBody.getResultCode())) {
            return FrontResponse.error((String)inpAdmissionResDTO.getTransactionId(), (String)SUCCESS_FLAG, (String)resDTOBody.getErr());
        }
        List getPayRecordsResItemDTOList = resDTOBody.getItems();
        if (CollectionUtils.isEmpty((Collection)getPayRecordsResItemDTOList)) {
            return FrontResponse.error((String)inpAdmissionResDTO.getTransactionId(), (String)SUCCESS_FLAG, null);
        }
        ArrayList<GetOrdItemsResItems> list = new ArrayList<GetOrdItemsResItems>();
        for (GetInpAdmissionResItemDTO getInpAdmissionResItemDTO : getPayRecordsResItemDTOList) {
            GetOrdItemsResItems getOrdItemsListRes = new GetOrdItemsResItems();
            getOrdItemsListRes.setAmount(getInpAdmissionResItemDTO.getItemdatetiem());
            getOrdItemsListRes.setFeeDate(getInpAdmissionResItemDTO.getIndate());
            getOrdItemsListRes.setFeeType(getInpAdmissionResItemDTO.getFeeType());
            getOrdItemsListRes.setPrice(getInpAdmissionResItemDTO.getUnitPrice());
            getOrdItemsListRes.setQty(getInpAdmissionResItemDTO.getQty());
            getOrdItemsListRes.setItmMastName(getInpAdmissionResItemDTO.getFeeName());
            getOrdItemsListRes.setSpec(getInpAdmissionResItemDTO.getItemspec());
            getOrdItemsListRes.setUomDesc(getInpAdmissionResItemDTO.getUnit());
            list.add(getOrdItemsListRes);
        }
        getOrdItemsRes.setOrdItem(list);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getOrdItemsRes);
    }

    public FrontResponse<QueryInvoiceResVo> queryInvoice(FrontRequest<QueryInvoiceReqVo> param) {
        QueryInvoiceDTO queryInvoiceDTO = QueryInvoiceDTO.builder().patientNO(((QueryInvoiceReqVo)param.getBody()).getPatientNo()).build();
        HashMap<String, QueryInvoiceDTO> map = new HashMap<String, QueryInvoiceDTO>();
        map.put(EntityKeyEnum.QUERY_INVOICE.getValue(), queryInvoiceDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_INVOICE.getValue(), map, QueryInvoiceResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, null);
        }
        if (!HIS_OUT_HOSP_STATUS.equals(((QueryInvoiceResDTO)response.getBody()).getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryInvoiceResDTO)response.getBody()).getErr());
        }
        QueryInvoiceResDTO responseBody = (QueryInvoiceResDTO)response.getBody();
        if (CollectionUtils.isEmpty((Collection)responseBody.getItem())) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        List item = responseBody.getItem();
        ArrayList<QueryInvoiceResItemVo> list = new ArrayList<QueryInvoiceResItemVo>();
        for (QueryInvoiceItemResDTO queryInvoiceItemResDTO : item) {
            QueryInvoiceResItemVo queryInvoiceResItemVo = new QueryInvoiceResItemVo();
            BeanUtils.copyProperties((Object)queryInvoiceItemResDTO, (Object)queryInvoiceResItemVo);
            list.add(queryInvoiceResItemVo);
        }
        QueryInvoiceResVo queryInvoiceResVo = new QueryInvoiceResVo();
        queryInvoiceResVo.setItem(list);
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryInvoiceResVo);
    }

    public FrontResponse<QueryHospitalizationInfoResVo> queryHospitalizationInfo(FrontRequest<QueryHospitalizationInfoReqVo> param) {
        QueryHospitalizationInfoReqVo body = (QueryHospitalizationInfoReqVo)param.getBody();
        HashMap<String, QueryHospitalizationInfoReqVo> map = new HashMap<String, QueryHospitalizationInfoReqVo>();
        map.put(EntityKeyEnum.QUERY_HOSPITALIZATION_INFO.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_HOSPITALIZATION_INFO.getValue(), map, QueryHospitalizationInfoResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, null);
        }
        QueryHospitalizationInfoResDTO responseBody = (QueryHospitalizationInfoResDTO)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        if (!HIS_OUT_HOSP_STATUS.equals(responseBody.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)responseBody.getErr());
        }
        if (CollectionUtils.isEmpty((Collection)responseBody.getInPatientInfo())) {
            FrontResponse.success((String)param.getTransactionId(), null);
        }
        QueryHospitalizationInfoResVo queryHospitalizationInfoResVo = new QueryHospitalizationInfoResVo();
        List inPatientInfo = responseBody.getInPatientInfo();
        ArrayList<QueryHospitalizationInfoResItemVo> list = new ArrayList<QueryHospitalizationInfoResItemVo>();
        for (InPatientInfoResDTO inPatientInfoResDTO : inPatientInfo) {
            QueryHospitalizationInfoResItemVo queryHospitalizationInfoResItemVo = new QueryHospitalizationInfoResItemVo();
            BeanUtils.copyProperties((Object)inPatientInfoResDTO, (Object)queryHospitalizationInfoResItemVo);
            list.add(queryHospitalizationInfoResItemVo);
        }
        queryHospitalizationInfoResVo.setInPatientInfo(list);
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryHospitalizationInfoResVo);
    }

    public FrontResponse<QuerySerialNumberResVo> querySerialNumber(FrontRequest<QuerySerialNumberReqVo> param) {
        HashMap<String, QuerySerialNumberReqVo> map = new HashMap<String, QuerySerialNumberReqVo>();
        QuerySerialNumberReqVo body = (QuerySerialNumberReqVo)param.getBody();
        map.put(EntityKeyEnum.QUERY_SERIAL_NUMBER.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_SERIAL_NUMBER.getValue(), map, QuerySerialNumberResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, null);
        }
        if (Objects.isNull(response.getBody())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        QuerySerialNumberResDTO responseBody = (QuerySerialNumberResDTO)response.getBody();
        if (!HIS_OUT_HOSP_STATUS.equals(responseBody.getResult())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)responseBody.getErr());
        }
        if (CollectionUtils.isEmpty((Collection)responseBody.getItem())) {
            FrontResponse.success((String)param.getTransactionId(), null);
        }
        QuerySerialNumberResVo querySerialNumberResVo = new QuerySerialNumberResVo();
        ArrayList<QuerySerialNumberItemResVo> list = new ArrayList<QuerySerialNumberItemResVo>();
        List items = responseBody.getItem();
        for (QuerySerialNumberItemResDTO querySerialNumberItemResDTO : items) {
            QuerySerialNumberItemResVo querySerialNumberItemResVo = new QuerySerialNumberItemResVo();
            BeanUtils.copyProperties((Object)querySerialNumberItemResDTO, (Object)querySerialNumberItemResVo);
            list.add(querySerialNumberItemResVo);
        }
        querySerialNumberResVo.setItem(list);
        return FrontResponse.success((String)param.getTransactionId(), (Object)querySerialNumberResVo);
    }

    public FrontResponse<QueryInpatientExpenseResVo> queryInpatientExpense(FrontRequest<QueryInpatientExpenseReqVo> param) {
        HashMap<String, QueryInpatientExpenseReqVo> map = new HashMap<String, QueryInpatientExpenseReqVo>();
        QueryInpatientExpenseReqVo body = (QueryInpatientExpenseReqVo)param.getBody();
        map.put(EntityKeyEnum.QUERY_INPATIENT_EXPENSE.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_INPATIENT_EXPENSE.getValue(), map, QueryInpatientExpenseResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, null);
        }
        if (Objects.isNull(response.getBody())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        QueryInpatientExpenseResDTO responseBody = (QueryInpatientExpenseResDTO)response.getBody();
        if (!HIS_OUT_HOSP_STATUS.equals(responseBody.getResult())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)responseBody.getErr());
        }
        if (CollectionUtils.isEmpty((Collection)responseBody.getDayFeeList())) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        List dayFeeList = responseBody.getDayFeeList();
        QueryInpatientExpenseResVo queryInpatientExpenseResVo = new QueryInpatientExpenseResVo();
        ArrayList<QueryInpatientExpenseItemResVo> list = new ArrayList<QueryInpatientExpenseItemResVo>();
        for (DayFeeListResDTO dayFeeListResDTO : dayFeeList) {
            QueryInpatientExpenseItemResVo queryInpatientExpenseItemResVo = new QueryInpatientExpenseItemResVo();
            BeanUtils.copyProperties((Object)dayFeeListResDTO, (Object)queryInpatientExpenseItemResVo);
            list.add(queryInpatientExpenseItemResVo);
        }
        queryInpatientExpenseResVo.setItem(list);
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryInpatientExpenseResVo);
    }

    public FrontResponse<QuerySerialNumberByCardIdResVo> querySerialNumberByCardId(FrontRequest<QuerySerialNumberByCardIdReqVo> param) {
        QuerySerialNumberByCardIdReqVo body = (QuerySerialNumberByCardIdReqVo)param.getBody();
        HashMap<String, QuerySerialNumberByCardIdReqVo> map = new HashMap<String, QuerySerialNumberByCardIdReqVo>();
        map.put(EntityKeyEnum.QUERY_SERIAL_NUMBER.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_SERIAL_NUMBER_BY_CARDID.getValue(), map, QuerySerialNumberByCardIdResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, null);
        }
        if (Objects.isNull(response.getBody())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        QuerySerialNumberByCardIdResDTO responseBody = (QuerySerialNumberByCardIdResDTO)response.getBody();
        if (!HIS_OUT_HOSP_STATUS.equals(responseBody.getResult())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)responseBody.getErr());
        }
        if (CollectionUtils.isEmpty((Collection)responseBody.getItem())) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        List item = responseBody.getItem();
        QuerySerialNumberByCardIdResVo querySerialNumberByCardIdResVo = new QuerySerialNumberByCardIdResVo();
        ArrayList<QuerySerialNumberByCardIdItemResVo> list = new ArrayList<QuerySerialNumberByCardIdItemResVo>();
        for (InPatientInfoDTO inPatientInfoDTO : item) {
            QuerySerialNumberByCardIdItemResVo querySerialNumberByCardIdItemResVo = new QuerySerialNumberByCardIdItemResVo();
            BeanUtils.copyProperties((Object)inPatientInfoDTO, (Object)querySerialNumberByCardIdItemResVo);
            list.add(querySerialNumberByCardIdItemResVo);
        }
        querySerialNumberByCardIdResVo.setItem(list);
        return FrontResponse.success((String)param.getTransactionId(), (Object)querySerialNumberByCardIdResVo);
    }

    public FrontResponse<AddRecordResDTO> addRecord(FrontRequest<GetOrdItemsReq> param) {
        GetOrdItemsReq body = (GetOrdItemsReq)param.getBody();
        AddRecordDTO addRecordDTO = AddRecordDTO.builder().InvoiceNo(body.getInvoiceNo()).InPatientNO(body.getInHospNo()).build();
        HashMap<String, AddRecordDTO> map = new HashMap<String, AddRecordDTO>();
        map.put(EntityKeyEnum.ADD_RECORD.getValue(), addRecordDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.ADD_RECORD.getValue(), map, AddRecordResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        if (Objects.isNull(response.getBody())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        AddRecordResDTO responseBody = (AddRecordResDTO)response.getBody();
        if (!HIS_OUT_HOSP_STATUS.equals(responseBody.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)responseBody.getResultMsg());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)responseBody);
    }
}

