/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.PayTypeEnums;
import com.ebaiyihui.his.pojo.dto.GetOutPatientAdmResDTO;
import com.ebaiyihui.his.pojo.dto.GetOutPatientAdmResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsReqDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsResDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsResItemDTO;
import com.ebaiyihui.his.pojo.dto.OutpatientComfirePayReqDTO;
import com.ebaiyihui.his.pojo.dto.OutpatientComfirePayResDTO;
import com.ebaiyihui.his.pojo.dto.PendingPayDetailResDTO;
import com.ebaiyihui.his.pojo.dto.PendingPayDetailResItemDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsRes;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemReq;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemRes;
import com.ebaiyihui.his.pojo.vo.outpatient.datas.PayItemResDatas;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetAdmissionItems;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetPayRecordsResDetails;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetPayRecordsResItems;
import com.ebaiyihui.his.pojo.vo.outpatient.items.PayItemResItems;
import com.ebaiyihui.his.pojo.vo.outpatient.respmsg.ComfirmPayNewReqMsg;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.OutpatientPaymentService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetAdmissionRes> getAdmission(FrontRequest<GetAdmissionReq> param) {
        GetAdmissionRes getAdmissionRes = new GetAdmissionRes();
        HashMap<String, Object> admMap = new HashMap<String, Object>(1);
        admMap.put(EntityKeyEnum.Get_ADMSSION_INFO.getValue(), param.getBody());
        FrontResponse admRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_MEDICAL_RECORDS.getValue(), admMap, GetOutPatientAdmResDTO.class);
        GetOutPatientAdmResDTO getOutPatientAdmRes = (GetOutPatientAdmResDTO)admRes.getBody();
        if (Objects.isNull(getOutPatientAdmRes)) {
            return FrontResponse.error((String)admRes.getTransactionId(), (String)"0", (String)admRes.getMessage());
        }
        if (!"1".equals(getOutPatientAdmRes.getResultCode())) {
            return FrontResponse.error((String)admRes.getTransactionId(), (String)"0", (String)getOutPatientAdmRes.getResultMsg());
        }
        List getOutPatientAdmResItemDTOList = getOutPatientAdmRes.getItems();
        if (CollectionUtils.isEmpty((Collection)getOutPatientAdmResItemDTOList)) {
            return FrontResponse.error((String)admRes.getTransactionId(), (String)"0", (String)getOutPatientAdmRes.getResultMsg());
        }
        ArrayList<GetAdmissionItems> admissionItemsList = new ArrayList<GetAdmissionItems>();
        for (GetOutPatientAdmResItemDTO getOutPatientAdmResItemDTO : getOutPatientAdmResItemDTOList) {
            GetAdmissionItems getAdmissionItems = new GetAdmissionItems();
            getAdmissionItems.setAdmDate(getOutPatientAdmResItemDTO.getRegDate());
            getAdmissionItems.setDeptName(getOutPatientAdmResItemDTO.getDeptName());
            getAdmissionItems.setDocName(getOutPatientAdmResItemDTO.getDocName());
            getAdmissionItems.setAdmStatus("3");
            getAdmissionItems.setAdmId(getOutPatientAdmResItemDTO.getAdmId());
            admissionItemsList.add(getAdmissionItems);
        }
        getAdmissionRes.setItems(admissionItemsList);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getAdmissionRes);
    }

    public FrontResponse<PayItemRes> payItem(FrontRequest<PayItemReq> param) {
        PayItemRes payItemRes = new PayItemRes();
        HashMap<String, Object> pendingPayMap = new HashMap<String, Object>(1);
        pendingPayMap.put(EntityKeyEnum.QUERY_PRESCRIPTION.getValue(), param.getBody());
        FrontResponse detailRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PENDING_RECORD_INQUIRY_DETAIL.getValue(), pendingPayMap, PendingPayDetailResDTO.class);
        PendingPayDetailResDTO resBody = (PendingPayDetailResDTO)detailRes.getBody();
        if (Objects.isNull(resBody)) {
            return FrontResponse.error((String)detailRes.getTransactionId(), (String)"0", (String)detailRes.getMessage());
        }
        if (!"1".equals(resBody.getResultCode())) {
            return FrontResponse.error((String)detailRes.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
        }
        List payDetailResList = resBody.getItem();
        if (CollectionUtils.isEmpty((Collection)payDetailResList)) {
            return FrontResponse.error((String)detailRes.getTransactionId(), (String)"0", (String)resBody.getResultMsg());
        }
        ArrayList<PayItemResDatas> datas = new ArrayList<PayItemResDatas>();
        for (PendingPayDetailResItemDTO pendingPayDetailResItemDTO : payDetailResList) {
            PayItemResDatas payItemResDatas = new PayItemResDatas();
            PayItemResItems payItemResItems = new PayItemResItems();
            payItemResDatas.setAmount(pendingPayDetailResItemDTO.getCost());
            payItemResDatas.setStartDate(pendingPayDetailResItemDTO.getFeeDate());
            String drugFlag = pendingPayDetailResItemDTO.getDrugFlag();
            if (Objects.equals("1", drugFlag)) {
                payItemResDatas.setItemType("3");
            } else {
                payItemResDatas.setItemType("1");
            }
            ArrayList<PayItemResItems> items = new ArrayList<PayItemResItems>();
            payItemResItems.setPrescriptionNo(pendingPayDetailResItemDTO.getRecipeNO());
            payItemResItems.setDesc(pendingPayDetailResItemDTO.getItemName());
            payItemResItems.setUnit(pendingPayDetailResItemDTO.getDoseUnit());
            payItemResItems.setPrice(pendingPayDetailResItemDTO.getPrice());
            payItemResItems.setQty(pendingPayDetailResItemDTO.getQty());
            payItemResItems.setSum(pendingPayDetailResItemDTO.getCost());
            payItemResItems.setItemType(pendingPayDetailResItemDTO.getMinfee());
            items.add(payItemResItems);
            payItemResDatas.setItems(items);
            datas.add(payItemResDatas);
        }
        payItemRes.setDatas(datas);
        return FrontResponse.success((String)param.getTransactionId(), (Object)payItemRes);
    }

    public FrontResponse<ComfirmPayNewRes> comfirmPayNew(FrontRequest<ComfirmPayNewReq> param) {
        ComfirmPayNewRes comfirmPayNewRes = new ComfirmPayNewRes();
        ComfirmPayNewReq comfirmPayNewReq = (ComfirmPayNewReq)param.getBody();
        ComfirmPayNewReqMsg comfirmPayNewReqMsg = comfirmPayNewReq.getRespmsg();
        OutpatientComfirePayReqDTO outpatientComfirePayReqDTO = new OutpatientComfirePayReqDTO();
        outpatientComfirePayReqDTO.setVisitNo(comfirmPayNewReq.getId());
        outpatientComfirePayReqDTO.setConsume(comfirmPayNewReq.getAmount());
        outpatientComfirePayReqDTO.setPrescriptionNo(comfirmPayNewReq.getPrescriptionNos());
        outpatientComfirePayReqDTO.setTransFlag(HIS_PAY_SUCCESS);
        outpatientComfirePayReqDTO.setPayType(PayTypeEnums.getDisplay((String)comfirmPayNewReq.getPaychannel()));
        outpatientComfirePayReqDTO.setThirdConsume(comfirmPayNewReqMsg.getPayment());
        outpatientComfirePayReqDTO.setTradNo(comfirmPayNewReqMsg.getOrderid());
        outpatientComfirePayReqDTO.setTradDate(comfirmPayNewReqMsg.getAccdate());
        outpatientComfirePayReqDTO.setFlowNo(comfirmPayNewReq.getFlowNo());
        HashMap<String, OutpatientComfirePayReqDTO> confirmPaymap = new HashMap<String, OutpatientComfirePayReqDTO>(1);
        confirmPaymap.put(EntityKeyEnum.SELF_PAY.getValue(), outpatientComfirePayReqDTO);
        FrontResponse comfirePayResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.OUTPATIENT_PAYMENT.getValue(), confirmPaymap, OutpatientComfirePayResDTO.class);
        OutpatientComfirePayResDTO resDTOBody = (OutpatientComfirePayResDTO)comfirePayResDTO.getBody();
        if (Objects.isNull(resDTOBody)) {
            return FrontResponse.error((String)comfirePayResDTO.getTransactionId(), (String)"0", (String)comfirePayResDTO.getMessage());
        }
        if (!"1".equals(resDTOBody.getResultCode())) {
            return FrontResponse.error((String)comfirePayResDTO.getTransactionId(), (String)"0", (String)((OutpatientComfirePayResDTO)comfirePayResDTO.getBody()).getResultMsg());
        }
        comfirmPayNewRes.setReceiptId(resDTOBody.getMark());
        comfirmPayNewRes.setAdmId(comfirmPayNewReq.getId());
        comfirmPayNewRes.setCardNo(comfirmPayNewReq.getCardNo());
        comfirmPayNewRes.setAmount(comfirmPayNewReq.getAmount());
        return FrontResponse.success((String)param.getTransactionId(), (Object)comfirmPayNewRes);
    }

    public FrontResponse<GetPayRecordsRes> getPayRecords(FrontRequest<GetPayRecordsReq> param) {
        GetPayRecordsRes getPayRecordsRes = new GetPayRecordsRes();
        GetPayRecordsReq body = (GetPayRecordsReq)param.getBody();
        GetPayRecordsReqDTO getPayRecordsReqDTO = GetPayRecordsReqDTO.builder().dtBegin(body.getStartDate()).dtEnd(body.getEndDate()).cardNO(body.getCardNo()).build();
        HashMap<String, GetPayRecordsReqDTO> map = new HashMap<String, GetPayRecordsReqDTO>();
        map.put(EntityKeyEnum.GET_PAY_RECORDS.getValue(), getPayRecordsReqDTO);
        FrontResponse recordsResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.OUTPATIENT_LIST_INQUIRY.getValue(), map, GetPayRecordsResDTO.class);
        GetPayRecordsResDTO resDTOBody = (GetPayRecordsResDTO)recordsResDTO.getBody();
        if (Objects.isNull(resDTOBody)) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", (String)recordsResDTO.getMessage());
        }
        if (!"1".equals(resDTOBody.getResultCode())) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", null);
        }
        List getPayRecordsResItemDTOList = resDTOBody.getItem();
        if (CollectionUtils.isEmpty((Collection)getPayRecordsResItemDTOList)) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", null);
        }
        getPayRecordsRes.setCardNo(body.getCardNo());
        Map<String, List<GetPayRecordsResItemDTO>> collect = getPayRecordsResItemDTOList.stream().collect(Collectors.groupingBy(GetPayRecordsResItemDTO::getRecipeNO));
        ArrayList items = new ArrayList();
        collect.forEach((Key2, value) -> {
            GetPayRecordsResItems getPayRecordsResItems = new GetPayRecordsResItems();
            ArrayList details = new ArrayList();
            value.forEach(v -> {
                getPayRecordsResItems.setPayDateTime(v.getFeeDate());
                getPayRecordsResItems.setAdmId(v.getMoOrder());
                getPayRecordsResItems.setAdmType("O");
                getPayRecordsResItems.setDeptName(v.getExecDept());
                getPayRecordsResItems.setDocName(v.getDoctName());
                GetPayRecordsResDetails getPayRecordsResDetails = new GetPayRecordsResDetails();
                getPayRecordsResDetails.setPrice(v.getPrice());
                getPayRecordsResDetails.setDesc(v.getItemName());
                getPayRecordsResDetails.setQty(v.getQty());
                getPayRecordsResDetails.setUnit(v.getPriceUnit());
                details.add(getPayRecordsResDetails);
            });
            items.add(getPayRecordsResItems);
        });
        getPayRecordsRes.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getPayRecordsRes);
    }
}

