/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.DoctorTypeEnum;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.GetDeptDoctorResDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptDoctorResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptScheduleDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptScheduleResDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptScheduleResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetDocSourceScheduleResDTO;
import com.ebaiyihui.his.pojo.dto.GetDocSourceScheduleResItemDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptDoctorInfoReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetDeptScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ScheduleService;
import com.ebaiyihui.his.utils.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Value(value="${hosp.hospName}")
    private String hospName;
    @Value(value="${hosp.hospCode}")
    private String hospCode;
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetScheduleResVO> getSchedule(FrontRequest<GetScheduleReqVO> param) {
        GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
        ArrayList<GetScheduleResItems> items = new ArrayList<GetScheduleResItems>();
        GetScheduleReqVO paramBody = (GetScheduleReqVO)param.getBody();
        HashMap<String, GetScheduleReqVO> map = new HashMap<String, GetScheduleReqVO>();
        map.put(EntityKeyEnum.DEPT_DOCTOR_INFO.getValue(), paramBody);
        FrontResponse dtoFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_SCHEDULING_INFO.getValue(), map, GetDeptDoctorResDTO.class);
        GetDeptDoctorResDTO body = (GetDeptDoctorResDTO)dtoFrontResponse.getBody();
        if (Objects.isNull(body)) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", null);
        }
        if (!"1".equals(body.getResultCode())) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        List getDeptDoctorResItemDTOList = body.getItem();
        if (CollectionUtils.isEmpty((Collection)getDeptDoctorResItemDTOList)) {
            return FrontResponse.success((String)dtoFrontResponse.getTransactionId(), (Object)getScheduleResVO);
        }
        String bgDate = paramBody.getBgDate();
        String currentDateStr = DateUtil.getCurrentDateStr();
        for (GetDeptDoctorResItemDTO getDeptDoctorResItemDTO : getDeptDoctorResItemDTOList) {
            int regAvailable;
            String endDate = getDeptDoctorResItemDTO.getEndDate();
            boolean noon = DateUtil.checkTimeRange((String)endDate, (String)DateUtil.FULL_FORMAT);
            if (!noon) continue;
            GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
            getScheduleResItems.setAdmDate(bgDate);
            getScheduleResItems.setScheduleType(Integer.valueOf(1));
            getScheduleResItems.setLocCode(getDeptDoctorResItemDTO.getDeptCode());
            getScheduleResItems.setLocName(getDeptDoctorResItemDTO.getDeptName());
            getScheduleResItems.setScheduleId(getDeptDoctorResItemDTO.getSchemaId());
            getScheduleResItems.setRegFee("0.01");
            getScheduleResItems.setDiagFee("0");
            getScheduleResItems.setRegTitleName(getDeptDoctorResItemDTO.getRegLeveName());
            getScheduleResItems.setAdmLocation(getDeptDoctorResItemDTO.getDeptName());
            getScheduleResItems.setAdmTimeRange(getDeptDoctorResItemDTO.getNoonCode());
            getScheduleResItems.setIsTimeArrange(Integer.valueOf(1));
            getScheduleResItems.setHospitalArea("\u4fdd\u5b9a\u5e02\u7b2c\u4e00\u4e2d\u533b\u9662");
            String regLeveName = getDeptDoctorResItemDTO.getRegLeveName();
            String regLeve = getDeptDoctorResItemDTO.getRegLeve();
            getScheduleResItems.setScheduleLevelName(regLeveName);
            getScheduleResItems.setScheduleLevelCode(regLeve);
            if (StringUtils.isBlank((CharSequence)getDeptDoctorResItemDTO.getDoctorName())) {
                getScheduleResItems.setDocName(DoctorTypeEnum.getCardEnumByCardTypeCode((String)regLeve).getDoctorName());
                getScheduleResItems.setDocCode(regLeve);
            } else {
                getScheduleResItems.setDocName(getDeptDoctorResItemDTO.getDoctorName());
                getScheduleResItems.setDocCode(getDeptDoctorResItemDTO.getDoctorCode());
            }
            if (Objects.equals(bgDate, currentDateStr)) {
                int regLimit = Integer.parseInt(getDeptDoctorResItemDTO.getRegLimit());
                int reged = Integer.parseInt(getDeptDoctorResItemDTO.getReged());
                regAvailable = regLimit - reged;
                getScheduleResItems.setRegTotal(Integer.valueOf(regLimit));
                getScheduleResItems.setRegAvailable(Integer.valueOf(regAvailable));
            } else {
                int availablNo;
                int reged;
                int limited;
                TimeArrangeItems timeArrangeItems;
                List item;
                int telLimit = Integer.parseInt(getDeptDoctorResItemDTO.getTelLimit());
                int telReged = Integer.parseInt(getDeptDoctorResItemDTO.getTelReged());
                regAvailable = telLimit - telReged;
                getScheduleResItems.setRegTotal(Integer.valueOf(getDeptDoctorResItemDTO.getTelLimit()));
                getScheduleResItems.setRegAvailable(Integer.valueOf(regAvailable));
                HashMap<String, GetDeptDoctorResItemDTO> mapSchedule = new HashMap<String, GetDeptDoctorResItemDTO>();
                mapSchedule.put(EntityKeyEnum.DOC_SCHEDULE_SOURCE.getValue(), getDeptDoctorResItemDTO);
                FrontResponse docSourceScheduleRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.DOCTOR_SOURCE_LIST.getValue(), mapSchedule, GetDocSourceScheduleResDTO.class);
                GetDocSourceScheduleResDTO docSourceScheduleResBody = (GetDocSourceScheduleResDTO)docSourceScheduleRes.getBody();
                if (Objects.isNull(docSourceScheduleResBody)) {
                    return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", null);
                }
                if (!"1".equals(docSourceScheduleResBody.getResultCode()) || CollectionUtils.isEmpty((Collection)(item = docSourceScheduleResBody.getItem()))) continue;
                ArrayList<TimeArrangeItems> timeArrangeItemsList = new ArrayList<TimeArrangeItems>();
                if (Objects.equals(bgDate, currentDateStr)) {
                    for (GetDocSourceScheduleResItemDTO getDocSourceScheduleResItemDTO : item) {
                        if (!DateUtil.checkTimeRange((String)getDocSourceScheduleResItemDTO.getEndTime(), (String)DateUtil.TIME)) continue;
                        timeArrangeItems = new TimeArrangeItems();
                        timeArrangeItems.setTimeArrangeId(getDocSourceScheduleResItemDTO.getSchemaID());
                        timeArrangeItems.setStartTime(getDocSourceScheduleResItemDTO.getBeginTime());
                        timeArrangeItems.setEndTime(getDocSourceScheduleResItemDTO.getEndTime());
                        limited = Integer.parseInt(getDocSourceScheduleResItemDTO.getLimited());
                        reged = Integer.parseInt(getDocSourceScheduleResItemDTO.getReged());
                        availablNo = limited - reged;
                        timeArrangeItems.setAvailablNo(String.valueOf(availablNo));
                        timeArrangeItems.setTotalNo(getDocSourceScheduleResItemDTO.getLimited());
                        timeArrangeItems.setStartNo(Integer.valueOf(getDocSourceScheduleResItemDTO.getSortID()));
                        timeArrangeItemsList.add(timeArrangeItems);
                    }
                } else {
                    for (GetDocSourceScheduleResItemDTO getDocSourceScheduleResItemDTO : item) {
                        timeArrangeItems = new TimeArrangeItems();
                        timeArrangeItems.setTimeArrangeId(getDocSourceScheduleResItemDTO.getSchemaID());
                        timeArrangeItems.setStartTime(getDocSourceScheduleResItemDTO.getBeginTime());
                        timeArrangeItems.setEndTime(getDocSourceScheduleResItemDTO.getEndTime());
                        limited = Integer.parseInt(getDocSourceScheduleResItemDTO.getLimited());
                        reged = Integer.parseInt(getDocSourceScheduleResItemDTO.getReged());
                        availablNo = limited - reged;
                        timeArrangeItems.setAvailablNo(String.valueOf(availablNo));
                        timeArrangeItems.setTotalNo(getDocSourceScheduleResItemDTO.getLimited());
                        timeArrangeItems.setStartNo(Integer.valueOf(getDocSourceScheduleResItemDTO.getSortID()));
                        timeArrangeItemsList.add(timeArrangeItems);
                    }
                }
                getScheduleResItems.setTimeArrangeItems(timeArrangeItemsList);
            }
            items.add(getScheduleResItems);
        }
        getScheduleResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
    }

    public FrontResponse<GetDeptScheduleResVO> getDeptSchedule(FrontRequest<GetDeptScheduleReqVO> param) {
        GetDeptScheduleResVO getDeptScheduleResVO = new GetDeptScheduleResVO();
        ArrayList<GetDeptScheduleResItems> items = new ArrayList<GetDeptScheduleResItems>();
        GetDeptScheduleDTO getDeptScheduleDTO = GetDeptScheduleDTO.builder().build();
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(EntityKeyEnum.DOC_DAY_SCHEDULE_SOURCE.getValue(), param.getBody());
        FrontResponse getDeptList = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.REGISTERED_DOCTOR_LIST.getValue(), map, GetDeptScheduleResDTO.class);
        GetDeptScheduleResDTO body = (GetDeptScheduleResDTO)getDeptList.getBody();
        if (Objects.isNull(getDeptList)) {
            return FrontResponse.error((String)getDeptList.getTransactionId(), (String)"0", null);
        }
        if (!"1".equals(body.getResultCode())) {
            return FrontResponse.error((String)getDeptList.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        List getDeptItemList = body.getDept();
        if (CollectionUtils.isEmpty((Collection)getDeptItemList)) {
            return FrontResponse.error((String)getDeptList.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        for (GetDeptScheduleResItemDTO getDeptScheduleResItemDTO : getDeptItemList) {
            GetDeptScheduleResItems getDeptScheduleResItems = new GetDeptScheduleResItems();
            getDeptScheduleResItems.setDeptCode(getDeptScheduleResItemDTO.getId());
            getDeptScheduleResItems.setDeptName(getDeptScheduleResItemDTO.getName());
            getDeptScheduleResItems.setDeptAddress(getDeptScheduleResItemDTO.getAddress());
            items.add(getDeptScheduleResItems);
        }
        getDeptScheduleResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptScheduleResVO);
    }

    public FrontResponse<GetScheduleResVO> getDeptDoctorInfo(FrontRequest<GetDeptDoctorInfoReqVO> param) {
        GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
        ArrayList<GetScheduleResItems> items = new ArrayList<GetScheduleResItems>();
        GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
        TimeArrangeItems timeArrangeItems = new TimeArrangeItems();
        ArrayList<TimeArrangeItems> timeArrangeItemsList = new ArrayList<TimeArrangeItems>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EntityKeyEnum.DEPT_DOCTOR_INFO.getValue(), param.getBody());
        FrontResponse dtoFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_SCHEDULING_INFO.getValue(), map, GetDeptDoctorResDTO.class);
        GetDeptDoctorResDTO body = (GetDeptDoctorResDTO)dtoFrontResponse.getBody();
        if (Objects.isNull(body)) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", null);
        }
        if (!"1".equals(body.getResultCode())) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        List getDeptDoctorResItemDTOList = body.getItem();
        if (CollectionUtils.isEmpty((Collection)getDeptDoctorResItemDTOList)) {
            return FrontResponse.error((String)dtoFrontResponse.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        for (GetDeptDoctorResItemDTO getDeptDoctorResItemDTO : getDeptDoctorResItemDTOList) {
            getScheduleResItems.setRegFee("0");
            getScheduleResItems.setDiagFee(getDeptDoctorResItemDTO.getRegFee());
            getScheduleResItems.setLocCode(getDeptDoctorResItemDTO.getDeptCode());
            getScheduleResItems.setLocName(getDeptDoctorResItemDTO.getDeptName());
            getScheduleResItems.setDocName(getDeptDoctorResItemDTO.getDoctorName());
            getScheduleResItems.setDocCode(getDeptDoctorResItemDTO.getDoctorCode());
            getScheduleResItems.setScheduleLevelName(getDeptDoctorResItemDTO.getRegLeveName());
            getScheduleResItems.setScheduleLevelCode(getDeptDoctorResItemDTO.getRegLeve());
            getScheduleResItems.setAdmTimeRange(getDeptDoctorResItemDTO.getNoonCode());
            log.info("getDeptDoctorResItemDTO----->{}", (Object)getDeptDoctorResItemDTO);
            HashMap<String, GetDeptDoctorResItemDTO> mapSchedule = new HashMap<String, GetDeptDoctorResItemDTO>();
            mapSchedule.put(EntityKeyEnum.DOC_SCHEDULE_SOURCE.getValue(), getDeptDoctorResItemDTO);
            FrontResponse docSourceScheduleRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.DOCTOR_SOURCE_LIST.getValue(), mapSchedule, GetDocSourceScheduleResDTO.class);
            log.info("getDeptDoctorResItemDTO----->{}", (Object)getDeptDoctorResItemDTO);
            for (GetDocSourceScheduleResItemDTO getDocSourceScheduleResItemDTO : ((GetDocSourceScheduleResDTO)docSourceScheduleRes.getBody()).getItem()) {
                timeArrangeItems.setTimeArrangeId(getDocSourceScheduleResItemDTO.getSchemaID());
                timeArrangeItems.setStartTime(getDocSourceScheduleResItemDTO.getBeginTime());
                timeArrangeItems.setEndTime(getDocSourceScheduleResItemDTO.getEndTime());
                timeArrangeItems.setAvailablNo(getDocSourceScheduleResItemDTO.getLimited());
                timeArrangeItemsList.add(timeArrangeItems);
            }
            getScheduleResItems.setTimeArrangeItems(timeArrangeItemsList);
            items.add(getScheduleResItems);
            getScheduleResVO.setItems(items);
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
    }
}

