/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.AppointRegistrationNoPayResDTO;
import com.ebaiyihui.his.pojo.dto.AppointmentNoPayCancelResDTO;
import com.ebaiyihui.his.pojo.dto.AutoTakeNumberResDTO;
import com.ebaiyihui.his.pojo.dto.GetAppointRecordResBookingDTO;
import com.ebaiyihui.his.pojo.dto.GetAppointRecordResDTO;
import com.ebaiyihui.his.pojo.dto.HealthBackPayDTO;
import com.ebaiyihui.his.pojo.dto.LockDTO;
import com.ebaiyihui.his.pojo.dto.LockParam;
import com.ebaiyihui.his.pojo.dto.LockResDTO;
import com.ebaiyihui.his.pojo.dto.LockSignalsourceDto;
import com.ebaiyihui.his.pojo.dto.PayAppointmentReqDTO;
import com.ebaiyihui.his.pojo.dto.PayAppointmentResDTO;
import com.ebaiyihui.his.pojo.dto.QueryCostDTO;
import com.ebaiyihui.his.pojo.dto.QueryCostResDTO;
import com.ebaiyihui.his.pojo.dto.QueryRegistrationRecordsDTO;
import com.ebaiyihui.his.pojo.dto.QueryRegistrationRecordsItemDTO;
import com.ebaiyihui.his.pojo.dto.QueryValidResDTO;
import com.ebaiyihui.his.pojo.dto.RegisterDTO;
import com.ebaiyihui.his.pojo.dto.RegisteredNowDayReqDTO;
import com.ebaiyihui.his.pojo.dto.RegisteredNowDayResDTO;
import com.ebaiyihui.his.pojo.dto.RegisteredResDTO;
import com.ebaiyihui.his.pojo.dto.ReturnRegisterReqDTO;
import com.ebaiyihui.his.pojo.dto.ReturnRegisterResDTO;
import com.ebaiyihui.his.pojo.dto.SceneBackDTO;
import com.ebaiyihui.his.pojo.dto.SceneBackResDTO;
import com.ebaiyihui.his.pojo.vo.ReservationLockNumberReq;
import com.ebaiyihui.his.pojo.vo.ReservationLockNumberRes;
import com.ebaiyihui.his.pojo.vo.appoint.AppointRecordItem;
import com.ebaiyihui.his.pojo.vo.appoint.AutoTakeNumberReq;
import com.ebaiyihui.his.pojo.vo.appoint.AutoTakeNumberRes;
import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.GetAppointRecordReq;
import com.ebaiyihui.his.pojo.vo.appoint.GetAppointRecordRes;
import com.ebaiyihui.his.pojo.vo.appoint.HealthBackPayReqVo;
import com.ebaiyihui.his.pojo.vo.appoint.HealthBackPayResVo;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationRes;
import com.ebaiyihui.his.pojo.vo.appoint.QueryRegistrationRecordsItemRes;
import com.ebaiyihui.his.pojo.vo.appoint.QueryRegistrationRecordsReq;
import com.ebaiyihui.his.pojo.vo.appoint.QueryRegistrationRecordsRes;
import com.ebaiyihui.his.pojo.vo.appoint.QueryValidInfoReqVo;
import com.ebaiyihui.his.pojo.vo.appoint.QueryValidInfoResItemVo;
import com.ebaiyihui.his.pojo.vo.appoint.QueryValidInfoResVo;
import com.ebaiyihui.his.pojo.vo.appoint.RegisteredReqVo;
import com.ebaiyihui.his.pojo.vo.appoint.RegisteredResVo;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterRes;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.card.RechargeReqVo;
import com.ebaiyihui.his.pojo.vo.yb.YbRegistionResponseBody;
import com.ebaiyihui.his.pojo.vo.yb.YbRegistrationReqDTO;
import com.ebaiyihui.his.pojo.yb.ResponseHeadOfResponseBody2201;
import com.ebaiyihui.his.service.AppointService;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ICardService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AppointServiceImpl
implements AppointService {
    private static final Logger log = LoggerFactory.getLogger(AppointServiceImpl.class);
    public static final String CLINIC_TYPE_APPOINT = "0";
    public static final String CLINIC_TYPE_CANCEL = "1";
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    private static final String HOSPITAL_ID = "A10001";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private ICardService iCardService;

    public FrontResponse<ConfirmRegisterRes> confirmRegister(FrontRequest<ConfirmRegisterReq> param) {
        ConfirmRegisterReq confirmRegisterReq = (ConfirmRegisterReq)param.getBody();
        if (null == confirmRegisterReq) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, ConfirmRegisterReq> map = new HashMap<String, ConfirmRegisterReq>();
        map.put(EntityKeyEnum.OUT_PAT_BOOKINGCANCEL.getValue(), confirmRegisterReq);
        FrontResponse appointRegistrationNoPayRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.OUT_PAT_BOOKINGCANCEL.getValue(), map, AppointRegistrationNoPayResDTO.class);
        if (null == appointRegistrationNoPayRes) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, null);
        }
        AppointRegistrationNoPayResDTO appointRegistrationNoPayReq = (AppointRegistrationNoPayResDTO)appointRegistrationNoPayRes.getBody();
        if (null == appointRegistrationNoPayReq) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)appointRegistrationNoPayReq.getReturnInfo());
        }
        if (!CLINIC_TYPE_CANCEL.equals(appointRegistrationNoPayReq.getReturnCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)appointRegistrationNoPayReq.getReturnInfo());
        }
        ConfirmRegisterRes confirmRegisterRes = new ConfirmRegisterRes();
        confirmRegisterRes.setBookingNo(appointRegistrationNoPayReq.getBookingNO());
        confirmRegisterRes.setOperDate(appointRegistrationNoPayReq.getOperDate());
        confirmRegisterRes.setNo(appointRegistrationNoPayReq.getMark());
        return FrontResponse.success((String)param.getTransactionId(), (Object)confirmRegisterRes);
    }

    private FrontRequest<RechargeReqVo> getNewRechargeReqVoFrontRequest(FrontRequest<ConfirmRegisterReq> param) {
        ConfirmRegisterReq payRegistrationReq = (ConfirmRegisterReq)param.getBody();
        FrontRequest frontRequest = new FrontRequest();
        RechargeReqVo rechargeReqVo = new RechargeReqVo();
        rechargeReqVo.setCardNO(payRegistrationReq.getCardNo());
        rechargeReqVo.setName(payRegistrationReq.getPatientName());
        rechargeReqVo.setCost(payRegistrationReq.getRegFee());
        rechargeReqVo.setOrderNO(payRegistrationReq.getFlowNo());
        rechargeReqVo.setTransNO(payRegistrationReq.getFlowNo());
        String payChannel = payRegistrationReq.getPayChannel();
        if (Objects.equals(payChannel, "WECHAT")) {
            rechargeReqVo.setPayType("WX");
        } else if (Objects.equals(payChannel, "ALIPAY")) {
            rechargeReqVo.setPayType("ZF");
        } else if (Objects.equals(payChannel, "CCB")) {
            rechargeReqVo.setPayType("DB");
        } else {
            rechargeReqVo.setPayType("DB");
        }
        frontRequest.setBody((Object)rechargeReqVo);
        frontRequest.setChannel(param.getChannel());
        frontRequest.setChannelName(param.getChannel());
        frontRequest.setOrganCode(param.getOrganCode());
        frontRequest.setTransactionId(param.getTransactionId());
        return frontRequest;
    }

    private FrontRequest<RechargeReqVo> getRechargeReqVoFrontRequest(FrontRequest<PayRegistrationReq> param) {
        PayRegistrationReq payRegistrationReq = (PayRegistrationReq)param.getBody();
        FrontRequest frontRequest = new FrontRequest();
        RechargeReqVo rechargeReqVo = new RechargeReqVo();
        rechargeReqVo.setCardNO(payRegistrationReq.getCardNo());
        rechargeReqVo.setName(payRegistrationReq.getName());
        rechargeReqVo.setCost(payRegistrationReq.getRegFee());
        rechargeReqVo.setOrderNO(payRegistrationReq.getFlowNo());
        rechargeReqVo.setTransNO(payRegistrationReq.getFlowNo());
        rechargeReqVo.setPayType("CP");
        frontRequest.setBody((Object)rechargeReqVo);
        frontRequest.setChannel(param.getChannel());
        frontRequest.setChannelName(param.getChannel());
        frontRequest.setOrganCode(param.getOrganCode());
        frontRequest.setTransactionId(param.getTransactionId());
        return frontRequest;
    }

    public FrontResponse<PayRegistrationRes> payRegistration(FrontRequest<PayRegistrationReq> param) {
        PayRegistrationRes payRegistrationRes = new PayRegistrationRes();
        PayRegistrationReq payRegistrationReq = (PayRegistrationReq)param.getBody();
        PayAppointmentReqDTO payAppointmentReqDTO = new PayAppointmentReqDTO();
        HashMap<String, PayAppointmentReqDTO> payAppointMap = new HashMap<String, PayAppointmentReqDTO>(1);
        payAppointMap.put(EntityKeyEnum.PAY_REGISTRATION.getValue(), payAppointmentReqDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.APPOINTMENT_REGISTRATION_PAY.getValue(), payAppointMap, PayAppointmentResDTO.class);
        if (null == response) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, null);
        }
        if (Objects.isNull(response.getBody())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getMessage());
        }
        if (!CLINIC_TYPE_CANCEL.equals(((PayAppointmentResDTO)response.getBody()).getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)((PayAppointmentResDTO)response.getBody()).getResultMsg());
        }
        PayAppointmentResDTO payAppointmentResDTO = (PayAppointmentResDTO)response.getBody();
        payRegistrationRes.setReceiptId(payAppointmentResDTO.getReceiptId());
        payRegistrationRes.setNo(payAppointmentResDTO.getCallSeqNo());
        payRegistrationRes.setAdmId(payAppointmentResDTO.getRegistegOrderID());
        return FrontResponse.success((String)param.getTransactionId(), (Object)payRegistrationRes);
    }

    public FrontResponse<CancelRegisterRes> cancelRegister(FrontRequest<CancelRegisterReq> param) {
        CancelRegisterReq cancelRegisterReq = (CancelRegisterReq)param.getBody();
        if (null == cancelRegisterReq) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, CancelRegisterReq> map = new HashMap<String, CancelRegisterReq>();
        map.put(EntityKeyEnum.APPOINTMENT_REGISTRATION_NOPAY.getValue(), cancelRegisterReq);
        FrontResponse appointRegistrationNoPayRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.CANCEL_APPOINTMENT.getValue(), map, AppointmentNoPayCancelResDTO.class);
        if (Objects.isNull(appointRegistrationNoPayRes)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, null);
        }
        AppointmentNoPayCancelResDTO appointmentNoPayCancelResDTO = (AppointmentNoPayCancelResDTO)appointRegistrationNoPayRes.getBody();
        if (Objects.isNull(appointmentNoPayCancelResDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)appointRegistrationNoPayRes.getMessage());
        }
        if (!CLINIC_TYPE_CANCEL.equals(appointmentNoPayCancelResDTO.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)appointmentNoPayCancelResDTO.getResultMsg());
        }
        CancelRegisterRes cancelRegisterRes = new CancelRegisterRes();
        cancelRegisterRes.setBookingNo(appointmentNoPayCancelResDTO.getBookingNO());
        cancelRegisterRes.setOperDate(appointmentNoPayCancelResDTO.getOperDate());
        return FrontResponse.success((String)appointRegistrationNoPayRes.getTransactionId(), (Object)cancelRegisterRes);
    }

    public FrontResponse<ReturnRegisterRes> returnRegister(FrontRequest<ReturnRegisterReq> param) {
        ReturnRegisterRes returnRegisterRes = new ReturnRegisterRes();
        ReturnRegisterReqDTO returnRegisterReqDTO = new ReturnRegisterReqDTO();
        ReturnRegisterReq returnRegisterReq = (ReturnRegisterReq)param.getBody();
        returnRegisterReqDTO.setCardNo(returnRegisterReq.getAppointId());
        HashMap<String, ReturnRegisterReqDTO> returnRegMap = new HashMap<String, ReturnRegisterReqDTO>(1);
        returnRegMap.put(EntityKeyEnum.RETURN_REGISTER.getValue(), returnRegisterReqDTO);
        FrontResponse returnRegisterResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.ONLINE_REGISTRATION_REFUND.getValue(), returnRegMap, ReturnRegisterResDTO.class);
        if (Objects.isNull(returnRegisterResDTO)) {
            return FrontResponse.error((String)returnRegisterResDTO.getTransactionId(), (String)CLINIC_TYPE_APPOINT, null);
        }
        if (Objects.isNull(returnRegisterResDTO.getBody())) {
            return FrontResponse.error((String)returnRegisterResDTO.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)returnRegisterResDTO.getMessage());
        }
        if (!CLINIC_TYPE_CANCEL.equals(((ReturnRegisterResDTO)returnRegisterResDTO.getBody()).getResultCode())) {
            return FrontResponse.error((String)returnRegisterResDTO.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)returnRegisterResDTO.getCode());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)returnRegisterRes);
    }

    public FrontResponse<GetAppointRecordRes> getAppointRecord(FrontRequest<GetAppointRecordReq> param) {
        GetAppointRecordReq body = (GetAppointRecordReq)param.getBody();
        HashMap<String, GetAppointRecordReq> map = new HashMap<String, GetAppointRecordReq>();
        map.put(EntityKeyEnum.GET_APPOINT_RECORD.getValue(), body);
        FrontResponse appointRecordRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PATIENT_APPOINTMENT_LIST_QUERY.getValue(), map, GetAppointRecordResDTO.class);
        if (Objects.isNull(appointRecordRes)) {
            return FrontResponse.error((String)appointRecordRes.getTransactionId(), (String)CLINIC_TYPE_APPOINT, null);
        }
        if (Objects.isNull(appointRecordRes.getBody())) {
            return FrontResponse.error((String)appointRecordRes.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)appointRecordRes.getMessage());
        }
        GetAppointRecordResDTO appointRecordResBody = (GetAppointRecordResDTO)appointRecordRes.getBody();
        if (!CLINIC_TYPE_CANCEL.equals(appointRecordResBody.getResultCode())) {
            return FrontResponse.error((String)appointRecordRes.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)appointRecordResBody.getErr());
        }
        List item = appointRecordResBody.getItem();
        if (CollectionUtils.isEmpty((Collection)item)) {
            return FrontResponse.success((String)appointRecordRes.getTransactionId(), null);
        }
        GetAppointRecordRes getAppointRecordRes = new GetAppointRecordRes();
        ArrayList<AppointRecordItem> items = new ArrayList<AppointRecordItem>();
        for (GetAppointRecordResBookingDTO getAppointRecordResBookingDTO : item) {
            AppointRecordItem appointRecordItem = new AppointRecordItem();
            appointRecordItem.setId(getAppointRecordResBookingDTO.getId());
            appointRecordItem.setCardNo(getAppointRecordResBookingDTO.getCardNo());
            appointRecordItem.setPatientName(getAppointRecordResBookingDTO.getName());
            appointRecordItem.setSex(getAppointRecordResBookingDTO.getSex());
            appointRecordItem.setRelaPhone(getAppointRecordResBookingDTO.getRelaPhone());
            appointRecordItem.setIdenNo(getAppointRecordResBookingDTO.getIdenNo());
            appointRecordItem.setDeptName(getAppointRecordResBookingDTO.getDeptName());
            appointRecordItem.setDeptCode(getAppointRecordResBookingDTO.getDeptCode());
            appointRecordItem.setDocName(getAppointRecordResBookingDTO.getDoctName());
            appointRecordItem.setDocCode(getAppointRecordResBookingDTO.getDoctCode());
            appointRecordItem.setNoonCode(getAppointRecordResBookingDTO.getNoonCode());
            appointRecordItem.setBookingDate(getAppointRecordResBookingDTO.getBookingDate());
            appointRecordItem.setRegDocType(getAppointRecordResBookingDTO.getReglevelName());
            appointRecordItem.setReglevelCode(getAppointRecordResBookingDTO.getReglevelCode());
            appointRecordItem.setBeginTime(getAppointRecordResBookingDTO.getBeginTime());
            appointRecordItem.setEndTime(getAppointRecordResBookingDTO.getEndTime());
            appointRecordItem.setState(getAppointRecordResBookingDTO.getState());
            appointRecordItem.setTotCost(getAppointRecordResBookingDTO.getTotCost());
            appointRecordItem.setOwnCost(getAppointRecordResBookingDTO.getOwnCost());
            appointRecordItem.setRegFee(getAppointRecordResBookingDTO.getRegFee());
            appointRecordItem.setDiagFee(getAppointRecordResBookingDTO.getDiagFee());
            getAppointRecordRes.setCardNo(getAppointRecordResBookingDTO.getCardNo());
            getAppointRecordRes.setName(getAppointRecordResBookingDTO.getName());
            items.add(appointRecordItem);
        }
        getAppointRecordRes.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getAppointRecordRes);
    }

    public FrontResponse<AutoTakeNumberRes> autoTakeNumber(FrontRequest<AutoTakeNumberReq> param) {
        AutoTakeNumberReq body = (AutoTakeNumberReq)param.getBody();
        HashMap<String, AutoTakeNumberReq> map = new HashMap<String, AutoTakeNumberReq>();
        map.put(EntityKeyEnum.AUTO_TAKE_NUMBER.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.AUTO_TAKE_NUMBER.getValue(), map, AutoTakeNumberResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, null);
        }
        if (Objects.isNull(response.getBody())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getMessage());
        }
        AutoTakeNumberResDTO autoTakeNumberResDTO = (AutoTakeNumberResDTO)response.getBody();
        if (!CLINIC_TYPE_CANCEL.equals(autoTakeNumberResDTO.getResult())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)autoTakeNumberResDTO.getErr());
        }
        AutoTakeNumberRes autoTakeNumberRes = new AutoTakeNumberRes();
        BeanUtils.copyProperties((Object)autoTakeNumberResDTO, (Object)autoTakeNumberRes);
        return FrontResponse.success((String)param.getTransactionId(), (Object)autoTakeNumberRes);
    }

    public FrontResponse<DayRegisterRes> dayRegister(FrontRequest<DayRegisterReq> param) {
        DayRegisterReq dayRegisterReq = (DayRegisterReq)param.getBody();
        if (null == dayRegisterReq) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RegisteredNowDayReqDTO registeredNowDayReqDTO = new RegisteredNowDayReqDTO();
        registeredNowDayReqDTO.setCardNo(dayRegisterReq.getCardNo()).setTimeFlag(dayRegisterReq.getTimeFlag()).setScheduleNo(dayRegisterReq.getRbasId()).setOutPatientId(dayRegisterReq.getPatientId()).setHospitalId("A10001_" + dayRegisterReq.getTimeArrangeId());
        HashMap<String, RegisteredNowDayReqDTO> registeredNowDayReqMap = new HashMap<String, RegisteredNowDayReqDTO>(1);
        registeredNowDayReqMap.put(EntityKeyEnum.REGISTERED_NOWDAY.getValue(), registeredNowDayReqDTO);
        FrontResponse registeredNowDayRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.REGISTERED_NOWDAY.getValue(), registeredNowDayReqMap, RegisteredNowDayResDTO.class);
        RegisteredNowDayResDTO registeredNowDayResDTO = (RegisteredNowDayResDTO)registeredNowDayRes.getBody();
        if (null == registeredNowDayResDTO) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)registeredNowDayRes.getMessage());
        }
        if (!CLINIC_TYPE_CANCEL.equals(registeredNowDayResDTO.getResultCode())) {
            return FrontResponse.error((String)registeredNowDayRes.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)registeredNowDayResDTO.getResultMsg());
        }
        DayRegisterRes dayRegisterRes = new DayRegisterRes();
        registeredNowDayResDTO.getItem().forEach(registeredNowDayResItemDTO -> {
            dayRegisterRes.setAppointId(registeredNowDayResItemDTO.getRegistegOrderID());
            dayRegisterRes.setReceiptId(registeredNowDayResItemDTO.getRegisteID());
            dayRegisterRes.setAdmitTimeRange(registeredNowDayResItemDTO.getCheckTime());
            dayRegisterRes.setAdmitAddress(registeredNowDayResItemDTO.getClinicAddress());
            dayRegisterRes.setRegFee(registeredNowDayResItemDTO.getChargeRegister());
        });
        return FrontResponse.success((String)registeredNowDayRes.getTransactionId(), (Object)dayRegisterRes);
    }

    public FrontResponse<PayRegistrationRes> dayPayRegistration(FrontRequest<PayRegistrationReq> param) {
        PayRegistrationRes payRegistrationRes = new PayRegistrationRes();
        PayRegistrationReq payRegistrationReq = (PayRegistrationReq)param.getBody();
        PayAppointmentReqDTO payAppointmentReqDTO = new PayAppointmentReqDTO();
        HashMap<String, PayAppointmentReqDTO> payAppointMap = new HashMap<String, PayAppointmentReqDTO>(1);
        payAppointMap.put(EntityKeyEnum.REGISTERED_NOWDAY_PAY.getValue(), payAppointmentReqDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.DAY_APPOINTMENT_REGISTRATION_PAY.getValue(), payAppointMap, PayAppointmentResDTO.class);
        if (null == response) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)response.getMessage());
        }
        if (!CLINIC_TYPE_CANCEL.equals(((PayAppointmentResDTO)response.getBody()).getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)((PayAppointmentResDTO)response.getBody()).getResultMsg());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)payRegistrationRes);
    }

    public FrontResponse<RegisteredResVo> queryCost(FrontRequest<RegisteredReqVo> param) {
        QueryCostDTO queryCostDTO = QueryCostDTO.builder().build();
        RegisteredReqVo requestParam = (RegisteredReqVo)param.getBody();
        HashMap<String, RegisteredReqVo> map = new HashMap<String, RegisteredReqVo>();
        String sex = requestParam.getSex();
        sex = Objects.equals("M", sex) ? "\u7537" : "\u5973";
        requestParam.setSex(sex);
        map.put(EntityKeyEnum.QUERY_COST.getValue(), requestParam);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_COST.getValue(), map, QueryCostResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, null);
        }
        if (Objects.isNull(response.getBody())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)response.getMessage());
        }
        QueryCostResDTO body = (QueryCostResDTO)response.getBody();
        if (!CLINIC_TYPE_CANCEL.equals(body.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)body.getResultMsg());
        }
        RegisteredResVo registeredResVo = new RegisteredResVo();
        registeredResVo.setMsg(body.getMsg());
        return FrontResponse.success((String)param.getTransactionId(), (Object)registeredResVo);
    }

    public FrontResponse<PayRegistrationRes> registered(FrontRequest<PayRegistrationReq> param) {
        PayRegistrationReq dayRegisterReq = (PayRegistrationReq)param.getBody();
        HashMap<String, PayRegistrationReq> map = new HashMap<String, PayRegistrationReq>();
        String sex = dayRegisterReq.getSex();
        sex = Objects.equals("M", sex) ? "\u7537" : "\u5973";
        dayRegisterReq.setSex(sex);
        if (dayRegisterReq.getDoctCode().contains("66666")) {
            dayRegisterReq.setDoctCode(null);
            dayRegisterReq.setDoctName(null);
        }
        map.put(EntityKeyEnum.REGISTERED.getValue(), dayRegisterReq);
        log.info("\u5f53\u65e5\u6302\u53f7map\u4e3a - > {}", map);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.REGISTERED.getValue(), map, RegisteredResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, null);
        }
        if (Objects.isNull(response.getBody())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)response.getMessage());
        }
        RegisteredResDTO responseBody = (RegisteredResDTO)response.getBody();
        if (!CLINIC_TYPE_CANCEL.equals(responseBody.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)response.getMessage());
        }
        PayRegistrationRes dayRegisterRes = new PayRegistrationRes();
        dayRegisterRes.setAdmitAddress(responseBody.getDeptAdress());
        dayRegisterRes.setAdmId(responseBody.getClinicCode());
        dayRegisterRes.setReceiptId(responseBody.getInvoiceNO());
        dayRegisterRes.setTotalRegFee(responseBody.getTotCost());
        dayRegisterRes.setNo(responseBody.getSeqNO());
        dayRegisterRes.setRegistFee(responseBody.getRegFee());
        dayRegisterRes.setInspectFee(responseBody.getDiagFee());
        dayRegisterRes.setEleStr(responseBody.getEleStr());
        return FrontResponse.success((String)param.getTransactionId(), (Object)dayRegisterRes);
    }

    public FrontResponse<PayRegistrationRes> healthRegistered(FrontRequest<PayRegistrationReq> param) throws Exception {
        PayRegistrationReq dayRegisterReq = (PayRegistrationReq)param.getBody();
        String deptCode = dayRegisterReq.getDeptCode();
        HashMap<String, PayRegistrationReq> map = new HashMap<String, PayRegistrationReq>();
        String sex = dayRegisterReq.getSex();
        sex = Objects.equals("M", sex) ? "\u7537" : "\u5973";
        dayRegisterReq.setSex(sex);
        if (dayRegisterReq.getDoctCode().contains("66666")) {
            dayRegisterReq.setDoctCode(null);
            dayRegisterReq.setDoctName(null);
        }
        map.put(EntityKeyEnum.HEALTH.getValue(), dayRegisterReq);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.HEALTH.getValue(), map, RegisteredResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, null);
        }
        if (Objects.isNull(response.getBody())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)response.getMessage());
        }
        RegisteredResDTO responseBody = (RegisteredResDTO)response.getBody();
        if ("-2".equals(responseBody.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)responseBody.getResultCode(), (String)((RegisteredResDTO)response.getBody()).getResultMsg());
        }
        if (!CLINIC_TYPE_CANCEL.equals(responseBody.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)((RegisteredResDTO)response.getBody()).getResultMsg());
        }
        PayRegistrationRes dayRegisterRes = new PayRegistrationRes();
        dayRegisterRes.setAdmitAddress(responseBody.getDeptAdress());
        dayRegisterRes.setAdmId(responseBody.getClinicCode());
        dayRegisterRes.setReceiptId(responseBody.getInvoiceNO());
        dayRegisterRes.setTotalRegFee(responseBody.getTotCost());
        dayRegisterRes.setNo(responseBody.getSeqNO());
        dayRegisterRes.setRegistFee(responseBody.getRegFee());
        dayRegisterRes.setInspectFee(responseBody.getDiagFee());
        dayRegisterRes.setEleStr(responseBody.getEleStr());
        dayRegisterRes.setPubCost(responseBody.getPubCost());
        dayRegisterRes.setPayCost(responseBody.getPayCost());
        dayRegisterRes.setOwnCost(responseBody.getOwnCost());
        return FrontResponse.success((String)param.getTransactionId(), (Object)dayRegisterRes);
    }

    public FrontResponse<PayRegistrationRes> sceneBack(FrontRequest<PayRegistrationReq> param) {
        PayRegistrationReq paramBody = (PayRegistrationReq)param.getBody();
        SceneBackDTO sceneBackDTO = SceneBackDTO.builder().clinicCode(paramBody.getClinicCode()).build();
        HashMap<String, SceneBackDTO> map = new HashMap<String, SceneBackDTO>();
        map.put(EntityKeyEnum.SCENE_BACK.getValue(), sceneBackDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.SCENE_BACK.getValue(), map, SceneBackResDTO.class);
        return null;
    }

    public FrontResponse<QueryValidInfoResVo> queryValidInfo(FrontRequest<QueryValidInfoReqVo> param) {
        QueryValidInfoReqVo body = (QueryValidInfoReqVo)param.getBody();
        HashMap<String, QueryValidInfoReqVo> map = new HashMap<String, QueryValidInfoReqVo>();
        map.put(EntityKeyEnum.QUERY_VALID.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_VALID.getValue(), map, QueryValidResDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, null);
        }
        if (Objects.isNull(response.getBody())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)response.getMessage());
        }
        QueryValidResDTO responseBody = (QueryValidResDTO)response.getBody();
        if (!CLINIC_TYPE_CANCEL.equals(responseBody.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)response.getMessage());
        }
        List item = responseBody.getItem();
        if (CollectionUtils.isEmpty((Collection)item)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_APPOINT, null);
        }
        QueryValidInfoResVo queryValidInfoResVo = new QueryValidInfoResVo();
        ArrayList<QueryValidInfoResItemVo> list = new ArrayList<QueryValidInfoResItemVo>();
        for (RegisterDTO registerDTO : item) {
            QueryValidInfoResItemVo queryValidInfoResItemVo = new QueryValidInfoResItemVo();
            BeanUtils.copyProperties((Object)registerDTO, (Object)queryValidInfoResItemVo);
            list.add(queryValidInfoResItemVo);
        }
        queryValidInfoResVo.setItems(list);
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryValidInfoResVo);
    }

    public FrontResponse<QueryRegistrationRecordsRes> queryRegistrationRecords(FrontRequest<QueryRegistrationRecordsReq> param) {
        QueryRegistrationRecordsReq body = (QueryRegistrationRecordsReq)param.getBody();
        HashMap<String, QueryRegistrationRecordsReq> map = new HashMap<String, QueryRegistrationRecordsReq>();
        map.put(EntityKeyEnum.QUERY_REGISTRATION_RECORDS.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_REGISTRATION_RECORDS.getValue(), map, QueryRegistrationRecordsDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, null);
        }
        if (Objects.isNull(response.getBody())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)response.getMessage());
        }
        QueryRegistrationRecordsDTO responseBody = (QueryRegistrationRecordsDTO)response.getBody();
        if (!CLINIC_TYPE_CANCEL.equals(responseBody.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)response.getMessage());
        }
        if (CollectionUtils.isEmpty((Collection)responseBody.getItems())) {
            return FrontResponse.success((String)response.getTransactionId(), null);
        }
        QueryRegistrationRecordsRes queryRegistrationRecordsRes = new QueryRegistrationRecordsRes();
        ArrayList<QueryRegistrationRecordsItemRes> queryRegistrationRecordsItemRes = new ArrayList<QueryRegistrationRecordsItemRes>();
        List items = responseBody.getItems();
        for (QueryRegistrationRecordsItemDTO item : items) {
            QueryRegistrationRecordsItemRes queryRegistrationRecordsItemRes1 = new QueryRegistrationRecordsItemRes();
            BeanUtils.copyProperties((Object)item, (Object)queryRegistrationRecordsItemRes1);
            queryRegistrationRecordsItemRes.add(queryRegistrationRecordsItemRes1);
        }
        queryRegistrationRecordsRes.setItems(queryRegistrationRecordsItemRes);
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryRegistrationRecordsRes);
    }

    public FrontResponse<PayRegistrationRes> lock(FrontRequest<LockParam> param) {
        LockParam body = (LockParam)param.getBody();
        LockDTO lockDTO = LockDTO.builder().build();
        HashMap<String, LockParam> map = new HashMap<String, LockParam>();
        map.put(EntityKeyEnum.LOCK.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.LOCK.getValue(), map, LockResDTO.class);
        if (Objects.isNull(response)) {
            // empty if block
        }
        if (!CLINIC_TYPE_CANCEL.equals(((LockResDTO)response.getBody()).getResultCode())) {
            // empty if block
        }
        return null;
    }

    public FrontResponse<HealthBackPayResVo> healthBackPay(GatewayRequest<HealthBackPayReqVo> healthBackPayReqVoGatewayRequest) {
        HealthBackPayResVo healthBackPayResVo = new HealthBackPayResVo();
        HealthBackPayReqVo body = (HealthBackPayReqVo)healthBackPayReqVoGatewayRequest.getBody();
        HashMap<String, HealthBackPayReqVo> map = new HashMap<String, HealthBackPayReqVo>();
        map.put(EntityKeyEnum.HEALTH_BACK_PAY.getValue(), body);
        FrontResponse response = this.hisRemoteService.requestHis(healthBackPayReqVoGatewayRequest.getTransactionId(), MethodCodeEnum.HEALTH_BACK_PAY.getValue(), map, HealthBackPayDTO.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, null);
        }
        if (Objects.isNull(response.getBody())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)response.getMessage());
        }
        HealthBackPayDTO responseBody = (HealthBackPayDTO)response.getBody();
        if (!CLINIC_TYPE_CANCEL.equals(responseBody.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)CLINIC_TYPE_CANCEL, (String)responseBody.getMessage());
        }
        BeanUtils.copyProperties((Object)responseBody, (Object)healthBackPayResVo);
        return FrontResponse.success((String)healthBackPayReqVoGatewayRequest.getTransactionId(), (Object)healthBackPayResVo);
    }

    public ReservationLockNumberRes appointmentRegistrationLock(FrontRequest<ReservationLockNumberReq> reservationLockNumberReqFrontRequest) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(EntityKeyEnum.LOCK_SIGNAL_SOURCE.getValue(), reservationLockNumberReqFrontRequest.getBody());
            FrontResponse lockSignalsourceDtoFrontResponse = this.hisRemoteService.requestHis(reservationLockNumberReqFrontRequest.getTransactionId(), MethodCodeEnum.LOCK_SIGNAL_SOURCE.getValue(), map, LockSignalsourceDto.class);
            return (ReservationLockNumberRes)BeanUtil.copyProperties((Object)lockSignalsourceDtoFrontResponse.getBody(), ReservationLockNumberRes.class, (String[])new String[0]);
        }
        catch (Exception e) {
            ReservationLockNumberRes reservationLockNumberRes = new ReservationLockNumberRes();
            reservationLockNumberRes.setResult("-1");
            reservationLockNumberRes.setErr("hsi\u9501\u53f7\u9519\u8bef");
            reservationLockNumberRes.setMark(null);
            return reservationLockNumberRes;
        }
    }

    public FrontResponse<YbRegistionResponseBody> ybRegistion(FrontRequest<YbRegistrationReqDTO> param) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EntityKeyEnum.YB_REGISTRATION_2201.getValue(), param.getBody());
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.YB_REGISTRATION_2201.getValue(), map, ResponseHeadOfResponseBody2201.class);
        if (Objects.isNull(response)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u8bf7\u6c422201\u63a5\u53e3\u54cd\u5e94\u4e3anull");
        }
        ResponseHeadOfResponseBody2201 responseBody = (ResponseHeadOfResponseBody2201)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u8bf7\u6c422201\u63a5\u53e3\u8fd4\u56de\u5bf9\u8c61\u4e3anull");
        }
        if (!CLINIC_TYPE_APPOINT.equals(responseBody.getInfcode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)responseBody.getErrMsg());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)responseBody.getYbRegistionResponseBody());
    }
}

