/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.api;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.conmon.enums.LoginType;
import com.ebaiyihui.server.loginbusiness.LoginProcess;
import com.ebaiyihui.server.service.AccessTokenService;
import com.ebaiyihui.server.shiro.realm.UserToken;
import com.ebaiyihui.server.vo.LoginRequestVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
public class AuthController {
    @Autowired
    LoginProcess loginProcess;
    @Autowired
    AccessTokenService accessTokenService;

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public BaseResponse login(@RequestBody @Validated LoginRequestVo loginRequestVo) {
        UserToken token = new UserToken(LoginType.getEnum((String)loginRequestVo.getLoginType()), loginRequestVo, loginRequestVo.getAccountNo(), loginRequestVo.getPassword());
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.loginProcess.shiroLogin(token);
        }
        catch (Exception e) {
            return BaseResponse.error((String)("\u767b\u5f55\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return baseResponse;
    }

    @RequestMapping(value={"/validToken"}, method={RequestMethod.GET})
    public BaseResponse validToken(@RequestParam(value="accessToken") String accessToken) {
        return this.accessTokenService.validAcessToken(accessToken);
    }

    @RequestMapping(value={"/validTokennew"}, method={RequestMethod.GET})
    public BaseResponse validTokennew(@RequestParam(value="accessToken") String accessToken) {
        return this.accessTokenService.validAcessTokennew(accessToken);
    }

    @RequestMapping(value={"/refreshToken"}, method={RequestMethod.GET})
    public BaseResponse refreshToken(@RequestParam(value="refreshToken") String refreshToken) {
        return this.accessTokenService.refreshAccessToken(refreshToken);
    }

    @RequestMapping(value={"/getUserUnique"}, method={RequestMethod.GET})
    public BaseResponse wxopenId(@RequestHeader(value="token") String token, @RequestParam(value="code") String code, @RequestParam(value="appId") String appId) {
        return this.accessTokenService.getUserUnique(token, code, appId);
    }

    @RequestMapping(value={"/loginout"}, method={RequestMethod.GET})
    public BaseResponse loginout(@RequestHeader(value="accessToken") String token) {
        return this.accessTokenService.loginout(token);
    }

    @RequestMapping(value={"/tokenout"}, method={RequestMethod.GET})
    public BaseResponse tokenout(@RequestParam(value="accountId") String accountId) {
        return this.accessTokenService.tokenout(accountId);
    }
}

