/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.shiro.realm;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.common.pojo.AccountEntity;
import com.ebaiyihui.common.pojo.WeChatConfigEntity;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.server.conmon.ProjProperties;
import com.ebaiyihui.server.conmon.enums.ErrorEnum;
import com.ebaiyihui.server.conmon.enums.LoginDeviceType;
import com.ebaiyihui.server.conmon.enums.LoginType;
import com.ebaiyihui.server.dao.AccountDao;
import com.ebaiyihui.server.dao.WeChatConfigDao;
import com.ebaiyihui.server.service.AccountService;
import com.ebaiyihui.server.shiro.realm.UserToken;
import com.ebaiyihui.server.shiro.realm.WechatLoginRealm;
import com.ebaiyihui.server.util.ApiRespVO;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class WechatLoginRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(WechatLoginRealm.class);
    @Autowired
    private AccountService userService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private WeChatConfigDao weChatConfigDao;
    @Autowired
    AccountDao accountDao;
    @Autowired
    ProjProperties projProperties;

    public String getName() {
        return LoginType.WECHAT_LOGIN.getType();
    }

    public boolean supports(AuthenticationToken token) {
        if (token instanceof UserToken) {
            return ((UserToken)token).getLoginType() == LoginType.WECHAT_LOGIN;
        }
        return false;
    }

    public void setAuthorizationCacheName(String authorizationCacheName) {
        super.setAuthorizationCacheName(authorizationCacheName);
    }

    protected void clearCachedAuthorizationInfo(PrincipalCollection principals) {
        super.clearCachedAuthorizationInfo(principals);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        AccountEntity accountEntity1;
        log.info("---------------- \u5fae\u4fe1\u767b\u5f55 ----------------------");
        UserToken token = (UserToken)authcToken;
        String code = token.getLoginRequestVo().getCode();
        String phone = null;
        if (token.getLoginRequestVo().getLoginDeviceType().equals((Object)LoginDeviceType.WX_APPLET)) {
            phone = this.getPhone(code, token);
        } else if (token.getLoginRequestVo().getLoginDeviceType().equals((Object)LoginDeviceType.WX_ENT)) {
            phone = this.getWxEntPhone(code);
        }
        if (StringUtils.isEmpty((CharSequence)phone)) {
            log.error("\u5fae\u4fe1\u6388\u6743\u767b\u5f55\u5931\u8d25\uff0c\u672a\u83b7\u5f97\u7528\u6237\u624b\u673a\u53f7");
            throw new AuthenticationException();
        }
        AccountEntity accountEntity = this.userService.getByPhone(phone, token.getLoginRequestVo().getUserType(), token.getLoginRequestVo().getAppCode());
        if (3 == token.getLoginRequestVo().getUserType()) {
            if (null == accountEntity) {
                log.error("\u8d26\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u8d26\u53f7");
                throw new UnknownAccountException(ErrorEnum.USER_NOT_EXIT.getMsg());
            }
            if (-1 == accountEntity.getDelFlag()) {
                throw new DisabledAccountException(ErrorEnum.USER_NOT_EXIT.getMsg());
            }
            SimpleAuthenticationInfo authenticationInfo = new SimpleAuthenticationInfo((Object)accountEntity.getMobilePhone(), (Object)accountEntity.getPassword(), this.getName());
            return authenticationInfo;
        }
        if (null == accountEntity) {
            accountEntity1 = new AccountEntity();
            accountEntity1.setAppCode(token.getLoginRequestVo().getAppCode());
            accountEntity1.setAccountId(UUIDUtils.getUUID());
            accountEntity1.setDelFlag(Integer.valueOf(1));
            accountEntity1.setLoginName("");
            accountEntity1.setMobilePhone(phone);
            accountEntity1.setUserType(token.getLoginRequestVo().getUserType());
            accountEntity1.setStatus(Integer.valueOf(1));
            this.accountDao.save((Object)accountEntity1);
        }
        accountEntity1 = this.userService.getByPhone(phone, Integer.valueOf(token.getLoginRequestVo().getUserType()), token.getLoginRequestVo().getAppCode());
        SimpleAuthenticationInfo authenticationInfo = new SimpleAuthenticationInfo((Object)accountEntity1.getMobilePhone(), (Object)accountEntity1.getPassword(), this.getName());
        return authenticationInfo;
    }

    private String getPhone(String code, UserToken userToken) {
        WeChatConfigEntity weChatConfigEntity = null;
        try {
            weChatConfigEntity = this.weChatConfigDao.findByAppCodeAndUseTypeAndChannel(userToken.getLoginRequestVo().getAppCode(), userToken.getLoginRequestVo().getUserType().toString(), userToken.getLoginRequestVo().getLoginDeviceType().name());
        }
        catch (Exception e) {
            weChatConfigEntity = this.weChatConfigDao.findByAppId(userToken.getLoginRequestVo().getLoginDeviceNum());
        }
        if (null == weChatConfigEntity) {
            throw new AccountException("\u5fae\u4fe1\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            String token_url = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", weChatConfigEntity.getAppId(), weChatConfigEntity.getAppSecret());
            JSONObject token = JSON.parseObject((String)HttpUtil.get((String)token_url));
            String url = "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=" + token.getString("access_token");
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("code", code);
            HttpHeaders headers = new HttpHeaders();
            HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
            ResponseEntity responsephene = this.restTemplate.postForEntity(url, (Object)httpEntity, PhoneClass.class, new Object[0]);
            PhoneClass phoneClass = (PhoneClass)responsephene.getBody();
            return phoneClass.getPhone_info().getPurePhoneNumber();
        }
        return null;
    }

    public String getWxEntPhone(String code) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String url = this.projProperties.getWxentUrl();
        paramMap.put("code", code);
        paramMap.put("agentId", this.projProperties.getAgentId());
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responsephene = this.restTemplate.postForEntity(url, (Object)httpEntity, ApiRespVO.class, new Object[0]);
        log.info("responsephene{}", (Object)responsephene);
        ApiRespVO apiRespVO = (ApiRespVO)JSON.parseObject((String)JSON.toJSONString((Object)responsephene.getBody()), ApiRespVO.class);
        log.info("apiRespVO==={}", apiRespVO.getData());
        WxEnt wxEnt = (WxEnt)JSON.parseObject((String)JSON.toJSONString((Object)apiRespVO.getData()), WxEnt.class);
        return wxEnt.getPhone();
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

