/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.card.server.service.impl;

import com.ebaiyihui.card.common.vo.BackOrganConfigReqVO;
import com.ebaiyihui.card.common.vo.OrganConfigReqVO;
import com.ebaiyihui.card.common.vo.OrganConfigRespVO;
import com.ebaiyihui.card.server.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.card.server.service.BaseService;
import com.ebaiyihui.card.server.service.IHospitalConfigService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HospitalConfigServiceImpl
extends BaseService
implements IHospitalConfigService {
    public BaseResponse<OrganConfigRespVO> getOrganConfig(OrganConfigReqVO organConfigReqVO) {
        Optional organCodeOp = this.hospitalConfigRepository.findOneByOrganCode(organConfigReqVO.getOrganCode());
        if (!organCodeOp.isPresent()) {
            log.warn("\u672a\u83b7\u53d6\u5230\u673a\u6784\u914d\u7f6e\uff01organCode={}", (Object)organConfigReqVO.getOrganCode());
            return BaseResponse.success();
        }
        HospitalConfigEntity hospitalConfigEntity = (HospitalConfigEntity)organCodeOp.get();
        return BaseResponse.success((Object)this.buildOrganConfigRespVO(hospitalConfigEntity));
    }

    public BaseResponse<List<OrganConfigRespVO>> getAllOrganConfig() {
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        orders.add(new Sort.Order(Sort.Direction.DESC, "sort"));
        orders.add(new Sort.Order(Sort.Direction.ASC, "organName"));
        Sort sort = Sort.by(orders);
        List organs = this.hospitalConfigRepository.findAll(sort);
        ArrayList<OrganConfigRespVO> data = new ArrayList<OrganConfigRespVO>();
        if (!CollectionUtils.isEmpty((Collection)organs)) {
            for (HospitalConfigEntity organ : organs) {
                data.add(this.buildOrganConfigRespVO(organ));
            }
        }
        return BaseResponse.success(data);
    }

    public BaseResponse<List<OrganConfigRespVO>> getUsingOrganConfig() {
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        orders.add(new Sort.Order(Sort.Direction.DESC, "sort"));
        orders.add(new Sort.Order(Sort.Direction.ASC, "organName"));
        Sort sort = Sort.by(orders);
        HospitalConfigEntity usingOrgan = new HospitalConfigEntity();
        usingOrgan.setStatus(Boolean.TRUE);
        Example example = Example.of((Object)usingOrgan);
        List organs = this.hospitalConfigRepository.findAll(example, sort);
        ArrayList<OrganConfigRespVO> data = new ArrayList<OrganConfigRespVO>();
        if (!CollectionUtils.isEmpty((Collection)organs)) {
            for (HospitalConfigEntity organ : organs) {
                if ("10000000".equals(organ.getOrganCode())) continue;
                data.add(this.buildOrganConfigRespVO(organ));
            }
        }
        return BaseResponse.success(data);
    }

    public BaseResponse<OrganConfigRespVO> addOrganConfig(BackOrganConfigReqVO reqVO) {
        HospitalConfigEntity entity = new HospitalConfigEntity();
        entity.setOrganCode(reqVO.getOrganCode());
        entity.setOrganName(reqVO.getOrganName());
        entity.setCardReleaseTime(reqVO.getCardReleaseTime());
        entity.setCardSlot(reqVO.getCardSlot());
        entity.setFaceRecognition(reqVO.getFaceRecognition());
        entity.setManualAudit(reqVO.getManualAudit());
        entity.setSlotReleaseTime(reqVO.getSlotReleaseTime());
        entity.setSort(reqVO.getSort());
        entity.setRealName(reqVO.getRealName());
        entity.setStatus(Boolean.FALSE);
        this.hospitalConfigRepository.save((Object)entity);
        log.info("\u673a\u6784\u4fe1\u606f\u6dfb\u52a0\u6210\u529f,\u673a\u6784\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)entity));
        OrganConfigRespVO organConfigRespVO = this.buildOrganConfigRespVO(entity);
        return BaseResponse.success((Object)organConfigRespVO);
    }

    public BaseResponse<OrganConfigRespVO> updateOrganConfig(BackOrganConfigReqVO reqVO) {
        Optional organConfigOp = this.hospitalConfigRepository.findOneByOrganCode(reqVO.getOrganCode());
        if (!organConfigOp.isPresent()) {
            log.warn("\u672a\u67e5\u8be2\u5230\u8be5\u673a\u6784\u914d\u7f6e\uff0c\u673a\u6784\u7f16\u7801 = {}", (Object)reqVO.getOrganCode());
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST, (String)"\u672a\u67e5\u8be2\u5230\u8be5\u673a\u6784\u914d\u7f6e");
        }
        HospitalConfigEntity hospitalConfigEntity = (HospitalConfigEntity)organConfigOp.get();
        hospitalConfigEntity.setStatus(reqVO.getStatus() == 0 ? Boolean.FALSE : Boolean.TRUE);
        hospitalConfigEntity.setRealName(reqVO.getRealName());
        hospitalConfigEntity.setOrganName(reqVO.getOrganName());
        hospitalConfigEntity.setCardReleaseTime(reqVO.getCardReleaseTime());
        hospitalConfigEntity.setCardSlot(reqVO.getCardSlot());
        hospitalConfigEntity.setManualAudit(reqVO.getManualAudit());
        hospitalConfigEntity.setSlotReleaseTime(reqVO.getSlotReleaseTime());
        hospitalConfigEntity.setFaceRecognition(reqVO.getFaceRecognition());
        hospitalConfigEntity.setSort(reqVO.getSort());
        this.hospitalConfigRepository.save((Object)hospitalConfigEntity);
        log.info("\u673a\u6784\u4fe1\u606f\u4fee\u6539\u6210\u529f , \u4fe1\u606f\u66f4\u65b0 \uff0c\u6700\u65b0\u673a\u6784\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)hospitalConfigEntity));
        OrganConfigRespVO organConfigRespVO = this.buildOrganConfigRespVO(hospitalConfigEntity);
        return BaseResponse.success((Object)organConfigRespVO);
    }

    private OrganConfigRespVO buildOrganConfigRespVO(HospitalConfigEntity hospitalConfigEntity) {
        OrganConfigRespVO organConfigRespVO = new OrganConfigRespVO();
        organConfigRespVO.setCardReleaseTime(hospitalConfigEntity.getCardReleaseTime());
        organConfigRespVO.setSlotReleaseTime(hospitalConfigEntity.getSlotReleaseTime());
        organConfigRespVO.setUpdateTime(hospitalConfigEntity.getUpdateTime());
        organConfigRespVO.setCreateTime(hospitalConfigEntity.getCreateTime());
        organConfigRespVO.setCardSlot(hospitalConfigEntity.getCardSlot());
        organConfigRespVO.setId(hospitalConfigEntity.getId());
        organConfigRespVO.setFaceRecognition(hospitalConfigEntity.getFaceRecognition());
        organConfigRespVO.setManualAudit(hospitalConfigEntity.getManualAudit());
        organConfigRespVO.setOrganCode(hospitalConfigEntity.getOrganCode());
        organConfigRespVO.setRealName(hospitalConfigEntity.getRealName());
        organConfigRespVO.setOrganName(hospitalConfigEntity.getOrganName());
        organConfigRespVO.setStatus(Integer.valueOf(hospitalConfigEntity.getStatus().equals(Boolean.FALSE) ? 0 : 1));
        return organConfigRespVO;
    }

    public BaseResponse<List<OrganConfigRespVO>> getManagerUsingOrganConfig(String appCode) {
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        orders.add(new Sort.Order(Sort.Direction.DESC, "sort"));
        orders.add(new Sort.Order(Sort.Direction.ASC, "organName"));
        Sort sort = Sort.by(orders);
        HospitalConfigEntity usingOrgan = new HospitalConfigEntity();
        usingOrgan.setStatus(Boolean.TRUE);
        Example example = Example.of((Object)usingOrgan);
        List organs = this.hospitalConfigRepository.findAll(example, sort);
        ArrayList<OrganConfigRespVO> data = new ArrayList<OrganConfigRespVO>();
        if (!CollectionUtils.isEmpty((Collection)organs)) {
            for (HospitalConfigEntity organ : organs) {
                data.add(this.buildOrganConfigRespVO(organ));
            }
        }
        return BaseResponse.success(data);
    }
}

