/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.card.server.service.impl;

import com.ebaiyihui.card.common.vo.AddBlacklistBusinessReqVO;
import com.ebaiyihui.card.common.vo.PatientBlacklistBusinessReqVO;
import com.ebaiyihui.card.common.vo.PatientBlacklistPageReqVO;
import com.ebaiyihui.card.common.vo.PatientBlacklistRespVO;
import com.ebaiyihui.card.common.vo.RemoveBlacklistBusinessReqVO;
import com.ebaiyihui.card.common.vo.SaveBlacklistReqVO;
import com.ebaiyihui.card.server.common.TimeSpanCodeEnum;
import com.ebaiyihui.card.server.pojo.entity.PatientBlacklist;
import com.ebaiyihui.card.server.pojo.entity.PatientBlacklistBusiness;
import com.ebaiyihui.card.server.repository.PatientBlacklistBusinessMapper;
import com.ebaiyihui.card.server.repository.PatientBlacklistMapper;
import com.ebaiyihui.card.server.service.PatientBlacklistService;
import com.ebaiyihui.framework.page.PageResult;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PatientBlacklistServiceImpl
implements PatientBlacklistService {
    @Autowired
    private PatientBlacklistMapper patientBlacklistMapper;
    @Autowired
    private PatientBlacklistBusinessMapper patientBlacklistBusinessMapper;

    @Transactional(rollbackFor={Exception.class})
    public void saveBlacklist(SaveBlacklistReqVO saveBlacklistReqVO) {
        PatientBlacklist patientBlacklist = new PatientBlacklist();
        BeanUtils.copyProperties((Object)saveBlacklistReqVO, (Object)patientBlacklist);
        Integer timeSpanCode = saveBlacklistReqVO.getTimeSpanCode();
        Integer timeSpan = saveBlacklistReqVO.getTimeSpan();
        LocalDateTime localDateTime = LocalDateTime.now();
        if (TimeSpanCodeEnum.DAY.getTimeSpanCode().equals(timeSpanCode)) {
            localDateTime = localDateTime.plusDays(timeSpan.longValue());
        } else if (TimeSpanCodeEnum.MONTH.getTimeSpanCode().equals(timeSpanCode)) {
            localDateTime = localDateTime.plusMonths(timeSpan.longValue());
        } else if (TimeSpanCodeEnum.YEAR.getTimeSpanCode().equals(timeSpanCode)) {
            localDateTime = localDateTime.plusYears(timeSpan.longValue());
        }
        patientBlacklist.setExpireTime(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        this.patientBlacklistMapper.insertSelective(patientBlacklist);
        Long patientBlacklistId = patientBlacklist.getId();
        List patientBlacklistBusinessReqVOList = saveBlacklistReqVO.getPatientBlacklistBusinessReqVOList();
        for (PatientBlacklistBusinessReqVO patientBlacklistBusinessReqVO : patientBlacklistBusinessReqVOList) {
            PatientBlacklistBusiness patientBlacklistBusiness = new PatientBlacklistBusiness();
            patientBlacklistBusiness.setPatientBlacklistId(patientBlacklistId);
            patientBlacklistBusiness.setBusinessCode(patientBlacklistBusinessReqVO.getBusinessCode());
            patientBlacklistBusiness.setBusinessName(patientBlacklistBusinessReqVO.getBusinessName());
            this.patientBlacklistBusinessMapper.insertSelective(patientBlacklistBusiness);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeBlacklist(Long patientBlacklistId) {
        this.patientBlacklistBusinessMapper.deleteByPatientBlacklistId(patientBlacklistId);
        this.patientBlacklistMapper.deleteByPrimaryKey(patientBlacklistId);
    }

    public PatientBlacklist getByPatientCardNoAndBusinessCode(String patientCardNo, String businessCode) {
        return this.patientBlacklistMapper.getByPatientCardNoAndBusinessCode(patientCardNo, businessCode);
    }

    public PageResult<PatientBlacklistRespVO> findPage(PatientBlacklistPageReqVO patientBlacklistPageReqVO) {
        Integer pageNo = patientBlacklistPageReqVO.getPageNo();
        Integer pageSize = patientBlacklistPageReqVO.getPageSize();
        PageHelper.startPage((int)pageNo, (int)pageSize);
        List patientBlacklistRespVOList = this.patientBlacklistMapper.findPage(patientBlacklistPageReqVO);
        if (patientBlacklistRespVOList != null) {
            for (int i = 0; i < patientBlacklistRespVOList.size(); ++i) {
                PatientBlacklistRespVO patientBlacklistRespVO = (PatientBlacklistRespVO)patientBlacklistRespVOList.get(i);
                Long patientBlacklistId = patientBlacklistRespVO.getId();
                List patientBlacklistBusinessRespVOS = this.patientBlacklistBusinessMapper.findByPatientBlacklistId(patientBlacklistId);
                patientBlacklistRespVO.setBlacklistBusinessRespVOList(patientBlacklistBusinessRespVOS);
            }
        }
        PageInfo pageInfo = new PageInfo(patientBlacklistRespVOList);
        PageResult pageResult = new PageResult();
        pageResult.setPageNum(pageInfo.getPageNum());
        pageResult.setPageSize(pageInfo.getPageSize());
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setTotal(Long.valueOf(pageInfo.getTotal()).intValue());
        pageResult.setContent(pageInfo.getList());
        return pageResult;
    }

    public PatientBlacklist getByPatientCardNo(String patientCardNo) {
        return this.patientBlacklistMapper.getByPatientCardNo(patientCardNo);
    }

    public void addBlacklistBusiness(AddBlacklistBusinessReqVO addBlacklistBusinessReqVO) {
        PatientBlacklistBusinessReqVO blacklistBusinessReqVO = addBlacklistBusinessReqVO.getPatientBlacklistBusinessReqVO();
        PatientBlacklistBusiness patientBlacklistBusiness = new PatientBlacklistBusiness();
        patientBlacklistBusiness.setPatientBlacklistId(addBlacklistBusinessReqVO.getPatientBlacklistId());
        patientBlacklistBusiness.setBusinessCode(blacklistBusinessReqVO.getBusinessCode());
        patientBlacklistBusiness.setBusinessName(blacklistBusinessReqVO.getBusinessName());
        this.patientBlacklistBusinessMapper.insertSelective(patientBlacklistBusiness);
    }

    public void removeBlacklistBusiness(RemoveBlacklistBusinessReqVO removeBlacklistBusinessReqVO) {
        Long patientBlacklistId;
        List blacklistBusinessRespVOS;
        Long patientBlacklistBusinessId = removeBlacklistBusinessReqVO.getPatientBlacklistBusinessId();
        PatientBlacklistBusiness patientBlacklistBusiness = this.patientBlacklistBusinessMapper.selectByPrimaryKey(patientBlacklistBusinessId);
        if (patientBlacklistBusiness != null && (blacklistBusinessRespVOS = this.patientBlacklistBusinessMapper.findByPatientBlacklistId(patientBlacklistId = patientBlacklistBusiness.getPatientBlacklistId())) != null && blacklistBusinessRespVOS.size() == 1) {
            this.patientBlacklistBusinessMapper.deleteByPrimaryKey(patientBlacklistBusinessId);
            this.patientBlacklistMapper.deleteByPrimaryKey(patientBlacklistId);
        }
        this.patientBlacklistBusinessMapper.deleteByPrimaryKey(patientBlacklistBusinessId);
    }
}

