/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.card.server.logback.wx;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.card.server.logback.MessageManager;
import com.ebaiyihui.card.server.logback.TextMessage;
import com.ebaiyihui.card.server.logback.wx.Message;
import com.ebaiyihui.card.server.logback.wx.MessageTypeEnum;
import com.ebaiyihui.card.server.logback.wx.WxAlarmService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class WechatAlarm
implements WxAlarmService {
    private String webHookUrl;
    private ExecutorService executor;

    public WechatAlarm() {
    }

    public WechatAlarm(String webHookUrl) {
        this.webHookUrl = webHookUrl;
        this.executor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("wechat-thread-executor-"));
    }

    private Message buildParam(String messageText) {
        Message message = new Message();
        message.setMsgtype(MessageTypeEnum.text);
        TextMessage textMessage = new TextMessage();
        textMessage.setContent(messageText);
        JSONObject text = JSONObject.parseObject((String)JSONObject.toJSONString((Object)textMessage));
        message.setText(text);
        return message;
    }

    public boolean alarm(String messageText) {
        this.executor.execute(() -> {
            try {
                Message message = this.buildParam(messageText);
                MessageManager.sendMessage((Message)message, (String)this.webHookUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return true;
    }
}

