/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.card.server.service.impl;

import com.ebaiyihui.card.common.vo.BackOrganCardTypeReqVO;
import com.ebaiyihui.card.common.vo.BackOrganCardTypeRespVO;
import com.ebaiyihui.card.common.vo.OrganAddCardTypeReqVO;
import com.ebaiyihui.card.common.vo.OrganAddCardTypeRespVO;
import com.ebaiyihui.card.server.pojo.entity.HospitalAddCardTypeEntity;
import com.ebaiyihui.card.server.service.BaseService;
import com.ebaiyihui.card.server.service.ICardTypeService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CardTypeServiceImpl
extends BaseService
implements ICardTypeService {
    public BaseResponse<List<OrganAddCardTypeRespVO>> getOrganAddCardType(OrganAddCardTypeReqVO reqVO) {
        ArrayList<OrganAddCardTypeRespVO> organCardLists = new ArrayList<OrganAddCardTypeRespVO>();
        List cardTypeList = this.cardTypeRepository.findListByOrganCodeAndStatus(reqVO.getOrganCode(), Boolean.TRUE);
        if (CollectionUtils.isEmpty((Collection)cardTypeList)) {
            log.warn("\u672a\u83b7\u53d6\u5230\u673a\u6784\u652f\u6301\u6dfb\u52a0\u5361\u65b9\u5f0f\uff0corganCode = {}", (Object)reqVO.getOrganCode());
            return BaseResponse.success(new ArrayList());
        }
        for (HospitalAddCardTypeEntity cardTypeEntity : cardTypeList) {
            OrganAddCardTypeRespVO organCardListRespVO = new OrganAddCardTypeRespVO();
            organCardListRespVO.setCardDesc(cardTypeEntity.getCardDesc());
            organCardListRespVO.setCardIcon(cardTypeEntity.getCardIcon());
            organCardListRespVO.setCardTypeCode(cardTypeEntity.getCardTypeCode());
            organCardListRespVO.setCardTypeName(cardTypeEntity.getCardTypeName());
            organCardListRespVO.setNotice(cardTypeEntity.getNotice());
            organCardListRespVO.setOrganCode(cardTypeEntity.getOrganCode());
            organCardListRespVO.setCardMethodName(cardTypeEntity.getCardMethodName());
            organCardLists.add(organCardListRespVO);
        }
        return BaseResponse.success(organCardLists);
    }

    public BaseResponse<BackOrganCardTypeRespVO> addOrganCardType(BackOrganCardTypeReqVO reqVO) {
        HospitalAddCardTypeEntity entity = new HospitalAddCardTypeEntity();
        entity.setOrganCode(reqVO.getOrganCode());
        entity.setCardDesc(reqVO.getCardDesc());
        entity.setCardIcon(reqVO.getCardIcon());
        entity.setCardMethodName(reqVO.getCardMethodName());
        entity.setCardTypeName(reqVO.getCardTypeName());
        entity.setCardTypeCode(reqVO.getCardTypeCode());
        entity.setNotice(reqVO.getNotice());
        entity.setStatus(Boolean.FALSE);
        this.cardTypeRepository.save((Object)entity);
        log.info("\u673a\u6784\u7ed1\u5361\u65b9\u5f0f\u6dfb\u52a0\u6210\u529f,\u673a\u6784\u65b9\u5f0f\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)entity));
        BackOrganCardTypeRespVO organAddCardTypeRespVO = this.buildOrganAddCardTypeRespVO(entity);
        return BaseResponse.success((Object)organAddCardTypeRespVO);
    }

    public BaseResponse<BackOrganCardTypeRespVO> updateOrganCardType(BackOrganCardTypeReqVO reqVO) {
        Optional entityOp = this.cardTypeRepository.findByOrganCodeAndCardTypeCode(reqVO.getOrganCode(), reqVO.getCardTypeCode());
        if (!entityOp.isPresent()) {
            log.warn("\u672a\u67e5\u8be2\u5230\u8be5\u673a\u6784\u7ed1\u5361\u914d\u7f6e\uff0c\u673a\u6784\u7f16\u7801 = {}\uff0c\u5361\u7c7b\u578b\u7f16\u7801 = {}", (Object)reqVO.getOrganCode(), (Object)reqVO.getCardTypeCode());
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST, (String)"\u672a\u67e5\u8be2\u5230\u8be5\u673a\u6784\u8be5\u5361\u65b9\u5f0f\u914d\u7f6e");
        }
        HospitalAddCardTypeEntity hospitalAddCardTypeEntity = (HospitalAddCardTypeEntity)entityOp.get();
        hospitalAddCardTypeEntity.setNotice(reqVO.getNotice());
        hospitalAddCardTypeEntity.setCardDesc(reqVO.getCardDesc());
        hospitalAddCardTypeEntity.setCardIcon(reqVO.getCardIcon());
        hospitalAddCardTypeEntity.setCardTypeName(reqVO.getCardTypeName());
        hospitalAddCardTypeEntity.setCardMethodName(reqVO.getCardMethodName());
        hospitalAddCardTypeEntity.setStatus(reqVO.getStatus() == 0 ? Boolean.FALSE : Boolean.TRUE);
        this.cardTypeRepository.save((Object)hospitalAddCardTypeEntity);
        log.info("\u673a\u6784\u7ed1\u5361\u65b9\u5f0f\u4fee\u6539\u6210\u529f , \u4fe1\u606f\u66f4\u65b0 \uff0c\u6700\u65b0\u673a\u6784\u65b9\u5f0f\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)hospitalAddCardTypeEntity));
        BackOrganCardTypeRespVO organAddCardTypeRespVO = this.buildOrganAddCardTypeRespVO(hospitalAddCardTypeEntity);
        return BaseResponse.success((Object)organAddCardTypeRespVO);
    }

    private List<BackOrganCardTypeRespVO> buildRespContent(List<HospitalAddCardTypeEntity> entityList) {
        ArrayList<BackOrganCardTypeRespVO> respVOList = new ArrayList<BackOrganCardTypeRespVO>();
        for (HospitalAddCardTypeEntity entity : entityList) {
            BackOrganCardTypeRespVO backOrganCardTypeRespVO = new BackOrganCardTypeRespVO();
            backOrganCardTypeRespVO.setStatus(entity.getStatus());
            backOrganCardTypeRespVO.setCardIcon(entity.getCardIcon());
            backOrganCardTypeRespVO.setCardDesc(entity.getCardDesc());
            backOrganCardTypeRespVO.setCardMethodName(entity.getCardMethodName());
            backOrganCardTypeRespVO.setCardTypeCode(entity.getCardTypeCode());
            backOrganCardTypeRespVO.setCardTypeName(entity.getCardTypeName());
            backOrganCardTypeRespVO.setNotice(entity.getNotice());
            backOrganCardTypeRespVO.setOrganCode(entity.getOrganCode());
            respVOList.add(backOrganCardTypeRespVO);
        }
        return respVOList;
    }

    private BackOrganCardTypeRespVO buildOrganAddCardTypeRespVO(HospitalAddCardTypeEntity entity) {
        BackOrganCardTypeRespVO respVO = new BackOrganCardTypeRespVO();
        respVO.setCardTypeCode(entity.getCardTypeCode());
        respVO.setCardDesc(entity.getCardDesc());
        respVO.setCardIcon(entity.getCardIcon());
        respVO.setCardMethodName(entity.getCardMethodName());
        respVO.setCardTypeName(entity.getCardTypeName());
        respVO.setNotice(entity.getNotice());
        respVO.setOrganCode(entity.getOrganCode());
        respVO.setStatus(entity.getStatus());
        return respVO;
    }
}

