/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.card.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.card.common.model.PsPatientEntity;
import com.ebaiyihui.card.common.vo.PatientDiseasePictureVo;
import com.ebaiyihui.card.common.vo.PatientMedicalRecordDetailVO;
import com.ebaiyihui.card.common.vo.SavePatientMedicalRecordReqVO;
import com.ebaiyihui.card.common.vo.ServicePkgPatientMedicalRecordReqVo;
import com.ebaiyihui.card.common.vo.ServicePkgPatientMedicalRecordResVo;
import com.ebaiyihui.card.server.common.MedicalPictureTypeEnum;
import com.ebaiyihui.card.server.pojo.entity.PatientMedicalPictureEntity;
import com.ebaiyihui.card.server.pojo.entity.PatientMedicalRecordEntity;
import com.ebaiyihui.card.server.repository.IPatientInfoMapper;
import com.ebaiyihui.card.server.repository.PatientMedicalPictureMapper;
import com.ebaiyihui.card.server.repository.PatientMedicalRecordMapper;
import com.ebaiyihui.card.server.service.PatientMedicalRecordService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PatientMedicalRecordServiceImpl
implements PatientMedicalRecordService {
    private static final Logger log = LoggerFactory.getLogger(PatientMedicalRecordServiceImpl.class);
    @Autowired
    private PatientMedicalRecordMapper patientMedicalRecordMapper;
    @Autowired
    private PatientMedicalPictureMapper patientMedicalPictureMapper;
    @Autowired
    private IPatientInfoMapper patientInfoMapper;

    public List<ServicePkgPatientMedicalRecordResVo> getServicePkgPatientMedicalRecordList(ServicePkgPatientMedicalRecordReqVo servicePkgPatientMedicalRecordReqVo) {
        List servicePkgPatientMedicalRecordResVoList = this.patientMedicalRecordMapper.getServicePkgPatientMedicalRecordList(servicePkgPatientMedicalRecordReqVo);
        return servicePkgPatientMedicalRecordResVoList;
    }

    public PatientMedicalRecordDetailVO getPatientMedicalRecordDetailById(Long id) {
        PatientMedicalRecordEntity patientMedicalRecordEntity = this.patientMedicalRecordMapper.selectByPrimaryKey(id);
        PatientMedicalRecordDetailVO patientMedicalRecordDetailVO = new PatientMedicalRecordDetailVO();
        BeanUtils.copyProperties((Object)patientMedicalRecordEntity, (Object)patientMedicalRecordDetailVO);
        List patientMedicalPictureEntityList = this.patientMedicalPictureMapper.getPatientMedicalPictureByMedicalRecordId(id);
        if (CollectionUtils.isEmpty((Collection)patientMedicalPictureEntityList)) {
            return patientMedicalRecordDetailVO;
        }
        Map<Integer, List<PatientMedicalPictureEntity>> patientMedicalPictureEntityMap = patientMedicalPictureEntityList.stream().collect(Collectors.groupingBy(PatientMedicalPictureEntity::getMedicalPictureType));
        patientMedicalPictureEntityMap.keySet().forEach(medicalPictureType -> {
            if (MedicalPictureTypeEnum.DISEASE_PICTURE_TYPE.getValue().equals(medicalPictureType)) {
                List patientDiseasePictureVoList = this.getPatientDiseasePictureVoList(patientMedicalPictureEntityMap, medicalPictureType);
                patientMedicalRecordDetailVO.setPatientDiseasePictureVoList(patientDiseasePictureVoList);
            }
        });
        return patientMedicalRecordDetailVO;
    }

    public Long savePatientMedicalRecord(SavePatientMedicalRecordReqVO patientMedicalRecordReqVO) {
        log.info("\u4fdd\u5b58\u60a3\u8005\u75c5\u4f8b\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)patientMedicalRecordReqVO));
        PatientMedicalRecordEntity patientMedicalRecordEntity = new PatientMedicalRecordEntity();
        BeanUtils.copyProperties((Object)patientMedicalRecordReqVO, (Object)patientMedicalRecordEntity);
        PsPatientEntity psPatientEntity = this.patientInfoMapper.findByPatientId(patientMedicalRecordReqVO.getPatientId());
        patientMedicalRecordEntity.setPatientIdCard(psPatientEntity.getCredNo());
        patientMedicalRecordEntity.setPatientName(psPatientEntity.getPatientName());
        this.patientMedicalRecordMapper.insertSelective(patientMedicalRecordEntity);
        List patientDiseasePictureVoList = patientMedicalRecordReqVO.getPatientDiseasePictureVoList();
        if (!patientDiseasePictureVoList.isEmpty()) {
            patientDiseasePictureVoList.forEach(patientDiseasePictureVo -> {
                PatientMedicalPictureEntity patientMedicalPictureEntity = new PatientMedicalPictureEntity();
                BeanUtils.copyProperties((Object)patientDiseasePictureVo, (Object)patientMedicalPictureEntity);
                patientMedicalPictureEntity.setMedicalRecordId(patientMedicalRecordEntity.getId());
                this.patientMedicalPictureMapper.insertSelective(patientMedicalPictureEntity);
            });
        }
        return patientMedicalRecordEntity.getId();
    }

    private List<PatientDiseasePictureVo> getPatientDiseasePictureVoList(Map<Integer, List<PatientMedicalPictureEntity>> patientMedicalPictureEntityMap, Integer medicalPictureType) {
        List<PatientMedicalPictureEntity> patientDiseasePictureEntityList = patientMedicalPictureEntityMap.get(medicalPictureType);
        return patientDiseasePictureEntityList.stream().map(patientMedicalPictureEntity -> {
            PatientDiseasePictureVo patientDiseasePictureVo = new PatientDiseasePictureVo();
            BeanUtils.copyProperties((Object)patientMedicalPictureEntity, (Object)patientDiseasePictureVo);
            patientDiseasePictureVo.setMedicalPictureTypeName(MedicalPictureTypeEnum.DISEASE_PICTURE_TYPE.getDisplay());
            return patientDiseasePictureVo;
        }).collect(Collectors.toList());
    }
}

