/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.card.server.task;

import com.ebaiyihui.card.server.pojo.entity.PatientBlacklist;
import com.ebaiyihui.card.server.repository.PatientBlacklistBusinessMapper;
import com.ebaiyihui.card.server.repository.PatientBlacklistMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class BlacklistRemoveTask {
    private static final Logger log = LoggerFactory.getLogger(BlacklistRemoveTask.class);
    @Autowired
    private PatientBlacklistMapper patientBlacklistMapper;
    @Autowired
    private PatientBlacklistBusinessMapper patientBlacklistBusinessMapper;

    @Scheduled(cron="10 6 1 * * ?")
    public void destroyPressureEnvGroup() {
        List patientBlacklistList = this.patientBlacklistMapper.getRemoveBlacklistList();
        if (patientBlacklistList == null && patientBlacklistList.size() <= 0) {
            return;
        }
        for (PatientBlacklist patientBlacklist : patientBlacklistList) {
            Long patientBlacklistId = patientBlacklist.getId();
            this.patientBlacklistBusinessMapper.deleteByPatientBlacklistId(patientBlacklistId);
            this.patientBlacklistMapper.deleteByPrimaryKey(patientBlacklistId);
        }
    }
}

