/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.card.server.logback.fs;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.card.server.logback.MessageManager;
import com.ebaiyihui.card.server.logback.TextMessage;
import com.ebaiyihui.card.server.logback.fs.FeiShuMessage;
import com.ebaiyihui.card.server.logback.fs.FsAlarmService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class FeiShuAlarm
implements FsAlarmService {
    private static final Logger log = LoggerFactory.getLogger(FeiShuAlarm.class);
    private String webHookUrl;
    private ExecutorService executor;

    public FeiShuAlarm() {
    }

    public FeiShuAlarm(String webHookUrl) {
        this.webHookUrl = webHookUrl;
        this.executor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("feishu-thread-executor-"));
    }

    private FeiShuMessage buildParam(String messageText) {
        FeiShuMessage message = new FeiShuMessage();
        message.setMsg_type("text");
        TextMessage textMessage = new TextMessage();
        textMessage.setText(messageText);
        JSONObject text = JSONObject.parseObject((String)JSONObject.toJSONString((Object)textMessage));
        message.setContent(text);
        return message;
    }

    public boolean alarm(String messageText) {
        this.executor.execute(() -> {
            try {
                FeiShuMessage message = this.buildParam(messageText);
                MessageManager.sendFeiShuMessage((FeiShuMessage)message, (String)this.webHookUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return true;
    }
}

