/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.card.server.service.impl;

import com.ebaiyihui.card.common.enums.PatientErrorEnum;
import com.ebaiyihui.card.common.model.PsPatientEntity;
import com.ebaiyihui.card.common.model.PsPatientHospitalRelationEntity;
import com.ebaiyihui.card.common.vo.BasePatientRespVO;
import com.ebaiyihui.card.common.vo.GetPatientInfoByCrednoAndTypeReqVO;
import com.ebaiyihui.card.common.vo.GetPatientInfoByCrednoReqVO;
import com.ebaiyihui.card.common.vo.PatientInfoListReqVO;
import com.ebaiyihui.card.common.vo.PatientInfoListRespVO;
import com.ebaiyihui.card.common.vo.PatientInfoReqVO;
import com.ebaiyihui.card.common.vo.PatientInfoRespVO;
import com.ebaiyihui.card.common.vo.SavePatientInfoReqVo;
import com.ebaiyihui.card.common.vo.UpdatePatientInfoReqVO;
import com.ebaiyihui.card.server.repository.IPatientHospitalRelationMapper;
import com.ebaiyihui.card.server.repository.IPatientInfoMapper;
import com.ebaiyihui.card.server.service.IPatienInfoService;
import com.ebaiyihui.card.server.util.DateUtils;
import com.ebaiyihui.card.server.util.SnowflakeIdWorker;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.JsonUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PatientInfoServiceImpl
implements IPatienInfoService {
    private static final Logger log = LoggerFactory.getLogger(PatientInfoServiceImpl.class);
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private IPatientInfoMapper iPatientInfoDao;
    @Autowired
    private IPatientHospitalRelationMapper iPatientHospitalRelationDao;

    public BaseResponse<BasePatientRespVO> updatePatientInfo(UpdatePatientInfoReqVO updatePatientInfoReqVO) {
        String credNo = updatePatientInfoReqVO.getCredNo();
        String credTypeCode = updatePatientInfoReqVO.getCredTypeCode();
        String tel = updatePatientInfoReqVO.getContactMobile();
        String patientId = updatePatientInfoReqVO.getPatientId();
        String hospitalId = updatePatientInfoReqVO.getHospitalId();
        String appCode = updatePatientInfoReqVO.getAppCode();
        PsPatientEntity patientEntityOptional = this.iPatientInfoDao.findByPatientId(patientId);
        if (null == patientEntityOptional) {
            log.warn("\u4fee\u6539\u60a3\u8005\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u60a3\u8005\u4e0d\u5b58\u5728\uff0c\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)updatePatientInfoReqVO));
            return BaseResponse.error((IError)PatientErrorEnum.PATIENT_NOT_EXIT, (String)"\u60a3\u8005\u4e0d\u5b58\u5728");
        }
        PsPatientHospitalRelationEntity psPatientHospitalRelationEntity = this.iPatientHospitalRelationDao.findByPatientId(patientId, hospitalId, appCode);
        if (null == psPatientHospitalRelationEntity) {
            log.warn("\u4fee\u6539\u60a3\u8005\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u60a3\u8005\u4e0d\u5b58\u5728\uff0c\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)updatePatientInfoReqVO));
            return BaseResponse.error((IError)PatientErrorEnum.PATIENT_NOT_EXIT, (String)"\u60a3\u8005\u4e0d\u5b58\u5728");
        }
        PsPatientEntity patientEntity = patientEntityOptional;
        Boolean flag = this.cheekPatientInfoUpdate(updatePatientInfoReqVO, patientEntity);
        if (flag.booleanValue()) {
            log.warn("\u4fee\u6539\u60a3\u8005\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8d44\u6599\u672a\u505a\u4fee\u6539\uff0c\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)updatePatientInfoReqVO));
            return BaseResponse.error((IError)PatientErrorEnum.INFO_NOT_UPDATE, (String)"\u8d44\u6599\u672a\u505a\u4fee\u6539");
        }
        PsPatientEntity psPatientEntity = this.iPatientInfoDao.findByCredNoAndCredTypeCode(credNo, credTypeCode);
        if (psPatientEntity != null && !patientId.equals(psPatientEntity.getPatientId())) {
            log.warn("\u4fee\u6539\u60a3\u8005\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bc1\u4ef6\u53f7\u88ab\u5360\u7528\uff0c\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)updatePatientInfoReqVO));
            return BaseResponse.error((IError)PatientErrorEnum.CREDNO_EXIT, (String)"\u8bc1\u4ef6\u53f7\u88ab\u5360\u7528");
        }
        patientEntity = this.biuldPsPatientEntity(updatePatientInfoReqVO, patientEntity);
        this.iPatientInfoDao.update(patientEntity);
        BasePatientRespVO data = new BasePatientRespVO();
        data.setPatientId(patientId);
        return BaseResponse.success((Object)data);
    }

    private PsPatientEntity biuldPsPatientEntity(UpdatePatientInfoReqVO updatePatientInfoReqVO, PsPatientEntity patientEntity) {
        patientEntity.setCityAreaCode(updatePatientInfoReqVO.getCityAreaCode());
        patientEntity.setCityCode(updatePatientInfoReqVO.getCityCode());
        patientEntity.setProvinceCode(updatePatientInfoReqVO.getProvinceCode());
        patientEntity.setCredNo(updatePatientInfoReqVO.getCredNo());
        patientEntity.setCredTypeCode(updatePatientInfoReqVO.getCredTypeCode());
        patientEntity.setNationCode(updatePatientInfoReqVO.getNation());
        patientEntity.setDob(updatePatientInfoReqVO.getBirthdate());
        patientEntity.setOccupationCode(updatePatientInfoReqVO.getOccupationCode());
        patientEntity.setPatientName(updatePatientInfoReqVO.getName());
        patientEntity.setTel(updatePatientInfoReqVO.getContactMobile());
        patientEntity.setSexCode(updatePatientInfoReqVO.getGender());
        String address = updatePatientInfoReqVO.getDetailAddress();
        if (!StringUtils.isEmpty((Object)address)) {
            patientEntity.setDetailAddress(updatePatientInfoReqVO.getDetailAddress());
        }
        return patientEntity;
    }

    private Boolean cheekPatientInfoUpdate(UpdatePatientInfoReqVO updatePatientInfoReqVO, PsPatientEntity patientEntity) {
        Boolean flag = false;
        String address = updatePatientInfoReqVO.getDetailAddress();
        String detailAddress = patientEntity.getDetailAddress();
        if (!updatePatientInfoReqVO.getName().equals(patientEntity.getPatientName())) {
            return flag;
        }
        if (!updatePatientInfoReqVO.getCityAreaCode().equals(patientEntity.getCityAreaCode())) {
            return flag;
        }
        if (!updatePatientInfoReqVO.getCityCode().equals(patientEntity.getCityCode())) {
            return flag;
        }
        if (!updatePatientInfoReqVO.getProvinceCode().equals(patientEntity.getProvinceCode())) {
            return flag;
        }
        if (!updatePatientInfoReqVO.getCredNo().equals(patientEntity.getCredNo())) {
            return flag;
        }
        if (!updatePatientInfoReqVO.getCredTypeCode().equals(patientEntity.getCredTypeCode())) {
            return flag;
        }
        if (!updatePatientInfoReqVO.getNation().equals(patientEntity.getNationCode())) {
            return flag;
        }
        if (!updatePatientInfoReqVO.getBirthdate().equals(patientEntity.getDob())) {
            return flag;
        }
        if (!updatePatientInfoReqVO.getGender().equals(patientEntity.getSexCode())) {
            return flag;
        }
        if (!updatePatientInfoReqVO.getContactMobile().equals(patientEntity.getTel())) {
            return flag;
        }
        if (!updatePatientInfoReqVO.getOccupationCode().equals(patientEntity.getOccupationCode())) {
            return flag;
        }
        if (!StringUtils.isEmpty((Object)address) && !StringUtils.isEmpty((Object)detailAddress) ? !address.equals(detailAddress) : !StringUtils.isEmpty((Object)address) && StringUtils.isEmpty((Object)detailAddress) || StringUtils.isEmpty((Object)address) && !StringUtils.isEmpty((Object)detailAddress)) {
            return flag;
        }
        flag = true;
        return flag;
    }

    public BaseResponse<PatientInfoRespVO> findPatientInfo(PatientInfoReqVO reqVO) {
        return this.getPatientInfoResp(reqVO.getPatientId(), reqVO.getHospitalId(), reqVO.getAppCode());
    }

    private BaseResponse<PatientInfoRespVO> getPatientInfoResp(String patientId, String hospitalId, String appCode) {
        PsPatientEntity patientEntityOptional = this.iPatientInfoDao.findByPatientId(patientId);
        if (null == patientEntityOptional) {
            return BaseResponse.error((IError)PatientErrorEnum.PATIENT_NOT_EXIT);
        }
        if (!StringUtils.isEmpty((Object)hospitalId)) {
            PsPatientHospitalRelationEntity psPatientHospitalRelationEntity = this.iPatientHospitalRelationDao.findByPatientId(patientId, hospitalId, appCode);
            log.info("\u6839\u636e\u60a3\u8005id\uff0chospitalid,appcode\u67e5\u8be2\u5173\u8054\u8868\u4e2d\u6570\u636e\u4e3a[{}]", (Object)psPatientHospitalRelationEntity);
            if (null == psPatientHospitalRelationEntity) {
                PsPatientHospitalRelationEntity entity = new PsPatientHospitalRelationEntity();
                entity.setAppCode(appCode);
                entity.setHospitalId(hospitalId);
                entity.setPatientId(patientId);
                this.iPatientHospitalRelationDao.save(entity);
            }
        }
        PatientInfoRespVO respData = this.getPatientInfoRespVO(patientEntityOptional);
        log.info("\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u6210\u529f\uff0c\u8fd4\u56de={}", (Object)respData);
        return BaseResponse.success((Object)respData);
    }

    private String birthdayToAge(Date dob) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(dob.toInstant(), ZoneId.systemDefault());
        LocalDate localDate = LocalDate.from(localDateTime);
        Period period = localDate.until(LocalDate.now());
        StringBuilder sb = new StringBuilder();
        int years = period.getYears();
        if (years <= 0) {
            int months = period.getMonths();
            if (months <= 0) {
                int days = period.getDays();
                sb.append(days);
                sb.append("\u5929");
            } else {
                sb.append(months);
                sb.append("\u6708");
            }
        } else {
            sb.append(years);
            sb.append("\u5c81");
        }
        return sb.toString();
    }

    public BaseResponse<List<PatientInfoListRespVO>> listPatientInfo(PatientInfoListReqVO reqVO) {
        String ids = "";
        for (String id : reqVO.getPatientIds()) {
            ids = ids + id + ",";
        }
        List psPatientList = this.iPatientInfoDao.findByIds(ids = ids.substring(0, ids.length() - 1));
        if (CollectionUtils.isEmpty((Collection)psPatientList)) {
            BaseResponse.success(new ArrayList());
        }
        psPatientList.forEach(e -> {
            PsPatientHospitalRelationEntity psPatientHospitalRelationEntity = this.iPatientHospitalRelationDao.findByPatientId(e.getPatientId(), reqVO.getHospitalId(), reqVO.getAppCode());
            if (null == psPatientHospitalRelationEntity) {
                PsPatientHospitalRelationEntity entity = new PsPatientHospitalRelationEntity();
                entity.setAppCode(reqVO.getAppCode());
                entity.setHospitalId(reqVO.getHospitalId());
                entity.setPatientId(e.getPatientId());
                this.iPatientHospitalRelationDao.save(entity);
            }
        });
        List psPatientHospitalRelationList = this.iPatientHospitalRelationDao.findByIds(ids, reqVO.getHospitalId(), reqVO.getAppCode());
        log.info("\u6839\u636e\u60a3\u8005id\uff0c\u533b\u9662id\uff0cappcode\u67e5\u8be2,\u67e5\u8be2\u7ed3\u679c\u4e3a:[{}]", (Object)psPatientHospitalRelationList);
        if (CollectionUtils.isEmpty((Collection)psPatientHospitalRelationList)) {
            BaseResponse.success(new ArrayList());
        }
        List filteredPsPatientList = psPatientList.stream().filter(e -> !psPatientHospitalRelationList.contains(e.getPatientId())).collect(Collectors.toList());
        Function mapper = this.getPatientInfoListMap();
        List data = filteredPsPatientList.stream().map(mapper).collect(Collectors.toList());
        log.info("\u67e5\u8be2\u6210\u529f\uff0c\u8bf7\u6c42={}\uff0c\u8fd4\u56de={}", (Object)reqVO, (Object)Arrays.toString(data.toArray()));
        return BaseResponse.success(data);
    }

    public BaseResponse<BasePatientRespVO> savePatientInfo(SavePatientInfoReqVo reqVO) {
        PsPatientEntity patientEntityBeforeSave = this.iPatientInfoDao.findByCredNoAndCredTypeCode(reqVO.getCredNo(), reqVO.getCredTypeCode());
        if (null != patientEntityBeforeSave) {
            patientEntityBeforeSave.setTel(reqVO.getContactMobile());
            this.iPatientInfoDao.update(patientEntityBeforeSave);
            String patientId = patientEntityBeforeSave.getPatientId();
            PsPatientHospitalRelationEntity psPatientHospitalRelationEntity = this.iPatientHospitalRelationDao.findByPatientId(patientId, reqVO.getHospitalId(), reqVO.getAppCode());
            log.info("\u6839\u636e\u60a3\u8005id\uff0chospitalid,appcode\u67e5\u8be2\u5173\u8054\u8868\u4e2d\u6570\u636e\u4e3a[{}]", (Object)psPatientHospitalRelationEntity);
            if (null != psPatientHospitalRelationEntity) {
                log.info("\u4fdd\u5b58\u60a3\u8005\u7684\u8bc1\u4ef6\u53f7\u548c\u8bc1\u4ef6\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728,SavePatientInfoReqVo[{}]", (Object)reqVO);
                BasePatientRespVO basePatientRespVO = this.buildBasePatientRespVO(patientEntityBeforeSave);
                return BaseResponse.success((Object)basePatientRespVO);
            }
            PsPatientHospitalRelationEntity psPatientHospitalRelation = this.buildPsPatientHospitalRelationEntity(patientId, reqVO.getHospitalId(), reqVO.getAppCode());
            this.iPatientHospitalRelationDao.save(psPatientHospitalRelation);
            BasePatientRespVO basePatientRespVO = this.buildBasePatientRespVO(patientEntityBeforeSave);
            return BaseResponse.success((Object)basePatientRespVO);
        }
        PsPatientEntity patientEntity = this.getPsPatientEntity(reqVO);
        PsPatientHospitalRelationEntity psPatientHospitalRelation = this.buildPsPatientHospitalRelationEntity(patientEntity.getPatientId(), reqVO.getHospitalId(), reqVO.getAppCode());
        this.iPatientInfoDao.save(patientEntity);
        this.iPatientHospitalRelationDao.save(psPatientHospitalRelation);
        PsPatientEntity psPatient = patientEntity;
        BasePatientRespVO basePatientRespVO = this.buildBasePatientRespVO(psPatient);
        return BaseResponse.success((Object)basePatientRespVO);
    }

    private BasePatientRespVO buildBasePatientRespVO(PsPatientEntity psPatientEntity) {
        BasePatientRespVO basePatientRespVO = new BasePatientRespVO();
        basePatientRespVO.setPatientId(psPatientEntity.getPatientId());
        basePatientRespVO.setContactMobile(psPatientEntity.getTel());
        basePatientRespVO.setGender(psPatientEntity.getSexCode());
        basePatientRespVO.setName(psPatientEntity.getPatientName());
        return basePatientRespVO;
    }

    private PsPatientHospitalRelationEntity buildPsPatientHospitalRelationEntity(String patientId, String hospitalId, String appCode) {
        PsPatientHospitalRelationEntity psPatientHospitalRelationEntity = new PsPatientHospitalRelationEntity();
        psPatientHospitalRelationEntity.setPatientId(patientId);
        psPatientHospitalRelationEntity.setHospitalId(hospitalId);
        psPatientHospitalRelationEntity.setAppCode(appCode);
        return psPatientHospitalRelationEntity;
    }

    private PsPatientEntity getPsPatientEntity(SavePatientInfoReqVo reqVO) {
        PsPatientEntity patientEntity = new PsPatientEntity();
        patientEntity.setCredTypeCode(reqVO.getCredTypeCode());
        patientEntity.setCredNo(reqVO.getCredNo());
        patientEntity.setCityAreaCode(reqVO.getCityAreaCode());
        patientEntity.setCityCode(reqVO.getCityCode());
        patientEntity.setDetailAddress(reqVO.getDetailAddress());
        patientEntity.setDob(reqVO.getBirthdate());
        patientEntity.setNationCode(reqVO.getNation());
        patientEntity.setOccupationCode(reqVO.getOccupationCode());
        patientEntity.setPatientName(reqVO.getName());
        patientEntity.setProvinceCode(reqVO.getProvinceCode());
        patientEntity.setRegisterSource(reqVO.getChannelCode());
        patientEntity.setSexCode(reqVO.getGender());
        patientEntity.setTel(reqVO.getContactMobile());
        patientEntity.setPatientId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return patientEntity;
    }

    private PsPatientEntity getPsPatientEntityByCredNo(String credNo, String credTypeCode) {
        return this.iPatientInfoDao.findByCredNoAndCredTypeCode(credNo, credTypeCode);
    }

    public BaseResponse<PatientInfoRespVO> getPatientInfoBycredNo(GetPatientInfoByCrednoReqVO reqVO) {
        PsPatientEntity patientEntity = this.iPatientInfoDao.findByCredNoAndCredTypeCode(reqVO.getCredNo(), reqVO.getCredTypeCode());
        if (null == patientEntity) {
            return BaseResponse.error((IError)PatientErrorEnum.PATIENT_NOT_EXIT);
        }
        String patientId = patientEntity.getPatientId();
        PsPatientHospitalRelationEntity psPatientHospitalRelationEntity = this.iPatientHospitalRelationDao.findByPatientId(patientId, reqVO.getHospitalId(), reqVO.getAppCode());
        log.info("\u6839\u636e\u60a3\u8005id\uff0chospitalid,appcode\u67e5\u8be2\u5173\u8054\u8868\u4e2d\u6570\u636e\u4e3a[{}]", (Object)psPatientHospitalRelationEntity);
        if (null == psPatientHospitalRelationEntity) {
            return BaseResponse.error((IError)PatientErrorEnum.PATIENT_NOT_EXIT);
        }
        PatientInfoRespVO respVO = this.getPatientInfoRespVO(patientEntity);
        log.info("\u6839\u636e\u8bc1\u4ef6\u548c\u8bc1\u4ef6\u7c7b\u578b\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u6210\u529f\uff0c\u8fd4\u56de={}", (Object)respVO);
        return BaseResponse.success((Object)respVO);
    }

    public BaseResponse<PatientInfoRespVO> getpatientinfobycrednoAndType(GetPatientInfoByCrednoAndTypeReqVO reqVO) {
        PsPatientEntity patientEntity = this.iPatientInfoDao.findByCredNoAndCredTypeCode(reqVO.getCredNo(), reqVO.getCredTypeCode());
        if (null == patientEntity) {
            return BaseResponse.error((IError)PatientErrorEnum.PATIENT_NOT_EXIT);
        }
        PatientInfoRespVO respVO = this.getPatientInfoRespVO(patientEntity);
        log.info("\u6839\u636e\u8bc1\u4ef6\u548c\u8bc1\u4ef6\u7c7b\u578b\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u6210\u529f\uff0c\u8fd4\u56de={}", (Object)respVO);
        return BaseResponse.success((Object)respVO);
    }

    public BaseResponse<String> getPhoneByPatientId(String patientId) {
        PsPatientEntity psPatientEntity = this.iPatientInfoDao.findByPatientId(patientId);
        if (psPatientEntity == null) {
            BaseResponse.error((String)"\u6839\u636e\u60a3\u8005id\u672a\u67e5\u8be2\u5230\u6539\u60a3\u8005\u4fe1\u606f");
        }
        String tel = psPatientEntity.getTel();
        return BaseResponse.success((Object)tel);
    }

    private PatientInfoRespVO getPatientInfoRespVO(PsPatientEntity patientEntity) {
        PatientInfoRespVO respVO = new PatientInfoRespVO();
        respVO.setCityAreaCode(patientEntity.getCityAreaCode() == null ? null : patientEntity.getCityAreaCode());
        respVO.setCityCode(patientEntity.getCityCode() == null ? null : patientEntity.getCityCode());
        respVO.setContactMobile(patientEntity.getTel() == null ? null : patientEntity.getTel());
        respVO.setCredNo(patientEntity.getCredNo() == null ? null : patientEntity.getCredNo());
        respVO.setCredTypeCode(patientEntity.getCredTypeCode() == null ? null : patientEntity.getCredTypeCode());
        respVO.setDetailAddress(patientEntity.getDetailAddress() == null ? null : patientEntity.getDetailAddress());
        respVO.setGender(patientEntity.getSexCode() == null ? null : patientEntity.getSexCode());
        respVO.setName(patientEntity.getPatientName() == null ? null : patientEntity.getPatientName());
        respVO.setNation(patientEntity.getNationCode() == null ? null : patientEntity.getNationCode());
        respVO.setOccupationCode(patientEntity.getOccupationCode() == null ? null : patientEntity.getOccupationCode());
        respVO.setPatientId(patientEntity.getPatientId() == null ? null : patientEntity.getPatientId());
        respVO.setProvinceCode(patientEntity.getProvinceCode() == null ? null : patientEntity.getProvinceCode());
        respVO.setRegisterSource(patientEntity.getRegisterSource() == null ? null : patientEntity.getRegisterSource());
        respVO.setBirthdate(patientEntity.getDob() == null ? null : DateUtils.formatDateDefault((Date)patientEntity.getDob()));
        respVO.setAge(patientEntity.getDob() == null ? null : this.birthdayToAge(patientEntity.getDob()));
        return respVO;
    }

    private Function<PsPatientEntity, PatientInfoListRespVO> getPatientInfoListMap() {
        return pe -> {
            PatientInfoListRespVO respVO = new PatientInfoListRespVO();
            String credNo = pe.getCredNo();
            respVO.setCredNo(credNo);
            String credType = pe.getCredTypeCode();
            respVO.setCredTypeCode(credType);
            String patientId = pe.getPatientId();
            respVO.setPatientId(patientId);
            String patientName = pe.getPatientName();
            respVO.setName(patientName);
            respVO.setGender(pe.getSexCode());
            respVO.setTel(pe.getTel());
            if (pe.getDob() != null) {
                respVO.setBirthDate(DateUtils.formatDateDefault((Date)pe.getDob()));
                String age = this.birthdayToAge(pe.getDob());
                respVO.setAge(age);
            }
            return respVO;
        };
    }
}

