/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonStringUtils {
    public static boolean isBlank(Object ... objects) {
        Boolean result = false;
        for (Object object : objects) {
            if (null != object && !"".equals(object.toString().trim()) && !"null".equals(object.toString().trim())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String cutLongStr(String str) {
        String result = str;
        if (str != null && str.length() >= 255) {
            result = str.substring(0, 120);
        }
        return result;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() <= 0 || str.equals("null");
    }

    public static boolean isEmptyList(List<?> list) {
        return list == null || list.size() <= 0;
    }

    public static <T> List<T> deepCopy(List<T> src) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(src);
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        ObjectInputStream in = new ObjectInputStream(byteIn);
        List dest = (List)in.readObject();
        return dest;
    }

    public static boolean HasDigit(String content) {
        boolean flag = false;
        Pattern p = Pattern.compile(".*\\d+.*");
        Matcher m = p.matcher(content);
        if (m.matches()) {
            flag = true;
        }
        return flag;
    }

    public static int getInt(String str) {
        if (CommonStringUtils.isNumeric(str)) {
            return Integer.parseInt(str);
        }
        String[] arr = str.split("[^0-9]");
        String s = "";
        for (int i = 0; i < arr.length; ++i) {
            s = s + arr[i];
        }
        return Integer.parseInt(s);
    }
}

