/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.invoice.utils.date;

import com.ebaiyihui.invoice.aop.execption.BusinessException;
import com.ebaiyihui.invoice.utils.date.enumerate.DateFormatEnum;
import com.ebaiyihui.invoice.utils.price.PriceUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    private static final Integer DAY_TIME_STAMP = 86400;

    public static Integer getDateTimeStampInteger() {
        return PriceUtil.getIntegerValue(DateUtil.getDateTimeStamp());
    }

    public static Long getDateTimeStamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static Integer getDateTimeByLongTime(Long time) {
        if (time == null) {
            return 0;
        }
        return PriceUtil.getIntegerValue(time / 1000L);
    }

    public static String getTimeStringByLongTime(long longTime, String pattern) {
        return DateUtil.getJavaDateStringByPhpTime(DateUtil.getDateTimeByLongTime(longTime), pattern);
    }

    public static String getCurrentDateStringByPattern(String pattern) {
        return DateUtil.getJavaDateStringByPattern(new Date(), pattern);
    }

    public static String getJavaDateStringByPhpTime(Integer phpTime, String pattern) {
        if (phpTime == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = DateFormatEnum.\u6760\u5e74\u6708\u65e5\u65f6\u5206\u79d2.getCode();
        }
        return new SimpleDateFormat(pattern).format(DateUtil.phpTimeToJavaTime(phpTime));
    }

    public static String getJavaDateStringByDateString(String dateString, String oldPattern, String newPattern) {
        if (StringUtils.isEmpty((CharSequence)dateString) || StringUtils.isEmpty((CharSequence)oldPattern)) {
            return "";
        }
        newPattern = StringUtils.isEmpty((CharSequence)newPattern) ? DateFormatEnum.\u6760\u5e74\u6708\u65e5\u65f6\u5206\u79d2.getCode() : newPattern;
        Date date = null;
        try {
            date = new SimpleDateFormat(oldPattern).parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new SimpleDateFormat(newPattern).format(date);
    }

    public static Date getDateByDateTimeString(String dateTimeString, String pattern) {
        if (StringUtils.isEmpty((CharSequence)dateTimeString)) {
            throw new BusinessException("500", "\u53c2\u6570\u4e3a\u7a7a");
        }
        pattern = StringUtils.isEmpty((CharSequence)pattern) ? DateFormatEnum.\u6760\u5e74\u6708\u65e5.getCode() : pattern;
        Date date = null;
        try {
            date = new SimpleDateFormat(pattern).parse(dateTimeString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date phpTimeToJavaTime(Integer phpTime) {
        if (phpTime == null || phpTime < 0) {
            return null;
        }
        long javaTimestamp = phpTime.longValue() * 1000L;
        return new Date(javaTimestamp);
    }

    public static String getJavaDateStringByPattern(Date date, String pattern) {
        if (null == date) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = DateFormatEnum.\u6760\u5e74\u6708\u65e5\u65f6\u5206\u79d2.getCode();
        }
        try {
            return new SimpleDateFormat(pattern).format(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Integer JavaTimeToPhpTime(Date date) {
        if (date == null) {
            return null;
        }
        long phpTimestamp = date.getTime() / 1000L;
        return PriceUtil.getIntegerValue(phpTimestamp);
    }

    public static Integer getDateBetweenDays(Date dateOne, Date dateTwo) {
        if (null == dateOne || null == dateTwo) {
            return 0;
        }
        int dateOneTime = DateUtil.JavaTimeToPhpTime(dateOne);
        int dateTwoTime = DateUtil.JavaTimeToPhpTime(dateTwo);
        return Math.abs((dateOneTime - dateTwoTime) / DAY_TIME_STAMP);
    }

    public static Integer getDateBetweenDays(String dateOne, String dateTwo) {
        if (StringUtils.isEmpty((CharSequence)dateOne) || StringUtils.isEmpty((CharSequence)dateTwo)) {
            return null;
        }
        return DateUtil.getDateBetweenDays(DateUtil.getDateByDateTimeString(dateOne, DateFormatEnum.\u6760\u5e74\u6708\u65e5.getCode()), DateUtil.getDateByDateTimeString(dateTwo, DateFormatEnum.\u6760\u5e74\u6708\u65e5.getCode()));
    }
}

