/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.invoice.utils.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

public class HttpUtil {
    public static final int DEFAULT_HTTP_CONNECTION_TIMEOUT = 50000;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 50000;
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    public static final int DEFAULT_MAX_PER_ROUTE = 20;
    public static final int MAX_TOTAL = 200;
    public static final String CHARSET_UTF8 = "UTF-8";
    private static final CloseableHttpClient httpClient = HttpUtil.getHttpClient();

    public static CloseableHttpClient getHttpClient() {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(HttpUtil.createIgnoreVerifySSL())).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(200);
        connManager.setDefaultMaxPerRoute(20);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(50000).setSocketTimeout(50000).build();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(requestConfig).build();
    }

    public static String doGet(String url, Header ... header) {
        return HttpUtil.doGet(url, new HashMap<String, Object>(), header);
    }

    public static String doGet(String url, Map<String, Object> params) {
        return HttpUtil.doRequest(url, MethodType.GET, params, new Header[0]);
    }

    public static String doGet(String url, Map<String, Object> params, Header ... header) {
        return HttpUtil.doRequest(url, MethodType.GET, params, header);
    }

    public static String doPost(String url, Header ... header) {
        return HttpUtil.doPost(url, new HashMap<String, Object>(), header);
    }

    public static String doPost(String url, Map<String, Object> params, Header ... header) {
        return HttpUtil.doRequest(url, MethodType.POST, params, header);
    }

    public static String doPost(String url, String text, Header ... header) {
        return HttpUtil.doPost(url, text, ContentType.APPLICATION_JSON, header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String text, ContentType contentType, Header ... header) {
        String result = null;
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity myEntity = new StringEntity(text, CHARSET_UTF8);
            if (contentType != null) {
                httpPost.addHeader("Content-Type", contentType.value());
            }
            if (header != null) {
                for (int i = 0; i < header.length; ++i) {
                    httpPost.addHeader(header[i]);
                }
            }
            httpPost.setEntity((HttpEntity)myEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = IOUtils.toString((InputStream)entity.getContent(), (String)CHARSET_UTF8);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static InputStream doPostFile(String url, String text, ContentType contentType, Header ... header) {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity myEntity = new StringEntity(text, CHARSET_UTF8);
            if (contentType != null) {
                httpPost.addHeader("Content-Type", contentType.value());
            }
            httpPost.setEntity((HttpEntity)myEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                return entity.getContent();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doRequest(String url, MethodType methodType, Map<String, Object> params, Header ... headers) {
        String apiUrl = url;
        if (methodType == MethodType.GET) {
            apiUrl = HttpUtil.mapToUrlString(url, params);
        }
        String result = null;
        CloseableHttpResponse response = null;
        try {
            switch (methodType) {
                case GET: {
                    HttpGet httpGet = new HttpGet(apiUrl);
                    if (headers != null) {
                        for (Header header : headers) {
                            httpGet.addHeader(header);
                        }
                    }
                    response = httpClient.execute((HttpUriRequest)httpGet);
                    break;
                }
                case POST: {
                    HttpPost httpPost = new HttpPost(apiUrl);
                    ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                        pairList.add(pair);
                    }
                    if (headers != null) {
                        for (Header header : headers) {
                            httpPost.addHeader(header);
                        }
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, StandardCharsets.UTF_8));
                    response = httpClient.execute((HttpUriRequest)httpPost);
                }
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = IOUtils.toString((InputStream)entity.getContent(), (String)CHARSET_UTF8);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private static String mapToUrlString(String url, Map<String, Object> map) {
        StringBuffer sb = null;
        if (map != null && map.size() > 0) {
            sb = new StringBuffer();
            Set<String> set = map.keySet();
            for (String s : set) {
                sb.append(s + "=" + map.get(s));
                sb.append("&");
            }
        }
        if (sb != null) {
            String pramas = sb.toString().substring(0, sb.length() - 1);
            url = url.lastIndexOf("?") == -1 ? url + "?" + pramas : url + "&" + pramas;
        }
        System.out.println("\u8bf7\u6c42\u8def\u5f84\u4e3a" + url);
        return url;
    }

    private static String mapToUrlParams(Map<String, String> map) {
        StringBuffer params = null;
        if (map != null && map.size() > 0) {
            params = new StringBuffer();
            Set<String> set = map.keySet();
            for (String s : set) {
                params.append(s).append("=").append(map.get(s));
                params.append("&");
            }
            return params.toString().substring(0, params.length() - 1);
        }
        return null;
    }

    public static SSLContext createIgnoreVerifySSL() {
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSLv3");
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            sc.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return sc;
    }

    public static Header createHeader(final String name, final String value) {
        return new Header(){

            public String getName() {
                return name;
            }

            public String getValue() {
                return value;
            }

            public HeaderElement[] getElements() throws ParseException {
                return new HeaderElement[0];
            }
        };
    }

    public static enum ContentType {
        WILDCARD("*/*"),
        APPLICATION_XML("application/xml"),
        APPLICATION_ATOM_XML("application/atom+xml"),
        APPLICATION_XHTML_XML("application/xhtml+xml"),
        APPLICATION_SVG_XML("application/svg+xml"),
        APPLICATION_JSON("application/json"),
        APPLICATION_FORM_URLENCODED("application/x-www-form-urlencoded"),
        MULTIPART_FORM_DATA("multipart/form-data"),
        APPLICATION_OCTET_STREAM("application/octet-stream");

        private String name;

        private ContentType(String name) {
            this.name = name;
        }

        public String value() {
            return this.name;
        }
    }

    public static enum MethodType {
        GET,
        POST;

    }
}

