/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.date.DateUtil;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.common.enums.DataSourceEnum;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.HospitalRegionEnum;
import com.ebaiyihui.his.common.enums.IdCardTypeEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.SexEnum;
import com.ebaiyihui.his.common.enums.TransNoEnum;
import com.ebaiyihui.his.pojo.dto.CreatePatientInfoReqDTO;
import com.ebaiyihui.his.pojo.dto.CreatePatientInfoResDTO;
import com.ebaiyihui.his.pojo.dto.QueryCardInfoItemResDTO;
import com.ebaiyihui.his.pojo.dto.QueryCardInfoReqDTO;
import com.ebaiyihui.his.pojo.dto.QueryCardInfoResDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.AddPatientFilingDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.AddPatientFilingReqDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.AddPatientFilingReqFilingDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.HisHeadDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.QueryPatientFilingDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.QueryPatientFilingReqDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.QueryPatientFilingReqSerachDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.AddPatientFilingResVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.AddPatientFilingVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.QueryPatientFilingResVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.QueryPatientFilingVO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoResVO;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardReqVO;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ICardService;
import com.ebaiyihui.his.utils.ObjectUtil;
import com.ebaiyihui.his.utils.SnowflakeIdWorker;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardServiceImpl
implements ICardService {
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;

    public FrontResponse<QueryCardInfoResVO> queryCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
        QueryCardInfoReqDTO cardInfoReqDTO = new QueryCardInfoReqDTO();
        cardInfoReqDTO.setCardNo(((QueryCardInfoReqVO)param.getBody()).getCardNo());
        cardInfoReqDTO.setIdNo(((QueryCardInfoReqVO)param.getBody()).getCredNo());
        cardInfoReqDTO.setPatientName(((QueryCardInfoReqVO)param.getBody()).getName());
        if (StringUtils.isBlank((CharSequence)queryCardInfoResVO.getCredNo()) && StringUtils.isBlank((CharSequence)queryCardInfoResVO.getGuardianIdNo())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u76d1\u62a4\u4eba\u8eab\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        cardInfoReqDTO.setGuardianIdNo(cardInfoReqDTO.getGuardianIdNo());
        HashMap<String, QueryCardInfoReqDTO> cardInfoMap = new HashMap<String, QueryCardInfoReqDTO>(1);
        cardInfoMap.put(EntityKeyEnum.QUERY_CARD_INFO.getValue(), cardInfoReqDTO);
        FrontResponse queryCardInfoRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.FIND_PATIENT_INFO.getValue(), cardInfoMap, QueryCardInfoResDTO.class);
        QueryCardInfoResDTO queryCardInfoResDTO = (QueryCardInfoResDTO)queryCardInfoRes.getBody();
        if (null == queryCardInfoResDTO) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)queryCardInfoRes.getMessage());
        }
        if (!"0".equals(queryCardInfoResDTO.getResultCode())) {
            return FrontResponse.error((String)queryCardInfoRes.getTransactionId(), (String)"0", (String)queryCardInfoResDTO.getResultMsg());
        }
        QueryCardInfoItemResDTO queryCardInfo = queryCardInfoResDTO.getItem();
        BeanUtils.copyProperties((Object)queryCardInfo, (Object)queryCardInfoResVO);
        queryCardInfoResVO.setCredType(((QueryCardInfoReqVO)param.getBody()).getCredType());
        queryCardInfoResVO.setCredNo(((QueryCardInfoReqVO)param.getBody()).getCredNo());
        queryCardInfoResVO.setName(((QueryCardInfoReqVO)param.getBody()).getName());
        queryCardInfoResVO.setCardType(((QueryCardInfoReqVO)param.getBody()).getCardType());
        queryCardInfoResVO.setCardNo(String.valueOf(this.snowflakeIdWorker.nextId()));
        return FrontResponse.success((String)queryCardInfoRes.getTransactionId(), (Object)queryCardInfoResVO);
    }

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegisteredCardReqVO> param) {
        RegisteredCardReqVO registeredCardReqVO = (RegisteredCardReqVO)param.getBody();
        CreatePatientInfoReqDTO createPatientInfoReqDTO = new CreatePatientInfoReqDTO();
        createPatientInfoReqDTO.setAge(Integer.valueOf(IdCardUtil.getAgeByIdCard((String)registeredCardReqVO.getCredNo())));
        createPatientInfoReqDTO.setPatientName(registeredCardReqVO.getName());
        createPatientInfoReqDTO.setSex(registeredCardReqVO.getSex());
        createPatientInfoReqDTO.setBirthday(registeredCardReqVO.getDob());
        createPatientInfoReqDTO.setIdNo(registeredCardReqVO.getCredNo());
        createPatientInfoReqDTO.setPhone(registeredCardReqVO.getTelephone());
        createPatientInfoReqDTO.setAddress(registeredCardReqVO.getAddress());
        if (StringUtils.isBlank((CharSequence)registeredCardReqVO.getCredNo()) && StringUtils.isBlank((CharSequence)registeredCardReqVO.getGuardianIdNo())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u76d1\u62a4\u4eba\u8eab\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        createPatientInfoReqDTO.setGuardianIdNo(registeredCardReqVO.getGuardianIdNo());
        createPatientInfoReqDTO.setGuardianName(registeredCardReqVO.getGuardianName());
        createPatientInfoReqDTO.setGuardianPhone(registeredCardReqVO.getGuardianPhone());
        HashMap<String, CreatePatientInfoReqDTO> map = new HashMap<String, CreatePatientInfoReqDTO>(1);
        map.put(EntityKeyEnum.CREATE_PATIENT_INFO.getValue(), createPatientInfoReqDTO);
        FrontResponse resDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.CREATE_PATIENT_FILE.getValue(), map, CreatePatientInfoResDTO.class);
        CreatePatientInfoResDTO createPatientInfoResDTO = (CreatePatientInfoResDTO)resDTO.getBody();
        if (null == createPatientInfoResDTO) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)resDTO.getMessage());
        }
        if (!"0".equals(createPatientInfoResDTO.getResultCode())) {
            return FrontResponse.error((String)resDTO.getTransactionId(), (String)"0", (String)createPatientInfoResDTO.getResultMsg());
        }
        RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
        registeredCardResVO.setPatientId(createPatientInfoResDTO.getPatientId());
        registeredCardResVO.setCardNo(createPatientInfoResDTO.getCardNo());
        registeredCardResVO.setTelephone(registeredCardReqVO.getTelephone());
        registeredCardResVO.setSex(registeredCardReqVO.getSex());
        registeredCardResVO.setCredNo(registeredCardReqVO.getCredNo());
        registeredCardResVO.setCardType(registeredCardReqVO.getCardType());
        registeredCardResVO.setDob(registeredCardReqVO.getDob());
        registeredCardResVO.setAddress(registeredCardReqVO.getAddress());
        registeredCardResVO.setName(registeredCardReqVO.getName());
        registeredCardResVO.setCredType(registeredCardReqVO.getCredType());
        registeredCardResVO.setPatientNo(createPatientInfoResDTO.getPatientId());
        return FrontResponse.success((String)resDTO.getTransactionId(), (Object)registeredCardResVO);
    }

    public FrontResponse<QueryCardInfoResVO> queryNewCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        QueryPatientFilingReqDTO queryPatientFilingReqDTO = new QueryPatientFilingReqDTO();
        queryPatientFilingReqDTO.setSource(DataSourceEnum.HLWYY.getValue());
        queryPatientFilingReqDTO.setHospitalCode(HospitalRegionEnum.PJ.getValue());
        queryPatientFilingReqDTO.setOperCode("70019");
        queryPatientFilingReqDTO.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        queryPatientFilingReqDTO.setCertNo(((QueryCardInfoReqVO)param.getBody()).getCredNo());
        queryPatientFilingReqDTO.setCertType(IdCardTypeEnum.ID_CARD.getValue());
        QueryPatientFilingReqSerachDTO queryPatientFilingReqSerachDTO = new QueryPatientFilingReqSerachDTO();
        queryPatientFilingReqSerachDTO.setQueryPatientFilingReqDTO(queryPatientFilingReqDTO);
        QueryPatientFilingDTO queryPatientFilingDTO = new QueryPatientFilingDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(TransNoEnum.HIS_PATIENT_FILING_QUERY.getValue());
        queryPatientFilingDTO.setHeadDTO(headDTO);
        queryPatientFilingDTO.setQueryPatientFilingReqSerachDTO(queryPatientFilingReqSerachDTO);
        String converTomXml = XmlUtil.converTomXml((Object)queryPatientFilingDTO);
        FrontResponse queryPatientFilingVORes = this.hisRemoteService.hisNewRequest(TransNoEnum.HIS_PATIENT_FILING_QUERY.getValue(), converTomXml, QueryPatientFilingVO.class);
        QueryPatientFilingVO queryPatientFilingVO = (QueryPatientFilingVO)queryPatientFilingVORes.getBody();
        if (null == queryPatientFilingVO) {
            return FrontResponse.error((String)queryPatientFilingVORes.getTransactionId(), (String)"0", (String)queryPatientFilingVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        if (!"1".equals(queryPatientFilingVO.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)queryPatientFilingVORes.getTransactionId(), (String)"0", (String)queryPatientFilingVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        QueryPatientFilingResVO queryPatientFilingResVO = queryPatientFilingVO.getQueryPatientFilingResVO();
        QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
        queryCardInfoResVO.setName(queryPatientFilingResVO.getPatientName());
        queryCardInfoResVO.setSex(SexEnum.getValueEnumByCode((String)queryPatientFilingResVO.getSex()));
        queryCardInfoResVO.setDob(DateUtil.format((Date)DateUtil.parse((CharSequence)queryPatientFilingResVO.getBirthDate()), (String)"yyyy-MM-dd"));
        queryCardInfoResVO.setCredNo(queryPatientFilingResVO.getCertNo());
        queryCardInfoResVO.setCredType(queryPatientFilingResVO.getCertType());
        queryCardInfoResVO.setTelephone(queryPatientFilingResVO.getMobilePhone());
        queryCardInfoResVO.setAddress(queryPatientFilingResVO.getAddress());
        queryCardInfoResVO.setCardNo(queryPatientFilingResVO.getPid());
        queryCardInfoResVO.setCardType(((QueryCardInfoReqVO)param.getBody()).getCardType());
        queryCardInfoResVO.setPatientId(queryPatientFilingResVO.getPatientId());
        ObjectUtil.objectToTrim((Object)queryCardInfoResVO);
        return FrontResponse.success((String)queryPatientFilingVORes.getTransactionId(), (Object)queryCardInfoResVO);
    }

    public FrontResponse<RegisteredCardResVO> registerNewCardInfo(FrontRequest<RegisteredCardReqVO> param) {
        AddPatientFilingReqDTO addPatientFilingReqDTO = new AddPatientFilingReqDTO();
        addPatientFilingReqDTO.setSource(DataSourceEnum.HLWYY.getValue());
        addPatientFilingReqDTO.setHospitalCode(HospitalRegionEnum.PJ.getValue());
        addPatientFilingReqDTO.setOperCode("70019");
        addPatientFilingReqDTO.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        addPatientFilingReqDTO.setCertNo(((RegisteredCardReqVO)param.getBody()).getCredNo());
        addPatientFilingReqDTO.setCertType(IdCardTypeEnum.ID_CARD.getValue());
        addPatientFilingReqDTO.setPatientName(((RegisteredCardReqVO)param.getBody()).getName());
        addPatientFilingReqDTO.setBirthDate(((RegisteredCardReqVO)param.getBody()).getDob());
        addPatientFilingReqDTO.setSex(SexEnum.getCodeEnumByValue((String)((RegisteredCardReqVO)param.getBody()).getSex()));
        addPatientFilingReqDTO.setResponseType(IdCardTypeEnum.ID_CARD.getValue());
        addPatientFilingReqDTO.setMobilePhone(((RegisteredCardReqVO)param.getBody()).getTelephone());
        addPatientFilingReqDTO.setAddress(((RegisteredCardReqVO)param.getBody()).getAddress());
        AddPatientFilingReqFilingDTO addPatientFilingReqFilingDTO = new AddPatientFilingReqFilingDTO();
        addPatientFilingReqFilingDTO.setAddPatientFilingReqDTO(addPatientFilingReqDTO);
        AddPatientFilingDTO addPatientFilingDTO = new AddPatientFilingDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(TransNoEnum.HIS_PATIENT_FILING_ADD.getValue());
        addPatientFilingDTO.setHeadDTO(headDTO);
        addPatientFilingDTO.setAddPatientFilingReqFilingDTO(addPatientFilingReqFilingDTO);
        String converTomXml = XmlUtil.converTomXml((Object)addPatientFilingDTO);
        FrontResponse addPatientFilingVORes = this.hisRemoteService.hisNewRequest(TransNoEnum.HIS_PATIENT_FILING_ADD.getValue(), converTomXml, AddPatientFilingVO.class);
        AddPatientFilingVO addPatientFilingVO = (AddPatientFilingVO)addPatientFilingVORes.getBody();
        if (null == addPatientFilingVO) {
            return FrontResponse.error((String)addPatientFilingVORes.getTransactionId(), (String)"0", (String)addPatientFilingVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        if (!"1".equals(addPatientFilingVO.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)addPatientFilingVORes.getTransactionId(), (String)"0", (String)addPatientFilingVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        AddPatientFilingResVO addPatientFilingResVO = addPatientFilingVO.getAddPatientFilingResVO();
        RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
        registeredCardResVO.setName(((RegisteredCardReqVO)param.getBody()).getName());
        registeredCardResVO.setSex(((RegisteredCardReqVO)param.getBody()).getSex());
        registeredCardResVO.setDob(((RegisteredCardReqVO)param.getBody()).getDob());
        registeredCardResVO.setCredNo(((RegisteredCardReqVO)param.getBody()).getCredNo());
        registeredCardResVO.setCredType(((RegisteredCardReqVO)param.getBody()).getCredType());
        registeredCardResVO.setTelephone(((RegisteredCardReqVO)param.getBody()).getTelephone());
        registeredCardResVO.setAddress(((RegisteredCardReqVO)param.getBody()).getAddress());
        registeredCardResVO.setPatientId(addPatientFilingResVO.getPatientId());
        registeredCardResVO.setCardNo(addPatientFilingResVO.getPid());
        registeredCardResVO.setCardType(((RegisteredCardReqVO)param.getBody()).getCardType());
        ObjectUtil.objectToTrim((Object)registeredCardResVO);
        return FrontResponse.success((String)addPatientFilingVORes.getTransactionId(), (Object)registeredCardResVO);
    }
}

