/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.enums.TransNoEnum;
import com.ebaiyihui.his.mapper.InspectMapper;
import com.ebaiyihui.his.pojo.dto.AssayReportDetailQueryResDTO;
import com.ebaiyihui.his.pojo.dto.AssayReportQueryResDTO;
import com.ebaiyihui.his.pojo.dto.GetJYReportListsReqBody;
import com.ebaiyihui.his.pojo.dto.GetJYReportListsReqDTO;
import com.ebaiyihui.his.pojo.dto.LabReportInfo;
import com.ebaiyihui.his.pojo.dto.PacsReportDetailQueryResDTO;
import com.ebaiyihui.his.pojo.dto.PacsReportDetailQueryResItem;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.HisHeadDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListReq;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.datas.LisReportListResData;
import com.ebaiyihui.his.service.ElectronicReportService;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.DateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private static final Logger log = LoggerFactory.getLogger(ElectronicReportServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private InspectMapper inspectMapper;

    public FrontResponse<GetReportListsRes> getJYReportLists(FrontRequest<GetReportListsReq> param) {
        GetReportListsReq getReportListsReq = (GetReportListsReq)param.getBody();
        try {
            if (null == getReportListsReq.getBeginTime() || null == getReportListsReq.getEndTime()) {
                getReportListsReq.setEndTime(DateUtil.getCurrentDateTimeStringNew());
                getReportListsReq.setBeginTime(DateUtil.getAfterCurrentDay((int)-365));
            }
            GetJYReportListsReqDTO getJYReportListsReqDTO = new GetJYReportListsReqDTO();
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.JY_LIST.getValue());
            getJYReportListsReqDTO.setHead(headDTO);
            GetJYReportListsReqBody body = new GetJYReportListsReqBody();
            body.setPageNum("1");
            body.setPageSize("99");
            body.setCertNo(getReportListsReq.getCredNo());
            body.setEndTime(getReportListsReq.getEndTime());
            body.setStartTime(getReportListsReq.getBeginTime());
            getJYReportListsReqDTO.setBody(body);
            HashMap<String, GetJYReportListsReqDTO> map = new HashMap<String, GetJYReportListsReqDTO>();
            map.put("Request", getJYReportListsReqDTO);
            log.info("his\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(map));
            String hisRes = HttpUtil.post((String)"https://10.1.24.232:7073/ServiceForAll", (String)JSON.toJSONString(map));
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            AssayReportQueryResDTO response = (AssayReportQueryResDTO)JSON.parseObject((String)hisRes, AssayReportQueryResDTO.class);
            log.info("response\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if ("1".equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            List records = response.getData().getContent();
            if (records.size() <= 0) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            GetReportListsRes getReportListsRes = new GetReportListsRes();
            ArrayList<GetReportListsData> datas = new ArrayList<GetReportListsData>();
            for (LabReportInfo reportInfoDTO : records) {
                if (null != reportInfoDTO.getApplierDept() && reportInfoDTO.getApplierDept().contains("\u6838\u9178")) continue;
                GetReportListsData getReportListsData = new GetReportListsData();
                getReportListsData.setReportNo(reportInfoDTO.getLabFlow());
                getReportListsData.setReportName(reportInfoDTO.getLabRepName());
                getReportListsData.setReportDate(reportInfoDTO.getLabTime().substring(0, 19));
                getReportListsData.setSpecName(reportInfoDTO.getSample());
                getReportListsData.setRecTime(reportInfoDTO.getLabTime().substring(0, 19));
                getReportListsData.setAuthTime(reportInfoDTO.getLabTime().substring(0, 19));
                getReportListsData.setAuthUser(reportInfoDTO.getAuditUserName());
                getReportListsData.setRecUser(reportInfoDTO.getLabRecorder());
                getReportListsData.setDeptName(reportInfoDTO.getApplierDept());
                getReportListsData.setColTime(reportInfoDTO.getSampleRecvTime().substring(0, 19));
                datas.add(getReportListsData);
            }
            getReportListsRes.setDatas(datas);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }

    public FrontResponse<GetReportListsRes> getJCReportLists(FrontRequest<GetReportListsReq> param) {
        GetReportListsReq getReportListsReq = (GetReportListsReq)param.getBody();
        if (null == getReportListsReq.getBeginTime() || null == getReportListsReq.getEndTime()) {
            getReportListsReq.setEndTime(DateUtil.getCurrentDateTimeStringNew());
            getReportListsReq.setBeginTime(DateUtil.getAfterCurrentDay((int)-365));
        }
        try {
            GetJYReportListsReqDTO getJYReportListsReqDTO = new GetJYReportListsReqDTO();
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.JC_LIST.getValue());
            getJYReportListsReqDTO.setHead(headDTO);
            GetJYReportListsReqBody body = new GetJYReportListsReqBody();
            body.setPageNum("1");
            body.setPageSize("99");
            body.setCertNo(getReportListsReq.getCredNo());
            body.setEndTime(getReportListsReq.getEndTime());
            body.setStartTime(getReportListsReq.getBeginTime());
            getJYReportListsReqDTO.setBody(body);
            HashMap<String, GetJYReportListsReqDTO> map = new HashMap<String, GetJYReportListsReqDTO>();
            map.put("Request", getJYReportListsReqDTO);
            log.info("his\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(map));
            String hisRes = HttpUtil.post((String)"https://10.1.24.232:7073/ServiceForAll", (String)JSON.toJSONString(map));
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            AssayReportQueryResDTO response = (AssayReportQueryResDTO)JSON.parseObject((String)hisRes, AssayReportQueryResDTO.class);
            log.info("response\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if ("1".equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            List records = response.getData().getContent();
            if (records.size() <= 0) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            GetReportListsRes getReportListsRes = new GetReportListsRes();
            ArrayList<GetReportListsData> datas = new ArrayList<GetReportListsData>();
            for (LabReportInfo reportInfoDTO : records) {
                GetReportListsData getReportListsData = new GetReportListsData();
                getReportListsData.setReportNo(reportInfoDTO.getExamrptFlow());
                getReportListsData.setReportName(reportInfoDTO.getExamorderName());
                getReportListsData.setReportType(reportInfoDTO.getExamName());
                getReportListsData.setReportDate(reportInfoDTO.getExamTime());
                datas.add(getReportListsData);
            }
            getReportListsRes.setDatas(datas);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u68c0\u67e5\u5217\u8868\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }

    public FrontResponse<LisReportListRes> lisReportList(FrontRequest<LisReportListReq> param) {
        LisReportListReq getReportListsReq = (LisReportListReq)param.getBody();
        try {
            GetJYReportListsReqDTO getJYReportListsReqDTO = new GetJYReportListsReqDTO();
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.JY_DETAIL.getValue());
            getJYReportListsReqDTO.setHead(headDTO);
            GetJYReportListsReqBody body = new GetJYReportListsReqBody();
            body.setPageNum("1");
            body.setPageSize("99");
            body.setLabFlow(getReportListsReq.getReportNo());
            getJYReportListsReqDTO.setBody(body);
            HashMap<String, GetJYReportListsReqDTO> map = new HashMap<String, GetJYReportListsReqDTO>();
            map.put("Request", getJYReportListsReqDTO);
            log.info("his\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(map));
            String hisRes = HttpUtil.post((String)"https://10.1.24.232:7073/ServiceForAll", (String)JSON.toJSONString(map));
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            AssayReportDetailQueryResDTO response = (AssayReportDetailQueryResDTO)JSON.parseObject((String)hisRes, AssayReportDetailQueryResDTO.class);
            log.info("response\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if ("1".equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            List records = response.getData().getContent();
            if (records.size() <= 0) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            LisReportListRes lisReportListRes = new LisReportListRes();
            ArrayList datas = new ArrayList();
            records.stream().forEach(date -> {
                LisReportListResData lisReportListResData = new LisReportListResData();
                lisReportListResData.setItmCode(date.getLabRepItemCode());
                lisReportListResData.setItmName(date.getLabRepItemName());
                lisReportListResData.setItmUnit(date.getLabRepItemUnit());
                if (date.getChangeFlag().equals("\u2191")) {
                    lisReportListResData.setItmCrises("\u504f\u9ad8");
                } else if (date.getChangeFlag().equals("\u2193")) {
                    lisReportListResData.setItmCrises("\u504f\u4f4e");
                } else {
                    lisReportListResData.setItmCrises("\u6b63\u5e38");
                }
                lisReportListResData.setItmRanges(date.getReferenceText());
                lisReportListResData.setItmRes(date.getResultText1());
                lisReportListResData.setItmRanges(date.getReferenceText());
                datas.add(lisReportListResData);
            });
            lisReportListRes.setDatas(datas);
            return FrontResponse.success((String)param.getTransactionId(), (Object)lisReportListRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }

    public FrontResponse<PacsReportListRes> pacsReportList(FrontRequest<LisReportListReq> param) {
        LisReportListReq getReportListsReq = (LisReportListReq)param.getBody();
        try {
            GetJYReportListsReqDTO getJYReportListsReqDTO = new GetJYReportListsReqDTO();
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.JC_DETAIL.getValue());
            getJYReportListsReqDTO.setHead(headDTO);
            GetJYReportListsReqBody body = new GetJYReportListsReqBody();
            body.setPageNum("1");
            body.setPageSize("99");
            body.setExamFlow(getReportListsReq.getReportNo());
            body.setExamName(getReportListsReq.getReportName());
            getJYReportListsReqDTO.setBody(body);
            HashMap<String, GetJYReportListsReqDTO> map = new HashMap<String, GetJYReportListsReqDTO>();
            map.put("Request", getJYReportListsReqDTO);
            log.info("his\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(map));
            String hisRes = HttpUtil.post((String)"https://10.1.24.232:7073/ServiceForAll", (String)JSON.toJSONString(map));
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            PacsReportDetailQueryResDTO response = (PacsReportDetailQueryResDTO)JSON.parseObject((String)hisRes, PacsReportDetailQueryResDTO.class);
            log.info("response\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if ("1".equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            List records = response.getData().getContent();
            if (records.size() <= 0) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            PacsReportListRes lisReportListRes = new PacsReportListRes();
            for (PacsReportDetailQueryResItem data : records) {
                lisReportListRes.setReportName(data.getExamOrderName());
                lisReportListRes.setDeptName(data.getApplierDep());
                lisReportListRes.setAuthTime(data.getAuditTime());
                lisReportListRes.setCheckResult(data.getResult());
                lisReportListRes.setCheckDesc(data.getFindings());
                lisReportListRes.setPerformedDept(data.getPerformedDept());
                lisReportListRes.setExamTime(data.getExamTime());
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)lisReportListRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }
}

