/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.common.enums.TransNoEnum;
import com.ebaiyihui.his.pojo.DelPrescriptionReq;
import com.ebaiyihui.his.pojo.DelPrescriptionRes;
import com.ebaiyihui.his.pojo.MedicalPresVo;
import com.ebaiyihui.his.pojo.MedicalPrescriptionReq;
import com.ebaiyihui.his.pojo.MedicalPrescriptionRes;
import com.ebaiyihui.his.pojo.MedicalPrescriptionResVo;
import com.ebaiyihui.his.pojo.MedicalPrescriptionVo;
import com.ebaiyihui.his.pojo.MedicalRecordReq;
import com.ebaiyihui.his.pojo.MedicalRecordReqVo;
import com.ebaiyihui.his.pojo.MedicalRecordRes;
import com.ebaiyihui.his.pojo.MedicalRecordResVo;
import com.ebaiyihui.his.pojo.ReviewPrescriptionReq;
import com.ebaiyihui.his.pojo.SendMedicalPrescriptionVo;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.HisHeadDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.ReviewPrescriptionItemVO;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.MedicalRecordService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import com.ebaiyihui.his.utils.IDCardUtil;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class MecicalRecordServiceImpl
implements MedicalRecordService {
    private static final Logger log = LoggerFactory.getLogger(MecicalRecordServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private HisRemoteService hisRemoteService;

    public BaseResponse saveMedicalRecord() {
        return null;
    }

    public BaseResponse getMedicalRecord(MedicalRecordReqVo medicalRecordReqVo) {
        log.info("\u83b7\u53d6\u53c2\u6570\u5165\u53c2{}", (Object)JSON.toJSONString((Object)medicalRecordReqVo));
        MedicalRecordReq medicalRecordReq = new MedicalRecordReq();
        HisHeadDTO hisHeadDTO = new HisHeadDTO();
        hisHeadDTO.setSource("HLWYY");
        hisHeadDTO.setTransNo(TransNoEnum.LISTREPORT_LIST.getValue());
        medicalRecordReq.setHeadDTO(hisHeadDTO);
        MedicalRecordReq.Body body = new MedicalRecordReq.Body();
        MedicalRecordReq.Body.Param param = new MedicalRecordReq.Body.Param();
        param.setApiCode("HSC0348");
        MedicalRecordReq.Body.Param.RequestBody requestBody = new MedicalRecordReq.Body.Param.RequestBody();
        MedicalRecordReq.Body.Param.RequestBody.CParam cParam = new MedicalRecordReq.Body.Param.RequestBody.CParam();
        MedicalRecordReq.Body.Param.RequestBody.Order order = new MedicalRecordReq.Body.Param.RequestBody.Order();
        order.setArray("true");
        cParam.setPatientId(medicalRecordReqVo.getPatientId());
        MedicalRecordReq.Body.Param.RequestBody.CParam.IsDeleted isDeleted = new MedicalRecordReq.Body.Param.RequestBody.CParam.IsDeleted();
        isDeleted.setKey("true");
        isDeleted.setValue(Integer.valueOf(0));
        cParam.setIsDeleted(isDeleted);
        MedicalRecordReq.Body.Param.RequestBody.Page page = new MedicalRecordReq.Body.Param.RequestBody.Page();
        page.setPageNo(medicalRecordReqVo.getPage());
        requestBody.setCParam(cParam);
        requestBody.setPage(page);
        requestBody.setOrder(order);
        param.setRequestBody(requestBody);
        body.setParam(param);
        medicalRecordReq.setBody(body);
        log.info("medicalRecordReq{}", (Object)JSON.toJSONString((Object)medicalRecordReq));
        String converTomXml = XmlUtil.converTomXml((Object)medicalRecordReq);
        FrontResponse medicalRecordResFrontResponse = this.hisRemoteService.hisNewRequest("HSC0348", converTomXml, MedicalRecordRes.class);
        log.info("\u60a3\u8005\u75c5\u5386\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)medicalRecordResFrontResponse));
        MedicalRecordRes medicalRecordRes = (MedicalRecordRes)medicalRecordResFrontResponse.getBody();
        if (null == medicalRecordRes) {
            return BaseResponse.error((String)"\u60a3\u8005\u75c5\u5386\u67e5\u8be2\u5931\u8d25\uff01");
        }
        if (!"1".equals(medicalRecordRes.getHisReturnVO().getRetCode())) {
            return BaseResponse.error((String)"\u60a3\u8005\u75c5\u5386\u67e5\u8be2\u5931\u8d25\uff01");
        }
        Integer total = medicalRecordRes.getBody().getData().getResponseData().getData().getTotal();
        if (total == 0) {
            MedicalRecordRes.Body.PData.ResponseData.Data data = medicalRecordRes.getBody().getData().getResponseData().getData();
            data.setRecords(new ArrayList());
            return BaseResponse.success((Object)data);
        }
        medicalRecordRes.getBody().getData().getResponseData().getData();
        Collections.sort(medicalRecordRes.getBody().getData().getResponseData().getData().getRecords(), Comparator.comparing(MedicalRecordResVo::getOperationtime).reversed());
        return BaseResponse.success((Object)medicalRecordRes.getBody().getData().getResponseData().getData());
    }

    public BaseResponse getMedicalPrescription(MedicalRecordReqVo medicalRecordReqVo) {
        log.info("\u83b7\u53d6\u53c2\u6570\u5165\u53c2{}", (Object)JSON.toJSONString((Object)medicalRecordReqVo));
        MedicalPrescriptionReq medicalRecordReq = new MedicalPrescriptionReq();
        HisHeadDTO hisHeadDTO = new HisHeadDTO();
        hisHeadDTO.setSource("HLWYY");
        hisHeadDTO.setTransNo(TransNoEnum.LISTREPORT_LIST.getValue());
        medicalRecordReq.setHeadDTO(hisHeadDTO);
        MedicalPrescriptionReq.Body body = new MedicalPrescriptionReq.Body();
        MedicalPrescriptionReq.Body.Param param = new MedicalPrescriptionReq.Body.Param();
        param.setApiCode("HSC0339");
        MedicalPrescriptionReq.Body.Param.RequestBody requestBody = new MedicalPrescriptionReq.Body.Param.RequestBody();
        MedicalPrescriptionReq.Body.Param.RequestBody.CParam cParam = new MedicalPrescriptionReq.Body.Param.RequestBody.CParam();
        MedicalPrescriptionReq.Body.Param.RequestBody.Order order = new MedicalPrescriptionReq.Body.Param.RequestBody.Order();
        order.setArray("true");
        cParam.setPatientId(medicalRecordReqVo.getPatientId());
        MedicalPrescriptionReq.Body.Param.RequestBody.CParam.IsDeleted isDeleted = new MedicalPrescriptionReq.Body.Param.RequestBody.CParam.IsDeleted();
        isDeleted.setKey("true");
        isDeleted.setValue(Integer.valueOf(0));
        cParam.setIsDeleted(isDeleted);
        MedicalPrescriptionReq.Body.Param.RequestBody.Page page = new MedicalPrescriptionReq.Body.Param.RequestBody.Page();
        page.setPageNo(medicalRecordReqVo.getPage());
        requestBody.setCParam(cParam);
        requestBody.setPage(page);
        requestBody.setOrder(order);
        param.setRequestBody(requestBody);
        body.setParam(param);
        medicalRecordReq.setBody(body);
        log.info("medicalRecordReq{}", (Object)JSON.toJSONString((Object)medicalRecordReq));
        String converTomXml = XmlUtil.converTomXml((Object)medicalRecordReq);
        FrontResponse medicalRecordResFrontResponse = this.hisRemoteService.hisNewRequest("HSC0339", converTomXml, MedicalPrescriptionRes.class);
        log.info("\u60a3\u8005\u5904\u65b9\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)medicalRecordResFrontResponse));
        MedicalPrescriptionRes medicalRecordRes = (MedicalPrescriptionRes)medicalRecordResFrontResponse.getBody();
        if (null == medicalRecordRes) {
            return BaseResponse.error((String)"\u60a3\u8005\u5904\u65b9\u67e5\u8be2\u5931\u8d25\uff01");
        }
        if (!"1".equals(medicalRecordRes.getHisReturnVO().getRetCode())) {
            return BaseResponse.error((String)"\u60a3\u8005\u5904\u65b9\u67e5\u8be2\u5931\u8d25\uff01");
        }
        List prescriptionResVos = medicalRecordRes.getBody().getData().getResponseData().getData().getRecords();
        HashMap<String, MedicalPrescriptionVo> map = new HashMap<String, MedicalPrescriptionVo>();
        for (MedicalPrescriptionResVo medicalPrescriptionResVo : prescriptionResVos) {
            MedicalPrescriptionVo medicalPrescriptionVo;
            Boolean flag = map.containsKey(medicalPrescriptionResVo.getPrescriptionsn());
            if (flag.booleanValue()) {
                medicalPrescriptionVo = (MedicalPrescriptionVo)map.get(medicalPrescriptionResVo.getPrescriptionsn());
                List drugs = medicalPrescriptionVo.getDrugs();
                MedicalPrescriptionVo.Drug drug = new MedicalPrescriptionVo.Drug();
                BeanUtils.copyProperties((Object)medicalPrescriptionResVo, (Object)drug);
                drugs.add(drug);
                medicalPrescriptionVo.setDrugs(drugs);
                map.put(medicalPrescriptionResVo.getPrescriptionsn(), medicalPrescriptionVo);
                continue;
            }
            medicalPrescriptionVo = new MedicalPrescriptionVo();
            BeanUtils.copyProperties((Object)medicalPrescriptionResVo, (Object)medicalPrescriptionVo);
            DateTime date = DateUtil.parse((CharSequence)medicalPrescriptionVo.getPrescriptiontime());
            int age = IdcardUtil.getAgeByIdCard((String)medicalPrescriptionResVo.getCertno(), (Date)date);
            Integer sex = IDCardUtil.getGenderForInteger((String)medicalPrescriptionResVo.getCertno());
            medicalPrescriptionVo.setAge(Integer.valueOf(age));
            medicalPrescriptionVo.setSex(sex);
            ArrayList<MedicalPrescriptionVo.Drug> drugs = new ArrayList<MedicalPrescriptionVo.Drug>();
            MedicalPrescriptionVo.Drug drug = new MedicalPrescriptionVo.Drug();
            BeanUtils.copyProperties((Object)medicalPrescriptionResVo, (Object)drug);
            drugs.add(drug);
            medicalPrescriptionVo.setDrugs(drugs);
            map.put(medicalPrescriptionResVo.getPrescriptionsn(), medicalPrescriptionVo);
        }
        List list = map.values().stream().collect(Collectors.toList());
        MedicalPresVo medicalPresVo = new MedicalPresVo();
        medicalPresVo.setPage(medicalRecordRes.getBody().getData().getResponseData().getData().getPage());
        medicalPresVo.setPageNo(medicalRecordRes.getBody().getData().getResponseData().getData().getPageNo());
        medicalPresVo.setPageSize(medicalRecordRes.getBody().getData().getResponseData().getData().getPageSize());
        medicalPresVo.setTotal(medicalRecordRes.getBody().getData().getResponseData().getData().getTotal());
        if (medicalPresVo.getTotal() == 0) {
            medicalPresVo.setMedicalPrescriptionVos(new ArrayList());
        } else {
            medicalPresVo.setMedicalPrescriptionVos(list);
        }
        return BaseResponse.success((Object)medicalPresVo);
    }

    public BaseResponse sendMedicalPrescription(SendMedicalPrescriptionVo sendMedicalPrescriptionVo) {
        SendMedicalPrescriptionVo.Request.Head head = new SendMedicalPrescriptionVo.Request.Head();
        head.setSource("HLWYY");
        head.setTransNo("HTIP.CM.DRUGDISTRI.0001");
        SendMedicalPrescriptionVo.Request request = sendMedicalPrescriptionVo.getRequest();
        request.setHead(head);
        sendMedicalPrescriptionVo.setRequest(request);
        try {
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"text/plain; charset=UTF-8");
            headers.setContentType(type);
            HttpEntity entity = new HttpEntity((Object)JSON.toJSONString((Object)sendMedicalPrescriptionVo), (MultiValueMap)headers);
            log.info("sendMedicalPrescriptionVo:{},url{}", (Object)JSON.toJSONString((Object)sendMedicalPrescriptionVo), (Object)"https://10.1.24.232:7073/ServiceForAll");
            ResponseEntity responseEntity = this.restTemplate.exchange("https://10.1.24.232:7073/ServiceForAll", HttpMethod.POST, entity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseResponse.success();
    }

    public FrontResponse<ReviewPrescriptionItemVO> reviewPrescription(ReviewPrescriptionReq review) {
        String sex = review.getPatientInfo().getPatientSex();
        ReviewPrescriptionReq.PatientInfo patientInfo = review.getPatientInfo();
        if ("1".equals(sex)) {
            patientInfo.setPatientSex("\u5973");
            review.setPatientInfo(patientInfo);
        } else {
            patientInfo.setPatientSex("\u7537");
            review.setPatientInfo(patientInfo);
        }
        String converseTomXml = XmlUtil.converTomXml((Object)review);
        String resultStr = new CxfClientUtil().smsSend("http://10.1.2.45:8056/phhcwsi/services/medOrdersAudit?wsdl", TransNoEnum.REVIEW_PRESCRIPTION.getValue(), converseTomXml);
        resultStr = resultStr.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>", "");
        ReviewPrescriptionItemVO responseBody = (ReviewPrescriptionItemVO)XmlUtil.convertToJavaBean((String)resultStr, ReviewPrescriptionItemVO.class);
        if (null == responseBody) {
            return FrontResponse.error((String)TransNoEnum.REVIEW_PRESCRIPTION.getValue(), (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)TransNoEnum.REVIEW_PRESCRIPTION.getValue(), (Object)responseBody);
    }

    public FrontResponse<DelPrescriptionRes> delPrescription(DelPrescriptionReq delPrescriptionReq) {
        String converseTomXml = XmlUtil.converTomXml((Object)delPrescriptionReq);
        String resultStr = new CxfClientUtil().smsSendNew("http://10.1.2.45:8056/phhcwsi/services/medOrdersAudit?wsdl", TransNoEnum.UPDATE_PRESCRIPTIONSTATUS.getValue(), "10.1.2.198", converseTomXml);
        DelPrescriptionRes responseBody = (DelPrescriptionRes)XmlUtil.convertToJavaBean((String)(resultStr = resultStr.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>", "")), DelPrescriptionRes.class);
        if (null == responseBody) {
            return FrontResponse.error((String)TransNoEnum.UPDATE_PRESCRIPTIONSTATUS.getValue(), (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)TransNoEnum.UPDATE_PRESCRIPTIONSTATUS.getValue(), (Object)responseBody);
    }
}

