/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.his.common.enums.DataSourceEnum;
import com.ebaiyihui.his.common.enums.HospitalRegionEnum;
import com.ebaiyihui.his.common.enums.TransNoEnum;
import com.ebaiyihui.his.common.enums.TreatTypeEnum;
import com.ebaiyihui.his.config.NodeConfig;
import com.ebaiyihui.his.pojo.dto.yb.CancelUnpaidOrderReqDTO;
import com.ebaiyihui.his.pojo.dto.yb.CancelUnpaidOrderResDTO;
import com.ebaiyihui.his.pojo.dto.yb.PresRecipeJsReqDTO;
import com.ebaiyihui.his.pojo.dto.yb.PresRecipeJsResDTO;
import com.ebaiyihui.his.pojo.dto.yb.PresRecipeYjsReqDTO;
import com.ebaiyihui.his.pojo.dto.yb.PresRecipeYjsResDTO;
import com.ebaiyihui.his.pojo.dto.yb.RegRecipeJsReqDTO;
import com.ebaiyihui.his.pojo.dto.yb.RegRecipeJsResDTO;
import com.ebaiyihui.his.pojo.dto.yb.RegRecipeYjsReqDTO;
import com.ebaiyihui.his.pojo.dto.yb.RegRecipeYjsResDTO;
import com.ebaiyihui.his.pojo.dto.yb.vo.CancelUnpaidOrderReqVo;
import com.ebaiyihui.his.pojo.dto.yb.vo.PresRecipeJsReqVO;
import com.ebaiyihui.his.pojo.dto.yb.vo.PresRecipeJsResVO;
import com.ebaiyihui.his.pojo.dto.yb.vo.PresRecipeYjsReqVO;
import com.ebaiyihui.his.pojo.dto.yb.vo.PresRecipeYjsResVO;
import com.ebaiyihui.his.pojo.dto.yb.vo.RegRecipeJsReqVO;
import com.ebaiyihui.his.pojo.dto.yb.vo.RegRecipeJsResVO;
import com.ebaiyihui.his.pojo.dto.yb.vo.RegRecipeYjsReqVO;
import com.ebaiyihui.his.pojo.dto.yb.vo.RegRecipeYjsResVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.AddMedicalOrderInfoDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.AddMedicalOrderInfoReqDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.AdvanceFeeReqDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.HisHeadDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.PaymentListReturnedInfoDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.PendingFeesEnquiryReqDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.PushMedicalOrderInfoDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.PushMedicalOrderInfoDTOReq;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.AddMedicalOrderInfoVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.AdvanceFeeDetailVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.HisReturnVO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.vo.PaymentListReturnedInfoVO;
import com.ebaiyihui.his.pojo.vo.CirculationReqVo;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.MedicalOrderService;
import com.ebaiyihui.his.utils.HttpUtils;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MedicalOrderServiceImpl
implements MedicalOrderService {
    private static final Logger log = LoggerFactory.getLogger(MedicalOrderServiceImpl.class);
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private HisRemoteService hisRemoteService;

    public HisReturnVO addOrders(String message) {
        HisReturnVO hisReturnVO = new HisReturnVO();
        PushMedicalOrderInfoDTO req = (PushMedicalOrderInfoDTO)XmlUtil.convertToJavaBean((String)message, PushMedicalOrderInfoDTO.class);
        if (null == req.getAddMedicalOrderInfoReqDTO() || req.getAddMedicalOrderInfoReqDTO().size() <= 0) {
            hisReturnVO.setRetCode("0");
            hisReturnVO.setRetCont("\u4f20\u5165AppStatuss\u4e3a\u7a7a");
            return hisReturnVO;
        }
        List addMedicalOrderInfoReqDTO = req.getAddMedicalOrderInfoReqDTO();
        for (PushMedicalOrderInfoDTOReq pushMedicalOrderInfoDTOReq : addMedicalOrderInfoReqDTO) {
            if (null == pushMedicalOrderInfoDTOReq.getRecordFlow() || pushMedicalOrderInfoDTOReq.getRecordFlow().equals("")) {
                hisReturnVO.setRetCode("0");
                hisReturnVO.setRetCont("\u4ea4\u6613\u6d41\u6c34\u53f7\u4e3a\u7a7a");
                return hisReturnVO;
            }
            if (null == pushMedicalOrderInfoDTOReq.getStatus() || pushMedicalOrderInfoDTOReq.getStatus().equals("")) {
                hisReturnVO.setRetCode("0");
                hisReturnVO.setRetCont("HIS\u6536\u8d39\u72b6\u6001\u4e3a\u7a7a");
                return hisReturnVO;
            }
            if (null != pushMedicalOrderInfoDTOReq.getPatId() && !pushMedicalOrderInfoDTOReq.getPatId().equals("")) continue;
            hisReturnVO.setRetCode("0");
            hisReturnVO.setRetCont("\u60a3\u8005\u75c5\u5386\u53f7\u4e3a\u7a7a");
            return hisReturnVO;
        }
        try {
            log.info("===\u8bf7\u6c42\u533b\u836f\u4e91\u63a8\u9001\u5904\u65b9\u63a5\u53e3\u5165\u53c2{}", (Object)JSON.toJSONString((Object)req.getAddMedicalOrderInfoReqDTO()));
            String body = HttpKit.jsonPost((String)"http://10.7.0.9:8014/patientInvoic/v1/synchronous", (String)JSON.toJSONString((Object)req.getAddMedicalOrderInfoReqDTO()));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            log.info("===\u8bf7\u6c42\u533b\u836f\u4e91\u63a8\u9001\u5904\u65b9\u63a5\u53e3\u8fd4\u56de{}", (Object)JSON.toJSONString((Object)baseResponse));
            if (!baseResponse.isSuccess()) {
                hisReturnVO.setRetCode("0");
                hisReturnVO.setRetCont(baseResponse.getMsg());
                return hisReturnVO;
            }
            hisReturnVO.setRetCode("1");
            return hisReturnVO;
        }
        catch (Exception e) {
            hisReturnVO.setRetCode("0");
            hisReturnVO.setRetCont("\u8bf7\u6c42\u5f02\u5e38");
            log.info("===\u8bf7\u6c42\u5f02\u5e38{}", (Object)JSON.toJSONString((Object)e.getMessage()));
            return hisReturnVO;
        }
    }

    public FrontResponse<String> issuingMedicalOrder(List<AddMedicalOrderInfoReqDTO> param) {
        log.info("issuingMedicalOrder {}", (Object)JSON.toJSONString(param));
        param.forEach(addMedicalOrderInfoReqDTO -> {
            if (null == addMedicalOrderInfoReqDTO.getHospitalCode()) {
                addMedicalOrderInfoReqDTO.setHospitalCode(HospitalRegionEnum.PJ.getValue());
            }
            addMedicalOrderInfoReqDTO.setTreatTypeCode(TreatTypeEnum.H.getValue());
            addMedicalOrderInfoReqDTO.setTreatType(TreatTypeEnum.H.getDisplay());
            if (null == addMedicalOrderInfoReqDTO.getOrderSource()) {
                addMedicalOrderInfoReqDTO.setOrderSource(DataSourceEnum.HLWYY.getValue());
            }
            addMedicalOrderInfoReqDTO.setOperateTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        });
        AddMedicalOrderInfoDTO addMedicalOrderInfoDTO = new AddMedicalOrderInfoDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(TransNoEnum.HIS_ISSUING_MEDICAL_ORDER.getValue());
        addMedicalOrderInfoDTO.setHeadDTO(headDTO);
        addMedicalOrderInfoDTO.setAddMedicalOrderInfoReqDTO(param);
        String converTomXml = XmlUtil.converTomXml((Object)addMedicalOrderInfoDTO);
        FrontResponse addMedicalOrderInfoVORes = this.hisRemoteService.hisNewRequest(TransNoEnum.HIS_ISSUING_MEDICAL_ORDER.getValue(), converTomXml, AddMedicalOrderInfoVO.class);
        AddMedicalOrderInfoVO addMedicalOrderInfoVO = (AddMedicalOrderInfoVO)addMedicalOrderInfoVORes.getBody();
        if (null == addMedicalOrderInfoVO) {
            return FrontResponse.error((String)addMedicalOrderInfoVORes.getTransactionId(), (String)"0", (String)addMedicalOrderInfoVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        if (!"1".equals(addMedicalOrderInfoVO.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)addMedicalOrderInfoVORes.getTransactionId(), (String)"0", (String)addMedicalOrderInfoVO.getHeadVO().getHisReturnVO().getRetCont());
        }
        return FrontResponse.success((String)addMedicalOrderInfoVORes.getTransactionId(), (Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public BaseResponse presCirculation(List<CirculationReqVo> param) {
        log.info("==========><\u836f\u623f\u56de\u8c03>\u3010\u533b\u836f\u4e91\u3011\u8bf7\u6c42\u4e92\u8054\u7f51\u533b\u9662\u5730\u5740:{}", (Object)this.nodeConfig.getPresCirculationUrl());
        String str = null;
        try {
            str = HttpUtils.post((String)this.nodeConfig.getPresCirculationUrl(), null, (String)JSON.toJSONString(param));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("==========><\u836f\u623f\u56de\u8c03>\u3010\u533b\u836f\u4e91\u3011\u4e92\u8054\u7f51\u533b\u9662\u8fd4\u56de\u539f\u59cb\u6570\u636e{}", (Object)str);
        return BaseResponse.success();
    }

    public FrontResponse<List<AdvanceFeeDetailVO>> listPendingFeesEnquiry(PendingFeesEnquiryReqDTO param) {
        AdvanceFeeReqDTO advanceFeeReqDTO = new AdvanceFeeReqDTO();
        BeanUtils.copyProperties((Object)param, (Object)advanceFeeReqDTO);
        advanceFeeReqDTO.setSource(DataSourceEnum.HLWYY.getValue());
        advanceFeeReqDTO.setLybj("04");
        if (null == param.getHospitalCode()) {
            advanceFeeReqDTO.setHospitalCode(HospitalRegionEnum.PJ.getValue());
        }
        advanceFeeReqDTO.setOperCode("70019");
        advanceFeeReqDTO.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        PaymentListReturnedInfoDTO paymentListReturnedInfoDTO = new PaymentListReturnedInfoDTO();
        HisHeadDTO headDTO = new HisHeadDTO();
        headDTO.setSource("HLWYY");
        headDTO.setTransNo(TransNoEnum.ONLINE_FEE_LIST_QUERY.getValue());
        paymentListReturnedInfoDTO.setHeadDTO(headDTO);
        paymentListReturnedInfoDTO.setAdvanceFeeReqDTO(advanceFeeReqDTO);
        String converTomXml = XmlUtil.converTomXml((Object)paymentListReturnedInfoDTO);
        FrontResponse queryDiagnosticInfoVORes = this.hisRemoteService.hisNewRequest(TransNoEnum.ONLINE_FEE_LIST_QUERY.getValue(), converTomXml, PaymentListReturnedInfoVO.class);
        PaymentListReturnedInfoVO resBody = (PaymentListReturnedInfoVO)queryDiagnosticInfoVORes.getBody();
        if (!"1".equals(resBody.getHeadVO().getHisReturnVO().getRetCode())) {
            return FrontResponse.error((String)queryDiagnosticInfoVORes.getTransactionId(), (String)"0", (String)resBody.getHeadVO().getHisReturnVO().getRetCont());
        }
        ArrayList advanceFeeDetail = new ArrayList();
        List paymentListReturned = resBody.getPaymentListReturned().getPaymentListReturned();
        paymentListReturned.forEach(paymentListReturnedVO -> {
            AdvanceFeeDetailVO advanceFeeDetailVO = new AdvanceFeeDetailVO();
            BeanUtils.copyProperties((Object)paymentListReturnedVO, (Object)advanceFeeDetailVO);
            advanceFeeDetail.add(advanceFeeDetailVO);
        });
        return FrontResponse.success((String)queryDiagnosticInfoVORes.getTransactionId(), advanceFeeDetail);
    }

    public FrontResponse<RegRecipeYjsResVO> regRecipeYjs(RegRecipeYjsReqVO param) {
        log.info("\u6302\u53f7\u9884\u7ed3\u7b97===> {}", (Object)JSON.toJSONString((Object)param));
        try {
            RegRecipeYjsReqDTO regRecipeYjsReqDTO = new RegRecipeYjsReqDTO();
            param.setOperCode("70019");
            param.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            regRecipeYjsReqDTO.setBody(param);
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.REG_FEE_YJSORDNO.getValue());
            regRecipeYjsReqDTO.setHeadDTO(headDTO);
            String converTomXml = XmlUtil.converTomXml((Object)regRecipeYjsReqDTO);
            FrontResponse response = this.hisRemoteService.hisNewRequest(TransNoEnum.REG_FEE_YJSORDNO.getValue(), converTomXml, RegRecipeYjsResDTO.class);
            RegRecipeYjsResDTO responsebody = (RegRecipeYjsResDTO)response.getBody();
            if (null == responsebody) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            if (!"1".equals(responsebody.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            return FrontResponse.success((String)response.getTransactionId(), (Object)responsebody.getBodyDTO());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u9884\u7ed3\u7b97\u8bf7\u6c42\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)"", (String)"0", (String)"\u6302\u53f7\u9884\u7ed3\u7b97\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<RegRecipeJsResVO> regRecipeJs(RegRecipeJsReqVO param) {
        log.info("\u6302\u53f7\u7ed3\u7b97===> {}", (Object)JSON.toJSONString((Object)param));
        try {
            RegRecipeJsReqDTO requestbody = new RegRecipeJsReqDTO();
            RegRecipeJsReqDTO.BodyDTO body = new RegRecipeJsReqDTO.BodyDTO();
            body.setRegister(param);
            param.setOperCode("70019");
            param.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            requestbody.setBody(body);
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.REG_FEE_JSORDNO.getValue());
            requestbody.setHeadDTO(headDTO);
            String converTomXml = XmlUtil.converTomXml((Object)requestbody);
            FrontResponse response = this.hisRemoteService.hisNewRequest(TransNoEnum.REG_FEE_JSORDNO.getValue(), converTomXml, RegRecipeJsResDTO.class);
            RegRecipeJsResDTO responsebody = (RegRecipeJsResDTO)response.getBody();
            if (null == responsebody) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            if (!"1".equals(responsebody.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            return FrontResponse.success((String)response.getTransactionId(), (Object)responsebody.getBodyDTO());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u7ed3\u7b97\u8bf7\u6c42\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)"", (String)"0", (String)"\u6302\u53f7\u7ed3\u7b97\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<PresRecipeYjsResVO> presRecipeYjs(PresRecipeYjsReqVO param) {
        log.info("\u533b\u5631\u9884\u7ed3\u7b97===> {}", (Object)JSON.toJSONString((Object)param));
        try {
            PresRecipeYjsReqDTO requestbody = new PresRecipeYjsReqDTO();
            param.setOperCode("70019");
            param.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            requestbody.setBody(param);
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.ORDER_OLYJSRECIPE.getValue());
            requestbody.setHeadDTO(headDTO);
            String converTomXml = XmlUtil.converTomXml((Object)requestbody);
            FrontResponse response = this.hisRemoteService.hisNewRequest(TransNoEnum.ORDER_OLYJSRECIPE.getValue(), converTomXml, PresRecipeYjsResDTO.class);
            PresRecipeYjsResDTO responsebody = (PresRecipeYjsResDTO)response.getBody();
            if (null == responsebody) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            if (!"1".equals(responsebody.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            return FrontResponse.success((String)response.getTransactionId(), (Object)responsebody.getBodyDTO());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u533b\u5631\u9884\u7ed3\u7b97\u8bf7\u6c42\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)"", (String)"0", (String)"\u533b\u5631\u9884\u7ed3\u7b97\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<PresRecipeJsResVO> presRecipeJs(PresRecipeJsReqVO param) {
        log.info("\u533b\u5631\u7ed3\u7b97===> {}", (Object)JSON.toJSONString((Object)param));
        try {
            PresRecipeJsReqDTO requestbody = new PresRecipeJsReqDTO();
            param.setOperCode("70019");
            param.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            requestbody.setBody(param);
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.ORDER_OLJSRECIPE.getValue());
            requestbody.setHeadDTO(headDTO);
            String converTomXml = XmlUtil.converTomXml((Object)requestbody);
            FrontResponse response = this.hisRemoteService.hisNewRequest(TransNoEnum.ORDER_OLJSRECIPE.getValue(), converTomXml, PresRecipeJsResDTO.class);
            PresRecipeJsResDTO responsebody = (PresRecipeJsResDTO)response.getBody();
            if (null == responsebody) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            if (!"1".equals(responsebody.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            return FrontResponse.success((String)response.getTransactionId(), (Object)responsebody.getBodyDTO());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u533b\u5631\u7ed3\u7b97\u8bf7\u6c42\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)"", (String)"0", (String)"\u533b\u5631\u7ed3\u7b97\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<String> cancelUnpaidOrder(CancelUnpaidOrderReqVo param) {
        log.info("\u672a\u4ea4\u8d39\u533b\u5631\u64a4\u9500===> {}", (Object)JSON.toJSONString((Object)param));
        try {
            CancelUnpaidOrderReqDTO requestbody = new CancelUnpaidOrderReqDTO();
            param.setOperCode("70019");
            param.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            requestbody.setBody(param);
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.CANCEL_UNPAID_ORDER.getValue());
            requestbody.setHeadDTO(headDTO);
            String converTomXml = XmlUtil.converTomXml((Object)requestbody);
            FrontResponse response = this.hisRemoteService.hisNewRequest(TransNoEnum.CANCEL_UNPAID_ORDER.getValue(), converTomXml, CancelUnpaidOrderResDTO.class);
            CancelUnpaidOrderResDTO responsebody = (CancelUnpaidOrderResDTO)response.getBody();
            if (null == responsebody) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            if (!"1".equals(responsebody.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            return FrontResponse.success((String)response.getTransactionId(), (Object)responsebody.getBodyDTO());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u672a\u4ea4\u8d39\u533b\u5631\u64a4\u9500\u8bf7\u6c42\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)"", (String)"0", (String)"\u672a\u4ea4\u8d39\u533b\u5631\u64a4\u9500\u8bf7\u6c42\u5f02\u5e38");
        }
    }
}

