/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.common.constant.OrderConstant;
import com.ebaiyihui.his.common.enums.PayTypeEnums;
import com.ebaiyihui.his.common.enums.RefundTypeEnum;
import com.ebaiyihui.his.common.enums.SearchTypeEnum;
import com.ebaiyihui.his.common.enums.TradeStateEnum;
import com.ebaiyihui.his.interceptor.OrderInterceptor;
import com.ebaiyihui.his.pojo.pay.dto.AliSearchDTO;
import com.ebaiyihui.his.pojo.pay.dto.PayDTO;
import com.ebaiyihui.his.pojo.pay.dto.RefundDTO;
import com.ebaiyihui.his.pojo.pay.dto.WeChatSearchDTO;
import com.ebaiyihui.his.pojo.pay.vo.AliH5PayVO;
import com.ebaiyihui.his.pojo.pay.vo.AliMiniPayVO;
import com.ebaiyihui.his.pojo.pay.vo.AliRefundVO;
import com.ebaiyihui.his.pojo.pay.vo.OutTradeNo;
import com.ebaiyihui.his.pojo.pay.vo.PayVO;
import com.ebaiyihui.his.pojo.pay.vo.RefundVO;
import com.ebaiyihui.his.pojo.pay.vo.RequestHeaderVO;
import com.ebaiyihui.his.pojo.pay.vo.SearchVO;
import com.ebaiyihui.his.pojo.pay.vo.WeChatMiniAndH5PayVO;
import com.ebaiyihui.his.pojo.pay.vo.WeChatRefundVO;
import com.ebaiyihui.his.service.OrderService;
import com.ebaiyihui.his.utils.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);

    public PayDTO payOrder(PayVO vo) {
        ThreadLocal requestHeader = OrderInterceptor.headerVOThreadLocal;
        Map header = this.getRequestHeader(requestHeader);
        if (Objects.equals(vo.getPayMethod(), PayTypeEnums.ALIPAY.getValue())) {
            AliMiniPayVO aliMiniPayVO = new AliMiniPayVO();
            BeanUtils.copyProperties((Object)vo.getAliMiniPayVO(), (Object)aliMiniPayVO);
            try {
                String respStr = HttpUtils.doPost((String)OrderConstant.PAY_ALIPAY_HOST, (String)JSON.toJSONString((Object)aliMiniPayVO), (String)OrderConstant.ENCODE, (Map)header);
                return this.analysisPayResp(respStr);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            }
        } else if (Objects.equals(vo.getPayMethod(), PayTypeEnums.ALIPAY_H5.getValue())) {
            AliH5PayVO aliH5PayVO = new AliH5PayVO();
            BeanUtils.copyProperties((Object)vo.getAliH5PayVO(), (Object)aliH5PayVO);
            try {
                String respStr = HttpUtils.doPost((String)OrderConstant.PAY_ALIPAY_H5_HOST, (String)JSON.toJSONString((Object)aliH5PayVO), (String)OrderConstant.ENCODE, (Map)header);
                return this.analysisPayResp(respStr);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            }
        } else {
            WeChatMiniAndH5PayVO weChatMiniAndH5PayVO = new WeChatMiniAndH5PayVO();
            BeanUtils.copyProperties((Object)vo.getWeChatMiniAndH5PayVO(), (Object)weChatMiniAndH5PayVO);
            try {
                String respStr = Objects.equals(vo.getPayMethod(), PayTypeEnums.WECHAT.getValue()) ? HttpUtils.doPost((String)OrderConstant.PAY_WECHAT_HOST, (String)JSON.toJSONString((Object)weChatMiniAndH5PayVO), (String)OrderConstant.ENCODE, (Map)header) : HttpUtils.doPost((String)OrderConstant.PAY_WECHAT_H5_HOST, (String)JSON.toJSONString((Object)weChatMiniAndH5PayVO), (String)OrderConstant.ENCODE, (Map)header);
                return this.analysisPayResp(respStr);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            }
        }
        return null;
    }

    public RefundDTO refund(RefundVO vo) {
        ThreadLocal requestHeader = OrderInterceptor.headerVOThreadLocal;
        Map header = this.getRequestHeader(requestHeader);
        if (Objects.equals(vo.getRefundMethod(), RefundTypeEnum.ALIPAY_REFUND.getValue())) {
            AliRefundVO aliRefundVO = new AliRefundVO();
            BeanUtils.copyProperties((Object)vo.getAliRefundVO(), (Object)aliRefundVO);
            try {
                String respStr = HttpUtils.doPost((String)OrderConstant.REFUND_ALIPAY_HOST, (String)JSON.toJSONString((Object)aliRefundVO), (String)OrderConstant.ENCODE, (Map)header);
                return this.analysisRefundResp(respStr);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            }
        } else {
            WeChatRefundVO weChatRefundVO = new WeChatRefundVO();
            BeanUtils.copyProperties((Object)vo.getWeChatRefundVO(), (Object)weChatRefundVO);
            try {
                String respStr = HttpUtils.doPost((String)OrderConstant.REFUND_WECHAT_HOST, (String)JSON.toJSONString((Object)weChatRefundVO), (String)OrderConstant.ENCODE, (Map)header);
                this.analysisRefundResp(respStr);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            }
        }
        return null;
    }

    public BaseResponse search(SearchVO vo) {
        ThreadLocal requestHeader = OrderInterceptor.headerVOThreadLocal;
        Map header = this.getRequestHeader(requestHeader);
        OutTradeNo outTradeNo = new OutTradeNo();
        outTradeNo.setOutTradeNo(vo.getOutTradeNo());
        if (Objects.equals(vo.getSearchMethod(), SearchTypeEnum.ALIPAY_REFUND)) {
            try {
                String respStr = HttpUtils.doPost((String)OrderConstant.SEARCH_ALIPAY_HOST, (String)JSON.toJSONString((Object)outTradeNo), (String)OrderConstant.ENCODE, (Map)header);
                return BaseResponse.success((Object)this.analysisAliResp(respStr));
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            }
        } else {
            try {
                String respStr = HttpUtils.doPost((String)OrderConstant.SEARCH_WECHAT_HOST, (String)JSON.toJSONString((Object)outTradeNo), (String)OrderConstant.ENCODE, (Map)header);
                return BaseResponse.success((Object)this.analysisWeChatResp(respStr));
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            }
        }
        return null;
    }

    private PayDTO analysisPayResp(String respStr) {
        String code = JSON.parseObject((String)respStr).getString(OrderConstant.CODE);
        JSONObject jsonObject = JSONObject.parseObject((String)respStr);
        if (Objects.equals(code, 1) && JSON.parseObject((String)respStr).getJSONObject(OrderConstant.DATA) != null) {
            PayDTO.SuccessResult result = (PayDTO.SuccessResult)JSON.parseObject((String)jsonObject.get((Object)OrderConstant.RESULT).toString(), PayDTO.SuccessResult.class);
            return PayDTO.success((String)result.getOutTradeNo(), (String)result.getTradeNo());
        }
        return PayDTO.fail((String)"\u8ba2\u5355\u652f\u4ed8\u5931\u8d25");
    }

    private RefundDTO analysisRefundResp(String respStr) {
        String code = JSON.parseObject((String)respStr).getString(OrderConstant.CODE);
        JSONObject jsonObject = JSONObject.parseObject((String)respStr);
        if (Objects.equals(code, 1) && JSON.parseObject((String)respStr).getJSONObject(OrderConstant.DATA) != null) {
            RefundDTO.RefundSuccess result = (RefundDTO.RefundSuccess)JSONObject.parseObject((String)jsonObject.get((Object)OrderConstant.RESULT).toString(), RefundDTO.RefundSuccess.class);
            return RefundDTO.success((String)result.getOutTradeNo(), (String)result.getOutRefundNo(), (String)result.getRefundFee());
        }
        return RefundDTO.fail((String)"\u8ba2\u5355\u9000\u6b3e\u5931\u8d25");
    }

    private AliSearchDTO analysisAliResp(String respStr) {
        String code = JSON.parseObject((String)respStr).getString(OrderConstant.CODE);
        if (Objects.equals(code, 1) && JSON.parseObject((String)respStr).getJSONObject(OrderConstant.DATA) != null) {
            JSONObject jsonObject = JSONObject.parseObject((String)respStr);
            AliSearchDTO.HaveFeeResult result = (AliSearchDTO.HaveFeeResult)JSONObject.parseObject((String)jsonObject.get((Object)OrderConstant.RESULT).toString(), AliSearchDTO.HaveFeeResult.class);
            if (Objects.equals(result.getTradeState(), TradeStateEnum.ALI_NO_TRADE.getTradeState())) {
                return AliSearchDTO.noPay((String)result.getOutTradeNo());
            }
            if (Objects.equals(result.getTradeState(), TradeStateEnum.ALI_TRADE_CLOSE.getTradeState())) {
                return AliSearchDTO.payClose((String)result.getOutTradeNo(), (String)result.getTotalFee());
            }
            if (Objects.equals(result.getTradeState(), TradeStateEnum.ALI_TRADE_ING.getTradeState())) {
                return AliSearchDTO.payIng((String)result.getOutTradeNo(), (String)result.getTotalFee());
            }
            return AliSearchDTO.paySuccess((String)result.getOutTradeNo(), (String)result.getTotalFee());
        }
        return AliSearchDTO.payFail((String)"\u672a\u627e\u5230outTradeNo\u5bf9\u5e94\u8ba2\u5355");
    }

    private WeChatSearchDTO analysisWeChatResp(String respStr) {
        String code = JSON.parseObject((String)respStr).getString(OrderConstant.CODE);
        if (Objects.equals(code, 1) && JSON.parseObject((String)respStr).getJSONObject(OrderConstant.DATA) != null) {
            JSONObject jsonObject = JSONObject.parseObject((String)respStr);
            WeChatSearchDTO.HaveFeeResult result = (WeChatSearchDTO.HaveFeeResult)JSONObject.parseObject((String)jsonObject.get((Object)OrderConstant.RESULT).toString(), WeChatSearchDTO.HaveFeeResult.class);
            if (Objects.equals(result.getTradeState(), TradeStateEnum.WECHAT_NO_TRADE.getTradeState())) {
                return WeChatSearchDTO.noPay((String)result.getOutTradeNo(), (String)result.getTotalFee());
            }
            if (Objects.equals(result.getTradeState(), TradeStateEnum.WECHAT_TRADE_CLOSE.getTradeState())) {
                return WeChatSearchDTO.payClose((String)result.getOutTradeNo(), (String)result.getTotalFee());
            }
            if (Objects.equals(result.getTradeState(), TradeStateEnum.WECHAT_TRADE_REFUND.getTradeState())) {
                return WeChatSearchDTO.payRefund((String)result.getOutTradeNo(), (String)result.getTotalFee());
            }
            return WeChatSearchDTO.paySuccess((String)result.getOutTradeNo(), (String)result.getTotalFee());
        }
        return WeChatSearchDTO.payFail((String)"\u672a\u627e\u5230outTradeNo\u5bf9\u5e94\u8ba2\u5355");
    }

    private Map<String, String> getRequestHeader(ThreadLocal<RequestHeaderVO> requestHeader) {
        RequestHeaderVO headerVO = requestHeader.get();
        HashMap<String, String> header = new HashMap<String, String>(10);
        header.put("timestamp", headerVO.getTimestamp());
        header.put("appid", headerVO.getAppId());
        header.put("noncestr", headerVO.getNoncestr());
        header.put("sign", headerVO.getSign());
        header.put("clientip", headerVO.getClientIp());
        header.put("deviceid", headerVO.getDeviceId());
        header.put("content-type", "application/json");
        return header;
    }
}

