/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.date.DateUtil;
import com.ebaiyihui.his.common.enums.TransNoEnum;
import com.ebaiyihui.his.pojo.dto.AdmDetailReqDTO;
import com.ebaiyihui.his.pojo.dto.AdmDetailResDTO;
import com.ebaiyihui.his.pojo.dto.GetOutPatientAdmReqDTO;
import com.ebaiyihui.his.pojo.dto.GetOutPatientAdmResDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsReqDTO;
import com.ebaiyihui.his.pojo.dto.OutpatientComfirePayReqDTO;
import com.ebaiyihui.his.pojo.dto.OutpatientComfirePayResDTO;
import com.ebaiyihui.his.pojo.dto.PreComfirePayBodyResDTO;
import com.ebaiyihui.his.pojo.dto.PreComfirePayReqDTO;
import com.ebaiyihui.his.pojo.dto.PreComfirePayResDTO;
import com.ebaiyihui.his.pojo.regulatoryPlatformVo.dto.HisHeadDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.outpatient.AdmInsuSettlement;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayPreNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsRes;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemReq;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemRes;
import com.ebaiyihui.his.pojo.vo.outpatient.PreComfirePayRes;
import com.ebaiyihui.his.pojo.vo.outpatient.datas.PayItemResDatas;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetAdmissionItems;
import com.ebaiyihui.his.pojo.vo.outpatient.items.PayItemResItems;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.OutpatientPaymentService;
import com.ebaiyihui.his.utils.XmlUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentServiceImpl.class);
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetAdmissionRes> getAdmission(FrontRequest<GetAdmissionReq> param) {
        GetAdmissionReq body = (GetAdmissionReq)param.getBody();
        try {
            GetOutPatientAdmReqDTO getOutPatientAdmReqDTO = new GetOutPatientAdmReqDTO();
            GetOutPatientAdmReqDTO.AdvanceFeeDTO RequestBodyDTO2 = new GetOutPatientAdmReqDTO.AdvanceFeeDTO();
            RequestBodyDTO2.setHospitalCode(body.getHospitalCode());
            RequestBodyDTO2.setPid(body.getCardNo());
            RequestBodyDTO2.setOperCode("70019");
            RequestBodyDTO2.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            getOutPatientAdmReqDTO.setAdvanceFee(RequestBodyDTO2);
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.FEE_LIST_QUERY.getValue());
            getOutPatientAdmReqDTO.setHeadDTO(headDTO);
            String converTomXml = XmlUtil.converTomXml((Object)getOutPatientAdmReqDTO);
            log.info("XML===>" + converTomXml);
            FrontResponse response = this.hisRemoteService.hisNewRequest(TransNoEnum.FEE_LIST_QUERY.getValue(), converTomXml, GetOutPatientAdmResDTO.class);
            GetOutPatientAdmResDTO responsebody = (GetOutPatientAdmResDTO)response.getBody();
            if (null == responsebody) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            if (!"1".equals(responsebody.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            GetAdmissionRes getAdmissionRes = new GetAdmissionRes();
            ArrayList items = new ArrayList();
            responsebody.getBodyDTO().getRecords().stream().forEach(date -> {
                GetAdmissionItems getAdmissionItems = new GetAdmissionItems();
                getAdmissionItems.setAdmDate(date.getRecipeDate());
                getAdmissionItems.setDeptCode(date.getRecipeDeptCode());
                getAdmissionItems.setDeptName(date.getRecipeDeptName());
                getAdmissionItems.setDocName(date.getRecipeDoctName());
                getAdmissionItems.setDocCode(date.getRecipeDoctCode());
                getAdmissionItems.setAdmId(date.getOrderNo());
                items.add(getAdmissionItems);
            });
            getAdmissionRes.setItems(items);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getAdmissionRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u5c31\u8bca\u8bb0\u5f55\u67e5\u8be2\u8bf7\u6c42\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u5c31\u8bca\u8bb0\u5f55\u67e5\u8be2\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<PayItemRes> payItem(FrontRequest<PayItemReq> param) {
        PayItemReq body = (PayItemReq)param.getBody();
        try {
            AdmDetailReqDTO admDetailReqDTO = new AdmDetailReqDTO();
            AdmDetailReqDTO.BodyDTO RequestBodyDTO2 = new AdmDetailReqDTO.BodyDTO();
            RequestBodyDTO2.setHospitalCode(body.getHospitalCode());
            RequestBodyDTO2.setOrderNo(body.getAdmId());
            RequestBodyDTO2.setOperCode("70019");
            RequestBodyDTO2.setPId(body.getCardNo());
            RequestBodyDTO2.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            admDetailReqDTO.setBody(RequestBodyDTO2);
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.FEE_DETIL_QUERY.getValue());
            admDetailReqDTO.setHeadDTO(headDTO);
            String converTomXml = XmlUtil.converTomXml((Object)admDetailReqDTO);
            log.info("\u5c31\u8bca\u8bb0\u5f55\u8be6XML===>" + converTomXml);
            FrontResponse response = this.hisRemoteService.hisNewRequest(TransNoEnum.FEE_DETIL_QUERY.getValue(), converTomXml, AdmDetailResDTO.class);
            AdmDetailResDTO responsebody = (AdmDetailResDTO)response.getBody();
            if (null == responsebody) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            if (!"1".equals(responsebody.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            PayItemRes payItemRes = new PayItemRes();
            ArrayList<PayItemResDatas> PayItemResDatas2 = new ArrayList<PayItemResDatas>();
            PayItemResDatas payItemResData = new PayItemResDatas();
            ArrayList items = new ArrayList();
            responsebody.getBodyDTO().getRecords().stream().forEach(date -> {
                payItemResData.setAdmId(date.getOrderNo());
                PayItemResItems payItemResItems = new PayItemResItems();
                payItemResItems.setId(date.getItemCode());
                payItemResItems.setPrice(String.valueOf(new BigDecimal(date.getUnitPrice()).setScale(2, 1)));
                payItemResItems.setDesc(date.getItemName());
                payItemResItems.setQty(date.getQty());
                payItemResItems.setUnit(date.getItemUnit());
                payItemResItems.setSum(date.getCost());
                payItemResItems.setItemType(date.getFeeName());
                payItemResItems.setItemTypeNo(date.getFeeCode());
                items.add(payItemResItems);
            });
            payItemResData.setItems(items);
            BigDecimal detailTotalMoney = new BigDecimal("0");
            for (PayItemResItems payItemResItems : items) {
                if (null == payItemResItems.getSum()) continue;
                detailTotalMoney = detailTotalMoney.add(new BigDecimal(payItemResItems.getSum()));
            }
            payItemResData.setAmount(String.valueOf(detailTotalMoney));
            PayItemResDatas2.add(payItemResData);
            payItemRes.setDatas(PayItemResDatas2);
            return FrontResponse.success((String)param.getTransactionId(), (Object)payItemRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u5c31\u8bca\u8bb0\u5f55\u8be6\u60c5\u67e5\u8be2\u8bf7\u6c42\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u5c31\u8bca\u8bb0\u5f55\u8be6\u60c5\u67e5\u8be2\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<PreComfirePayRes> pendingPayItems(FrontRequest<ComfirmPayPreNewReq> param) {
        ComfirmPayPreNewReq body = (ComfirmPayPreNewReq)param.getBody();
        try {
            PreComfirePayReqDTO preComfirePayReqDTO = new PreComfirePayReqDTO();
            PreComfirePayReqDTO.BodyDTO RequestBodyDTO2 = new PreComfirePayReqDTO.BodyDTO();
            RequestBodyDTO2.setHospitalCode(body.getHospitalCode());
            RequestBodyDTO2.setOrderNo(body.getOrderNo());
            RequestBodyDTO2.setOperCode("70019");
            RequestBodyDTO2.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            RequestBodyDTO2.setPsnName(body.getPsnName());
            RequestBodyDTO2.setMdtrtCertNo(body.getMdtrtCertNo());
            RequestBodyDTO2.setResponseType(body.getResponseType());
            preComfirePayReqDTO.setBodyDTO(RequestBodyDTO2);
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.FEE_PRE_PAY.getValue());
            preComfirePayReqDTO.setHeadDTO(headDTO);
            String converTomXml = XmlUtil.converTomXml((Object)preComfirePayReqDTO);
            log.info("\u95e8\u8bca\u9884\u652f\u4ed8XML===>" + converTomXml);
            FrontResponse response = this.hisRemoteService.hisNewRequest(TransNoEnum.FEE_PRE_PAY.getValue(), converTomXml, PreComfirePayResDTO.class);
            PreComfirePayResDTO responsebody = (PreComfirePayResDTO)response.getBody();
            if (null == responsebody) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            if (!"1".equals(responsebody.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            PreComfirePayRes preComfirePayRes = new PreComfirePayRes();
            PreComfirePayBodyResDTO preComfirePayBodyResDTO = responsebody.getPreComfirePayBodyResDTO();
            BeanUtils.copyProperties((Object)preComfirePayBodyResDTO, (Object)preComfirePayRes);
            return FrontResponse.success((String)param.getTransactionId(), (Object)preComfirePayRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u95e8\u8bca\u9884\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u95e8\u8bca\u9884\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<ComfirmPayNewRes> comfirmPayNew(FrontRequest<ComfirmPayNewReq> param) {
        ComfirmPayNewReq body = (ComfirmPayNewReq)param.getBody();
        try {
            OutpatientComfirePayReqDTO outpatientComfirePayReqDTO = new OutpatientComfirePayReqDTO();
            OutpatientComfirePayReqDTO.BodyDTO RequestBodyDTO2 = new OutpatientComfirePayReqDTO.BodyDTO();
            RequestBodyDTO2.setHospitalCode(body.getHospitalCode());
            RequestBodyDTO2.setOrderNo(body.getPreSettlementNo());
            RequestBodyDTO2.setResponseType(body.getResponseType());
            RequestBodyDTO2.setOwnCost(body.getAmount());
            RequestBodyDTO2.setOwnPayType(body.getPaychannel());
            RequestBodyDTO2.setOwnPayTransNo(body.getFlowNo());
            RequestBodyDTO2.setOperCode("70019");
            RequestBodyDTO2.setOperTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            if (null != body.getInsuSettlement() || body.getResponseType().equals("9")) {
                AdmInsuSettlement insuSettlement = body.getInsuSettlement();
                OutpatientComfirePayReqDTO.InsuSettlementDTO insuSettlementDTO = new OutpatientComfirePayReqDTO.InsuSettlementDTO();
                BeanUtils.copyProperties((Object)insuSettlement, (Object)insuSettlementDTO);
                RequestBodyDTO2.setInsuSettlementDTO(insuSettlementDTO);
            }
            outpatientComfirePayReqDTO.setBodyDTO(RequestBodyDTO2);
            HisHeadDTO headDTO = new HisHeadDTO();
            headDTO.setSource("HLWYY");
            headDTO.setTransNo(TransNoEnum.FEE_PAY.getValue());
            outpatientComfirePayReqDTO.setHeadDTO(headDTO);
            String converTomXml = XmlUtil.converTomXml((Object)outpatientComfirePayReqDTO);
            log.info("\u95e8\u8bca\u652f\u4ed8XML" + converTomXml);
            FrontResponse response = this.hisRemoteService.hisNewRequest(TransNoEnum.FEE_PAY.getValue(), converTomXml, OutpatientComfirePayResDTO.class);
            OutpatientComfirePayResDTO responsebody = (OutpatientComfirePayResDTO)response.getBody();
            if (null == responsebody) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            if (!"1".equals(responsebody.getHeadVO().getHisReturnVO().getRetCode())) {
                return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responsebody.getHeadVO().getHisReturnVO().getRetCont());
            }
            ComfirmPayNewRes comfirePayRes = new ComfirmPayNewRes();
            OutpatientComfirePayResDTO.ComfirePayBodyResDTO comfirePayBodyResDTO = responsebody.getComfirePayBodyResDTO();
            comfirePayRes.setAdmId(comfirePayBodyResDTO.getSerialNo());
            comfirePayRes.setReceiptId(comfirePayBodyResDTO.getRealNo());
            comfirePayRes.setRemark(comfirePayBodyResDTO.getVisitLocation());
            return FrontResponse.success((String)param.getTransactionId(), (Object)comfirePayRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u95e8\u8bca\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u95e8\u8bca\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<GetPayRecordsRes> getPayRecords(FrontRequest<GetPayRecordsReq> param) {
        GetPayRecordsRes getPayRecordsRes = new GetPayRecordsRes();
        GetPayRecordsReqDTO getPayRecordsReqDTO = new GetPayRecordsReqDTO();
        try {
            GetPayRecordsRes GetPayRecordsRes2 = new GetPayRecordsRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)GetPayRecordsRes2);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u95e8\u8bca\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u95e8\u8bca\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38");
        }
    }
}

