/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.log.util;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.ebaiyihui.log.util.FileUtil;
import com.ebaiyihui.log.util.SpringContextHolder;
import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.UserAgent;
import java.io.File;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringUtil {
    private static final Logger log = LoggerFactory.getLogger(StringUtil.class);
    private static boolean ipLocal = false;
    private static File file = null;
    private static DbConfig config;
    private static Logger logger;
    public static final String EMPTY_STRING = "";

    private StringUtil() {
    }

    public static String getBrowser(HttpServletRequest request) {
        UserAgent userAgent = UserAgent.parseUserAgentString((String)request.getHeader("User-Agent"));
        Browser browser = userAgent.getBrowser();
        return browser.getName();
    }

    public static String getCityInfo(String ip) {
        if (ipLocal) {
            return StringUtil.getLocalCityInfo((String)ip);
        }
        return StringUtil.getHttpCityInfo((String)ip);
    }

    public static String getHttpCityInfo(String ip) {
        String api = String.format("http://whois.pconline.com.cn/ipJson.jsp?ip=%s&json=true", ip);
        JSONObject object = JSONUtil.parseObj((String)HttpUtil.get((String)api));
        return (String)object.get((Object)"addr", String.class);
    }

    public static String getLocalCityInfo(String ip) {
        try {
            DataBlock dataBlock = new DbSearcher(config, file.getPath()).binarySearch(ip);
            String region = dataBlock.getRegion();
            String address = region.replace("0|", "");
            char symbol = '|';
            if (address.charAt(address.length() - 1) == symbol) {
                address = address.substring(0, address.length() - 1);
            }
            return address.equals("\u5185\u7f51IP|\u5185\u7f51IP") ? "\u5185\u7f51IP" : address;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() <= 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty((String)str);
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtil.isBlank((String)str);
    }

    public static long toLongValue(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        String str = null;
        str = obj instanceof String ? (String)obj : String.valueOf(obj);
        if (StringUtil.isBlank((String)str)) {
            return 0L;
        }
        if ("null".equals(str)) {
            return 0L;
        }
        try {
            return Long.valueOf(str);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static int toIntValue(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        String str = null;
        str = obj instanceof String ? (String)obj : String.valueOf(obj);
        if (StringUtil.isBlank((String)str)) {
            return 0;
        }
        if ("null".equals(str)) {
            return 0;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public static String trim(String str) {
        if (str == null || str.length() <= 0) {
            return "";
        }
        return str.trim();
    }

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String replace(String strSource, String strFrom, String strTo) {
        int intPos;
        if (strFrom == null || strFrom.equals("")) {
            return strSource;
        }
        String strDest = "";
        int intFromLen = strFrom.length();
        while ((intPos = strSource.indexOf(strFrom)) != -1) {
            strDest = strDest + strSource.substring(0, intPos);
            strDest = strDest + strTo;
            strSource = strSource.substring(intPos + intFromLen);
        }
        strDest = strDest + strSource;
        return strDest;
    }

    public static Date dateConvertFormat(String dateStr) throws ParseException {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        date = format.parse(dateStr);
        return date;
    }

    public static String[] mergeStrArray(String[] a, String[] b) {
        int i;
        int j = 0;
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (i = 0; i < a.length; ++i) {
            map.put(a[i], a[i]);
        }
        for (i = 0; i < b.length; ++i) {
            map.put(b[i], b[i]);
        }
        Collection values = map.values();
        Iterator iterator = values.iterator();
        String[] c = new String[values.size()];
        while (iterator.hasNext()) {
            c[j++] = (String)iterator.next();
        }
        return c;
    }

    static {
        logger = LoggerFactory.getLogger(StringUtil.class);
        SpringContextHolder.addCallBacks(() -> {
            ipLocal = (Boolean)SpringContextHolder.getProperties((String)"ip.local-parsing", (Object)false, Boolean.class);
            if (ipLocal) {
                String path = "ip2region/ip2region.db";
                String name = "ip2region/ip2region.db";
                try {
                    config = new DbConfig();
                    file = FileUtil.inputStreamToFile((InputStream)new ClassPathResource(path).getInputStream(), (String)name);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

