/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.log.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.log.entity.Log;
import com.ebaiyihui.log.util.StringUtil;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Async
public class LogServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(LogServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;

    public void save(String userViewId, String browser, String ip, ProceedingJoinPoint joinPoint, Log adminLog) {
        log.info("\u8fdb\u5165\u7eaa\u5f55\u65e5\u5fd7service");
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        com.ebaiyihui.log.annotation.Log aopLog = method.getAnnotation(com.ebaiyihui.log.annotation.Log.class);
        Integer logActionType = aopLog.type().getValue();
        String methodName = joinPoint.getTarget().getClass().getName() + "." + signature.getName() + "()";
        StringBuilder params = new StringBuilder("{");
        ArrayList<Object> argValues = new ArrayList<Object>(Arrays.asList(joinPoint.getArgs()));
        for (Object e : argValues) {
            params.append(e).append(" ");
        }
        if (adminLog != null) {
            adminLog.setDescription(aopLog.value());
        }
        assert (log != null);
        adminLog.setRequestIp(ip);
        Object result = null;
        try {
            result = joinPoint.proceed();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        String string = this.postHandle(result);
        log.info("\u8fd4\u56de\u53c2\u6570:\u3010{}\u3011", (Object)string);
        try {
            adminLog.setAddress(StringUtil.getCityInfo(adminLog.getRequestIp()));
        }
        catch (Exception e) {
            adminLog.setAddress(ip);
        }
        adminLog.setMethod(methodName);
        adminLog.setUserViewId(userViewId);
        adminLog.setReqParams(params.toString() + " }");
        adminLog.setBrowser(browser);
        adminLog.setLogActionType(logActionType);
        adminLog.setResParams(string);
        adminLog.setCreateTime(new Timestamp(System.currentTimeMillis()));
        log.info("\u53c2\u6570\u7ec4\u88c5ok\uff0c\u51c6\u5b58mongo------>{}", (Object)JSON.toJSONString((Object)adminLog));
        this.mongoTemplate.save((Object)adminLog);
    }

    private String postHandle(Object retVal) {
        if (null == retVal) {
            return "";
        }
        return JSON.toJSONString((Object)retVal);
    }
}

