/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.log.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.log.entity.Log;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class LogServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(LogServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    private static ExecutorService simpleExecutorService = new ThreadPoolExecutor(10, 50, 0L, TimeUnit.MICROSECONDS, new LinkedBlockingDeque<Runnable>(1000), new ThreadPoolExecutor.DiscardPolicy());

    public void save(String appCode, String resParam, String userViewId, String browser, String ip, ProceedingJoinPoint joinPoint, Log adminLog) {
        simpleExecutorService.execute(() -> {
            try {
                log.info("\u8fdb\u5165\u7eaa\u5f55\u65e5\u5fd7service");
                MethodSignature signature = (MethodSignature)joinPoint.getSignature();
                Method method = signature.getMethod();
                com.ebaiyihui.log.annotation.Log aopLog = method.getAnnotation(com.ebaiyihui.log.annotation.Log.class);
                String logActionType = aopLog.type().getDisplay();
                String methodName = joinPoint.getTarget().getClass().getName() + "." + signature.getName() + "()";
                StringBuilder params = new StringBuilder("{");
                ArrayList<Object> argValues = new ArrayList<Object>(Arrays.asList(joinPoint.getArgs()));
                for (Object e : argValues) {
                    params.append(e).append(" ");
                }
                if (adminLog != null) {
                    adminLog.setDescription(aopLog.value());
                }
                adminLog.setAppCode(appCode);
                adminLog.setRequestIp(ip);
                adminLog.setMethod(methodName);
                adminLog.setUserViewId(userViewId);
                adminLog.setReqParams(params.toString() + " }");
                adminLog.setBrowser(browser);
                adminLog.setLogActionType(logActionType);
                adminLog.setResParams(resParam);
                adminLog.setCreateTime(new Timestamp(System.currentTimeMillis()));
                log.info("\u53c2\u6570\u7ec4\u88c5ok\uff0c\u51c6\u5b58mongo------>{}", (Object)JSON.toJSONString((Object)adminLog));
                this.mongoTemplate.save((Object)adminLog);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

