/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicarecore.handle.aspectj;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.medicarecore.handle.annotation.Log;
import com.ebaiyihui.medicarecore.ybBusiness.domain.ResultResponse;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);

    @Pointcut(value="@annotation(com.ebaiyihui.medicarecore.handle.annotation.Log)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object doAfterReturning(ProceedingJoinPoint proceedingJoinPoint) {
        Object result = ResultResponse.error();
        String name = "";
        String code = "";
        try {
            MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
            Method method = methodSignature.getMethod();
            Log controllerLog = method.getAnnotation(Log.class);
            if (controllerLog == null) {
                return proceedingJoinPoint.proceed();
            }
            name = controllerLog.name();
            code = controllerLog.code();
            Object[] objects = proceedingJoinPoint.getArgs();
            if (objects.length > 1) {
                log.info("{}\u3010{}\u3011\u5165\u53c2\uff1a{}", new Object[]{name, code, JSON.toJSONString((Object)objects)});
            } else {
                log.info("{}\u3010{}\u3011\u5165\u53c2\uff1a{}", new Object[]{name, code, JSON.toJSONString((Object)objects[0])});
            }
            result = proceedingJoinPoint.proceed();
            log.info("{}\u3010{}\u3011\u51fa\u53c2\uff1a{}", new Object[]{name, code, JSON.toJSONString((Object)result)});
            return result;
        }
        catch (Throwable e) {
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.toString());
            e.printStackTrace();
            return result;
        }
    }
}

