/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.gateway.model;

import com.ebaiyihui.gateway.config.RequestWrapper;
import com.ebaiyihui.gateway.model.AuthRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthRequest {
    private static final Logger log = LoggerFactory.getLogger(AuthRequest.class);
    private String ipAddress;
    private String url;
    private String token;
    private String accessToken;
    private String cloudAuth;
    private String channelSource;
    private String appChannel;
    private String cloud;
    private String appCode;
    private String sign;
    private String params;

    public static AuthRequest fromHttpRequest(HttpServletRequest request) {
        return AuthRequest.builder().ipAddress(AuthRequest.getIpAddress((HttpServletRequest)request)).url(request.getRequestURI()).token(request.getHeader("token")).accessToken(request.getHeader("accessToken")).cloudAuth(request.getHeader("cloudAuth")).channelSource(request.getHeader("channelSource")).appChannel(request.getHeader("appChannel")).cloud(request.getHeader("cloud")).appCode(request.getHeader("appCode")).sign(request.getHeader("signMsg")).params(AuthRequest.extractParams((HttpServletRequest)request)).build();
    }

    public static AuthRequest fromWebSocketHandshake(ServerHttpRequest request) {
        String appCode;
        String channelSource;
        String accessToken;
        MultiValueMap queryParams = UriComponentsBuilder.fromUri((URI)request.getURI()).build().getQueryParams();
        log.info("WebSocket\u8bf7\u6c42URI: {}", (Object)request.getURI());
        log.info("\u89e3\u6790\u7684\u67e5\u8be2\u53c2\u6570: {}", (Object)queryParams);
        log.info("channelSource\u53c2\u6570\u503c: [{}]", queryParams.getFirst((Object)"channelSource"));
        log.info("accessToken\u53c2\u6570\u503c: [{}]", queryParams.getFirst((Object)"accessToken"));
        String token = AuthRequest.getFirst((MultiValueMap)queryParams, (String)"token");
        if (token == null) {
            token = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"token");
        }
        if ((accessToken = AuthRequest.getFirst((MultiValueMap)queryParams, (String)"accessToken")) == null) {
            accessToken = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"accessToken");
        }
        if ((channelSource = AuthRequest.getFirst((MultiValueMap)queryParams, (String)"channelSource")) == null) {
            channelSource = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"channelSource");
        }
        if ((appCode = AuthRequest.getFirst((MultiValueMap)queryParams, (String)"appCode")) == null) {
            appCode = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"appCode");
        }
        log.info("\u6700\u7ec8\u53c2\u6570\u503c - channelSource: [{}], accessToken: [{}], token: [{}], appCode: [{}]", new Object[]{channelSource, accessToken, token, appCode});
        return AuthRequest.builder().ipAddress(AuthRequest.getIpAddressFromWebSocket((ServerHttpRequest)request)).url(request.getURI().getPath()).token(token).accessToken(accessToken).cloudAuth(AuthRequest.getFirst((MultiValueMap)queryParams, (String)"cloudAuth") != null ? AuthRequest.getFirst((MultiValueMap)queryParams, (String)"cloudAuth") : AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"cloudAuth")).channelSource(channelSource).appChannel(AuthRequest.getFirst((MultiValueMap)queryParams, (String)"appChannel") != null ? AuthRequest.getFirst((MultiValueMap)queryParams, (String)"appChannel") : AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"appChannel")).cloud(AuthRequest.getFirst((MultiValueMap)queryParams, (String)"cloud") != null ? AuthRequest.getFirst((MultiValueMap)queryParams, (String)"cloud") : AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"cloud")).appCode(appCode).sign(AuthRequest.getFirst((MultiValueMap)queryParams, (String)"sign") != null ? AuthRequest.getFirst((MultiValueMap)queryParams, (String)"sign") : AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"sign")).params(AuthRequest.getFirst((MultiValueMap)queryParams, (String)"params") != null ? AuthRequest.getFirst((MultiValueMap)queryParams, (String)"params") : AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"params")).build();
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getIpAddressFromWebSocket(ServerHttpRequest request) {
        String ip = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = AuthRequest.getHeaderValue((ServerHttpRequest)request, (String)"HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddress() != null ? request.getRemoteAddress().getAddress().getHostAddress() : "unknown";
        }
        return ip;
    }

    private static String getHeaderValue(ServerHttpRequest request, String headerName) {
        return request.getHeaders().getFirst(headerName);
    }

    private static String getFirst(MultiValueMap<String, String> queryParams, String key) {
        return (String)queryParams.getFirst((Object)key);
    }

    private static String extractParams(HttpServletRequest request) {
        RequestWrapper requestWrapper = new RequestWrapper(request);
        String body = requestWrapper.getBody();
        String getParam = AuthRequest.getParamOfMethodGet((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)getParam)) {
            try {
                return URLDecoder.decode(getParam, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u89e3\u7801\u53c2\u6570\u5f02\u5e38\uff1a " + e.getMessage());
                return getParam;
            }
        }
        if (body.contains("=") && !body.contains(":")) {
            body = AuthRequest.convertParam((String)body);
            try {
                return URLDecoder.decode(body, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u89e3\u7801\u53c2\u6570\u5f02\u5e38\uff1a " + e.getMessage());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)request.getContentType()) && request.getContentType().contains("multipart")) {
            return "";
        }
        return body;
    }

    private static String getParamOfMethodGet(HttpServletRequest request) {
        if (null == request.getQueryString()) {
            return "";
        }
        String param = URLDecoder.decode(request.getQueryString());
        param = AuthRequest.convertParam((String)param);
        return param;
    }

    private static String convertParam(String param) {
        Object[] params = param.split("&");
        Arrays.sort(params);
        StringBuilder json = new StringBuilder("{");
        for (int i = 0; i < params.length; ++i) {
            String value;
            String[] keyValue = ((String)params[i]).split("=");
            String key = keyValue[0];
            String string = value = keyValue.length > 1 ? keyValue[1] : "";
            if (i > 0) {
                json.append(",");
            }
            json.append("\"").append(key).append("\":\"").append(value).append("\"");
        }
        json.append("}");
        return json.toString();
    }

    AuthRequest(String ipAddress, String url, String token, String accessToken, String cloudAuth, String channelSource, String appChannel, String cloud, String appCode, String sign, String params) {
        this.ipAddress = ipAddress;
        this.url = url;
        this.token = token;
        this.accessToken = accessToken;
        this.cloudAuth = cloudAuth;
        this.channelSource = channelSource;
        this.appChannel = appChannel;
        this.cloud = cloud;
        this.appCode = appCode;
        this.sign = sign;
        this.params = params;
    }

    public static AuthRequestBuilder builder() {
        return new AuthRequestBuilder();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getUrl() {
        return this.url;
    }

    public String getToken() {
        return this.token;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getCloudAuth() {
        return this.cloudAuth;
    }

    public String getChannelSource() {
        return this.channelSource;
    }

    public String getAppChannel() {
        return this.appChannel;
    }

    public String getCloud() {
        return this.cloud;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getSign() {
        return this.sign;
    }

    public String getParams() {
        return this.params;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setCloudAuth(String cloudAuth) {
        this.cloudAuth = cloudAuth;
    }

    public void setChannelSource(String channelSource) {
        this.channelSource = channelSource;
    }

    public void setAppChannel(String appChannel) {
        this.appChannel = appChannel;
    }

    public void setCloud(String cloud) {
        this.cloud = cloud;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthRequest)) {
            return false;
        }
        AuthRequest other = (AuthRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$cloudAuth = this.getCloudAuth();
        String other$cloudAuth = other.getCloudAuth();
        if (this$cloudAuth == null ? other$cloudAuth != null : !this$cloudAuth.equals(other$cloudAuth)) {
            return false;
        }
        String this$channelSource = this.getChannelSource();
        String other$channelSource = other.getChannelSource();
        if (this$channelSource == null ? other$channelSource != null : !this$channelSource.equals(other$channelSource)) {
            return false;
        }
        String this$appChannel = this.getAppChannel();
        String other$appChannel = other.getAppChannel();
        if (this$appChannel == null ? other$appChannel != null : !this$appChannel.equals(other$appChannel)) {
            return false;
        }
        String this$cloud = this.getCloud();
        String other$cloud = other.getCloud();
        if (this$cloud == null ? other$cloud != null : !this$cloud.equals(other$cloud)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        String this$sign = this.getSign();
        String other$sign = other.getSign();
        if (this$sign == null ? other$sign != null : !this$sign.equals(other$sign)) {
            return false;
        }
        String this$params = this.getParams();
        String other$params = other.getParams();
        return !(this$params == null ? other$params != null : !this$params.equals(other$params));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $cloudAuth = this.getCloudAuth();
        result = result * 59 + ($cloudAuth == null ? 43 : $cloudAuth.hashCode());
        String $channelSource = this.getChannelSource();
        result = result * 59 + ($channelSource == null ? 43 : $channelSource.hashCode());
        String $appChannel = this.getAppChannel();
        result = result * 59 + ($appChannel == null ? 43 : $appChannel.hashCode());
        String $cloud = this.getCloud();
        result = result * 59 + ($cloud == null ? 43 : $cloud.hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        String $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
        String $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        return result;
    }

    public String toString() {
        return "AuthRequest(ipAddress=" + this.getIpAddress() + ", url=" + this.getUrl() + ", token=" + this.getToken() + ", accessToken=" + this.getAccessToken() + ", cloudAuth=" + this.getCloudAuth() + ", channelSource=" + this.getChannelSource() + ", appChannel=" + this.getAppChannel() + ", cloud=" + this.getCloud() + ", appCode=" + this.getAppCode() + ", sign=" + this.getSign() + ", params=" + this.getParams() + ")";
    }
}

