/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.ResponseNotifyRestVo;
import com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.CallbackWhilePaySuccessFactory;
import com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.core.UpdateOrderRecordService;
import com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.service.CallbackWhilePaySuccess;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayChannelEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.AliMedicalInformationSender;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.manager.GnHisManagerService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.XmlUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.wx.NotifyRequest;
import com.ebaiyihui.onlineoutpatient.core.utils.wx.WXPayUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.TencentNotifyResponse;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CallbackWhilePaySuccessManage {
    private static final Logger log = LoggerFactory.getLogger(CallbackWhilePaySuccessManage.class);
    @Autowired
    private CallbackWhilePaySuccessFactory callbackWhilePaySuccessFactory;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private AliMedicalInformationSender aliMedicalInformationSender;
    @Autowired
    private UpdateOrderRecordService updateOrderRecordService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private GnHisManagerService gnHisManagerService;

    public BaseResponse<String> callbackWhilePaySuccess(ResponseNotifyRestVo dto) {
        if (!("SUCCESS".equals(dto.getReturnCode()) || "SUCCESS".equals(dto.getResultCode()) || "TRADE_FINISHED".equals(dto.getReturnMsg()))) {
            return BaseResponse.error((String)"\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setOrderSeq(dto.getOutTradeNo());
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity order = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == order) {
            return BaseResponse.error((String)"fail");
        }
        log.info("order:{}", (Object)JSON.toJSONString((Object)order));
        CallbackWhilePaySuccess callbackWhilePaySuccess = (CallbackWhilePaySuccess)this.callbackWhilePaySuccessFactory.get(order.getOrganId());
        BaseResponse response1 = callbackWhilePaySuccess.inquireOrder(dto);
        log.info("response1:{}", (Object)JSON.toJSONString((Object)response1));
        OrderEntity orderEntity = (OrderEntity)response1.getData();
        if (StringUtils.isEmpty((String)orderEntity.getXId())) {
            return BaseResponse.error((String)"fail");
        }
        BaseResponse response2 = callbackWhilePaySuccess.updateOrderRecord(dto, orderEntity);
        log.info("response2:{}", (Object)JSON.toJSONString((Object)response2));
        AdmissionEntity admissionEntity = (AdmissionEntity)response2.getData();
        if (admissionEntity == null) {
            return BaseResponse.error((String)"fail");
        }
        BaseResponse response3 = callbackWhilePaySuccess.medicarePayment(dto, orderEntity, admissionEntity);
        log.info("response3:{}", (Object)JSON.toJSONString((Object)response3));
        if (response3 != null && !((String)response3.getData()).equals("fail")) {
            return BaseResponse.error((String)"fail");
        }
        if (Objects.equals(order.getAppCode(), "GNYFY") && Objects.equals(order.getServType(), 3)) {
            BaseResponse followUpRegistrationAndReturn = this.gnHisManagerService.gnRegistrationToHis(order, dto, "WECHAT");
            if (!followUpRegistrationAndReturn.isSuccess()) {
                return BaseResponse.error((String)"fail");
            }
            OrderEntity hisOrder = new OrderEntity();
            hisOrder.setXId(orderEntity.getXId());
            hisOrder.setClinicCode((String)followUpRegistrationAndReturn.getData());
            this.baseInquiryOrderService.updateById((Object)hisOrder);
        }
        this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(orderEntity.getXId(), orderEntity.getAppCode()));
        return BaseResponse.success((Object)"success");
    }

    public String WXMedicalCallbackWhilePaySuccess(String tencentNotify) {
        try {
            log.info("======>>\u8fdb\u5165\u4e86\u652f\u4ed8\u56de\u8c03,\u56de\u8c03\u7684\u4fe1\u606f\u662f:{}", (Object)JSONObject.toJSONString((Object)tencentNotify));
            TencentNotifyResponse tencentNotifyResponse = (TencentNotifyResponse)XmlUtil.convertToJavaBean((String)tencentNotify, TencentNotifyResponse.class);
            ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
            responseNotifyRestVo.setTradeNo(tencentNotifyResponse.getMed_trans_id());
            responseNotifyRestVo.setPayTime(DateUtils.parseDate((String)tencentNotifyResponse.getTime_end(), (String)"yyyyMMddHHmmss"));
            responseNotifyRestVo.setDealTradeNo(tencentNotifyResponse.getMed_trans_id());
            responseNotifyRestVo.setPayChannel(PayChannelEnum.WECHAT.getPayChannel());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("x_id", tencentNotifyResponse.getHosp_out_trade_no());
            OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectByMap(map).get(0);
            BaseResponse admissionEntityBaseResponse = this.updateOrderRecordService.updateOrderRecord(responseNotifyRestVo, orderEntity);
            if ("1".equals(admissionEntityBaseResponse.getCode())) {
                return this.returnStr("SUCCESS");
            }
            return this.returnStr("FAIL");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return this.returnStr("SUCCESS");
        }
    }

    private String returnStr(String status) {
        try {
            String PAYKEY = "d4f25f38b817b20ef1b5e69696651245";
            NotifyRequest notifyRequest = new NotifyRequest();
            notifyRequest.setNonce_str(DateUtils.getCurrentDateSimpleToString());
            notifyRequest.setResult_code(status);
            notifyRequest.setReturn_code(status);
            Map objectMap = WXPayUtil.object2Map((Object)notifyRequest);
            String sign = WXPayUtil.generateSignature((Map)objectMap, (String)PAYKEY);
            objectMap.put("sign", sign);
            return WXPayUtil.mapToXml((Map)objectMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

