/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.core;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.ResponseNotifyRestVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.ServiceMerchantConfigMapper;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.utils.SignUtil;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InquireOrderService {
    private static final Logger log = LoggerFactory.getLogger(InquireOrderService.class);
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;

    public BaseResponse<OrderEntity> inquireOrder(ResponseNotifyRestVo dto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setOrderSeq(dto.getOutTradeNo());
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderInfo = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (orderInfo == null) {
            return BaseResponse.success((Object)orderInfo);
        }
        log.info("\u652f\u4ed8\u56de\u8c03\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f:{}", (Object)orderInfo.toString());
        if (this.vaildParams(dto, orderInfo)) {
            OrderEntity orderEntity = new OrderEntity();
            return BaseResponse.success((Object)orderEntity);
        }
        return BaseResponse.success((Object)orderInfo);
    }

    public boolean vaildParams(ResponseNotifyRestVo dto, OrderEntity orderInfo) {
        Map map = SignUtil.getKeyAndValue((Object)dto);
        QueryWrapper wrapper = new QueryWrapper();
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = new ServiceMerchantConfigEntity();
        serviceMerchantConfigEntity.setAppCode(orderInfo.getAppCode());
        serviceMerchantConfigEntity.setHospitalId(orderInfo.getHospitalId());
        if ("ZHJYJF".equals(orderInfo.getFundType())) {
            serviceMerchantConfigEntity.setBizSysSeq("ZHJYJF");
        } else {
            serviceMerchantConfigEntity.setBizSysSeq(ServiceTypeEnum.getCode((Integer)orderInfo.getServType()));
        }
        serviceMerchantConfigEntity.setApplyName(orderInfo.getPayMethod());
        wrapper.setEntity((Object)serviceMerchantConfigEntity);
        log.info("\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u8868\u5165\u53c2:{}" + serviceMerchantConfigEntity.toString());
        ServiceMerchantConfigEntity serviceMerchantConfig = (ServiceMerchantConfigEntity)this.serviceMerchantConfigMapper.selectOne((Wrapper)wrapper);
        if (serviceMerchantConfig == null) {
            log.info("\u672a\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u652f\u4ed8\u5e94\u7528code");
            return true;
        }
        log.info("serviceMerchantConfig:{}" + serviceMerchantConfig.toString());
        if (!SignUtil.checkSign((Map)map, (String)serviceMerchantConfig.getApplyKey())) {
            log.info("\u56de\u8c03\u4e2d\u8be5\u8ba2\u5355\u7684\u7b7e\u540d\u4e0d\u6b63\u786e,\u8ba2\u5355\u4fe1\u606f:{}", (Object)orderInfo.toString());
            return true;
        }
        if (orderInfo == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355,\u652f\u4ed8\u7cfb\u7edf\u4ea4\u6613\u7f16\u53f7={},\u4e1a\u52a1\u7cfb\u7edf\u4ea4\u6613\u7f16\u53f7={}", (Object)dto.getOutTradeNo());
            return true;
        }
        if (!orderInfo.getOrderSeq().equals(dto.getOutTradeNo())) {
            log.error("\u8ba2\u5355\u4fe1\u606f\u4e0e\u56de\u8c03\u53c2\u6570\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
            return true;
        }
        if (orderInfo.getServType().equals(ServiceTypeEnum.NOS.getValue()) && StringUtils.isNotEmpty((String)orderInfo.getOwnCost())) {
            BigDecimal bigDecimal = new BigDecimal(orderInfo.getOwnCost());
            if (0 != bigDecimal.compareTo(dto.getTotalAmount())) {
                log.error("\u8ba2\u5355\u91d1\u989d\u4e0e\u652f\u4ed8\u91d1\u989d\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
                return true;
            }
        } else if (0 != orderInfo.getPayAmount().compareTo(dto.getTotalAmount())) {
            log.error("\u8ba2\u5355\u91d1\u989d\u4e0e\u652f\u4ed8\u91d1\u989d\u4e0d\u5339\u914d,\u8ba2\u5355={},\u56de\u8c03\u53c2\u6570={}", (Object)orderInfo.toString(), (Object)dto.toString());
            return true;
        }
        if (!(OrderStatusEnum.TOPAY.getValue().intValue() == orderInfo.getStatus().intValue() || "2291".equals(orderInfo.getOrganId()) && ServiceTypeEnum.NOS.getValue().equals(orderInfo.getServType()) && StringUtils.isNotEmpty((String)orderInfo.getScheduleId()))) {
            log.error("doWhilePayCallBack \u8ba2\u5355\u72b6\u6001\u5f02\u5e38,\u8ba2\u5355\u975e\u5f85\u652f\u4ed8\u72b6\u6001!:{}", (Object)orderInfo.getStatus());
            return true;
        }
        return false;
    }
}

