/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.vo.mobile;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.Transient;
import java.util.Objects;

public class Result<T> {
    public static final String DEFAULT_SUCCESS_MESSAGE = "success";
    public static final String DEFAULT_ERROR_MESSAGE = "failed";
    public static final String DEFAULT_SUCCESS_CODE = "200";
    public static final String DEFAULT_ERROR_CODE = "0";
    private String code;
    private String message;
    private T data;

    public Result() {
    }

    public Result(String code, String message, T data) {
        this.code = code;
        this.data = data;
        this.message = message;
    }

    public static <T> Result<T> success(Object t) {
        Result res = new Result();
        res.setCode(DEFAULT_SUCCESS_CODE);
        res.setMsg(DEFAULT_SUCCESS_MESSAGE);
        res.setData(t);
        return res;
    }

    public static <T> Result<T> success() {
        Result res = new Result();
        res.setCode(DEFAULT_SUCCESS_CODE);
        res.setMsg(DEFAULT_SUCCESS_MESSAGE);
        res.setData(null);
        return res;
    }

    public static <T> Result<T> error() {
        Result res = new Result();
        res.setCode(DEFAULT_ERROR_CODE);
        res.setMsg(DEFAULT_ERROR_MESSAGE);
        res.setData(null);
        return res;
    }

    public static <T> Result<T> error(Object t) {
        Result res = new Result();
        res.setCode(DEFAULT_ERROR_CODE);
        res.setMsg(DEFAULT_ERROR_MESSAGE);
        res.setData(t);
        return res;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return this.message;
    }

    public void setMsg(String message) {
        this.message = message;
    }

    public T getData() {
        return (T)this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    @Transient
    @JsonIgnore
    public boolean isSuccess() {
        return Objects.equals(this.code, DEFAULT_SUCCESS_CODE);
    }

    public String toString() {
        return "ResultResponse [code=" + this.code + ", message=" + this.message + ", data=" + this.data + "]";
    }
}

