/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.AdmNumberQueryDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.AdmProcessAddDTO;
import com.ebaiyihui.onlineoutpatient.common.vo.AdmNumberQueryVO;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmProcessMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmProcessEntity;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.service.AdmProcessService;
import com.ebaiyihui.onlineoutpatient.core.service.AlipaySmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.UmAppPushService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdmProcessServiceImpl
implements AdmProcessService {
    private static final Logger log = LoggerFactory.getLogger(AdmProcessServiceImpl.class);
    @Autowired
    private AdmProcessMapper admProcessMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    @Autowired
    private AlipaySmallProgramPushService alipaySmallProgramPushService;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    private static Logger logger = LoggerFactory.getLogger(AdmProcessServiceImpl.class);
    @Autowired
    private UmAppPushService umAppPushService;
    private ExecutorService executor = Executors.newCachedThreadPool();

    public BaseResponse<AdmNumberQueryVO> addAdmProcess(AdmProcessAddDTO admProcessAddDTO) {
        AdmissionEntity admission = this.admissionMapper.findById(admProcessAddDTO.getAdmId());
        if (admission == null) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5c31\u8bca\u8bb0\u5f55");
        }
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admission.getStatus())) {
            return BaseResponse.error((String)"\u5c31\u8bca\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        if (DoctorTypeEnum.TEAM.getValue().equals(admission.getDoctorType())) {
            return BaseResponse.success();
        }
        int currentNum = admission.getCurrentNum() + admProcessAddDTO.getProcessNum();
        if (currentNum == 0) {
            admission.setEndTime(new Date());
            admission.setStatus(AdmissionStatusEnum.FINISH_TIME_OUT.getValue());
            int updateCount = this.admissionMapper.update(admission);
            if (updateCount < 1) {
                logger.warn("\u533b\u751f\u670d\u52a1\u6761\u6570\u6d88\u8d39 - \u7ed3\u675f\u5c31\u8bca\u5931\u8d25 - \u539f\u56e0\uff1a\u66f4\u65b0\u5c31\u8bca\u8bb0\u5f55\u5931\u8d25");
                return BaseResponse.error((String)"\u6d88\u8d39\u6761\u6570\u5b8c\u6bd5\uff0c\u7ed3\u675f\u5c31\u8bca\u5931\u8d25");
            }
            this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.admissionMapper.updateAdmNumber(admProcessAddDTO.getAdmId(), admProcessAddDTO.getProcessNum());
        AdmProcessEntity admProcessEntity = new AdmProcessEntity();
        admProcessEntity.setAdmId(admProcessAddDTO.getAdmId());
        admProcessEntity.setProcessTime(admProcessAddDTO.getProcessTime());
        admProcessEntity.setProcessNum(admProcessAddDTO.getProcessNum());
        admProcessEntity.setCurrentNum(Integer.valueOf(currentNum));
        admProcessEntity.setXId(UUIDUtil.getUUID());
        admProcessEntity.setXCreateTime(new Date());
        admProcessEntity.setXUpdateTime(new Date());
        this.admProcessMapper.insert(admProcessEntity);
        AdmNumberQueryVO queryVO = new AdmNumberQueryVO();
        queryVO.setCurrentNum(Integer.valueOf(currentNum));
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return BaseResponse.success((Object)queryVO);
    }

    public BaseResponse<AdmNumberQueryVO> queryAdmNumber(AdmNumberQueryDTO admNumberQueryDTO) {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admNumberQueryDTO.getAdmId());
        if (admissionEntity == null) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u5c31\u8bca\u8bb0\u5f55");
        }
        AdmNumberQueryVO admNumberQueryVO = new AdmNumberQueryVO();
        admNumberQueryVO.setCurrentNum(admissionEntity.getCurrentNum());
        return BaseResponse.success((Object)admNumberQueryVO);
    }

    private OrderEntity getOrderById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setXId(id);
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderEntity = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == orderEntity) {
            return null;
        }
        return orderEntity;
    }

    static /* synthetic */ IMInformService access$000(AdmProcessServiceImpl x0) {
        return x0.imInformService;
    }

    static /* synthetic */ OrderEntity access$100(AdmProcessServiceImpl x0, String x1) {
        return x0.getOrderById(x1);
    }

    static /* synthetic */ SmallProgramPushService access$200(AdmProcessServiceImpl x0) {
        return x0.smallProgramPushService;
    }

    static /* synthetic */ AlipaySmallProgramPushService access$300(AdmProcessServiceImpl x0) {
        return x0.alipaySmallProgramPushService;
    }

    static /* synthetic */ UmAppPushService access$400(AdmProcessServiceImpl x0) {
        return x0.umAppPushService;
    }

    static /* synthetic */ Logger access$500() {
        return log;
    }
}

