/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.DoctorRequestRefundDTO;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.PasswordVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.RequestBusinessBillVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ErrorCodeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServicePayBillMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.service.AliSmsPushService;
import com.ebaiyihui.onlineoutpatient.core.service.AlipaySmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.PaymentService;
import com.ebaiyihui.onlineoutpatient.core.service.RedisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionOrCancellationReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionOrCancellationResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.onlineoutpatient.core.vo.expense.ExpenseReqSubject;
import com.ebaiyihui.onlineoutpatient.core.vo.expense.ExpenseRespData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PaymentServiceImpl
implements PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentServiceImpl.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private IMInformService iMInformService;
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    @Autowired
    private AlipaySmallProgramPushService alipaySmallProgramPushService;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private AliSmsPushService aliSmsPushService;
    @Autowired
    private RedisTemplateService redisTemplateService;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private static final String FAIL = "0";
    private static final String SUCCESS = "1";

    public ResultData<String> doctorAllRefund(DoctorRequestRefundDTO param) {
        String redisKey;
        Boolean flag;
        ResultData result = new ResultData();
        String msg = this.checkDoctorAccount(param);
        if (msg != null) {
            return result.error(msg);
        }
        AdmissionEntity admission = this.admissionMapper.findById(param.getAdmissionId());
        if (admission == null) {
            return result.error("\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        OrderEntity order = this.orderMapper.findById(admission.getOrderId());
        if (order == null) {
            return result.error("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if ("2".equals(order.getFundType()) || "4".equals(order.getFundType())) {
            return result.error("\u533b\u4fdd\u8ba2\u5355\u6682\u4e0d\u652f\u6301\u533b\u751f\u7aef\u9000\u6b3e\uff01");
        }
        log.info("\u9000\u6b3e===", (Object)JSON.toJSONString((Object)order));
        if (0 == order.getPayAmount().compareTo(new BigDecimal(0.0)) && StringUtils.isEmpty((String)admission.getPackageId())) {
            log.info("=========0\u5143\u652f\u4ed8\u4e0d\u652f\u6301\u9000\u6b3e===========");
            return result.success((Object)"0\u5143\u652f\u4ed8\u4e0d\u652f\u6301\u9000\u6b3e");
        }
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(order.getAppCode());
        inquiryMchCodeEntity.setHospitalId(order.getHospitalId());
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        if (null == entity) {
            log.info("\u6ca1\u6709\u914d\u7f6e\u5546\u6237\u53f7\u6216his");
        }
        if (null != admission && admission.getStatus().equals(AdmissionStatusEnum.IN_CONSULTATION.getValue()) && order.getServType().equals(ServiceTypeEnum.NOS.getValue()) && null != entity && StringUtils.isNotEmpty((String)entity.getHisUrl()) && "GNYFY".equals(order.getAppCode())) {
            log.info("his\u5f00\u59cb\u53d6\u6d88\u63a5\u8bca");
            AdmissionOrCancellationReqVo admissionOrCancellationReqVo = new AdmissionOrCancellationReqVo();
            admissionOrCancellationReqVo.setClinicCode(order.getClinicCode());
            admissionOrCancellationReqVo.setYnSee(FAIL);
            AdmissionOrCancellationResVo admissionOrCancellation = this.hisTemplateService.admissionOrCancellation(admissionOrCancellationReqVo);
            if (null == admissionOrCancellation) {
                log.info("\u53d6\u6d88\u63a5\u8bca\u5931\u8d25");
                return result.error("\u53d6\u6d88\u63a5\u8bca\u5931\u8d25");
            }
        }
        RequestRefundVo requestRefundVo = new RequestRefundVo();
        requestRefundVo.setOrderId(order.getXId());
        requestRefundVo.setServerType(String.valueOf(order.getServType()));
        BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
        admission.setStatus(AdmissionStatusEnum.REFUNDED_APPLY.getValue());
        admission.setXRemark(param.getReason());
        this.admissionMapper.update(admission);
        if (Objects.equals(DoctorTypeEnum.TEAM.getValue(), order.getDoctorType()) && (flag = Boolean.valueOf(this.redisTemplateService.addLockNew(redisKey = param.getAdmissionId() + "_YSTK", redisKey, 600L))).booleanValue()) {
            log.info("\u8be5\u60a3\u8005\u5df2\u9000\u6b3e");
            return new ResultData(true, "\u64cd\u4f5c\u6210\u529f", "-1", (Object)"\u8be5\u60a3\u8005\u5df2\u9000\u6b3e");
        }
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return result.success((Object)"\u7533\u8bf7\u9000\u6b3e\u6210\u529f");
    }

    private String checkDoctorAccount(DoctorRequestRefundDTO param) {
        PasswordVo passwordVo = new PasswordVo();
        BeanUtils.copyProperties((Object)param, (Object)passwordVo);
        String url = this.projProperties.getVerifyAccount();
        BaseResponse response = null;
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)passwordVo));
            response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), BaseResponse.class);
            log.info("response:{}" + JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u9a8c\u8bc1\u63a5\u53e3\u5931\u8d25" + e.getMessage());
        }
        if (response.getData() != null) {
            return null;
        }
        return "\u767b\u5f55\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01";
    }

    private OrderEntity getOrderById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setXId(id);
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderEntity = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == orderEntity) {
            return null;
        }
        return orderEntity;
    }

    public BaseResponse<List<ServicePayBillEntity>> getBusinessBill(RequestBusinessBillVo param) {
        if (StringUtils.isNotEmpty((String)param.getWorkServiceCode()) && !ServiceTypeEnum.HOS.getCode().equals(param.getWorkServiceCode()) && !ServiceTypeEnum.NOS.getCode().equals(param.getWorkServiceCode())) {
            return BaseResponse.success(new ArrayList());
        }
        List servicePayBillEntities = this.servicePayBillMapper.selectBillList(param);
        log.info("servicePayBillEntities:{}" + JSON.toJSONString((Object)servicePayBillEntities));
        return BaseResponse.success((Object)servicePayBillEntities);
    }

    public BaseResponse<List<ExpenseRespData>> getExpense(ExpenseReqSubject reqVo) {
        log.info("\u4f20\u5165\u53c2\u6570ExpenseReqSubject\uff1a{}", (Object)reqVo);
        List data = this.servicePayBillMapper.selectExpense(reqVo);
        if (CollectionUtils.isEmpty((Collection)data)) {
            return BaseResponse.error((String)ErrorCodeEnum.NOT_FOUND.getDisplay());
        }
        log.info("\u67e5\u8be2\u7ed3\u679cList<ExpenseRespData>:{}", (Object)JSON.toJSONString((Object)data));
        return BaseResponse.success((Object)data);
    }

    static /* synthetic */ IMInformService access$000(PaymentServiceImpl x0) {
        return x0.iMInformService;
    }

    static /* synthetic */ OrderEntity access$100(PaymentServiceImpl x0, String x1) {
        return x0.getOrderById(x1);
    }

    static /* synthetic */ SmallProgramPushService access$200(PaymentServiceImpl x0) {
        return x0.smallProgramPushService;
    }

    static /* synthetic */ AlipaySmallProgramPushService access$300(PaymentServiceImpl x0) {
        return x0.alipaySmallProgramPushService;
    }

    static /* synthetic */ Logger access$400() {
        return log;
    }
}

