/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.api;

import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.QueryDoctorNetinquiryOrdersDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.QueryPatientNetinquiryOrdersDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.OrderInfoDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.order.QueryNoSourceDto;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.CancelOrderReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.DoctorNetinquiryOrderListVo;
import com.ebaiyihui.onlineoutpatient.common.vo.GetCardNoReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientNetinquiryOrderListVo;
import com.ebaiyihui.onlineoutpatient.common.vo.RegisteredRecordResVo;
import com.ebaiyihui.onlineoutpatient.common.vo.UpdateOrderForReconciliationReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.GetMedicalRecordDetailReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.GetMedicalRecordDetailResVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.GetMedicalRecordReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.GetMedicalRecordResVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.OnlineOutPatientUseRecordVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.PatientNetOrderVoRes;
import com.ebaiyihui.onlineoutpatient.common.vo.order.PatientNetOrdersReq;
import com.ebaiyihui.onlineoutpatient.common.vo.order.ReqDoctorMedicalRecordsInfoVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.ReqDoctorMedicalRecordsVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.ResDoctorMedicalRecordsInfoVo;
import com.ebaiyihui.onlineoutpatient.common.vo.order.ResDoctorMedicalRecordsVo;
import com.ebaiyihui.onlineoutpatient.core.business.offlinemedicalrecords.OfflineMedicalRecordsManage;
import com.ebaiyihui.onlineoutpatient.core.config.annotation.DoctorAppTag;
import com.ebaiyihui.onlineoutpatient.core.config.annotation.PatientAppTag;
import com.ebaiyihui.onlineoutpatient.core.service.OrderService;
import com.ebaiyihui.onlineoutpatient.core.utils.PageUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.ActivityRegisteredReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.GetCardNoResVoNew;
import com.ebaiyihui.onlineoutpatient.core.vo.GetPatientPayInfoVoRes;
import com.ebaiyihui.onlineoutpatient.core.vo.GetPatientPayOrderDetailVoRes;
import com.ebaiyihui.onlineoutpatient.core.vo.GetPatientPaySuccessInfoVoRes;
import com.ebaiyihui.onlineoutpatient.core.vo.HisMedicalsReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.MedOrderVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderCheckForPlatformReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ReqPatientPayOrderListVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ResPatientPayOrderListVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/order"})
@Api(tags={"\u8ba2\u5355\u76f8\u5173API"})
public class OrderController {
    @Resource
    private OrderService orderService;
    @Autowired
    private OfflineMedicalRecordsManage offlineMedicalRecordsManage;

    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u8ba2\u5355\u5217\u8868\u4fe1\u606f", notes="\u83b7\u53d6\u60a3\u8005\u8ba2\u5355\u5217\u8868\u4fe1\u606f")
    @RequestMapping(value={"/patientNetinquiryList"}, method={RequestMethod.POST})
    @PatientAppTag
    public ResultData<List<PatientNetinquiryOrderListVo>> getPatientNetinquiryOrders(@RequestBody @Validated QueryPatientNetinquiryOrdersDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ResultData().error(bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderService.getPatientNetinquiryOrders(dto);
    }

    @ApiOperation(value="\u83b7\u53d6\u533b\u751f\u8ba2\u5355\u5217\u8868\u4fe1\u606f", notes="\u83b7\u53d6\u533b\u751f\u8ba2\u5355\u5217\u8868\u4fe1\u606f")
    @RequestMapping(value={"/doctorNetinquiryList"}, method={RequestMethod.POST})
    @DoctorAppTag
    public BaseResponse<PageUtil<DoctorNetinquiryOrderListVo>> getDoctorNetinquiryOrders(@RequestBody @Validated QueryDoctorNetinquiryOrdersDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderService.getDoctorNetinquiryOrders(dto);
    }

    @PatientAppTag
    @ApiOperation(value="\u53d6\u6d88\u5f85\u652f\u4ed8\u8ba2\u5355", notes="\u53d6\u6d88\u5f85\u652f\u4ed8\u8ba2\u5355")
    @RequestMapping(value={"/cancelOrder"}, method={RequestMethod.POST})
    public ResultData<Object> cancelOrder(@RequestBody @Validated CancelOrderReqVO param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ResultData().error(bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderService.cancelOrder(param);
    }

    @ApiOperation(value="\u5bf9\u8d26\u5e73\u53f0\u5e94\u7528", notes="\u5bf9\u8d26\u5e73\u53f0\u5e94\u7528")
    @RequestMapping(value={"/bystatusdesc"}, method={RequestMethod.POST})
    public BaseResponse<List<OrderInfoDTO>> getByTimeAndAppCode(@RequestParam(value="time") String time, @RequestParam(value="appCode") String appCode) {
        return this.orderService.getByTimeAndAppCode(time, appCode);
    }

    @ApiOperation(value="\u60a3\u8005\u7aef\u7f34\u8d39\u8ba2\u5355\u5217\u8868", notes="\u60a3\u8005\u7aef\u7f34\u8d39\u8ba2\u5355\u5217\u8868")
    @RequestMapping(value={"/getPatientPayOrderList"}, method={RequestMethod.POST})
    public BaseResponse<List<ResPatientPayOrderListVo>> getPatientPayOrderList(@RequestBody @Validated ReqPatientPayOrderListVo reqPatientPayOrderListVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return BaseResponse.success((Object)this.orderService.getPatientPayOrderList(reqPatientPayOrderListVo));
    }

    @ApiOperation(value="\u60a3\u8005\u7aef\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5", notes="\u60a3\u8005\u7aef\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5")
    @RequestMapping(value={"/getPatientPayOrderDetail"}, method={RequestMethod.GET})
    public BaseResponse<GetPatientPayOrderDetailVoRes> getPatientPayOrderDetail(String admId, String cardId) {
        return BaseResponse.success((Object)this.orderService.getPatientPayOrderDetail(admId, cardId));
    }

    @ApiOperation(value="\u60a3\u8005\u7aef\u7f34\u8d39\u9875\u9762\u83b7\u53d6\u652f\u4ed8\u4fe1\u606f", notes="\u60a3\u8005\u7aef\u7f34\u8d39\u9875\u9762\u83b7\u53d6\u652f\u4ed8\u4fe1\u606f")
    @RequestMapping(value={"/getPatientPayInfo"}, method={RequestMethod.GET})
    public BaseResponse<GetPatientPayInfoVoRes> getPatientPayInfo(String admId) {
        GetPatientPayInfoVoRes getPatientPayInfoVoRes = this.orderService.getPatientPayInfo(admId);
        return BaseResponse.success((Object)getPatientPayInfoVoRes);
    }

    @ApiOperation(value="\u60a3\u8005\u7aef\u7f34\u8d39\u9875\u9762\u83b7\u53d6\u652f\u4ed8\u6210\u529f\u4fe1\u606f", notes="\u60a3\u8005\u7aef\u7f34\u8d39\u9875\u9762\u83b7\u53d6\u652f\u4ed8\u6210\u529f\u4fe1\u606f")
    @RequestMapping(value={"/getPatientPaySuccessInfo"}, method={RequestMethod.GET})
    public BaseResponse<GetPatientPaySuccessInfoVoRes> getPatientPaySuccessInfo(String admId) {
        GetPatientPaySuccessInfoVoRes getPatientPaySuccessInfoVoRes = this.orderService.getPatientPaySuccessInfo(admId);
        return BaseResponse.success((Object)getPatientPaySuccessInfoVoRes);
    }

    @ApiOperation(value="\u8d26\u5355\u670d\u52a1\u63a5\u53e3", notes="\u4e3a\u8d26\u5355\u670d\u52a1\u63a5\u53e3")
    @RequestMapping(value={"/updateOrderForReconciliation"}, method={RequestMethod.POST})
    public BaseResponse updateOrderForReconciliation(@Valid @RequestBody UpdateOrderForReconciliationReqVo updateOrderForReconciliationReqVo) {
        this.orderService.updateOrderForReconciliation(updateOrderForReconciliationReqVo);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u83b7\u53d6\u7f51\u7edc\u95e8\u8bca\u60a3\u8005\u8ba2\u5355\u5217\u8868\u4fe1\u606f", notes="\u83b7\u53d6\u7f51\u7edc\u95e8\u8bca\u60a3\u8005\u8ba2\u5355\u5217\u8868\u4fe1\u606f")
    @RequestMapping(value={"/patientOrderInfoList"}, method={RequestMethod.POST})
    @PatientAppTag
    public BaseResponse<PageResult<PatientNetOrderVoRes>> getPatientOrderInfo(@RequestBody @Validated PatientNetOrdersReq req, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return BaseResponse.success((Object)this.orderService.getPatientOrderInfo(req));
    }

    @PatientAppTag
    @ApiOperation(value="\u67e5\u8be2\u5728\u7ebf\u95ee\u8bca\u662f\u5426\u8fd8\u6709\u53f7\u6e90")
    @RequestMapping(value={"/getnosourcebyservtype"}, method={RequestMethod.POST})
    public BaseResponse<String> getNoSourceByServType(@RequestBody @Validated QueryNoSourceDto queryNoSourceDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderService.getNoSourceByServType(queryNoSourceDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u65f6\u95f4")
    @RequestMapping(value={"/getdate"}, method={RequestMethod.POST})
    public BaseResponse<Object> getDate() {
        return BaseResponse.success((Object)new Date());
    }

    @DoctorAppTag
    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u7aef\u5c31\u8bca\u8bb0\u5f55\u5217\u8868-\u7ebf\u4e0a\u5c31\u8bca\u8bb0\u5f55")
    @RequestMapping(value={"/getDoctorMedicalRecords"}, method={RequestMethod.POST})
    public BaseResponse<List<ResDoctorMedicalRecordsVo>> getDoctorMedicalRecords(@RequestBody @Validated ReqDoctorMedicalRecordsVo reqDoctorMedicalRecordsVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return BaseResponse.success((Object)this.orderService.getDoctorMedicalRecords(reqDoctorMedicalRecordsVo));
    }

    @DoctorAppTag
    @ApiOperation(value="\u533b\u60a3\u5173\u7cfb\u533b\u751f\u7aef\u5c31\u8bca\u8be6\u60c5")
    @RequestMapping(value={"/getDoctorMedicalRecordsInfo"}, method={RequestMethod.POST})
    public BaseResponse<ResDoctorMedicalRecordsInfoVo> getDoctorMedicalRecordsInfo(@RequestBody @Validated ReqDoctorMedicalRecordsInfoVo reqDoctorMedicalRecordsInfoVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderService.getDoctorMedicalRecordsInfo(reqDoctorMedicalRecordsInfoVo);
    }

    @ApiOperation(value="\u6839\u636e\u670d\u52a1\u5305\u8ba2\u5355id\u67e5\u8be2\u5728\u7ebf\u54a8\u8be2\u4f7f\u7528\u8bb0\u5f55")
    @GetMapping(value={"/getByServicepkgOrderId"})
    public BaseResponse<List<OnlineOutPatientUseRecordVo>> getByServicepkgOrderId(@RequestParam(value="servicepkgOrderId") String servicepkgOrderId) {
        return BaseResponse.success((Object)this.orderService.getOnlineByServicepkgOrderId(servicepkgOrderId));
    }

    @ApiOperation(value="\u6839\u636e\u670d\u52a1\u5305\u8ba2\u5355id\u67e5\u8be2\u590d\u8bca\u5f00\u836f\u4f7f\u7528\u8bb0\u5f55")
    @GetMapping(value={"/getFollowUpByServicepkgOrderId"})
    public BaseResponse<List<OnlineOutPatientUseRecordVo>> getFollowUpByServicepkgOrderId(@RequestParam(value="servicepkgOrderId") String servicepkgOrderId) {
        return BaseResponse.success((Object)this.orderService.getFollowUpByServicepkgOrderId(servicepkgOrderId));
    }

    @ApiOperation(value="\u968f\u8bbf\u75c5\u4f8b\u5217\u8868", notes="\u968f\u8bbf\u75c5\u4f8b\u5217\u8868")
    @RequestMapping(value={"/getMedicalRecordList"}, method={RequestMethod.POST})
    public BaseResponse<List<GetMedicalRecordResVo>> getPatientMedicalRecordList(@RequestBody @Validated GetMedicalRecordReqVo getMedicalRecordReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderService.getPatientMedicalRecordList(getMedicalRecordReqVo);
    }

    @ApiOperation(value="\u968f\u8bbf\u75c5\u4f8b\u8be6\u60c5", notes="\u968f\u8bbf\u75c5\u4f8b\u8be6\u60c5")
    @RequestMapping(value={"/getMedicalRecordDetail"}, method={RequestMethod.POST})
    public BaseResponse<GetMedicalRecordDetailResVo> getMedicalRecordDetail(@RequestBody @Validated GetMedicalRecordDetailReqVo getMedicalRecordDetailReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderService.getMedicalRecordDetail(getMedicalRecordDetailReqVo);
    }

    @DoctorAppTag
    @ApiOperation(value="\u5386\u53f2\u75c5\u4f8bto\u822a\u5929")
    @RequestMapping(value={"/medicalRecordsToHT"}, method={RequestMethod.POST})
    public BaseResponse<List<RegisteredRecordResVo>> medicalRecordsToHT(@RequestBody @Validated HisMedicalsReqVo hisMedicalsReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.offlineMedicalRecordsManage.medicalRecords(hisMedicalsReqVo);
    }

    @ApiOperation(value="\u83b7\u53d6\u75c5\u5386\u53f7")
    @RequestMapping(value={"/getCardNo"}, method={RequestMethod.POST})
    public BaseResponse<GetCardNoResVoNew> getCardNo(@RequestBody @Validated GetCardNoReqVo getCardNoReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderService.getCardNo(getCardNoReqVo);
    }

    @ApiOperation(value="\u6d3b\u52a8\u6302\u53f7", notes="\u6d3b\u52a8\u6302\u53f7")
    @RequestMapping(value={"/activityRegistered"}, method={RequestMethod.POST})
    public BaseResponse<String> activityRegistered(@RequestBody @Validated ActivityRegisteredReqVo activityRegisteredReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderService.activityRegistered(activityRegisteredReqVo);
    }

    @ApiOperation(value="\u76d1\u7ba1\u5e73\u53f0\u8ba2\u5355\u6821\u9a8c", notes="\u76d1\u7ba1\u5e73\u53f0\u8ba2\u5355\u6821\u9a8c")
    @RequestMapping(value={"/orderCheckForPlatform"}, method={RequestMethod.POST})
    public BaseResponse<String> orderCheckForPlatform(@RequestBody @Validated OrderCheckForPlatformReqVo orderCheckForPlatformReqVo, BindingResult bindingResult) throws Exception {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderService.orderCheckForPlatform(orderCheckForPlatformReqVo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5361\u8be6\u60c5\u8fd4\u56de\u7684\u75c5\u5386\u53f7\u4ee5\u53caid")
    @RequestMapping(value={"/getCardNoAndCardId"}, method={RequestMethod.POST})
    public BaseResponse<GetCardNoResVoNew> getCardNoAndCardId(@RequestBody @Validated GetCardNoReqVo getCardNoReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderService.getCardNoAndCardId(getCardNoReqVo);
    }

    @ApiOperation(value="\u533b\u836f\u4e91\u83b7\u53d6\u590d\u8bca\u8ba2\u5355\u8be6\u60c5")
    @RequestMapping(value={"/getOrderDetail"}, method={RequestMethod.GET})
    public BaseResponse<MedOrderVo> getOrderDetail(@RequestParam(value="orderId") String orderId) {
        return this.orderService.getOrderDetail(orderId);
    }
}

