/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.api.doctor;

import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.config.annotation.DoctorAppTag;
import com.ebaiyihui.onlineoutpatient.core.exception.AdmissionException;
import com.ebaiyihui.onlineoutpatient.core.service.doctor.DoctorAdmissonService;
import com.ebaiyihui.onlineoutpatient.core.vo.AddDoctorMedicalOpinionReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorAdmissionVoReq;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMedicalOpinionVoRes;
import com.ebaiyihui.onlineoutpatient.core.vo.GetDoctorWebAdmissionVoReq;
import com.ebaiyihui.onlineoutpatient.core.vo.GetDoctorWebAdmissionVoRes;
import com.ebaiyihui.onlineoutpatient.core.vo.GetIMPatientAdmissionVoReq;
import com.ebaiyihui.onlineoutpatient.core.vo.GetIMPatientAdmissionVoRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/doctor_admission"})
@Api(tags={"\u533b\u751f\u7aef\u5c31\u8bca\u8bb0\u5f55API"})
public class DoctorAdmissionController {
    private static final Logger log = LoggerFactory.getLogger(DoctorAdmissionController.class);
    @Autowired
    private DoctorAdmissonService doctorAdmissionService;

    @ApiOperation(value="\u67e5\u8be2\u533b\u751fweb\u7aef\u60a3\u8005\u7684\u5c31\u8bca\u8bb0\u5f55\u5217\u8868")
    @PostMapping(value={"/queryDoctorWebAdmission"})
    public BaseResponse<PageResult<GetDoctorWebAdmissionVoRes>> getDoctorWebAdmission(@RequestBody @Valid GetDoctorWebAdmissionVoReq getDoctorAdmissionReq, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("\u67e5\u8be2\u533b\u751fweb\u7aef\u60a3\u8005\u7684\u5c31\u8bca\u8bb0\u5f55{}", (Object)getDoctorAdmissionReq.toString());
        return BaseResponse.success((Object)this.doctorAdmissionService.getDoctorWebAdmission(getDoctorAdmissionReq));
    }

    @ApiOperation(value="\u533b\u751fweb\u7aefIM\u9875\u9762\u5c31\u8bca\u8bb0\u5f55\u67e5\u8be2")
    @GetMapping(value={"/getIMPatientAdmission"})
    @DoctorAppTag
    public BaseResponse<List<GetIMPatientAdmissionVoRes>> getIMPatientAdmission(@Valid GetIMPatientAdmissionVoReq getIMPatientAdmissionVoReq, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("\u533b\u751fweb\u7aefIM\u9875\u9762\u5c31\u8bca\u67e5\u8be2{}", (Object)getIMPatientAdmissionVoReq.toString());
        List getIMPatientAdmissionVoResList = this.doctorAdmissionService.getIMPatientAdmission(getIMPatientAdmissionVoReq);
        return BaseResponse.success((Object)getIMPatientAdmissionVoResList);
    }

    @ApiOperation(value="\u533b\u751f\u7aef\u63a5\u8bcaIM\u63a5\u53e3")
    @PostMapping(value={"/doctorAdmission"})
    public BaseResponse doctorAdmission(@RequestBody DoctorAdmissionVoReq doctorAdmissionVoReq) {
        try {
            this.doctorAdmissionService.doctorAdmission(doctorAdmissionVoReq);
        }
        catch (AdmissionException e) {
            e.printStackTrace();
            BaseResponse.error((String)e.getMessage());
        }
        log.info("\u4fee\u6539\u5c31\u8bca\u72b6\u6001{}", (Object)doctorAdmissionVoReq.toString());
        return BaseResponse.success();
    }

    @ApiOperation(value="\u533b\u751f\u7aef\u6dfb\u52a0\u8bca\u7597\u610f\u89c1")
    @PostMapping(value={"/addDoctorMedicalOpinion"})
    public BaseResponse<DoctorMedicalOpinionVoRes> addDoctorMedicalOpinion(@RequestBody @Valid AddDoctorMedicalOpinionReqVo doctorMedicalOpinionVoReq, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("\u6dfb\u52a0\u8bca\u7597\u610f\u89c1{}", (Object)doctorMedicalOpinionVoReq.toString());
        return this.doctorAdmissionService.addDoctorMedicalOpinion(doctorMedicalOpinionVoReq);
    }

    @ApiOperation(value="\u533b\u751f\u7aef\u7ed3\u675f\u5c31\u8bcaIM\u63a5\u53e3")
    @PostMapping(value={"/endDoctorAdmission"})
    public BaseResponse endDoctorAdmission(@RequestBody DoctorAdmissionVoReq doctorAdmissionVoReq) {
        log.info("\u4fee\u6539\u5c31\u8bca\u72b6\u6001{}", (Object)doctorAdmissionVoReq.toString());
        this.doctorAdmissionService.endDoctorAdmission(doctorAdmissionVoReq);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u533b\u751f\u7aef\u67e5\u8be2\u8bca\u7597\u610f\u89c1\u63a5\u53e3")
    @PostMapping(value={"/getDoctorMedicalOpinion"})
    public BaseResponse<DoctorMedicalOpinionVoRes> getDoctorMedicalOpinion(@RequestBody DoctorAdmissionVoReq doctorAdmissionVoReq) {
        log.info("\u67e5\u8be2\u8bca\u7597\u610f\u89c1{}", (Object)doctorAdmissionVoReq.toString());
        return this.doctorAdmissionService.getDoctorMedicalOpinion(doctorAdmissionVoReq);
    }
}

