/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.offlinemedicalrecords.core;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.DrugsNewVo;
import com.ebaiyihui.onlineoutpatient.common.vo.GetPayRecordDetailReq;
import com.ebaiyihui.onlineoutpatient.common.vo.GetPayRecordDetailRes;
import com.ebaiyihui.onlineoutpatient.common.vo.PrescriptionsNewVo;
import com.ebaiyihui.onlineoutpatient.common.vo.RegisteredRecordResVo;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportReq;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportRes;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ReportPublicService {
    private static final Logger log = LoggerFactory.getLogger(ReportPublicService.class);
    @Autowired
    private HisTemplateService hisTemplateService;

    public BaseResponse<List<RegisteredRecordResVo>> getReport(List<RegisteredRecordResVo> registeredRecordList, PatientEntity patientEntity) {
        if (CollectionUtils.isEmpty(registeredRecordList)) {
            return null;
        }
        Integer age = 0;
        String gender = null;
        if (null != patientEntity && StringUtils.isNotEmpty((String)patientEntity.getIdcard())) {
            try {
                age = IDCardUtil.getAge((String)patientEntity.getIdcard());
                gender = IDCardUtil.getGender((String)patientEntity.getIdcard());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String edTime = format.format(new Date());
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(2, -6);
        Date m3 = c.getTime();
        String bgDate = format.format(m3);
        log.info("\u68c0\u9a8c\u68c0\u67e5\u5f00\u59cb\u67e5\u8be2:{}", (Object)JSON.toJSONString(registeredRecordList));
        for (RegisteredRecordResVo reg : registeredRecordList) {
            reg.setAge(age.toString());
            reg.setName(patientEntity.getPatientName());
            reg.setSex(gender);
            GetPayRecordDetailReq getPayRecordDetailReq = new GetPayRecordDetailReq();
            getPayRecordDetailReq.setAdmId(reg.getAdmId());
            GetPayRecordDetailRes reportAndDragList = this.hisTemplateService.getReportAndDragList(getPayRecordDetailReq);
            if (null == reportAndDragList || CollectionUtils.isEmpty((Collection)reportAndDragList.getGetPayRecordDetailItemsResList())) continue;
            ArrayList drugsNewList = new ArrayList();
            reportAndDragList.getGetPayRecordDetailItemsResList().stream().forEach(r -> {
                DrugsNewVo drugsNewVo = new DrugsNewVo();
                BeanUtils.copyProperties((Object)r, (Object)drugsNewVo);
                drugsNewVo.setDrugName(r.getArcmiDesc());
                drugsNewVo.setDrugFrequence(r.getNum() + r.getSpec());
                drugsNewList.add(drugsNewVo);
            });
            ArrayList<PrescriptionsNewVo> prescriptionsNewList = new ArrayList<PrescriptionsNewVo>();
            PrescriptionsNewVo prescriptionsNewVo = new PrescriptionsNewVo();
            prescriptionsNewVo.setDrugsList(drugsNewList);
            prescriptionsNewList.add(prescriptionsNewVo);
            reg.setPrescriptionsVo(prescriptionsNewList);
            ReportReq reportReq = new ReportReq();
            reportReq.setAdmId(reg.getAdmId());
            reportReq.setPatientId(reg.getPatientId());
            reportReq.setBeginTime(bgDate);
            reportReq.setEndTime(edTime);
            ReportRes reportList = this.hisTemplateService.getReportList(reportReq);
            if (null == reportList) continue;
            reg.setReportRes(reportList);
        }
        registeredRecordList.sort(Comparator.comparing(RegisteredRecordResVo::getRegDate).reversed());
        return BaseResponse.success(registeredRecordList);
    }
}

