/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.common.enums;

import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;

public enum DoctorNetinquiryOrderStatusEnum {
    TO_CONSULTATION(Integer.valueOf(1), "\u5f85\u63a5\u8bca"),
    IN_CONSULTATION(Integer.valueOf(2), "\u8fdb\u884c\u4e2d"),
    END_CONSULTATION(Integer.valueOf(3), "\u5df2\u5b8c\u6210"),
    ADMISSION_NOT_HANDLE(Integer.valueOf(4), "\u5df2\u9000\u6b3e"),
    REFUSE_ADMISSION(Integer.valueOf(5), "\u5df2\u9000\u6b3e"),
    REQUEST_REFUND(Integer.valueOf(6), "\u5df2\u9000\u6b3e"),
    ADMIN_REFUNDED(Integer.valueOf(45), "\u5df2\u5931\u6548"),
    ZERO_REFUSE_REFUND(Integer.valueOf(30), "\u5df2\u62d2\u7edd"),
    REQUEST_REFUNDING(Integer.valueOf(7), "\u9000\u6b3e\u4e2d"),
    DOCTOR_CLOSED_SCHEDULE(Integer.valueOf(16), "\u5df2\u9000\u6b3e"),
    TO_BE_RECEIVED_REFUND(Integer.valueOf(15), "\u5df2\u9000\u6b3e"),
    REFERRAL(Integer.valueOf(40), "\u5df2\u5b8c\u6210"),
    PASS_NUMBER(Integer.valueOf(50), "\u5df2\u8fc7\u53f7");

    private Integer value;
    private String desc;

    public static DoctorNetinquiryOrderStatusEnum getEnum(Integer admStautus) {
        if (admStautus == null) {
            return null;
        }
        if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admStautus)) {
            return TO_CONSULTATION;
        }
        if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admStautus)) {
            return IN_CONSULTATION;
        }
        if (AdmissionStatusEnum.REFUNDED_APPLY.getValue().equals(admStautus)) {
            return REQUEST_REFUND;
        }
        if (AdmissionStatusEnum.REFUNDED_REFUSE.getValue().equals(admStautus)) {
            return REFUSE_ADMISSION;
        }
        if (AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue().equals(admStautus)) {
            return ADMISSION_NOT_HANDLE;
        }
        if (AdmissionStatusEnum.FINISH_APPLY.getValue().equals(admStautus) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(admStautus)) {
            return END_CONSULTATION;
        }
        return null;
    }

    public static DoctorNetinquiryOrderStatusEnum getEnum(Integer admStautus, Integer orderStatus) {
        if (admStautus == null || orderStatus == null) {
            return null;
        }
        if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admStautus)) {
            return TO_CONSULTATION;
        }
        if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admStautus)) {
            return IN_CONSULTATION;
        }
        if (AdmissionStatusEnum.REFUNDED_APPLY.getValue().equals(admStautus)) {
            if (OrderStatusEnum.REFUNDING.getValue().equals(orderStatus)) {
                return REQUEST_REFUNDING;
            }
            return REQUEST_REFUND;
        }
        if (AdmissionStatusEnum.REFUNDED_REFUSE.getValue().equals(admStautus)) {
            return REFUSE_ADMISSION;
        }
        if (AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue().equals(admStautus)) {
            return ADMISSION_NOT_HANDLE;
        }
        if (AdmissionStatusEnum.FINISH_APPLY.getValue().equals(admStautus) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(admStautus)) {
            return END_CONSULTATION;
        }
        return null;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    private DoctorNetinquiryOrderStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }
}

