/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.doctor.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.AdmDateVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.AdmissionService;
import com.ebaiyihui.onlineoutpatient.core.service.AlipaySmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.ImMqSendService;
import com.ebaiyihui.onlineoutpatient.core.service.RedisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.UmAppPushService;
import com.ebaiyihui.onlineoutpatient.core.service.doctor.DoctorAdmissonService;
import com.ebaiyihui.onlineoutpatient.core.service.mobile.MobileBenefitPackageService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.AddDoctorMedicalOpinionReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorAdmissionVoReq;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMedicalOpinionVoRes;
import com.ebaiyihui.onlineoutpatient.core.vo.GetDoctorWebAdmissionVoReq;
import com.ebaiyihui.onlineoutpatient.core.vo.GetDoctorWebAdmissionVoRes;
import com.ebaiyihui.onlineoutpatient.core.vo.GetIMPatientAdmissionVoReq;
import com.ebaiyihui.onlineoutpatient.core.vo.GetIMPatientAdmissionVoRes;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DoctorAdmissionServiceImpl
implements DoctorAdmissonService {
    private static final Logger log = LoggerFactory.getLogger(DoctorAdmissionServiceImpl.class);
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    @Autowired
    private AlipaySmallProgramPushService alipaySmallProgramPushService;
    @Autowired
    private UmAppPushService umAppPushService;
    @Resource
    private IMInformService iMInformService;
    @Autowired
    private OrderSender orderSender;
    @Resource
    private ImMqSendService imMqSendService;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private AdmissionService admissionService;
    @Resource
    private MobileBenefitPackageService mobileBenefitPackageService;
    private ExecutorService executor = Executors.newCachedThreadPool();
    @Autowired
    private OrderMapper orderMapper;

    public PageResult<GetDoctorWebAdmissionVoRes> getDoctorWebAdmission(GetDoctorWebAdmissionVoReq getDoctorWebAdmissionVoReq) {
        log.info("getDoctorWebAdmissionVoReq:{}" + getDoctorWebAdmissionVoReq.toString());
        PageHelper.startPage((int)getDoctorWebAdmissionVoReq.getPageNum(), (int)getDoctorWebAdmissionVoReq.getPageSize());
        Page doctorAdmissionRspPage = this.admissionMapper.getDoctorWebAdmission(getDoctorWebAdmissionVoReq);
        log.info("doctorAdmissionRspPage:{}" + JSONObject.toJSONString((Object)doctorAdmissionRspPage));
        PageResult pageResult = new PageResult();
        pageResult.setTotal(Long.valueOf(doctorAdmissionRspPage.getTotal()).intValue());
        pageResult.setContent(doctorAdmissionRspPage.getResult());
        log.info("pageResult:{}" + JSONObject.toJSONString((Object)pageResult));
        return pageResult;
    }

    public List<GetIMPatientAdmissionVoRes> getIMPatientAdmission(GetIMPatientAdmissionVoReq getIMPatientAdmissionVoReq) {
        ArrayList<GetIMPatientAdmissionVoRes> getIMPatientAdmissionVoResListVo = new ArrayList<GetIMPatientAdmissionVoRes>();
        ArrayList<GetIMPatientAdmissionVoRes> getIMPatientAdmissionVoResVo = new ArrayList<GetIMPatientAdmissionVoRes>();
        List getIMPatientAdmissionVoResList = this.admissionMapper.getDoctorWebIMPatientAdmission(getIMPatientAdmissionVoReq);
        log.info("getIMPatientAdmissionVoResList:{}" + getIMPatientAdmissionVoResList.toString());
        getIMPatientAdmissionVoResListVo.addAll(getIMPatientAdmissionVoResList);
        GetIMPatientAdmissionVoRes doctorWebIMPatientAdmissionAdd = this.admissionMapper.getDoctorWebIMPatientAdmissionAdd(getIMPatientAdmissionVoReq);
        log.info("doctorWebIMPatientAdmissionAdd:{}" + doctorWebIMPatientAdmissionAdd.toString());
        for (GetIMPatientAdmissionVoRes getIMPatientAdmissionVoRes : getIMPatientAdmissionVoResList) {
            if (getIMPatientAdmissionVoRes.getAdmId().equals(doctorWebIMPatientAdmissionAdd.getAdmId())) continue;
            getIMPatientAdmissionVoResVo.add(doctorWebIMPatientAdmissionAdd);
        }
        if (getIMPatientAdmissionVoResList.size() == getIMPatientAdmissionVoResVo.size()) {
            getIMPatientAdmissionVoResListVo.add(doctorWebIMPatientAdmissionAdd);
        }
        log.info("getIMPatientAdmissionVoResListVo:{}" + ((Object)getIMPatientAdmissionVoResListVo).toString());
        return getIMPatientAdmissionVoResListVo;
    }

    public void doctorAdmission(DoctorAdmissionVoReq doctorAdmissionVoReq) {
        AdmissionEntity admission = this.admissionMapper.findById(doctorAdmissionVoReq.getAdmId());
        if (null == admission) {
            log.error("\u533b\u751fweb\u63a5\u5355  \u672a\u67e5\u8be2\u5230\u5c31\u8bca\u8bb0\u5f55  \u63a5\u5355\u5931\u8d25");
            return;
        }
        OrderEntity order = this.orderMapper.findById(admission.getOrderId());
        Integer servTime = admission.getServTime();
        admission.setStartTime(new Date());
        admission.setEndTime(DateUtils.dateAddMinutes((Date)admission.getStartTime(), (int)servTime));
        AdmDateVo dateRes = new AdmDateVo();
        dateRes.setEdTime(admission.getEndTime());
        dateRes.setNowTime(new Date());
        if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admission.getStatus())) {
            log.info("\u5b9a\u65f6\u7ed3\u675f\u65f6\u95f4\u67e5\u770b" + admission.toString());
            admission.setStatus(AdmissionStatusEnum.IN_CONSULTATION.getValue());
            admission.setReceptionTime(new Date());
            this.admissionMapper.update(admission);
        }
        this.admissionService.inquiryEndPrePush(doctorAdmissionVoReq.getAdmId());
        Date nowDate = new Date();
        int i = DateUtils.secondsBetween((Date)nowDate, (Date)admission.getEndTime());
        if (i < 600) {
            log.info("\u5ef6\u65f6\u65f6\u95f4\u5c0f\u65f610\u5206\u949f\u4e0d\u63a8\u9001");
        } else if (i == 600) {
            this.iMInformService.tenMinutesBeforeEnd(doctorAdmissionVoReq.getAdmId());
            this.umAppPushService.noMedicalOpinionFollowUpCaseAppPush(doctorAdmissionVoReq.getAdmId());
            log.info("\u533b\u751f\u8ddd\u79bb\u95ee\u8bca\u7ed3\u675f10\u5206\u949f\u524d\u672a\u5f00\u5177\u8bca\u7597\u610f\u89c1\u6216\u8005\u590d\u8bca\u75c5\u4f8b\u63a8\u9001\u6210\u529f");
        } else {
            log.info("\u672a\u523010\u5206\u949f\u653e\u5165\u961f\u5217");
            OrderTaskVo orderTaskVoNew = new OrderTaskVo();
            orderTaskVoNew.setId(admission.getOrderId());
            orderTaskVoNew.setType(Integer.valueOf(6));
            this.orderSender.sendDelay(orderTaskVoNew);
        }
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public BaseResponse<DoctorMedicalOpinionVoRes> addDoctorMedicalOpinion(AddDoctorMedicalOpinionReqVo addDoctorMedicalOpinionReqVo) {
        DoctorAdmissionVoReq doctorAdmissionVoReq = new DoctorAdmissionVoReq();
        doctorAdmissionVoReq.setAdmId(addDoctorMedicalOpinionReqVo.getAdmId());
        DoctorMedicalOpinionVoRes doctorMedicalOpinion = this.admissionMapper.getDoctorMedicalOpinion(doctorAdmissionVoReq);
        if (StringUtils.isNotBlank((CharSequence)doctorMedicalOpinion.getMedicalOpinion())) {
            return BaseResponse.success((Object)doctorMedicalOpinion);
        }
        this.admissionMapper.addDoctorMedicalOpinion(addDoctorMedicalOpinionReqVo);
        this.imInformService.addDoctorMedicalOpinion(addDoctorMedicalOpinionReqVo.getAdmId());
        return BaseResponse.success();
    }

    public void endDoctorAdmission(DoctorAdmissionVoReq doctorAdmissionVoReq) {
        this.imInformService.endDoctorAdmissionSendImMessage(doctorAdmissionVoReq.getAdmId());
        log.info("\u4fee\u6539\u5c31\u8bca\u72b6\u6001\u4e3a\u7ed3\u675f\uff1a{}");
        this.admissionMapper.updateAdmissionStatusById(doctorAdmissionVoReq.getAdmId(), AdmissionStatusEnum.FINISH_APPLY.getValue(), null);
        AdmissionEntity admission = this.admissionMapper.findById(doctorAdmissionVoReq.getAdmId());
        if (StringUtils.isNotEmpty((CharSequence)admission.getPackageId())) {
            OrderEntity order = this.orderMapper.findById(admission.getOrderId());
            this.mobileBenefitPackageService.updateNotifyConsultData(admission, order);
        }
    }

    public BaseResponse<DoctorMedicalOpinionVoRes> getDoctorMedicalOpinion(DoctorAdmissionVoReq doctorAdmissionVoReq) {
        DoctorMedicalOpinionVoRes doctorMedicalOpinion = this.admissionMapper.getDoctorMedicalOpinion(doctorAdmissionVoReq);
        log.info("\u67e5\u8be2\u8bca\u7597\u610f\u89c1\uff1a{}", (Object)JSON.toJSONString((Object)doctorMedicalOpinion));
        return BaseResponse.success((Object)doctorMedicalOpinion);
    }

    static /* synthetic */ OrderSender access$000(DoctorAdmissionServiceImpl x0) {
        return x0.orderSender;
    }

    static /* synthetic */ IMInformService access$100(DoctorAdmissionServiceImpl x0) {
        return x0.iMInformService;
    }

    static /* synthetic */ SmallProgramPushService access$200(DoctorAdmissionServiceImpl x0) {
        return x0.smallProgramPushService;
    }

    static /* synthetic */ AlipaySmallProgramPushService access$300(DoctorAdmissionServiceImpl x0) {
        return x0.alipaySmallProgramPushService;
    }

    static /* synthetic */ UmAppPushService access$400(DoctorAdmissionServiceImpl x0) {
        return x0.umAppPushService;
    }

    static /* synthetic */ MobileBenefitPackageService access$500(DoctorAdmissionServiceImpl x0) {
        return x0.mobileBenefitPackageService;
    }

    static /* synthetic */ Logger access$600() {
        return log;
    }
}

