/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionVideoMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionVideoEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.service.AdmissionVideoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionVideoReqVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdmissionVideoServiceImpl
implements AdmissionVideoService {
    private static final Logger log = LoggerFactory.getLogger(AdmissionVideoServiceImpl.class);
    @Autowired
    private AdmissionVideoMapper admissionVideoMapper;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private OrderMapper orderMapper;
    private static final Integer STATUS = 1;

    public void insertVideo(AdmissionVideoReqVo admissionVideoReqVo) {
        boolean flag;
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionVideoReqVo.getTreatmentId());
        log.info("\u5c31\u8bca\u89c6\u9891\u5165\u53c2admissionVideoReqVo:{}", (Object)JSON.toJSONString((Object)admissionVideoReqVo));
        AdmissionVideoEntity admissionVideoEntity = new AdmissionVideoEntity();
        admissionVideoEntity.setAdmId(admissionVideoReqVo.getTreatmentId());
        admissionVideoEntity.setVideoUrl(admissionVideoReqVo.getVideoUrl());
        String startTime = DateUtils.secondToDateTime((long)Long.valueOf(admissionVideoReqVo.getStartTime()));
        admissionVideoEntity.setStartTime(startTime);
        String endTime = DateUtils.secondToDateTime((long)Long.valueOf(admissionVideoReqVo.getEndTime()));
        admissionVideoEntity.setEndTime(endTime);
        admissionVideoEntity.setXId(UUIDUtils.getUUID());
        admissionVideoEntity.setStatus(STATUS);
        String videoLength = DateUtils.tosecondString((String)admissionVideoReqVo.getDuration());
        admissionVideoEntity.setVideoLength(videoLength);
        boolean bl = flag = admissionVideoReqVo.getIsMix().equals("noMixed") && "BDDYZYY".equals(orderEntity.getAppCode());
        if (!flag) {
            admissionVideoEntity.setIsMix(admissionVideoReqVo.getIsMix());
            admissionVideoEntity.setXCreateTime(new Date());
            admissionVideoEntity.setXUpdateTime(new Date());
            int insert = this.admissionVideoMapper.insert((Object)admissionVideoEntity);
            if (0 == insert) {
                log.info("\u6ca1\u6709\u63d2\u5165\u6210\u529f");
            }
        }
    }

    public List<AdmissionVideoEntity> getVideoFromIm(String admId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("viewId", admId);
        String url = this.projProperties.getGetImVideo();
        ArrayList<AdmissionVideoEntity> admissionVideoEntities = new ArrayList<AdmissionVideoEntity>();
        try {
            String s = HttpKit.get((String)url, map);
            log.info("\u4eceIM\u670d\u52a1\u67e5\u8be2\u7fa4\u804a\u89c6\u9891:{}", (Object)s);
            if (StringUtils.isNotEmpty((String)s)) {
                List list = JSONObject.parseArray((String)s, AdmissionVideoReqVo.class);
                for (AdmissionVideoReqVo admissionVideoReqVo : list) {
                    if (Objects.isNull(admissionVideoReqVo)) continue;
                    AdmissionVideoEntity admissionVideoEntityVo = new AdmissionVideoEntity();
                    admissionVideoEntityVo.setAdmId(admId);
                    admissionVideoEntityVo.setStatus(STATUS);
                    admissionVideoEntityVo.setVideoUrl(admissionVideoReqVo.getVideoUrl());
                    admissionVideoEntityVo.setVideoLength(DateUtils.tosecondString((String)admissionVideoReqVo.getDuration()));
                    admissionVideoEntityVo.setStartTime(DateUtils.secondToDateTime((long)Long.valueOf(admissionVideoReqVo.getStartTime())));
                    admissionVideoEntityVo.setEndTime(DateUtils.secondToDateTime((long)Long.valueOf(admissionVideoReqVo.getEndTime())));
                    admissionVideoEntities.add(admissionVideoEntityVo);
                }
                return admissionVideoEntities;
            }
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2IM\u89c6\u9891\u51fa\u9519:{}", (Throwable)e);
            return null;
        }
        return null;
    }
}

